#!/bin/sh

echo "Magicard Ltd"
echo "magicardcupsdrv-installer"
echo "---------------------------------------"
echo ""

ROOT_UID=0

# shellcheck disable=SC2039
USER_ID="${UID-$(id -u)}"

if [ -z "${RPMBUILD}" ] && [ "${USER_ID}" -ne "${ROOT_UID}" ]
then
    echo "This script requires root user access."
    echo "Re-run as root user."
    exit 1
fi

if [ -n "${DESTDIR}" ]
then
   # Ensure no trailing slash
   DESTDIR="${DESTDIR%%/}"
   echo "DESTDIR set to ${DESTDIR}"
   echo
fi

if command -v cups-config > /dev/null; then
   CUPSCONFIG_FILTERDIR="$(cups-config --serverbin)/filter"
   CUPSCOFIG_PPDDIR="$(cups-config --datadir)/model/ultra"
fi

FILTERDIR="${CUPSCONFIG_FILTERDIR:-/usr/lib/cups/filter}"
PPDDIR="${CUPSCOFIG_PPDDIR:-/usr/share/cups/model/ultra}"

# On Mac, the PPD files go in their own special place.
if [ "$(uname -s)" = "Darwin" ]; then
   PPDDIR="/Library/Printers/PPDs/Contents/Resources/"
fi

echo "Copying rastertoultra filter to ${DESTDIR}${FILTERDIR}"
mkdir -p "${DESTDIR}${FILTERDIR}"
chmod +x rastertoultra
cp rastertoultra "${DESTDIR}${FILTERDIR}"
echo

echo "Copying cmdtoultra to ${DESTDIR}${FILTERDIR}"
mkdir -p "${DESTDIR}${FILTERDIR}"
chmod +x cmdtoultra
cp cmdtoultra "${DESTDIR}${FILTERDIR}"
echo

echo "Copying model ppd files to ${DESTDIR}${PPDDIR}"
mkdir -p "${DESTDIR}${PPDDIR}"
cp ./*.ppd "${DESTDIR}${PPDDIR}"
echo

if [ -z "${RPMBUILD}" ]
then
    echo "Restarting CUPS"
    if [ -x /etc/software/init.d/cups ]
    then
        /etc/software/init.d/cups stop
        /etc/software/init.d/cups start
    elif [ -x /etc/rc.d/init.d/cups ]
    then
        /etc/rc.d/init.d/cups stop
        /etc/rc.d/init.d/cups start
    elif [ -x /etc/init.d/cups ]
    then
        /etc/init.d/cups stop
        /etc/init.d/cups start
    elif [ -x /sbin/init.d/cups ]
    then
        /sbin/init.d/cups stop
        /sbin/init.d/cups start
    elif [ -x /etc/software/init.d/cupsys ]
    then
        /etc/software/init.d/cupsys stop
        /etc/software/init.d/cupsys start
    elif [ -x /etc/rc.d/init.d/cupsys ]
    then
        /etc/rc.d/init.d/cupsys stop
        /etc/rc.d/init.d/cupsys start
    elif [ -x /etc/init.d/cupsys ]
    then
        /etc/init.d/cupsys stop
        /etc/init.d/cupsys start
    elif [ -x /sbin/init.d/cupsys ]
    then
        /sbin/init.d/cupsys stop
        /sbin/init.d/cupsys start
   elif [ -x /bin/launchctl ]
   then
      # Mac OSX
      /bin/launchctl stop org.cups.cupsd
      /bin/launchctl start org.cups.cupsd
    else
        echo "Could not restart CUPS"
    fi
    echo
fi

echo "Install Complete"
echo "Plug in the printer and connect the printer via USB and visit"
echo "http://localhost:631/Printers. If the printer is not listed"
echo "add the printer queue manually at http://localhost:631"
echo

