/***************************************************************************/
/**                                                                       **/
/**                            MAGICARD LTD                               **/
/**                                                                       **/
/***************************************************************************/
/**                                                                       **/
/**  PROJECT      : UltraLinux                                            **/
/**                                                                       **/
/**  MODULE NAME  : MagiGen.h                                             **/
/**                                                                       **/
/**  COPYRIGHT    : Magicard Ltd                                          **/
/**                                                                       **/
/***************************************************************************/

#ifndef MAGI_GENERAL
#define MAGI_GENERAL

#include "rp2mag.h"
#include <stdbool.h>
#include <stdint.h>

#define MAX_CARD_WIDTH    1016
#define MAX_CARD_HEIGHT   642
#define PREVIEW_WIDTH     236 /**< The width of a RGB image preview panel. */
#define PREVIEW_HEIGHT    148 /**< The height of a RGB image preview panel. */
#define FILTER_SIZE       60
#define BUFSIZE           512
#define STATUS_BUFFERSIZE 1024

#define MAX_LANGID 3

#define ENGLISH      TEXT("ENG")
#define FRENCH       TEXT("FRA")
#define GERMAN       TEXT("DEU")
#define ITALIAN      TEXT("ITA")
#define SPANISH      TEXT("SPA")
#define PORTUGUESE   TEXT("POR")
#define SIMP_CHINESE TEXT("SCH")
#define POLISH       TEXT("POL")
#define RUSSIAN      TEXT("RUS")
#define TURKISH      TEXT("TUR")
#define ROMANIAN     TEXT("ROM")
#define KOREAN       TEXT("KOR")
#define TRAD_CHINESE TEXT("TCH")
#define JAPANESE     TEXT("JPN")
#define GREEK        TEXT("GRK")
#define DANISH       TEXT("DAN")

// Port name
#define PORTNAME_LPT   L"LPT"
#define PORTNAME_USB   L"USB"
#define PORTNAME_TCPIP L"IP_"
#define PORTNAME_FILE  L"FILE:"
#define PORTNAME_TS    L"TS"
#define PORTNAME_NE    L"NE"

// #############################################################################
typedef uint32_t COLORREF;

typedef struct _RECTL {
    int32_t left;
    int32_t top;
    int32_t right;
    int32_t bottom;
} RECTL;

typedef struct _RECTL *PRECTL;

typedef struct _RECTL *LPRECTL;

typedef struct _POINTL {
    int32_t x;
    int32_t y;
} POINTL;

typedef struct _RGBTRIPLE {
    uint8_t rgbtBlue;
    uint8_t rgbtGreen;
    uint8_t rgbtRed;
} RGBTRIPLE, *PRGBTRIPLE, *LPRGBTRIPLE;

enum { OFF, ON };

enum { FRONT, BACK };

enum PrintMode { PRINT_MODE_NORMAL, PRINT_MODE_ENHANCED };

#define GEN_DEBUG_FLAG      0x01
#define LM_DEBUG_FLAG       0x02
#define SM_DEBUG_FLAG       0x04
#define ETHERNET_DEBUG_FLAG 0x08
#define GFX_DEBUG_FLAG      0x10
#define ALL_DEBUG           (GEN_DEBUG_FLAG | LM_DEBUG_FLAG | SM_DEBUG_FLAG)

#define NUMBER_05S 64

/*#include "debug.h"
////#define MAGDEBUG
#ifdef LANG_MON
  #define LM_DEBUGGING(x) ((x) & LM_DEBUG_FLAG)
  #define ERROR_MSG(x)  {if (LM_DEBUGGING(iLM_Debug)) ErrorMsg(x);}
#else
#ifdef STATUS_MON
  #define ERROR_MSG(x) {if (bSM_Debug) ErrorMsg(x);}
#else
  #define ERROR_MSG(x, y) {if (DetermineDebugStatus((x)))
OutputDebugString((y));}
#endif
#endif
*/

// #############################################################################

#define MAG_PRINTER  0x01
#define DUO_PRINTER  0x02
#define CHIP_PRINTER 0x10

enum {
    // Printer Family assignment set to OEM value in devmode
    OEM_RIO = 1,
    OEM_AOTA,
    OEM_ENDURO,
    OEM_HELIX,
    OEM_PRO360
};

enum {
    // Rio Printers
    RIO_TANGO = 0,
    XXL       = 1,
    // AOTA Printers
    ALTO   = 2,
    OPERA  = 3,
    TEMPO  = 4,
    AVALON = 5,
    DCP100 = 6,
    // Enduro Printers
    ENDURO          = 7,
    MC200           = 8,
    PRONTO          = 9,
    PRO             = 10,
    IDMAKER         = 11,
    P4500S          = 12,
    P2500S          = 13,
    PPC_ID2000      = 14,
    PPC_ID2100      = 15,
    PPC_ID3100      = 16,
    IDM_VALUE       = 17,
    IDM_ADVANTAGE   = 18,
    IDM_SECURE      = 19,
    RIO_PRO_XTENDED = 20,
    FAGOO_P310E     = 21,
    ENDURO_PLUS     = 22,
    PPC_ID2300      = 23,
    IDM_ADVANT_PLUS = 24,
    P4500S_PLUS     = 25,
    PPC_ID3300      = 26,
    REWRITEPRINTER_A
    __attribute__((deprecated("Rewrite Printer A was never built."))) = 27,
    REWRITEPRINTER_B
    __attribute__((deprecated("Rewrite Printer B was never built."))) = 28,
    SECUPRINT_200
    __attribute__((deprecated("SECUPRINT 200 no longer supported."))) = 29,
    PRIDENTO_PLUS                                                     = 30,
    PRIDENTO                                                          = 31,
    ING171                                                            = 32,
    IDENTITYPRO                                                       = 33,
    DOH                                                               = 34,
    PRIDENTOPRO                                                       = 35,
    PRIDENTOPROXTD                                                    = 36,
    ENDURO_3E                                                         = 37,
    PPC_ID2350E                                                       = 38,
    ILINKCARD_IT2600                                                  = 39,
    DOPPIE_100                                                        = 40,
    DOPPIE_200                                                        = 41,
    DOPPIE_300                                                        = 42,
    ESSENTRASOLO                                                      = 43,
    ESSENTRAPLUS                                                      = 44,
    ESSENTRAPRO                                                       = 45,
    PCARD                                                             = 46,
    ORPHICARD                                                         = 47,
    SCREENCHECK_SC2500                                                = 48,
    SCREENCHECK_SC4500                                                = 49,
    SCREENCHECK_SC6500                                                = 50,
    XR160                                                             = 51,
    XR260                                                             = 52,
    XR360 __attribute__((deprecated("xr360 was never built.")))       = 53,
    MATICA_M300 __attribute__((deprecated("M300 was never built.")))  = 54,
    MATICA_M500 __attribute__((deprecated("M500 was never built.")))  = 55,
    AUTHENTYS                                                         = 56,
    AUTHENTYS_PRO                                                     = 57,
    AUTHENTYS_PLUS                                                    = 58,
    AUTHENTYS_PRONTO                                                  = 59,
    PLASCO_RIOPRO_LE                                                  = 60,
    PLASCO_ENDURO_LE                                                  = 61,
    JKE700C                                                           = 62,
    JKE160C                                                           = 63,
    JKE701C                                                           = 64,
    PRIDENTO_PLUS_OPEN_DATA                                           = 65,
    PRIDENTO_OPEN_DATA                                                = 66,
    ALPHACARD_PILOT                                                   = 67,
    ALPHACARD_COMPASS                                                 = 68,
    ALPHACARD_PRO_100                                                 = 69,
    ALPHACARD_PRO_500                                                 = 70,
    ALPHACARD_PRO_700                                                 = 71,
    PRICECARD_PRO_LITE                                                = 72,
    PRICECARD_PRO_DUO                                                 = 73,
    PRICECARD_PRO_FLEX                                                = 74,
    PHILOS_DTP_MK_1                                                   = 75,
    PHILOS_DTP_MK_2                                                   = 76,
    PHILOS_DTP_MK_3                                                   = 77,
    TITAN_T3                                                          = 78,
    TITAN_T5                                                          = 79,
    ELLIADEN_CAROLINE                                                 = 80,
    CARDMAKER_260                                                     = 81,
    PRONTO_NEO                                                        = 82,
    ENDURO_NEO                                                        = 83,
    NOVA                                                              = 84,
    // Helix Printers
    HELIX              = 85,
    PPC_RTP7500W       = 86,
    AUTHENTYS_RETRAX   = 87,
    SCREENCHECK_SC7500 = 88,
    HELIX_RT __attribute__((deprecated(
            "HELIX_RT was rebranded to ULTIMA, please use that instead."))) =
            89,
    ULTIMA = 90,
    // Pro 2 Printers
    PRO360 = 91,
    PRO_SELECT_360
    __attribute__((deprecated("Rio Pro 360 Select was never built.")))    = 92,
    PRO360_XTD                                                            = 93,
    IDM_SECURE_360                                                        = 94,
    AUTHENTYS_PRO_360                                                     = 95,
    ALPHACARD_PRO_700_360                                                 = 96,
    PHILOS_DTP_MK_3_360                                                   = 97,
    PLASCO_RIOPRO_LE_360                                                  = 98,
    SCREENCHECK_SC6500_360                                                = 99,
    TITAN_T5_360                                                          = 100,
    PPC_ID3350E_360                                                       = 101,
    PRIDENTO_PRO_360                                                      = 102,
    PRIDENTO_PRO_360_XTD                                                  = 103,
    PRICECARD_PRO_FLEX_360                                                = 104,
    PRO600                                                                = 105,
    PRO600_XTD __attribute__((deprecated("An xtd 600 was never built."))) = 106,
    CARDMAKER_360                                                         = 107,
    ALPHACARD_PRO_750_360                                                 = 108,
    PRO360NEO                                                             = 109,
    PRO300                                                                = 110,
    AUTHENTYS300                                                          = 111,
    PRIDENTO300                                                           = 112,
    ELLIADEN_CAROLINE300
    __attribute__((deprecated("ELLIADEN_CAROLINE300 was never built."))) = 113,
    ALPHACARD_PRO_550                                                    = 114,
    IDMAKER_EDGE                                                         = 115,
    IDMAKER_APEX                                                         = 116,
    PLASCO_300LE __attribute__((deprecated("Plasco 300LE was never built."))) =
            117,
    PLASCO_600LE __attribute__((deprecated("Plasco 600LE was never built."))) =
            118,
    PPC_ID3000                                                      = 119,
    PPC_ID4000                                                      = 120,
    PRO500 __attribute__((deprecated("Pro 500 was never built. Did you mean to "
                                     "use PRO500_D or PRO500_K?"))) = 121,
    PRO500_D                                                        = 122,
    PRO500_K                                                        = 123,
    BOOD680                                                         = 124,
    FAGOOP360E                                                      = 125,
    GOODCARDXR260D                                                  = 126,
    ING550                                                          = 127,
    GOODCARDXR360K                                                  = 128,
    PFS2360 __attribute__((deprecated("PFS2360 was never built."))) = 129,
    DOH300                                                          = 130,
    MODEL_MAGICARD_PRONTO_100                                       = 131,
    MODEL_MAGICARD_PRONTO_100_E      = 132, // Placeholder
    MODEL_MAGICARD_100_NEO           = 133,
    MODEL_IDVILLE_ID_MAKER_VALUE_MB1 = 134,
    MODEL_MAGICARD_PRONTO_MB1        = 135,
    MODEL_IDVILLE_ID_MAKER_ARC_MB1   = 136,
    MODEL_CARDMAKER_CMK_MB1
    __attribute__((deprecated("Cardmaker CMK was never built."))) = 137,
    MODEL_ALPHACARD_PRO_150_MB1
    __attribute__((deprecated("Pro 150 was never built."))) = 138,
    MODEL_PRICECARD_PRO_100                                 = 139,
    MODEL_MAGICARD_PRICECARDPRO_FLEX_PLUS                   = 140,
    MODEL_DIGITAL_ID_EASYBADGE_3_0_MB1                      = 141,
    MODEL_MAGICARD_PRONTO_NEO_MB1                           = 142,
    MODEL_ALPHACARD_PRO_100_MB1                             = 143,
    MODEL_GOODCARD_XR160_MB1                                = 144,
    MODEL_ALPHACARD_PILOT_MB1                               = 145,
    MODEL_CENTENA_EDGE_MB1                                  = 146,
    MODEL_MAGICARD_300_NEO_MB1                              = 147,
    MODEL_MAGICARD_600_NEO_MB1                              = 148,
    MODEL_MAGICARD_D_SUPPORTED_BY_BODNO_MB1                 = 149,
    MODEL_GUDECARD_XR160PRO_MB1                             = 150,
    MODEL_MAGICARD_E_PLUS_MB1                               = 151,
    MODEL_BRADY_PA1100_MB1                                  = 152,
    MODEL_BRADY_PA1300_MB1                                  = 153,
    MODEL_MAGICARD_E_PLUS_NEO_MB1                           = 154
};

/*//Rio Printers
#define RIO_TANGO       UICBVAL_Model_1
#define XXL             UICBVAL_Model_2
//AOTA Printers
#define ALTO            UICBVAL_Model_1
#define OPERA           UICBVAL_Model_2
#define TEMPO           UICBVAL_Model_3
#define AVALON          UICBVAL_Model_4
#define DCP100          UICBVAL_Model_5
//Enduro Printers
#define ENDURO          UICBVAL_Model_1
#define MC200           UICBVAL_Model_2
#define PRONTO          UICBVAL_Model_3
#define PRO             UICBVAL_Model_4
#define IDMAKER         UICBVAL_Model_5
#define AUTHENTYS       UICBVAL_Model_6
#define P4500S          UICBVAL_Model_7
#define P2500S          UICBVAL_Model_8
#define PPC_ID2000      UICBVAL_Model_9
#define PPC_ID2100      UICBVAL_Model_10
#define PPC_ID3100      UICBVAL_Model_11
#define IDM_VALUE       UICBVAL_Model_12
#define IDM_ADVANTAGE   UICBVAL_Model_13
#define IDM_SECURE      UICBVAL_Model_14
#define AUTHENTYS_PRO   UICBVAL_Model_15
#define RIO_PRO_XTENDED UICBVAL_Model_16
#define AISINO_JKE700C  UICBVAL_Model_17
#define FAGOO_P310E     UICBVAL_Model_18
#define ENDURO_PLUS     UICBVAL_Model_19
#define AUTHENTYS_PLUS  UICBVAL_Model_20
#define PPC_ID2300      UICBVAL_Model_21
#define IDM_ADVANT_PLUS UICBVAL_Model_22
#define P4500S_PLUS     UICBVAL_Model_23
#define PPC_ID3300      UICBVAL_Model_24
#define AISINO_JKE160C  UICBVAL_Model_25
#define REWRITE_PRINTER_A UICBVAL_Model_26
#define REWRITE_PRINTER_B UICBVAL_Model_27
*/

#define HELIX_OEM(x)          (x->OEM == OEM_HELIX)
#define HELIX_MODEL(x)        (HELIX_OEM((x)) && (MODEL((x)) == HELIX))
#define ULTIMA_MODEL(x)       (HELIX_OEM((x)) && (MODEL((x)) == ULTIMA))
#define PPC_RTP7500W_MODEL(x) (HELIX_OEM((x)) && (MODEL((x)) == PPC_RTP7500W))
#define AUTHENTYS_RETRAX_MODEL(x)                                              \
    (HELIX_OEM((x)) && (MODEL((x)) == AUTHENTYS_RETRAX))
#define SCREENCHECK_SC7500_MODEL(x)                                            \
    (HELIX_OEM((x)) && (MODEL((x)) == SCREENCHECK_SC7500))

// X Type defines
#define MODEL(x) (x->Printer)
#define RIO_MODEL(x)                                                           \
    (RIO_OEM((x)) && (MODEL((x)) == RIO_TANGO) && (x->TargetPrinter == 1))
#define TANGO_MODEL(x)                                                         \
    (RIO_OEM((x)) && (MODEL((x)) == RIO_TANGO) && (x->TargetPrinter == 2))
#define LAMINATOR_MODEL(x)                                                     \
    (RIO_OEM((x)) && (MODEL((x)) == RIO_TANGO) && (x->TargetPrinter == 3))
#define XXL_MODEL(x) (RIO_OEM((x)) && (MODEL((x)) == XXL))

// Alto type defines
#define AOTA_OEM(x)     (x->OEM == OEM_AOTA)
#define ALTO_MODEL(x)   (AOTA_OEM((x)) && (MODEL((x)) == ALTO))
#define OPERA_MODEL(x)  (AOTA_OEM((x)) && (MODEL((x)) == OPERA))
#define TEMPO_MODEL(x)  (AOTA_OEM((x)) && (MODEL((x)) == TEMPO))
#define AVALON_MODEL(x) (AOTA_OEM((x)) && (MODEL((x)) == AVALON))
#define DCP100_MODEL(x) (AOTA_OEM((x)) && (MODEL((x)) == DCP100))

// Enduro and Rio Pro type defines
#define RIO_OEM(x)          (x->OEM == OEM_RIO)
#define ENDURO_OEM(x)       (x->OEM == OEM_ENDURO)
#define ENDURO_MODEL(x)     (ENDURO_OEM((x)) && (MODEL((x)) == ENDURO))
#define MC200_MODEL(x)      (ENDURO_OEM((x)) && (MODEL((x)) == MC200))
#define PRONTO_MODEL(x)     (ENDURO_OEM((x)) && (MODEL((x)) == PRONTO))
#define RIOPRO_MODEL(x)     (ENDURO_OEM((x)) && (MODEL((x)) == PRO))
#define IDMAKER_MODEL(x)    (ENDURO_OEM((x)) && (MODEL((x)) == IDMAKER))
#define P4500S_MODEL(x)     (ENDURO_OEM((x)) && (MODEL((x)) == P4500S))
#define P2500S_MODEL(x)     (ENDURO_OEM((x)) && (MODEL((x)) == P2500S))
#define PPC_ID2000_MODEL(x) (ENDURO_OEM((x)) && (MODEL((x)) == PPC_ID2000))
#define PPC_ID2100_MODEL(x) (ENDURO_OEM((x)) && (MODEL((x)) == PPC_ID2100))
#define PPC_ID3100_MODEL(x) (ENDURO_OEM((x)) && (MODEL((x)) == PPC_ID3100))
#define IDM_VALUE_MODEL(x)  (ENDURO_OEM((x)) && (MODEL((x)) == IDM_VALUE))
#define IDM_ADVANTAGE_MODEL(x)                                                 \
    (ENDURO_OEM((x)) && (MODEL((x)) == IDM_ADVANTAGE))
#define IDM_SECURE_MODEL(x)  (ENDURO_OEM((x)) && (MODEL((x)) == IDM_SECURE))
#define RIO_PRO_X_MODEL(x)   (ENDURO_OEM((x)) && (MODEL((x)) == RIO_PRO_XTENDED))
#define FAGOO_P310E_MODEL(x) (ENDURO_OEM((x)) && (MODEL((x)) == FAGOO_P310E))
#define ENDURO_PLUS_MODEL(x) (ENDURO_OEM((x)) && (MODEL((x)) == ENDURO_PLUS))
#define PPC_ID2300_MODEL(x)  (ENDURO_OEM((x)) && (MODEL((x)) == PPC_ID2300))
#define P4500S_PLUS_MODEL(x) (ENDURO_OEM((x)) && (MODEL((x)) == P4500S_PLUS))
#define IDM_ADV_PLUS_MODEL(x)                                                  \
    (ENDURO_OEM((x)) && (MODEL((x)) == IDM_ADVANT_PLUS))
#define PPC_ID3300_MODEL(x) (ENDURO_OEM((x)) && (MODEL((x)) == PPC_ID3300))
#define PRIDENTO_PLUS_MODEL(x)                                                 \
    (ENDURO_OEM((x)) && (MODEL((x)) == PRIDENTO_PLUS))
#define PRIDENTO_MODEL(x)     (ENDURO_OEM((x)) && (MODEL((x)) == PRIDENTO))
#define ING171_MODEL(x)       (ENDURO_OEM((x)) && (MODEL((x)) == ING171))
#define IDENTITY_PRO_MODEL(x) (ENDURO_OEM((x)) && (MODEL((x)) == IDENTITYPRO))
#define DOH_MODEL(x)          (ENDURO_OEM((x)) && (MODEL((x)) == DOH))
#define PRIDENTO_PRO_MODEL(x) (ENDURO_OEM((x)) && (MODEL((x)) == PRIDENTOPRO))
#define PRIDENTO_PRO_X_MODEL(x)                                                \
    (ENDURO_OEM((x)) && (MODEL((x)) == PRIDENTOPROXTD))
#define ENDURO_3E_MODEL(x)   (ENDURO_OEM((x)) && (MODEL((x)) == ENDURO_3E))
#define PPC_ID2350E_MODEL(x) (ENDURO_OEM((x)) && (MODEL((x)) == PPC_ID2350E))
#define ILINKCARD_IT2600_MODEL(x)                                              \
    (ENDURO_OEM((x)) && (MODEL((x)) == ILINKCARD_IT2600))
#define DOPPIE_100_MODEL(x)    (ENDURO_OEM((x)) && (MODEL((x)) == DOPPIE_100))
#define DOPPIE_200_MODEL(x)    (ENDURO_OEM((x)) && (MODEL((x)) == DOPPIE_200))
#define DOPPIE_300_MODEL(x)    (ENDURO_OEM((x)) && (MODEL((x)) == DOPPIE_300))
#define ESSENTRA_SOLO_MODEL(x) (ENDURO_OEM((x)) && (MODEL((x)) == ESSENTRASOLO))
#define ESSENTRA_PLUS_MODEL(x) (ENDURO_OEM((x)) && (MODEL((x)) == ESSENTRAPLUS))
#define ESSENTRA_PRO_MODEL(x)  (ENDURO_OEM((x)) && (MODEL((x)) == ESSENTRAPRO))
#define P_CARD_MODEL(x)        (ENDURO_OEM((x)) && (MODEL((x)) == PCARD))
#define ORPHICARD_MODEL(x)     (ENDURO_OEM((x)) && (MODEL((x)) == ORPHICARD))
#define SCREENCHECK_SC2500_MODEL(x)                                            \
    (ENDURO_OEM((x)) && (MODEL((x)) == SCREENCHECK_SC2500))
#define SCREENCHECK_SC4500_MODEL(x)                                            \
    (ENDURO_OEM((x)) && (MODEL((x)) == SCREENCHECK_SC4500))
#define SCREENCHECK_SC6500_MODEL(x)                                            \
    (ENDURO_OEM((x)) && (MODEL((x)) == SCREENCHECK_SC6500))
#define XR160_MODEL(x)     (ENDURO_OEM((x)) && (MODEL((x)) == XR160))
#define XR260_MODEL(x)     (ENDURO_OEM((x)) && (MODEL((x)) == XR260))
#define AUTHENTYS_MODEL(x) (ENDURO_OEM((x)) && (MODEL((x)) == AUTHENTYS))
#define AUTHENTYS_PRO_MODEL(x)                                                 \
    (ENDURO_OEM((x)) && (MODEL((x)) == AUTHENTYS_PRO))
#define AUTH_PLUS_MODEL(x) (ENDURO_OEM((x)) && (MODEL((x)) == AUTHENTYS_PLUS))
#define AUTHENTYS_PRONTO_MODEL(x)                                              \
    (ENDURO_OEM((x)) && (MODEL((x)) == AUTHENTYS_PRONTO))
#define PLASCO_ENDURO_LE_MODEL(x)                                              \
    (ENDURO_OEM((x)) && (MODEL((x)) == PLASCO_ENDURO_LE))
#define PLASCO_RIOPRO_LE_MODEL(x)                                              \
    (ENDURO_OEM((x)) && (MODEL((x)) == PLASCO_RIOPRO_LE))
#define AISINO_JKE700C_MODEL(x) (ENDURO_OEM((x)) && (MODEL((x)) == JKE700C))
#define AISINO_JKE160C_MODEL(x) (ENDURO_OEM((x)) && (MODEL((x)) == JKE160C))
#define AISINO_JKE701C_MODEL(x) (ENDURO_OEM((x)) && (MODEL((x)) == JKE701C))
#define PRIDENTO_PLUS_OPEN_DATA_MODEL(x)                                       \
    (ENDURO_OEM((x)) && (MODEL((x)) == PRIDENTO_PLUS_OPEN_DATA))
#define PRIDENTO_OPEN_DATA_MODEL(x)                                            \
    (ENDURO_OEM((x)) && (MODEL((x)) == PRIDENTO_OPEN_DATA))
#define ALPHACARD_PILOT_MODEL(x)                                               \
    (ENDURO_OEM((x)) && (MODEL((x)) == ALPHACARD_PILOT))
#define ALPHACARD_COMPASS_MODEL(x)                                             \
    (ENDURO_OEM((x)) && (MODEL((x)) == ALPHACARD_COMPASS))
#define ALPHACARD_PRO_100_MODEL(x)                                             \
    (ENDURO_OEM((x)) && (MODEL((x)) == ALPHACARD_PRO_100))
#define ALPHACARD_PRO_500_MODEL(x)                                             \
    (ENDURO_OEM((x)) && (MODEL((x)) == ALPHACARD_PRO_500))
#define ALPHACARD_PRO_700_MODEL(x)                                             \
    (ENDURO_OEM((x)) && (MODEL((x)) == ALPHACARD_PRO_700))
#define PRICECARD_PRO_LITE_MODEL(x)                                            \
    (ENDURO_OEM((x)) && (MODEL((x)) == PRICECARD_PRO_LITE))
#define PRICECARD_PRO_DUO_MODEL(x)                                             \
    (ENDURO_OEM((x)) && (MODEL((x)) == PRICECARD_PRO_DUO))
#define PRICECARD_PRO_FLEX_MODEL(x)                                            \
    (ENDURO_OEM((x)) && (MODEL((x)) == PRICECARD_PRO_FLEX))
#define PHILOS_DTP_MK_1_MODEL(x)                                               \
    (ENDURO_OEM((x)) && (MODEL((x)) == PHILOS_DTP_MK_1))
#define PHILOS_DTP_MK_2_MODEL(x)                                               \
    (ENDURO_OEM((x)) && (MODEL((x)) == PHILOS_DTP_MK_2))
#define PHILOS_DTP_MK_3_MODEL(x)                                               \
    (ENDURO_OEM((x)) && (MODEL((x)) == PHILOS_DTP_MK_3))
#define TITAN_T3_MODEL(x) (ENDURO_OEM((x)) && (MODEL((x)) == TITAN_T3))
#define TITAN_T5_MODEL(x) (ENDURO_OEM((x)) && (MODEL((x)) == TITAN_T5))
#define ELLIADEN_CAROLINE_MODEL(x)                                             \
    (ENDURO_OEM((x)) && (MODEL((x)) == ELLIADEN_CAROLINE))
#define CARDMAKER_260_MODEL(x)                                                 \
    (ENDURO_OEM((x)) && (MODEL((x)) == CARDMAKER_260))
#define PRONTO_NEO_MODEL(x) (ENDURO_OEM((x)) && (MODEL((x)) == PRONTO_NEO))
#define ENDURO_NEO_MODEL(x) (ENDURO_OEM((x)) && (MODEL((x)) == ENDURO_NEO))
#define NOVA_MODEL(x)       (ENDURO_OEM((x)) && (MODEL((x)) == NOVA))

// 360 type defines
#define PRO360_OEM(x)       (x->OEM == OEM_PRO360)
#define PRO360_MODEL(x)     (PRO360_OEM((x)) && (MODEL((x)) == PRO360))
#define PRO360_XTD_MODEL(x) (PRO360_OEM((x)) && (MODEL((x)) == PRO360_XTD))
#define PRO360_XTD_TYPE(x)                                                     \
    (PRO360_XTD_MODEL((x)) || PRIDENTO_PRO_360_XTD_MODEL((x)) ||               \
     PRICECARD_PRO_FLEX_360_MODEL((x)) ||                                      \
     MAGICARD_PRICECARDPRO_FLEX_PLUS_MODEL((x)))
#define IDM_SECURE_MODEL_360(x)                                                \
    (PRO360_OEM((x)) && (MODEL((x)) == IDM_SECURE_360))
#define AUTHENTYS_PRO_MODEL_360(x)                                             \
    (PRO360_OEM((x)) && (MODEL((x)) == AUTHENTYS_PRO_360))
#define ALPHACARD_PRO_700_MODEL_360(x)                                         \
    (PRO360_OEM((x)) && (MODEL((x)) == ALPHACARD_PRO_700_360))
#define PHILOS_DTP_MK_3_MODEL_360(x)                                           \
    (PRO360_OEM((x)) && (MODEL((x)) == PHILOS_DTP_MK_3_360))
#define PLASCO_RIOPRO_LE_MODEL_360(x)                                          \
    (PRO360_OEM((x)) && (MODEL((x)) == PLASCO_RIOPRO_LE_360))
#define SCREENCHECK_SC6500_MODEL_360(x)                                        \
    (PRO360_OEM((x)) && (MODEL((x)) == SCREENCHECK_SC6500_360))
#define TITAN_T5_MODEL_360(x) (PRO360_OEM((x)) && (MODEL((x)) == TITAN_T5_360))
#define PPC_ID3350E_MODEL_360(x)                                               \
    (PRO360_OEM((x)) && (MODEL((x)) == PPC_ID3350E_360))
#define PRIDENTO_PRO_MODEL_360(x)                                              \
    (PRO360_OEM((x)) && (MODEL((x)) == PRIDENTO_PRO_360))
#define PRIDENTO_PRO_360_XTD_MODEL(x)                                          \
    (PRO360_OEM((x)) && (MODEL((x)) == PRIDENTO_PRO_360_XTD))
#define PRICECARD_PRO_FLEX_360_MODEL(x)                                        \
    (PRO360_OEM((x)) && (MODEL((x)) == PRICECARD_PRO_FLEX_360))
#define CARDMAKER_360_MODEL(x)                                                 \
    (PRO360_OEM((x)) && (MODEL((x)) == CARDMAKER_360))
#define ALPHACARD_PRO_750_MODEL_360(x)                                         \
    (PRO360_OEM((x)) && (MODEL((x)) == ALPHACARD_PRO_750_360))
#define MAGICARD_360_NEO_MODEL(x) (PRO360_OEM((x)) && (MODEL((x)) == PRO360NEO))
#define MAGICARD_300_MODEL(x)     (PRO360_OEM((x)) && (MODEL((x)) == PRO300))
#define AUTHENTYS_300_MODEL(x)    (PRO360_OEM((x)) && (MODEL((x)) == AUTHENTYS300))
#define PRIDENTO_300_MODEL(x)     (PRO360_OEM((x)) && (MODEL((x)) == PRIDENTO300))
#define ALPHACARD_PRO_550_MODEL(x)                                             \
    (PRO360_OEM((x)) && (MODEL((x)) == ALPHACARD_PRO_550))
#define ID_MAKER_EDGE_MODEL(x) (PRO360_OEM((x)) && (MODEL((x)) == IDMAKER_EDGE))
#define ID_MAKER_APEX_MODEL(x) (PRO360_OEM((x)) && (MODEL((x)) == IDMAKER_APEX))
#define PPC_ID3000_MODEL(x)    (PRO360_OEM((x)) && (MODEL((x)) == PPC_ID3000))
#define PPC_ID4000_MODEL(x)    (PRO360_OEM((x)) && (MODEL((x)) == PPC_ID4000))
#define PRO500_D_MODEL(x)      (PRO360_OEM((x)) && (MODEL((x)) == PRO500_D))
#define PRO500_K_MODEL(x)      (PRO360_OEM((x)) && (MODEL((x)) == PRO500_K))
#define BOOD_680_MODEL(x)      (PRO360_OEM((x)) && (MODEL((x)) == BOOD680))
#define FAGOO_P360E_MODEL(x)   (PRO360_OEM((x)) && (MODEL((x)) == FAGOOP360E))
#define GOODCARD_XR260D_MODEL(x)                                               \
    (PRO360_OEM((x)) && (MODEL((x)) == GOODCARDXR260D))
#define ING_550_MODEL(x) (PRO360_OEM((x)) && (MODEL((x)) == ING550))
#define GOODCARD_XR360K_MODEL(x)                                               \
    (PRO360_OEM((x)) && (MODEL((x)) == GOODCARDXR360K))
#define DOH_300_MODEL(x) (PRO360_OEM((x)) && (MODEL((x)) == DOH300))

// Magicard Pronto 100 variants
#define MAGICARD_PRONTO_100_MODEL(x)                                           \
    (PRO360_OEM((x)) && (MODEL((x)) == MODEL_MAGICARD_PRONTO_100))
#define MAGICARD_PRONTO_100_E_MODEL(x)                                         \
    (PRO360_OEM((x)) && (MODEL((x)) == MODEL_MAGICARD_PRONTO_100_E))
#define MAGICARD_100_NEO_MODEL(x)                                              \
    (PRO360_OEM((x)) && (MODEL((x)) == MODEL_MAGICARD_100_NEO))
#define MAGICARD_PRONTO_MB1_MODEL(x)                                           \
    (PRO360_OEM((x)) && (MODEL((x)) == MODEL_MAGICARD_PRONTO_MB1))
#define DIGITAL_ID_EASYBADGE_3_0_MB1_MODEL(x)                                  \
    (PRO360_OEM((x)) && (MODEL((x)) == MODEL_DIGITAL_ID_EASYBADGE_3_0_MB1))
#define MAGICARD_PRONTO_NEO_MB1_MODEL(x)                                       \
    (PRO360_OEM((x)) && (MODEL((x)) == MODEL_MAGICARD_PRONTO_NEO_MB1))

// White label Pronto 100 variants
#define IDVILLE_ID_MAKER_ARC_MB1_MODEL(x)                                      \
    (PRO360_OEM((x)) && (MODEL((x)) == MODEL_IDVILLE_ID_MAKER_ARC_MB1))

// PriceCardPro variant of Pronto 100
#define PRICECARD_PRO_100_MODEL(x)                                             \
    (PRO360_OEM((x)) && (MODEL((x)) == MODEL_PRICECARD_PRO_100))

// Same idea as the PRONTO (MB1) machine, looks like the original
// 'IDville ID Maker Value' but with MB1 internals
#define IDVILLE_ID_MAKER_VALUE_MB1_MODEL(x)                                    \
    (PRO360_OEM((x)) && (MODEL((x)) == MODEL_IDVILLE_ID_MAKER_VALUE_MB1))

// AlphaCard PRO 100.
#define ALPHACARD_PRO_100_MB1_MODEL(x)                                         \
    (PRO360_OEM((x)) && (MODEL((x)) == MODEL_ALPHACARD_PRO_100_MB1))

#define GOODCARD_XR160_MB1_MODEL(x)                                            \
    (PRO360_OEM((x)) && (MODEL((x)) == MODEL_GOODCARD_XR160_MB1))

#define ALPHACARD_PILOT_MB1_MODEL(x)                                           \
    (PRO360_OEM((x)) && (MODEL((x)) == MODEL_ALPHACARD_PILOT_MB1))

#define CENTENA_EDGE_MB1_MODEL(x)                                              \
    (PRO360_OEM((x)) && (MODEL((x)) == MODEL_CENTENA_EDGE_MB1))

#define MAGICARD_300_NEO_MB1_MODEL(x)                                          \
    (PRO360_OEM((x)) && (MODEL((x)) == MODEL_MAGICARD_300_NEO_MB1))

#define MAGICARD_600_NEO_MB1_MODEL(x)                                          \
    (PRO360_OEM((x)) && (MODEL((x)) == MODEL_MAGICARD_600_NEO_MB1))

#define MAGICARD_D_SUPPORTED_BY_BODNO_MB1_MODEL(x)                             \
    (PRO360_OEM((x)) && (MODEL((x)) == MODEL_MAGICARD_D_SUPPORTED_BY_BODNO_MB1))

// Gudecard XR160PRO (V2) (Pronto MB1 model)
#define GUDECARD_XR160PRO_MB1_MODEL(x)                                         \
    (PRO360_OEM((x)) && (MODEL((x)) == MODEL_GUDECARD_XR160PRO_MB1))

#define MAGICARD_E_PLUS_MB1_MODEL(x)                                           \
    (PRO360_OEM((x)) && (MODEL((x)) == MODEL_MAGICARD_E_PLUS_MB1))

// Brady PA1100 (Pronto 100 model)
#define BRADY_PA1100_MB1_MODEL(x)                                              \
    (PRO360_OEM((x)) && (MODEL((x)) == MODEL_BRADY_PA1100_MB1))

// Brady PA1300 (300 model)
#define BRADY_PA1300_MB1_MODEL(x)                                              \
    (PRO360_OEM((x)) && (MODEL((x)) == MODEL_BRADY_PA1300_MB1))

#define MAGICARD_E_PLUS_NEO_MB1_MODEL(x)                                       \
    (PRO360_OEM((x)) && (MODEL((x)) == MODEL_MAGICARD_E_PLUS_NEO_MB1))

// Magicard branded Pronto 100 printers, excludes the 'Magicard PRONTO  (V2)'
// model which is a lookalike to the original 'Magicard Pronto' with MB1
// internals.
#define MAGICARD_PRONTO_100_BASE_TYPE(x)                                       \
    (MAGICARD_PRONTO_100_MODEL((x)) || MAGICARD_PRONTO_100_E_MODEL((x)) ||     \
     MAGICARD_100_NEO_MODEL((x)) || PRICECARD_PRO_100_MODEL((x)))

// The Magicard base types and 'Magicard PRONTO  (V2)'
#define MAGICARD_PRONTO_100_TYPE(x)                                            \
    (MAGICARD_PRONTO_100_BASE_TYPE((x)) || MAGICARD_PRONTO_MB1_MODEL((x)) ||   \
     IDVILLE_ID_MAKER_VALUE_MB1_MODEL((x)) ||                                  \
     MAGICARD_PRONTO_NEO_MB1_MODEL((x)))

// White label versions of Pronto 100
#define PRONTO_100_WHITE_LABEL_TYPE(x)                                         \
    (IDVILLE_ID_MAKER_ARC_MB1_MODEL((x)) || PRICECARD_PRO_100_MODEL((x)) ||    \
     DIGITAL_ID_EASYBADGE_3_0_MB1_MODEL((x)) ||                                \
     ALPHACARD_PRO_100_MB1_MODEL((x)) || GOODCARD_XR160_MB1_MODEL((x)) ||      \
     ALPHACARD_PILOT_MB1_MODEL((x)))

// All Pronto 100 variants including 'Magicard PRONTO  (V2)' and 'IDville ID
// Maker VALUE  (V2)'
#define PRONTO_100_TYPE(x)                                                     \
    (PRONTO_100_WHITE_LABEL_TYPE((x)) || MAGICARD_PRONTO_100_TYPE((x)))

// All Pronto 100 variants excluding 'Magicard PRONTO  (V2)' and and 'IDville ID
// Maker VALUE  (V2)'
#define PRONTO_100_CORE_TYPES(x)                                               \
    (MAGICARD_PRONTO_100_BASE_TYPE((x)) || PRONTO_100_WHITE_LABEL_TYPE((x)))

// PriceCardPro Flex+
#define MAGICARD_PRICECARDPRO_FLEX_PLUS_MODEL(x)                               \
    (PRO360_OEM((x)) && (MODEL((x)) == MODEL_MAGICARD_PRICECARDPRO_FLEX_PLUS))

// 600 type defines
#define PRO600_MODEL(x) (PRO360_OEM((x)) && (MODEL((x)) == PRO600))
#define PRO600_TYPE(x)                                                         \
    (PRO600_MODEL((x)) || ALPHACARD_PRO_750_MODEL_360((x)) ||                  \
     ID_MAKER_APEX_MODEL((x)) || PPC_ID4000_MODEL((x)) ||                      \
     MAGICARD_600_NEO_MB1_MODEL((x)))

// OEM group defines
#define CARDMAKER_TYPE(x) (CARDMAKER_260_MODEL((x)) || CARDMAKER_360_MODEL((x)))

#define ELLIADEN_TYPE(x) (ELLIADEN_CAROLINE_MODEL((x)))

#define TITAN_TYPE(x) (TITAN_T3_MODEL((x)) || TITAN_T5_MODEL((x)))

#define PHILOS_TYPE(x)                                                         \
    (PHILOS_DTP_MK_1_MODEL((x)) || PHILOS_DTP_MK_2_MODEL((x)) ||               \
     PHILOS_DTP_MK_3_MODEL((x)))

#define PRICECARDPRO_TYPE(x)                                                   \
    (PRICECARD_PRO_LITE_MODEL((x)) || PRICECARD_PRO_DUO_MODEL((x)) ||          \
     PRICECARD_PRO_FLEX_MODEL((x)) || PRICECARD_PRO_100_MODEL((x)) ||          \
     MAGICARD_PRICECARDPRO_FLEX_PLUS_MODEL((x)))

#define ALPHACARD_TYPE(x)                                                      \
    (ALPHACARD_PILOT_MODEL((x)) || ALPHACARD_COMPASS_MODEL((x)) ||             \
     ALPHACARD_PRO_100_MODEL((x)) || ALPHACARD_PRO_500_MODEL((x)) ||           \
     ALPHACARD_PRO_700_MODEL((x)) || ALPHACARD_PRO_100_MB1_MODEL((x)))

#define XR_TYPE(x) (XR160_MODEL((x)) || XR260_MODEL((x)))

#define PLASCO_TYPE(x)                                                         \
    (PLASCO_ENDURO_LE_MODEL((x)) || PLASCO_RIOPRO_LE_MODEL((x)))

#define SCREENCHECK_TYPE(x)                                                    \
    (SCREENCHECK_SC2500_MODEL((x)) || SCREENCHECK_SC4500_MODEL((x)) ||         \
     SCREENCHECK_SC6500_MODEL((x)) || SCREENCHECK_SC7500_MODEL((x)))

#define POLAROID_TYPE(x)                                                       \
    (P4500S_MODEL((x)) || P4500S_PLUS_MODEL((x)) || P2500S_MODEL((x)))

#define PPC_TYPE(x)                                                            \
    (PPC_ID2000_MODEL((x)) || PPC_ID2100_MODEL((x)) ||                         \
     PPC_ID3100_MODEL((x)) || PPC_ID2300_MODEL((x)) ||                         \
     PPC_ID2350E_MODEL((x)) || PPC_ID3300_MODEL((x)) ||                        \
     PPC_RTP7500W_MODEL((x)))

#define IDVILLE_TYPE(x)                                                        \
    (IDMAKER_MODEL((x)) || IDM_VALUE_MODEL((x)) || IDM_ADVANTAGE_MODEL((x)) || \
     IDM_SECURE_MODEL((x)) || IDM_ADV_PLUS_MODEL((x)))

#define AUTHENTYS_TYPE(x)                                                      \
    (AUTHENTYS_MODEL((x)) || AUTHENTYS_PRO_MODEL((x)) ||                       \
     AUTH_PLUS_MODEL((x)) || AUTHENTYS_RETRAX_MODEL((x)) ||                    \
     AUTHENTYS_PRONTO_MODEL((x)))

#define ENDURO_TYPE(x)                                                         \
    (ENDURO_MODEL((x)) || MC200_MODEL((x)) || IDMAKER_MODEL((x)) ||            \
     AUTHENTYS_MODEL((x)) || P4500S_MODEL((x)) || PPC_ID2100_MODEL((x)) ||     \
     IDM_ADVANTAGE_MODEL((x)) || ENDURO_NEO_MODEL((x)) || NOVA_MODEL((x)))

#define PRONTO_TYPE(x)                                                         \
    (PRONTO_MODEL((x)) || P2500S_MODEL((x)) || PPC_ID2000_MODEL((x)) ||        \
     IDM_VALUE_MODEL((x)) || XR160_MODEL((x)) || PRIDENTO_MODEL((x)) ||        \
     DOPPIE_100_MODEL((x)) || ESSENTRA_SOLO_MODEL((x)) ||                      \
     SCREENCHECK_SC2500_MODEL((x)) || AUTHENTYS_PRONTO_MODEL((x)) ||           \
     AISINO_JKE700C_MODEL((x)) || PRIDENTO_OPEN_DATA_MODEL((x)) ||             \
     ALPHACARD_PILOT_MODEL((x)) || ALPHACARD_PRO_100_MODEL((x)) ||             \
     PRICECARD_PRO_LITE_MODEL((x)) || PRONTO_NEO_MODEL((x)) ||                 \
     PHILOS_DTP_MK_1_MODEL((x)))

#define RIOPRO_TYPE(x)                                                         \
    (RIOPRO_MODEL((x)) || PPC_ID3100_MODEL((x)) || IDM_SECURE_MODEL((x)) ||    \
     AUTHENTYS_PRO_MODEL((x)) || RIO_PRO_X_MODEL((x)) ||                       \
     PRIDENTO_PRO_MODEL((x)) || PRIDENTO_PRO_X_MODEL((x)) ||                   \
     PPC_ID3300_MODEL((x)) || IDENTITY_PRO_MODEL((x)) ||                       \
     DOPPIE_300_MODEL((x)) || ESSENTRA_PRO_MODEL((x)) ||                       \
     SCREENCHECK_SC6500_MODEL((x)) || AISINO_JKE160C_MODEL((x)) ||             \
     PRICECARD_PRO_FLEX_MODEL((x)) || PLASCO_RIOPRO_LE_MODEL((x)) ||           \
     ALPHACARD_PRO_700_MODEL((x)) || PHILOS_DTP_MK_3_MODEL((x)) ||             \
     TITAN_T5_MODEL((x)))

#define XXL_TYPE(x)                                                            \
    (XXL_MODEL((x)) || PRIDENTO_PRO_X_MODEL((x)) ||                            \
     PRICECARD_PRO_FLEX_MODEL((x)) || RIO_PRO_X_MODEL((x)))

#define RIOPRO_XTD_TYPE(x)                                                     \
    (RIO_PRO_X_MODEL((x)) || PRICECARD_PRO_FLEX_MODEL((x)) ||                  \
     PRIDENTO_PRO_X_MODEL((x)))

#define ENDURO_PLUS_TYPE(x)                                                    \
    (ENDURO_PLUS_MODEL((x)) || AUTH_PLUS_MODEL((x)) ||                         \
     P4500S_PLUS_MODEL((x)) || PPC_ID2300_MODEL((x)) ||                        \
     IDM_ADV_PLUS_MODEL((x)) || FAGOO_P310E_MODEL((x)) ||                      \
     PRIDENTO_PLUS_MODEL((x)) || DOH_MODEL((x)) ||                             \
     ING171_MODEL((x)) || ENDURO_3E_MODEL((x)) || PPC_ID2350E_MODEL((x)) ||    \
     ILINKCARD_IT2600_MODEL((x)) || DOPPIE_200_MODEL((x)) ||                   \
     ESSENTRA_PLUS_MODEL((x)) || P_CARD_MODEL((x)) || ORPHICARD_MODEL((x)) ||  \
     XR260_MODEL((x)) || SCREENCHECK_SC4500_MODEL((x)) ||                      \
     AISINO_JKE701C_MODEL((x)) || PLASCO_ENDURO_LE_MODEL((x)) ||               \
     PRIDENTO_PLUS_OPEN_DATA_MODEL((x)) || ALPHACARD_COMPASS_MODEL((x)) ||     \
     PRICECARD_PRO_DUO_MODEL((x)) || ALPHACARD_PRO_500_MODEL((x)) ||           \
     PHILOS_DTP_MK_2_MODEL((x)) || TITAN_T3_MODEL((x)) ||                      \
     CARDMAKER_260_MODEL((x)) || ENDURO_NEO_MODEL((x)) || NOVA_MODEL((x)) ||   \
     ELLIADEN_CAROLINE_MODEL((x)))

#define PRIDENTO_TYPE(x)                                                       \
    (PRIDENTO_PRO_X_MODEL((x)) || PRIDENTO_PRO_MODEL((x)) ||                   \
     PRIDENTO_PLUS_MODEL((x)) || PRIDENTO_MODEL((x)) ||                        \
     PRIDENTO_PLUS_OPEN_DATA_MODEL((x)) || PRIDENTO_OPEN_DATA_MODEL((x)))

#define ING171_TYPE(x) (ING171_MODEL(x))

#define IDENTITY_PRO_TYPE(x) (IDENTITY_PRO_MODEL(x))

#define HELIX_TYPE(x)                                                          \
    (HELIX_MODEL((x)) || PPC_RTP7500W_MODEL((x)) ||                            \
     AUTHENTYS_RETRAX_MODEL((x)) || SCREENCHECK_SC7500_MODEL((x)) ||           \
     ULTIMA_MODEL((x)))

#define ILINKCARD_IT2600_TYPE(x) (ILINKCARD_IT2600_MODEL(x))

#define DOPPIE_TYPE(x)                                                         \
    (DOPPIE_100_MODEL((x)) || DOPPIE_200_MODEL((x)) || DOPPIE_300_MODEL((x)))

#define ESSENTRA_TYPE(x)                                                       \
    (ESSENTRA_SOLO_MODEL((x)) || ESSENTRA_PLUS_MODEL((x)) ||                   \
     ESSENTRA_PRO_MODEL((x)))

#define P_CARD_TYPE(x) (P_CARD_MODEL(x))

#define ORPHICARD_TYPE(x) (ORPHICARD_MODEL(x))

#define IDVILLE_360_TYPE(x)                                                    \
    (IDM_SECURE_MODEL_360((x)) || ID_MAKER_EDGE_MODEL((x)) ||                  \
     ID_MAKER_APEX_MODEL((x)) || IDVILLE_ID_MAKER_ARC_MB1_MODEL((x)) ||        \
     IDVILLE_ID_MAKER_VALUE_MB1_MODEL((x)))

#define AUTHENTYS_360_TYPE(x)                                                  \
    (AUTHENTYS_PRO_MODEL_360((x)) || AUTHENTYS_300_MODEL((x)))

#define ALPHACARD_360_TYPE(x)                                                  \
    (ALPHACARD_PRO_700_MODEL_360((x)) || ALPHACARD_PRO_750_MODEL_360((x)) ||   \
     ALPHACARD_PRO_550_MODEL((x)) || ALPHACARD_PRO_100_MB1_MODEL((x)))

#define PHILOS_360_TYPE(x) (PHILOS_DTP_MK_3_MODEL_360((x)))

#define PLASCO_360_TYPE(x) (PLASCO_RIOPRO_LE_MODEL_360((x)))

#define TITAN_360_TYPE(x) (TITAN_T5_MODEL_360((x)))

#define SCREENCHECK_360_TYPE(x) (SCREENCHECK_SC6500_MODEL_360((x)))

#define PPC_360_TYPE(x)                                                        \
    (PPC_ID3350E_MODEL_360((x)) || PPC_ID3000_MODEL((x)) ||                    \
     PPC_ID4000_MODEL((x)))

#define PRICECARDPRO_360_TYPE(x) (PRICECARD_PRO_FLEX_360_MODEL((x)))

#define PRIDENTO_360_TYPE(x)                                                   \
    (PRIDENTO_PRO_MODEL_360((x)) || PRIDENTO_PRO_360_XTD_MODEL((x)) ||         \
     PRIDENTO_300_MODEL((x)))

#define PRO_300_TYPE(x)                                                        \
    (MAGICARD_300_MODEL((x)) || AUTHENTYS_300_MODEL((x)) ||                    \
     PRIDENTO_300_MODEL((x)) || ALPHACARD_PRO_550_MODEL((x)) ||                \
     ID_MAKER_EDGE_MODEL((x)) || PPC_ID3000_MODEL((x)) ||                      \
     CENTENA_EDGE_MB1_MODEL((x)) || MAGICARD_300_NEO_MB1_MODEL((x))            \
     BRADY_PA1300_MB1_MODEL((x)))

#define EASYBADGE_TYPE(x) (DIGITAL_ID_EASYBADGE_3_0_MB1_MODEL((x)))

#define PRO360_TYPE(x)                                                         \
    (PRO360_MODEL((x)) || PRIDENTO_PRO_360_XTD_MODEL((x)) ||                   \
     PRO360_XTD_MODEL((x)) || IDM_SECURE_MODEL_360((x)) ||                     \
     AUTHENTYS_PRO_MODEL_360((x)) || ALPHACARD_PRO_700_MODEL_360((x)) ||       \
     ALPHACARD_PRO_750_MODEL_360((x)) || PHILOS_DTP_MK_3_MODEL_360((x)) ||     \
     PLASCO_RIOPRO_LE_MODEL_360((x)) || TITAN_T5_MODEL_360((x)) ||             \
     SCREENCHECK_SC6500_MODEL_360((x)) || PPC_ID3350E_MODEL_360((x)) ||        \
     PRIDENTO_PRO_MODEL_360((x)) || PRO600_MODEL((x)) ||                       \
     CARDMAKER_360_MODEL((x)) || MAGICARD_360_NEO_MODEL((x)) ||                \
     MAGICARD_300_MODEL((x)) || AUTHENTYS_300_MODEL((x)) ||                    \
     PRIDENTO_300_MODEL((x)) || PRICECARD_PRO_FLEX_360_MODEL((x)) ||           \
     ALPHACARD_PRO_550_MODEL((x)) || ID_MAKER_EDGE_MODEL((x)) ||               \
     ID_MAKER_APEX_MODEL((x)) || PPC_ID3000_MODEL((x)) ||                      \
     PPC_ID4000_MODEL((x)) || PRO500_D_MODEL((x)) || PRO500_K_MODEL((x)) ||    \
     BOOD_680_MODEL((x)) || FAGOO_P360E_MODEL((x)) ||                          \
     GOODCARD_XR260D_MODEL((x)) || ING_550_MODEL((x)) ||                       \
     GOODCARD_XR360K_MODEL((x)) || DOH_300_MODEL((x)) ||                       \
     PRONTO_100_TYPE((x)) || MAGICARD_PRICECARDPRO_FLEX_PLUS_MODEL((x)) ||     \
     DIGITAL_ID_EASYBADGE_3_0_MB1_MODEL((x)) ||                                \
     MAGICARD_PRONTO_NEO_MB1_MODEL((x)) || ALPHACARD_PRO_100_MB1_MODEL((x)) || \
     GOODCARD_XR160_MB1_MODEL((x)) || ALPHACARD_PILOT_MB1_MODEL((x)) ||        \
     CENTENA_EDGE_MB1_MODEL((x)) || MAGICARD_300_NEO_MB1_MODEL((x)) ||         \
     MAGICARD_600_NEO_MB1_MODEL((x)) ||                                        \
     MAGICARD_D_SUPPORTED_BY_BODNO_MB1_MODEL((x)) ||                           \
     GUDECARD_XR160PRO_MB1_MODEL((x)) || MAGICARD_E_PLUS_MB1_MODEL((x)) ||     \
     BRADY_PA1100_MB1_MODEL((x)) || BRADY_PA1300_MB1_MODEL((x)) ||             \
     MAGICARD_E_PLUS_NEO_MB1_MODEL((x)))

#define PRO360_WIDTH_300DPI                                                    \
    1013 /**< The width of a 300 dpi image, in pixels. */
#define PRO360_HEIGHT_300DPI                                                   \
    642 /**< The height of a 300 dpi image, in pixels. */
#define BUF_SIZE_600DPI                                                        \
    (WIDTH_600DPI *                                                            \
     HEIGHT_600DPI) /**< The size of a 600 dpi panel buffer, in bytes. */
#define PRO360_BUF_SIZE_300DPI                                                 \
    (PRO360_WIDTH_300DPI * PRO360_HEIGHT_300DPI) /**< The size of a 300 dpi    \
                                                    panel buffer, in bytes. */

// #############################################################################

#define COLOUR_RED     RGB(255, 0, 0)
#define COLOUR_GREEN   RGB(0, 255, 0)
#define COLOUR_BLUE    RGB(0, 0, 255)
#define COLOUR_CYAN    RGB(0, 255, 255)
#define COLOUR_MAGENTA RGB(255, 0, 255)
#define COLOUR_YELLOW  RGB(255, 255, 0)
#define COLOUR_WHITE   RGB(255, 255, 255)
#define COLOUR_BLACK   RGB(0, 0, 0)

enum { CARDDISPLAY_AREASHOLES, CARDDISPLAY_ERASEAREA };

// #############################################################################

#define SERIAL_SIZE          20
#define MODEL_SIZE           30
#define ENDURO_MAGNETIC_MASK 0x01
#define ENDURO_DUPLEX_MASK   0x02

#define DEFAULT_RIOPRO_DENSITY 3829
#define MAX_BLACK_AREAS        10

typedef struct tag_ENDURO_STATUS {
    bool     bPrinterConnected;
    uint32_t eModel;
    char     sModel[MODEL_SIZE];
    uint32_t ePrintheadType;
    char     sPrinterSerial[SERIAL_SIZE];
    char     sPrintheadSerial[SERIAL_SIZE];
    char     sPCBSerial[SERIAL_SIZE];
    char     sFirmwareVersion[SERIAL_SIZE];

    // These elements were char sPCBVersion[SERIAL_SIZE], which was not used
    uint32_t iDummy1;
    uint32_t iDummy2;
    uint32_t iSmartOffset;
    uint32_t iBitFields;
    uint32_t iES_Density;

    uint32_t iHandFeed;
    uint32_t iCardsPrinted;
    uint32_t iCardsOnPrinthead;
    uint32_t iDyePanelsPrinted;
    uint32_t iCleansSinceShipped;
    uint32_t iDyePanelsSinceClean;
    uint32_t iCardsSinceClean;
    uint32_t iCardsBetweenCleans;

    uint32_t iPrintHeadPosn;
    uint32_t iImageStartPosn;
    uint32_t iImageEndPosn;
    uint32_t iMajorError;
    uint32_t iMinorError;

    char     sTagUID[20];
    uint32_t iShotsOnFilm;
    uint32_t iShotsUsed;
    char     sDyeFilmType[20];
    uint32_t iColourLength;
    uint32_t iResinLength;
    uint32_t iOvercoatLength;
    uint32_t eDyeFlags;
    uint32_t iCommandCode;
    uint32_t iDOB;
    uint32_t eDyeFilmManuf;
    uint32_t eDyeFilmProg;
} ENDURO_STATUS, *PENDURO_STATUS;

#define SEM_DEFAULT 0x00000001
#define SEM_PLATEN  0x00000002
#define ERASE_SPEED 0x00000004
#define EJECT_MODE  0x00000008
#define HORZ_EJECT  0x00000010
#define SEM_XLI     0x00000020

enum tagDRVCALLBACKSTATUS {
    DCBS_OK,        /* No error. Processing may continue            */
    DCBS_ABORTJOB,  /* Driver requests that job is aborted          */
    DCBS_FATALERROR /* Fatal error. Terminate the job               */
};

// Used in several functions to know which plane we are processing
#define PLANE_Y    0
#define PLANE_M    1
#define PLANE_C    2
#define PLANE_K    3
#define PLANE_HALO 4

#define PLANE_MAX (PLANE_HALO + 1) // This is used for allocating memory

// Fixed value : we always send out scanlines to the device as this width
#define OUTPUT_DATA_WIDTH_RIO    504  // Rio/Tango 2 Data Width
#define OUTPUT_DATA_WIDTH_ALTO   576  // Alto/Opera/Tempo Data Width
#define OUTPUT_DATA_WIDTH_HELIX  1036 // Optima Data Width
#define OUTPUT_DATA_WIDTH_PRO360 642  // pro2 Data Width

typedef struct tagSPOOLMEMINFO {
    uint32_t ulDataSize;   ///< how many bytes we copied on lpBuffer
    uint32_t ulColour;     ///< one of PLANE_X
    uint8_t *lpBuffer;     ///< plane data
    bool     bDataInPlane; ///< if lpBuffer has any color
} SPOOLMEMINFO;
typedef SPOOLMEMINFO *PSPOOLMEMINFO, *LPSPOOLMEMINFO;

// Track index in int
enum {
    MAG_TRACK_INDEX0, // Dummy track for passing commands to the printer in the
                      // header
    MAG_TRACK_INDEX1,
    MAG_TRACK_INDEX2,
    MAG_TRACK_INDEX3,
    MAG_TRACK_INDEX4,
    MAX_TRACK_NUMBER
};

#define MAG_TRACK_NONE  -1
#define FIRST_MAG_TRACK MAG_TRACK_INDEX1
#define LAST_MAG_TRACK  MAG_TRACK_INDEX3

// #define MAG_MAXBUFFERNUM  256  //RJE 22/1/09
#define MAG_MAXBUFFERNUM 750

typedef struct tagMAGTRACKINFO {
    bool     bFoundSS;    // true = Found the start sentinel
    bool     bFoundES;    // true = Found the end sentinel
    bool     bComplete;   // true = Saved full track data in TrackData
    bool     bBufferFull; // true = TrackData has max. no. of byte characters.
    char     TrackData[MAG_MAXBUFFERNUM]; ///< Recorded magnetic encoding data.
    uint32_t ulTrackLength;               // Length from SS to ES in TrackData
    // Members below will be dependent on track number.
    // See MagEncd.C InitializeMagneticEncodeTrackInfo()
    uint16_t wStartSentinel; // Start Sentinel (SS) for the track
    uint16_t wEndSentinel;   // End Sentinel (ES) for the track
    bool     bSSAutoInsert;  // Auto Insert setting for SS
    bool     bESAutoInsert;  // Auto Insert setting for ES
    uint16_t wMinCharCode;   // Minimum character code for the track.
    uint16_t wMaxCharCode;   // Maxmum character code for the track.
    bool bHexData; // true = Bits per Char is 4 so do not perform range checking
                   // on data as this is performed on output
    uint32_t ulMaxTrackLen; // Max. no. of characters between SS and ES
    uint16_t wBitsPerChar;  // Bits per char defaulting to UI setting and
                            // modified if passed in text string
    uint16_t wBitsPerInch;  // Bits per inch defaulting to UI setting and
                            // modified if passed in text string
    uint16_t wCoercivity; // Coercivity defaulting to UI setting and modified if
                          // passed in text string
    bool *pValidCharList; // List of characters to be used between SS and ES
} MAGTRACKINFO;
typedef MAGTRACKINFO *PMAGTRACKINFO, *LPMAGTRACKINFO;

// Index for the buffers to be used detect adjacent colour option
#define BUFFER_PREV 0
#define BUFFER_CURR 1
#define BUFFER_NEXT 2

typedef struct tagPATCH {
    int32_t left;
    int32_t width;
    int32_t bottom;
    int32_t height;
} PATCH, AREA, *LPPATCH;

struct SecurityOptions {
    uint16_t SecurityType;
    uint16_t UsewithLaminate;
    uint16_t DisableCustomHoloKoteKey;
    uint32_t HoloKoteMap;
    uint16_t Rotation;
    uint16_t ColourHole;
    uint32_t HoloKotePatch;
    PATCH    HoloPatchOffset;
    int16_t  HoloKote_XAdjust;
    int16_t  HoloKote_YAdjust;
};

struct BlackOptions {
    uint16_t Halftone;
    uint16_t AllBlackAs;
    uint16_t PicturesUseYMConly;
    uint16_t BlackTextUsesKResin;
    uint16_t MonoBitmapsUseKResin;
    uint16_t BlackPolygonsUseKResin;
};

struct OvercoatOptions {
    bool     bUserDefined;
    uint16_t Holes;
};

struct CardSideSettings {
    uint16_t               ColourFormat;
    bool                   PrintOvercoat;
    bool                   HoloKote;
    bool                   HoloPatch;
    bool                   Rotate180;
    uint16_t               CardOrient;
    struct OvercoatOptions OvercoatOptions;
    AREA                   Area[2];
    AREA                   Hole[2];
    struct BlackOptions    BlackOptions;
    AREA                   BlackAreas[MAX_BLACK_AREAS];
    uint16_t               NoBlackAreas;
    struct SecurityOptions SecurityOptions;
};

typedef struct settings_ {
    int     modelNumber;
    int16_t Printer; //*Current Printer Model
    float   pageWidth;
    float   pageHeight;

    int pageType;
    int focusArea;

    int overcoatType;

    int bytesPerScanLine;
    int bytesPerScanLineStd;
    int orientation;
    // ULTRA stuff

    int16_t OEM;           //*Printer Family 1=RIO, 2=ALTO 3=Enduro
    int16_t TargetPrinter; //*Rio/Tango target printer model
    int16_t LangNo;        //*Selected language
    // bool        bNGUI;
    ENDURO_STATUS es;
    uint16_t      nPrintHeadPosition; // retrieve from printer :!
    int16_t       iTotalJobPages;     // populated by pp?

    bool bOvercoat;                  // enable overcoat printing
    bool bSecureShield;              // enable SecureShield(TM)
    bool bUltraSecureOverlay;        // enable Overlay Feature
    bool nUltraSecureOverlayImageNo; // selection of secure image to be printed
                                     // 1-4
    int32_t  lHoloKote;              // HoloKote tile positions to be activated
    uint16_t nOvercoatX1;            // bottom left X of Overcoat region
    uint16_t nOvercoatY1;            // bottom left Y of Overcoat region
    uint16_t nOvercoatX2;            // top right X of Overcoat region
    uint16_t nOvercoatY2;            // top right Y of Overcoat region

    uint16_t Duplex;              // desired duplex
    uint16_t CardSize;            // selected card size
    bool     AppDeterminesOrient; // does app drive orientation
    bool     HandFeed;            // hand feed card
    bool     CardReject;          // reject faulty cards
    uint16_t EjectSide;           // eject side
    uint16_t XXL_ImageType;       // selected image type xxl type models only
    uint16_t PaperHeight;         // custom image length
    uint16_t XXL_TapeSize;        // selected tape length xxl type models only
    struct CardSideSettings CardFront;
    struct CardSideSettings CardBack;

    // ADVANCED
    uint16_t nColourCorrection; // the selected colour correction
    bool     bColourSure;       // colour sure setting
    uint16_t nPrintSpeed;       // print speed
    int16_t  nSharpness;        // sharpness to be applied
    uint16_t nDyeFilmOption;    // selected dye film option
    //    bool        bSplit;                 // split multi page files
    bool bPauseSpooler;         // pause spooler during a print
    bool bDisableStatusPolling; // stop polling
    bool bUsePRNSplit;          // use utility to split jobs

    int16_t nBrightness;                //
    int16_t nContrast;                  //
    int16_t nSaturation;                //
    int16_t nRedStrength;               //
    int16_t nGreenStrength;             //
    int16_t nBlueStrength;              //
    int16_t nPrintHeadPower_YMC;        //
    int16_t nPrintHeadPower_BlackResin; //
    int16_t nPrintHeadPower_Overcoat;   //
    //
    int16_t nImagePosition_UpDown; // 15 +/-
    int16_t nImagePosition_Start;  // 50 +/-
    int16_t nImagePosition_End;    // 50 +/-
    // REWRITEABLE CARDS
    bool    bEraseBeforePrint;
    int32_t EraseArea_Left;
    int32_t EraseArea_Width;
    int32_t EraseArea_Bottom;
    int32_t EraseArea_Height;

    uint16_t ErasePower_Start;     // 0-100
    uint16_t ErasePower_End;       // 0-100
    uint16_t WritePowerAdjustment; // 0-100
    // MAGNETIC ENCODING
    bool          bEncodeOnly;
    bool          bPerformVerification;
    bool          bConcatenateMagStrings;
    bool          bJIS2Enabled;
    uint16_t      nTrackOptions;
    uint16_t      nCoercivity;
    uint16_t      nBitsPerChar_Track1;
    uint16_t      nBitsPerChar_Track2;
    uint16_t      nBitsPerChar_Track3;
    uint16_t      nBitsPerInch_Track1;
    uint16_t      nBitsPerInch_Track2;
    uint16_t      nBitsPerInch_Track3;
    struct Rp2Mag rp2mag;
    // LAMINATING
    bool           bLaminateOnly;
    uint16_t       nLaminateSide;
    uint16_t       nProfile;
    uint16_t       wProfileDescription[256];
    uint16_t       nRollerTemperature;
    uint16_t       nCardSpeed;
    uint16_t       nPreLaminationDelay;
    uint16_t       nLaminationLength;
    int16_t        nStartOffset;
    uint16_t       nEndOffset;
    uint16_t       nFilmType;
    int16_t        nHLXPrintHeadPowerYMC;      //
    int16_t        nHLXPrintHeadPowerK;        //
    int16_t        nHLXPrintHeadPowerOvercoat; //
    uint16_t       ISO7810;
    uint16_t       CFHolokoteSlot;
    uint16_t       CBHolokoteSlot;
    uint16_t       xdpi;
    enum PrintMode highQualityYMC;
    enum PrintMode highQualityResin;
} SETTINGS, *PSETTINGS;

typedef struct _DEVDATA {

    uint32_t cCopies; // count of copies.

    uint16_t *pwstrDocName; // pointer to document name.
    uint16_t  epPrinterModel;
    int16_t   epLabelX;   /* width of label  */
    int16_t   epLabelY;   /* height of label */
    int16_t   epLabelXmm; /* width of label in mm */
    int16_t   epLabelYmm; /* height of label in mm */
    bool      epPrinterRemote;
    bool bFWDownload; // set if firmware job.. informs driver to send only data
                      // passed into PASSTHROUGH escape
    // image control settings
    bool    epbCyanLayer;           // is there a cyan layer to send
    bool    epbMagentaLayer;        // is there a magenta layer to send
    bool    epbYellowLayer;         // is there a yellow layer to send
    int32_t eplCyanImageDataLen;    // size of the cyan layer data
    int32_t eplMagentaImageDataLen; // size of the magenta layer data
    int32_t eplYellowImageDataLen;  // size of the yellow layer data
    int32_t eplBlackImageDataLen;   // size of the black layer data
    bool    epbBlackLayer;          // is there a black layer to send

    bool  bPageStarted; ///< if we finished initialize information per page
    bool  bFrontPage;   ///< true = Front Page, false = Back Page
    bool  bDuplex;      ///< true = Duplex on and need to output backside info
    void *pso32bitSurface; ///< Pointer to the surface for k-resin printing.

    SPOOLMEMINFO lpSplMemFront[4]; ///< Used to spool plane data in a page
    SPOOLMEMINFO lpSplMemBack[4];  ///< Used to spool plane data in a page

    uint32_t ulCMYInPlaneWidth;  ///< Plane width
    uint32_t ulCMYOutPlaneWidth; ///< Plane width
    uint16_t HelixPreview[PREVIEW_HEIGHT]
                         [PREVIEW_WIDTH]; ///< Used to store helix
                                          /// preview data for card
    uint8_t *lpCMYIn[3];  ///< Plane pointer used to convert 32-bit RGB to
                          /// 3-plane 8-bit
    uint8_t *lpCMYOut[3]; ///< Plane pointer used to convert 8-bit plane into
                          /// 6-bit plane

    uint32_t ulKOutPlaneWidth; ///< 1-bit plane width
    uint8_t *lpKOut; ///< 1-bit plane pointer used to save result of halftoning

    void *lpKSrcStrip;  ///< 8-bit surface
    void *lpKPSrcStrip; ///< 8-bit surface
    void *lpKDstStrip;  ///< 8-bit grayscale strip

    RECTL    BlackAreas[MAX_BLACK_AREAS];
    uint16_t NoBlackAreas;
    void    *lpKAreasStrip; ///< 8-bit grayscale strip

    void *lpHalftone;       ///< surface object ptr
    void *psoKResinSurface; ///< Pointer to the surface for k-resin printing.

    bool bBlackTextUseK;    ///< true = Black Text uses K-resin option is ON
    bool bBlackPolygonUseK; ///< true = Black Polygon uses K-resin option is ON
    bool bMonoBitmapUseK;   ///< true = Mono bitmaps use K-resin option is ON
    bool bDetectAdjacentColour; ///< true = Detect adjacent colour option is ON
    bool bPhotoUseYMC; ///< true = Photographs use YMC only option is ON
    bool bExtracted;   ///< true = mono bitmap extracted
    bool bEncodeOnlyJob;
    uint8_t *lpPageBuffer[PLANE_MAX]; ///< Pointers used for page buffers with
                                      /// detect adjacent colour option
    int32_t LastMagTextY; ///< Last Y coordinate of text initialised to -1 in
                          /// startpage
    MAGTRACKINFO magTrackInfo[MAX_TRACK_NUMBER]; ///< Magnetic track information

    bool    bSplitJob;    ///< Job to be split
    int16_t iPaperHeight; ///< xxl paperheight
    int     iHaloRadius;

    int16_t xPrintingOffset; ///< x offset
    int16_t yPrintingOffset; ///< y offset
    int16_t xImage;          ///< width of card image
    int16_t yImage;          ///< height of card image
    int16_t width_pts;

    /////////////////
    // these might need moving to settings..
    uint16_t eBlackStartOption;
    uint16_t eOrientation;
    uint16_t eHalftoning;
    uint16_t bImageClipped;
    uint16_t iOrientation;
    bool     bRotate;
    uint16_t eChannelOption;
    uint16_t eCallBackStatus; // error flag

    ///////////////

    int16_t epPrinter; //*Printer selection

    int16_t epPaperX;         //*Paper X
    int16_t epPaperY;         //*Paper Y
    int16_t epPaperXdots;     //*Label width in dotsfor txtout
    int16_t epPaperYdots;     //*Label height in dots for txtout
    int16_t epPhysPaperXdots; //*width in dots for physical size
    int16_t epPhysPaperYdots; //*height in dots for physical size
    int16_t epOffsetX;        //*Offset X
    int16_t epOffsetY;        //*Offset Y
    int16_t lDelta;           // bytes to next line of surface

    int16_t epXdpi;
    int16_t epYdpi;

    uint8_t *pSurfaceBitmap;    // own managed storage for surface bitmap
    uint32_t SurfaceBitmapSize; // own store for size of bitmap

    uint32_t iPageNumber; // page number of current page.
    uint32_t epjobSize;   // pro360 job size
    uint32_t dwFlags;     // a bunch of flags defined above.
    uint32_t epCheckSum;  // pro360 job checksum
    uint32_t dwEndPDEV;   // end of pdev signature.
} DEVDATA;
typedef DEVDATA *PDEVDATA;

#endif // MAGI_GENERAL
