#ifndef _DEBUG_UTILS
#define _DEBUG_UTILS
#include <stdio.h>
#define DEBUG
#ifdef DEBUG
#define PRINT_DEBUG 1
#else
#define PRINT_DEBUG 0
#endif /* DEBUG */

/* if we're building for test, make sure all functions have external linkage so
 * that the test translation units can access them. */
#ifdef TEST
#define STATIC
#else
#define STATIC static
#endif /* TEST */

/* TRACE macro.
 * All output is sent to strerr.
 * usage:
 *     TRACE("Interesting var is %d", var);
 *
 * limitation: Can't take a single string:
 *     TRACE("Got here");
 * will result in a compilation failure. The workaround is to use the dedicated
 * macro:
 *     TRACE_STR("Got here");
 *
 */

#define TRACE(format, ...)                                                     \
    do {                                                                       \
        if (PRINT_DEBUG)                                                       \
            fprintf(stderr,                                                    \
                    ":mc:%s:%d:%s(): " format "\n",                                \
                    __FILE__,                                                  \
                    __LINE__,                                                  \
                    __func__,                                                  \
                    __VA_ARGS__);                                              \
    } while (0)

#define TRACE_STR(s) TRACE("%s", (s))

#define TRACE_IN TRACE("%s", "=>ENTERED")

#define TRACE_OUT TRACE("%s", "EXITED=>")

#define TRACE_AT TRACE("%s", "@")

#define STR(x)         #x
#define STR_BOOLEAN(x) ((x) ? "true" : "false")

#define WARN(format, ...)                                                      \
    do {                                                                       \
        fprintf(stderr,                                                        \
                "%s:%d:%s(): =WARNING=" format "\n",                           \
                __FILE__,                                                      \
                __LINE__,                                                      \
                __func__,                                                      \
                __VA_ARGS__);                                                  \
    } while (0)

#define WARN_STR(W) WARN("%s", W)

#define ERR(format, ...)                                                       \
    do {                                                                       \
        fprintf(stderr,                                                        \
                "%s:%d:%s(): =ERROR=" format "\n",                             \
                __FILE__,                                                      \
                __LINE__,                                                      \
                __func__,                                                      \
                __VA_ARGS__);                                                  \
    } while (0)

#define ERR_STR(E) ERR("%s", E)

#define DecodeHelixColourCorrection(cc)                                        \
    (cc == UICBVAL_HELIX_ColourCorrection_None) ?                              \
            "UICBVAL_HELIX_ColourCorrection_None" :                            \
    (cc == UICBVAL_HELIX_ColourCorrection_Perceptual) ?                        \
            "UICBVAL_HELIX_ColourCorrection_Perceptual" :                      \
    (cc == UICBVAL_HELIX_ColourCorrection_Saturation) ?                        \
            "UICBVAL_HELIX_ColourCorrection_Saturation" :                      \
    (cc == UICBVAL_HELIX_ColourCorrection_RelColorimetric) ?                   \
            "UICBVAL_HELIX_ColourCorrection_RelColorimetric" :                 \
    (cc == UICBVAL_HELIX_ColourCorrection_AbsColorimetric) ?                   \
            "UICBVAL_HELIX_ColourCorrection_AbsColorimetric" :                 \
    (cc == UICBVAL_HELIX_ColourCorrection_ICC_External) ?                      \
            "UICBVAL_HELIX_ColourCorrection_ICC_External" :                    \
            "<unknown>"

#define DecodeColourCorrection(cc)                                             \
    (cc == UICBVAL_ColourCorrection_None) ?                                    \
            "UICBVAL_ColourCorrection_None" :                                  \
    (cc == UICBVAL_ColourCorrection_Gamma1) ?                                  \
            "UICBVAL_ColourCorrection_Gamma1" :                                \
    (cc == UICBVAL_ColourCorrection_Gamma2) ?                                  \
            "UICBVAL_ColourCorrection_Gamma2" :                                \
    (cc == UICBVAL_ColourCorrection_ICC_Internal) ?                            \
            "UICBVAL_ColourCorrection_ICC_Internal" :                          \
    (cc == UICBVAL_ColourCorrection_ICC_External) ?                            \
            "UICBVAL_ColourCorrection_ICC_External" :                          \
    (cc == UICBVAL_ColourCorrection_Perceptual) ?                              \
            "UICBVAL_ColourCorrection_Perceptual" :                            \
    (cc == UICBVAL_ColourCorrection_Saturation) ?                              \
            "UICBVAL_ColourCorrection_Saturation" :                            \
    (cc == UICBVAL_ColourCorrection_RelColorimetric) ?                         \
            "UICBVAL_ColourCorrection_RelColorimetric" :                       \
    (cc == UICBVAL_ColourCorrection_AbsColorimetric) ?                         \
            "UICBVAL_ColourCorrection_AbsColorimetric" :                       \
            "<unknown colour correction>"

#define DecodeIntent(intent)                                                   \
    (intent == PERCEPTUAL)            ? "PERCEPTUAL" :                         \
    (intent == SATURATED)             ? "SATURATED" :                          \
    (intent == RELATIVE_COLORIMETRIC) ? "RELATIVE_COLORIMETRIC" :              \
    (intent == ABSOLUTE_COLORIMETRIC) ? "ABSOLUTE_COLORIMETRIC" :              \
    (intent == INTERNAL)              ? "INTERNAL" :                           \
    (intent == NO_OF_INTENTS)         ? "NO_OF_INTENTS" :                      \
                                        "<unknown intent>"

#define ShowTrueFalse(b) (b ? "true" : "false")

#endif
