

#include "debug_utils.h"
#include "cmddefs.h"
#include "cmnDef.h"
#include "comms.h"
#include "gndefs.h"
#include "command.h"
#include "utils.h"

#include "commandmb1.h"
#include "command_helper.h"

//-----------------------------------------------------------------------------
// Local functions
//-----------------------------------------------------------------------------

int16_t SendHole(PDEVDATA  pdev,
                        PSETTINGS psettings,
                        bool      bFront,
                        bool      bHole2,
                        int16_t   indentlevel); 

/*****************************************************************************
 *  OutputPro360HeaderCommand
 *
 *  Parameters:
 *      pdev         Pointer to our PDEV
 *      header
 *      pSettings
 *      bFrontPage   true = Front page (simplex or duplex);
 *                   false = Back page (simplex or duplex)
 *
 *  Returns:
 *      None
 *****************************************************************************/
void OutputPro360HeaderCommand(PDEVDATA            pdev,
                               cups_page_header2_t header,
                               PSETTINGS           psettings,
                               bool                bFrontPage) {
    HDR_JOB jobHeader = {0};

    LPSPOOLMEMINFO lpSplMemFront = NULL;
    LPSPOOLMEMINFO lpSplMemBack  = NULL;

    int iCopyCount = header.NumCopies;

    bool bHole_MagNormal  = false;
    bool bHole_MagWide    = false;
    bool bHole_ChipNormal = false;
    bool bHole_ChipLarge  = false;

    char temp_string[256] = {'\0'};
    int  ulColour         = 0;

    bool bBlankFrontPage   = true;
    bool bBlankBackPage    = true;

    int16_t indentlevel = 0;

    // see if any planes actually have data so we know whether to encode only..
    for (ulColour = 0; ulColour < 4; ulColour++) {
        lpSplMemFront = &pdev->lpSplMemFront[ulColour];
        lpSplMemBack  = &pdev->lpSplMemBack[ulColour];

        if (lpSplMemFront->lpBuffer != NULL && lpSplMemFront->bDataInPlane)
            bBlankFrontPage = false;

        if (lpSplMemBack->lpBuffer != NULL && lpSplMemBack->bDataInPlane)
            bBlankBackPage = false;
    }

    pdev->epjobSize = 0;

    if (pdev->bEncodeOnlyJob == false) {
        if (pdev->bDuplex) {
            if ((psettings->CardFront.HoloKote &&
                 psettings->CardFront.PrintOvercoat) ||
                (psettings->CardFront.HoloKote == false &&
                 psettings->CardFront.PrintOvercoat)) {
                jobHeader.job_sub_id |= POF_SIDE_1O;
            }
            if ((psettings->CardBack.HoloKote &&
                 psettings->CardBack.PrintOvercoat) ||
                (psettings->CardBack.HoloKote == false &&
                 psettings->CardBack.PrintOvercoat)) {
                jobHeader.job_sub_id |= POF_SIDE_2O;
            }
        } else {
            if (bFrontPage && psettings->Duplex == UICBVAL_Duplex_Back) {
                if ((psettings->CardBack.HoloKote &&
                     psettings->CardBack.PrintOvercoat) ||
                    (psettings->CardBack.HoloKote == false &&
                     psettings->CardBack.PrintOvercoat)) {
                    jobHeader.job_sub_id |= POF_SIDE_2O;
                }
            } else {
                if (bFrontPage && ((psettings->CardFront.HoloKote &&
                                    psettings->CardFront.PrintOvercoat) ||
                                   (psettings->CardFront.HoloKote == false &&
                                    psettings->CardFront.PrintOvercoat))) {
                    jobHeader.job_sub_id |= POF_SIDE_1O;
                }
                if (bFrontPage == false &&
                    ((psettings->CardBack.HoloKote &&
                      psettings->CardBack.PrintOvercoat) ||
                     (psettings->CardBack.HoloKote == false &&
                      psettings->CardBack.PrintOvercoat))) {
                    jobHeader.job_sub_id |= POF_SIDE_2O;
                }
            }
        }

        // which planes actually have data
        for (ulColour = 0; ulColour < 4; ulColour++) {
            lpSplMemFront = &pdev->lpSplMemFront[ulColour];
            lpSplMemBack  = &pdev->lpSplMemBack[ulColour];

            if (lpSplMemFront->lpBuffer != NULL &&
                lpSplMemFront->bDataInPlane) {
                if (ulColour == 0) {
                    // yellow
                    jobHeader.job_sub_id |= POF_SIDE_1Y;
                } else if (ulColour == 1) {
                    // magenta
                    jobHeader.job_sub_id |= POF_SIDE_1M;
                } else if (ulColour == 2) {
                    // cyan
                    jobHeader.job_sub_id |= POF_SIDE_1C;
                } else {
                    // resin
                    jobHeader.job_sub_id |= POF_SIDE_1K;
                }
                if (psettings->xdpi == 600) {
                    if (ulColour == 3) {
                        // resin
                        pdev->epjobSize += pdev->xImage * pdev->yImage;
                    } else {
                        pdev->epjobSize += pdev->xImage * (pdev->yImage >> 1);
                    }
                } else {
                    pdev->epjobSize += pdev->xImage * pdev->yImage;
                }
                bBlankFrontPage = false;
            }

            if (lpSplMemBack->lpBuffer != NULL && lpSplMemBack->bDataInPlane) {
                if (pdev->bDuplex) {
                    if (ulColour == 0) {
                        // yellow
                        jobHeader.job_sub_id |= POF_SIDE_2Y;
                    } else if (ulColour == 1) {
                        // magenta
                        jobHeader.job_sub_id |= POF_SIDE_2M;
                    } else if (ulColour == 2) {
                        // cyan
                        jobHeader.job_sub_id |= POF_SIDE_2C;
                    } else {
                        jobHeader.job_sub_id |= POF_SIDE_2K;
                    }
                } else {
                    // set the job header to flag side 1 for back only
                    if (ulColour == 0) {
                        // yellow
                        jobHeader.job_sub_id |= POF_SIDE_2Y;
                        bBlankFrontPage = false;
                    } else if (ulColour == 1) {
                        // magenta
                        jobHeader.job_sub_id |= POF_SIDE_2M;
                        bBlankFrontPage = false;
                    } else if (ulColour == 2) {
                        // cyan
                        jobHeader.job_sub_id |= POF_SIDE_2C;
                        bBlankFrontPage = false;
                    } else {
                        // resin
                        jobHeader.job_sub_id |= POF_SIDE_2K;
                        bBlankFrontPage = false;
                    }
                }
                if (psettings->xdpi == 600) {
                    if (ulColour == 3) {
                        // resin
                        pdev->epjobSize += pdev->xImage * pdev->yImage;
                    } else {
                        pdev->epjobSize += pdev->xImage * (pdev->yImage >> 1);
                    }
                } else {
                    pdev->epjobSize += pdev->xImage * pdev->yImage;
                }
                bBlankBackPage = false;
            }
        }

        // ensure we send something for a blank page
        if (bBlankFrontPage) {
            jobHeader.job_sub_id |= POF_SIDE_1K;
            pdev->epjobSize += pdev->xImage * pdev->yImage;
        }
        if (pdev->bDuplex && bBlankBackPage) {
            jobHeader.job_sub_id |= POF_SIDE_2K;
            pdev->epjobSize += pdev->xImage * pdev->yImage;
        }
    }

    myWritecs(pdev,
              "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n",
              0,
              indentlevel);
    myWritecs(pdev, "<prn>\n", 0, indentlevel++);
    myWritecs(pdev, "<card>\n", 0, indentlevel++);

    if (pdev->bEncodeOnlyJob) {
        myWritecs(pdev, "<card-options />\n", 0, indentlevel);
    } else {
        myWritecs(pdev, "<card-options>\n", 0, indentlevel++);
        memset((uint8_t *)&temp_string, 0, sizeof(temp_string));
        sprintf(temp_string, "<num-copies>%u</num-copies>\n", iCopyCount);
        myWritecs(pdev, temp_string, 0, indentlevel);
        memset((uint8_t *)&temp_string, 0, sizeof(temp_string));

        TRACE("Setting prn xml elem '<width>' to width_pts (%d)",
              pdev->width_pts);
        sprintf(temp_string, "<width>%u</width>\n", pdev->width_pts);
        myWritecs(pdev, temp_string, 0, indentlevel);
        memset((uint8_t *)&temp_string, 0, sizeof(temp_string));

        TRACE("Setting prn xml elem '<height>' to xImage (%d)", pdev->xImage);
        sprintf(temp_string, "<height>%u</height>\n", pdev->xImage);
        myWritecs(pdev, temp_string, 0, indentlevel);
        memset((uint8_t *)&temp_string, 0, sizeof(temp_string));

        indentlevel--;
        myWritecs(pdev, "</card-options>\n", 0, indentlevel);
    }
    if (pdev->bEncodeOnlyJob == false) {
        if (bFrontPage && psettings->Duplex != UICBVAL_Duplex_Back) {
            myWritecs(pdev, "<side-options side=\"0\">\n", 0, indentlevel++);
            if (jobHeader.job_sub_id & POF_SIDE_1Y) {
                myWritecs(pdev,
                          "<panel-options panel=\"y\">\n",
                          0,
                          indentlevel++);
                memset((uint8_t *)&temp_string, 0, sizeof(temp_string));

                int32_t power = CalculatePrintHeadPower_YMC(psettings);
                sprintf(temp_string,
                        "<power-adjust>%d</power-adjust>\n",
                        power);

                myWritecs(pdev, temp_string, 0, indentlevel);

                if (psettings->highQualityYMC == PRINT_MODE_ENHANCED) {
                   sprintf(temp_string,
                            "<print-quality>enhanced</print-quality>\n");
                    myWritecs(pdev, temp_string, 0, indentlevel);
                }

                myWritecs(pdev, "</panel-options>\n", 0, --indentlevel);
            }
            if (jobHeader.job_sub_id & POF_SIDE_1M) {
                myWritecs(pdev,
                          "<panel-options panel=\"m\">\n",
                          0,
                          indentlevel++);
                memset((uint8_t *)&temp_string, 0, sizeof(temp_string));
                sprintf(temp_string,
                        "<power-adjust>%d</power-adjust>\n",
                        (int)((float)(psettings->nPrintHeadPower_YMC - 50) *
                              655.34));
                myWritecs(pdev, temp_string, 0, indentlevel);

                if (psettings->highQualityYMC == PRINT_MODE_ENHANCED) {
                   sprintf(temp_string,
                            "<print-quality>enhanced</print-quality>\n");
                    myWritecs(pdev, temp_string, 0, indentlevel);
                }

                myWritecs(pdev, "</panel-options>\n", 0, --indentlevel);
            }
            if (jobHeader.job_sub_id & POF_SIDE_1C) {
                myWritecs(pdev,
                          "<panel-options panel=\"c\">\n",
                          0,
                          indentlevel++);
                memset((uint8_t *)&temp_string, 0, sizeof(temp_string));
                sprintf(temp_string,
                        "<power-adjust>%d</power-adjust>\n",
                        (int)((float)(psettings->nPrintHeadPower_YMC - 50) *
                              655.34));
                myWritecs(pdev, temp_string, 0, indentlevel);
                
                if (psettings->highQualityYMC == PRINT_MODE_ENHANCED) {
                   sprintf(temp_string,
                            "<print-quality>enhanced</print-quality>\n");
                    myWritecs(pdev, temp_string, 0, indentlevel);
                }

                myWritecs(pdev, "</panel-options>\n", 0, --indentlevel);
            }
            if (jobHeader.job_sub_id & POF_SIDE_1K) {
                myWritecs(pdev,
                          "<panel-options panel=\"k\">\n",
                          0,
                          indentlevel++);

                memset((uint8_t *)&temp_string, 0, sizeof(temp_string));
                // clang-format off
                sprintf(temp_string,
                        "<power-adjust>%d</power-adjust>\n",
                        (psettings->bEraseBeforePrint) ?
                            (int)((float)(psettings->WritePowerAdjustment - 50) * 655.34) :
                            (int)((float)(psettings ->nPrintHeadPower_BlackResin - 50) * 655.34));
                // clang-format on
                myWritecs(pdev, temp_string, 0, indentlevel);

                if (psettings->highQualityResin == PRINT_MODE_ENHANCED) {
                    myWritecs(pdev,
                              "<print-quality>enhanced</print-quality>\n",
                              0,
                              indentlevel);
                }

                TRACE("Sendheader 600 %u \n", psettings->xdpi);
                if (psettings->xdpi == 600) {
                    TRACE("Send x-density!!! 600 %u \n", psettings->xdpi);
                    sprintf(temp_string,
                            "<x-density>%d</x-density>\n",
                            psettings->xdpi);
                    myWritecs(pdev, temp_string, 0, indentlevel);
                }

                myWritecs(pdev, "</panel-options>\n", 0, --indentlevel);
            }
            if (jobHeader.job_sub_id & POF_SIDE_1O) {
                myWritecs(pdev,
                          "<panel-options panel=\"o\">\n",
                          0,
                          indentlevel++);
                memset((uint8_t *)&temp_string, 0, sizeof(temp_string));
                sprintf(temp_string,
                        "<x-adjust>%d</x-adjust>\n",
                        psettings->CardFront.SecurityOptions.HoloKote_XAdjust);
                myWritecs(pdev, temp_string, 0, indentlevel);
                sprintf(temp_string,
                        "<y-adjust>%d</y-adjust>\n",
                        psettings->CardFront.SecurityOptions.HoloKote_YAdjust);
                myWritecs(pdev, temp_string, 0, indentlevel);
                sprintf(temp_string,
                        "<power-adjust>%d</power-adjust>\n",
                        (int)((float)(psettings->nPrintHeadPower_Overcoat -
                                      50) *
                              655.34));
                myWritecs(pdev, temp_string, 0, indentlevel);
                if (psettings->CardFront.SecurityOptions.Rotation) {
                    sprintf(temp_string,
                            "<watermark-rotation>180</watermark-rotation>\n");
                    myWritecs(pdev, temp_string, 0, indentlevel);
                }
                if (psettings->CardFront.SecurityOptions.UsewithLaminate) {
                    sprintf(temp_string,
                            "<watermark-secure-shield>true</"
                            "watermark-secure-shield>\n");
                    myWritecs(pdev, temp_string, 0, indentlevel);
                }
                if (psettings->CardFront.HoloKote &&
                    psettings->CardFront.PrintOvercoat) {
                    sprintf(temp_string,
                            "<watermark-index>%d</watermark-index>\n",
                            psettings->CFHolokoteSlot);
                    myWritecs(pdev, temp_string, 0, indentlevel);
                }

                if (psettings->CardFront.HoloKote ||
                    psettings->CardFront.PrintOvercoat) {
                    if (psettings->CardFront.OvercoatOptions.bUserDefined) {
                        if (AreaHoleActive(psettings, FRONT_AREA1)) {
                            myWritecs(pdev, "<area>\n", 0, indentlevel++);

                            sprintf(temp_string,
                                    "<x>%d</x>\n",
                                    psettings->CardFront.Area[0].left);
                            myWritecs(pdev, temp_string, 0, indentlevel);
                            sprintf(temp_string,
                                    "<y>%d</y>\n",
                                    pdev->xImage -
                                            psettings->CardFront.Area[0]
                                                    .bottom -
                                            psettings->CardFront.Area[0]
                                                    .height);
                            myWritecs(pdev, temp_string, 0, indentlevel);
                            sprintf(temp_string,
                                    "<width>%d</width>\n",
                                    psettings->CardFront.Area[0].width);
                            myWritecs(pdev, temp_string, 0, indentlevel);
                            sprintf(temp_string,
                                    "<height>%d</height>\n",
                                    psettings->CardFront.Area[0].height);
                            myWritecs(pdev, temp_string, 0, indentlevel--);

                            myWritecs(pdev, "</area>\n", 0, indentlevel);
                        }
                        if (AreaHoleActive(psettings, FRONT_AREA2)) {
                            myWritecs(pdev, "<area>\n", 0, indentlevel++);

                            sprintf(temp_string,
                                    "<x>%d</x>\n",
                                    psettings->CardFront.Area[1].left);
                            myWritecs(pdev, temp_string, 0, indentlevel);
                            sprintf(temp_string,
                                    "<y>%d</y>\n",
                                    pdev->xImage -
                                            psettings->CardFront.Area[1]
                                                    .bottom -
                                            psettings->CardFront.Area[1]
                                                    .height);
                            myWritecs(pdev, temp_string, 0, indentlevel);
                            sprintf(temp_string,
                                    "<width>%d</width>\n",
                                    psettings->CardFront.Area[1].width);
                            myWritecs(pdev, temp_string, 0, indentlevel);
                            sprintf(temp_string,
                                    "<height>%d</height>\n",
                                    psettings->CardFront.Area[1].height);
                            myWritecs(pdev, temp_string, 0, indentlevel--);

                            myWritecs(pdev, "</area>\n", 0, indentlevel);
                        }
                    }
                    switch (psettings->CardFront.OvercoatOptions.Holes) {
                        case UICBVAL_MagStripeNormal:
                            bHole_MagNormal = true;
                            break;
                        case UICBVAL_MagStripeWide:
                            bHole_MagWide = true;
                            break;
                        case UICBVAL_ChipNormal:
                            bHole_ChipNormal = true;
                            break;
                        case UICBVAL_ChipLarge:
                            bHole_ChipLarge = true;
                            break;
                    }

                    if (bHole_MagNormal) {
                        psettings->CardFront.Hole[0].left   = 0;
                        psettings->CardFront.Hole[0].bottom = 420;
                        psettings->CardFront.Hole[0].width  = 1012;
                        psettings->CardFront.Hole[0].height = 170;

                        indentlevel = SendHole(
                                pdev, psettings, true, false, indentlevel);
                    } else if (bHole_MagWide) {
                        psettings->CardFront.Hole[0].left   = 0;
                        psettings->CardFront.Hole[0].bottom = 400;
                        psettings->CardFront.Hole[0].width  = 1012;
                        psettings->CardFront.Hole[0].height = 200;

                        indentlevel = SendHole(
                                pdev, psettings, true, false, indentlevel);
                    } else if (bHole_ChipNormal) {
                        psettings->CardFront.Hole[0].left   = 106;
                        psettings->CardFront.Hole[0].bottom = 310;
                        psettings->CardFront.Hole[0].width  = 136;
                        psettings->CardFront.Hole[0].height = 112;

                        indentlevel = SendHole(
                                pdev, psettings, true, false, indentlevel);

                    } else if (bHole_ChipLarge) {
                        psettings->CardFront.Hole[0].left   = 96;
                        psettings->CardFront.Hole[0].bottom = 288;
                        psettings->CardFront.Hole[0].width  = 162;
                        psettings->CardFront.Hole[0].height = 144;

                        indentlevel = SendHole(
                                pdev, psettings, true, false, indentlevel);
                    }
                }

                myWritecs(pdev, "</panel-options>\n", 0, --indentlevel);
            }
            if (psettings->CardFront.HoloPatch &&
                psettings->bEraseBeforePrint == false) {
                myWritecs(pdev, "<patch-options>\n", 0, indentlevel++);

                sprintf(temp_string,
                        "<x>%d</x>\n",
                        psettings->CardFront.SecurityOptions.HoloPatchOffset
                                .left);
                myWritecs(pdev, temp_string, 0, indentlevel);
                sprintf(temp_string,
                        "<y>%d</y>\n",
                        pdev->xImage -
                                psettings->CardFront.SecurityOptions
                                        .HoloPatchOffset.bottom -
                                psettings->CardFront.SecurityOptions
                                        .HoloPatchOffset.height);
                myWritecs(pdev, temp_string, 0, indentlevel);
                sprintf(temp_string,
                        "<width>%d</width>\n",
                        psettings->CardFront.SecurityOptions.HoloPatchOffset
                                .width);
                myWritecs(pdev, temp_string, 0, indentlevel);
                sprintf(temp_string,
                        "<height>%d</height>\n",
                        psettings->CardFront.SecurityOptions.HoloPatchOffset
                                .height);
                myWritecs(pdev, temp_string, 0, indentlevel--);

                myWritecs(pdev, "</patch-options>\n", 0, indentlevel);
            }

            TRACE("bEraseBeforePrint = %s",
                  STR_BOOLEAN(psettings->bEraseBeforePrint));
            if (psettings->bEraseBeforePrint &&
                pdev->eChannelOption == UICBVAL_KResin) {
                myWritecs(pdev, "<erase-options>\n", 0, indentlevel++);

                /* TODO: add any 'area' or 'hole' options here. */

                sprintf(temp_string,
                        "<power-adjust>%d</power-adjust>\n",
                        (int)((float)(psettings->ErasePower_Start - 50) *
                              655.34));
                myWritecs(pdev, temp_string, 0, indentlevel--);
                myWritecs(pdev, "</erase-options>\n", 0, indentlevel);
            }

            indentlevel--;
            myWritecs(pdev, "</side-options>\n", 0, indentlevel--);
        }

        if (pdev->bDuplex || psettings->Duplex == UICBVAL_Duplex_Back) {
            indentlevel++;
            myWritecs(pdev, "<side-options side=\"1\">\n", 0, indentlevel++);
            if (jobHeader.job_sub_id & POF_SIDE_2Y) {
                myWritecs(pdev,
                          "<panel-options panel=\"y\">\n",
                          0,
                          indentlevel++);
                memset((uint8_t *)&temp_string, 0, sizeof(temp_string));
                sprintf(temp_string,
                        "<power-adjust>%d</power-adjust>\n",
                        (int)((float)(psettings->nPrintHeadPower_YMC - 50) *
                              655.34));
                myWritecs(pdev, temp_string, 0, indentlevel);

                if (psettings->highQualityYMC == PRINT_MODE_ENHANCED) {
                   sprintf(temp_string,
                            "<print-quality>enhanced</print-quality>\n");
                    myWritecs(pdev, temp_string, 0, indentlevel);
                }

                myWritecs(pdev, "</panel-options>\n", 0, --indentlevel);
            }
            if (jobHeader.job_sub_id & POF_SIDE_2M) {
                myWritecs(pdev,
                          "<panel-options panel=\"m\">\n",
                          0,
                          indentlevel++);
                memset((uint8_t *)&temp_string, 0, sizeof(temp_string));
                sprintf(temp_string,
                        "<power-adjust>%d</power-adjust>\n",
                        (int)((float)(psettings->nPrintHeadPower_YMC - 50) *
                              655.34));
                myWritecs(pdev, temp_string, 0, indentlevel);

                if (psettings->highQualityYMC == PRINT_MODE_ENHANCED) {
                   sprintf(temp_string,
                            "<print-quality>enhanced</print-quality>\n");
                    myWritecs(pdev, temp_string, 0, indentlevel);
                }
                myWritecs(pdev, "</panel-options>\n", 0, --indentlevel);
            }
            if (jobHeader.job_sub_id & POF_SIDE_2C) {
                myWritecs(pdev,
                          "<panel-options panel=\"c\">\n",
                          0,
                          indentlevel++);
                memset((uint8_t *)&temp_string, 0, sizeof(temp_string));
                sprintf(temp_string,
                        "<power-adjust>%d</power-adjust>\n",
                        (int)((float)(psettings->nPrintHeadPower_YMC - 50) *
                              655.34));
                myWritecs(pdev, temp_string, 0, indentlevel);

                if (psettings->highQualityYMC == PRINT_MODE_ENHANCED) {
                   sprintf(temp_string,
                            "<print-quality>enhanced</print-quality>\n");
                    myWritecs(pdev, temp_string, 0, indentlevel);
                }
                myWritecs(pdev, "</panel-options>\n", 0, --indentlevel);
            }
            if (jobHeader.job_sub_id & POF_SIDE_2K) {
                myWritecs(pdev,
                          "<panel-options panel=\"k\">\n",
                          0,
                          indentlevel++);

                memset((uint8_t *)&temp_string, 0, sizeof(temp_string));

                // clang-format off
                sprintf(temp_string,
                        "<power-adjust>%d</power-adjust>\n",
                        (psettings->bEraseBeforePrint) ?
                                (int)((float)(psettings->WritePowerAdjustment - 50) * 655.34) :
                                (int)((float)(psettings->nPrintHeadPower_BlackResin - 50) * 655.34));
                // clang-format on

                myWritecs(pdev, temp_string, 0, indentlevel);

                if (psettings->xdpi == 600) {
                    sprintf(temp_string,
                            "<x-density>%d</x-density>\n",
                            psettings->xdpi);
                    myWritecs(pdev, temp_string, 0, indentlevel);
                }

                if (psettings->highQualityResin == PRINT_MODE_ENHANCED) {
                    myWritecs(pdev,
                              "<print-quality>enhanced</print-quality>\n",
                              0,
                              indentlevel);
                }

                myWritecs(pdev, "</panel-options>\n", 0, --indentlevel);
            }
            if (jobHeader.job_sub_id & POF_SIDE_2O) {
                myWritecs(pdev,
                          "<panel-options panel=\"o\">\n",
                          0,
                          indentlevel++);
                memset((uint8_t *)&temp_string, 0, sizeof(temp_string));
                sprintf(temp_string,
                        "<x-adjust>%d</x-adjust>\n",
                        psettings->CardBack.SecurityOptions.HoloKote_XAdjust);
                myWritecs(pdev, temp_string, 0, indentlevel);
                sprintf(temp_string,
                        "<y-adjust>%d</y-adjust>\n",
                        psettings->CardBack.SecurityOptions.HoloKote_YAdjust);
                myWritecs(pdev, temp_string, 0, indentlevel);
                sprintf(temp_string,
                        "<power-adjust>%d</power-adjust>\n",
                        (int)((float)(psettings->nPrintHeadPower_Overcoat -
                                      50) *
                              655.34));
                myWritecs(pdev, temp_string, 0, indentlevel);
                if (psettings->CardBack.SecurityOptions.Rotation) {
                    sprintf(temp_string,
                            "<watermark-rotation>180</watermark-rotation>\n");
                    myWritecs(pdev, temp_string, 0, indentlevel);
                }
                if (psettings->CardBack.SecurityOptions.UsewithLaminate) {
                    sprintf(temp_string,
                            "<watermark-secure-shield>true</"
                            "watermark-secure-shield>\n");
                    myWritecs(pdev, temp_string, 0, indentlevel);
                }
                if (psettings->CardBack.HoloKote &&
                    psettings->CardBack.PrintOvercoat) {
                    sprintf(temp_string,
                            "<watermark-index>%d</watermark-index>\n",
                            psettings->CBHolokoteSlot);
                    myWritecs(pdev, temp_string, 0, indentlevel);
                }
                if (psettings->CardBack.HoloKote ||
                    psettings->CardBack.PrintOvercoat) {
                    if (psettings->CardBack.OvercoatOptions.bUserDefined) {
                        if (AreaHoleActive(psettings, BACK_AREA1)) {
                            myWritecs(pdev, "<area>\n", 0, indentlevel++);

                            sprintf(temp_string,
                                    "<x>%d</x>\n",
                                    psettings->CardBack.Area[0].left);
                            myWritecs(pdev, temp_string, 0, indentlevel);
                            sprintf(temp_string,
                                    "<y>%d</y>\n",
                                    pdev->xImage -
                                            psettings->CardBack.Area[0].bottom -
                                            psettings->CardBack.Area[0].height);
                            myWritecs(pdev, temp_string, 0, indentlevel);
                            sprintf(temp_string,
                                    "<width>%d</width>\n",
                                    psettings->CardBack.Area[0].width);
                            myWritecs(pdev, temp_string, 0, indentlevel);
                            sprintf(temp_string,
                                    "<height>%d</height>\n",
                                    psettings->CardBack.Area[0].height);
                            myWritecs(pdev, temp_string, 0, indentlevel--);

                            myWritecs(pdev, "</area>\n", 0, indentlevel);
                        }
                        if (AreaHoleActive(psettings, BACK_AREA1)) {
                            myWritecs(pdev, "<area>\n", 0, indentlevel++);

                            sprintf(temp_string,
                                    "<x>%d</x>\n",
                                    psettings->CardBack.Area[1].left);
                            myWritecs(pdev, temp_string, 0, indentlevel);
                            sprintf(temp_string,
                                    "<y>%d</y>\n",
                                    pdev->xImage -
                                            psettings->CardBack.Area[1].bottom -
                                            psettings->CardBack.Area[1].height);
                            myWritecs(pdev, temp_string, 0, indentlevel);
                            sprintf(temp_string,
                                    "<width>%d</width>\n",
                                    psettings->CardBack.Area[1].width);
                            myWritecs(pdev, temp_string, 0, indentlevel);
                            sprintf(temp_string,
                                    "<height>%d</height>\n",
                                    psettings->CardBack.Area[1].height);
                            myWritecs(pdev, temp_string, 0, indentlevel--);

                            myWritecs(pdev, "</area>\n", 0, indentlevel);
                        }
                    }
                    bHole_MagNormal  = false;
                    bHole_MagWide    = false;
                    bHole_ChipNormal = false;
                    bHole_ChipLarge  = false;

                    switch (psettings->CardBack.OvercoatOptions.Holes) {
                        case UICBVAL_MagStripeNormal:
                            bHole_MagNormal = true;
                            break;
                        case UICBVAL_MagStripeWide:
                            bHole_MagWide = true;
                            break;
                        case UICBVAL_ChipNormal:
                            bHole_ChipNormal = true;
                            break;
                        case UICBVAL_ChipLarge:
                            bHole_ChipLarge = true;
                            break;
                    }

                    if (bHole_MagNormal) {
                        psettings->CardBack.Hole[0].left   = 0;
                        psettings->CardBack.Hole[0].bottom = 420;
                        psettings->CardBack.Hole[0].width  = 1012;
                        psettings->CardBack.Hole[0].height = 170;

                        indentlevel = SendHole(
                                pdev, psettings, false, false, indentlevel);
                    } else if (bHole_MagWide) {
                        psettings->CardBack.Hole[0].left   = 0;
                        psettings->CardBack.Hole[0].bottom = 400;
                        psettings->CardBack.Hole[0].width  = 1012;
                        psettings->CardBack.Hole[0].height = 200;

                        indentlevel = SendHole(
                                pdev, psettings, false, false, indentlevel);
                    } else if (bHole_ChipNormal) {
                        psettings->CardBack.Hole[0].left   = 90;
                        psettings->CardBack.Hole[0].bottom = 295;
                        psettings->CardBack.Hole[0].width  = 260;
                        psettings->CardBack.Hole[0].height = 190;

                        indentlevel = SendHole(
                                pdev, psettings, false, false, indentlevel);

                    } else if (bHole_ChipLarge) {
                        psettings->CardBack.Hole[0].left   = 75;
                        psettings->CardBack.Hole[0].bottom = 275;
                        psettings->CardBack.Hole[0].width  = 280;
                        psettings->CardBack.Hole[0].height = 190;

                        indentlevel = SendHole(
                                pdev, psettings, false, false, indentlevel);
                    }
                }

                myWritecs(pdev, "</panel-options>\n", 0, --indentlevel);
            }
            indentlevel--;
            myWritecs(pdev, "</side-options>\n", 0, indentlevel--);
        }
    }

    TRACE_STR("RP2 Mag Handling.");
    char mag_xml[RP2_MAG_MAX_XML_LEN] = {'\0'};
    rp2mag_to_xml(&psettings->rp2mag, mag_xml);
    TRACE("RP2 Mag = [%s]", mag_xml);
    TRACE("rp2mag_total_encoded_as_bytes = %zu",
          rp2mag_total_encoded_as_bytes(&psettings->rp2mag));
    myWritecs(pdev, mag_xml, 0, indentlevel--);
    myWritecs(pdev, "</card>\n", 0, indentlevel);
    memset((uint8_t *)&temp_string, 0, sizeof(temp_string));

    sprintf(temp_string,
            "<binary-size>%zu</binary-size>\n",
            pdev->epjobSize +
                    rp2mag_total_encoded_as_bytes(&psettings->rp2mag));
    myWritecs(pdev, temp_string, 0, indentlevel);
    time((time_t *)&jobHeader.timestamp);
    sprintf(temp_string, "<time>%u</time>\n", jobHeader.timestamp);
    myWritecs(pdev, temp_string, 0, indentlevel);

    myWritecs(pdev, "</prn>\n\000", 8, 0);

    // Write the mag data to the payload.
    // TODO: rp2mag module should be responsible for this - there is too much
    // internal knowledge exposed here.
    for (size_t i = 0; i < RP2_MAG_NUM_TRACKS; i++) {
        if (psettings->rp2mag.tracks[i].data.encoded_len_round_bytes > 0) {
            myWritecs(pdev,
                      (char *)psettings->rp2mag.tracks[i].data.encoded,
                      psettings->rp2mag.tracks[i].data.encoded_len_round_bytes,
                      indentlevel);
        }
    }

    TRACE_OUT;
    return;
}

//-----------------------------------------------------------------------------

int16_t SendHole(PDEVDATA  pdev,
                 PSETTINGS psettings,
                 bool      bFront,
                 bool      bHole2,
                 int16_t   indentlevel) {
    char temp_string[64] = {0};
    myWritecs(pdev, "<hole>\015", 0, indentlevel++);
    if (bHole2 == false) {
        if (bFront) {
            sprintf(temp_string,
                    "<x>%d</x>\015",
                    psettings->CardFront.Hole[0].left);
            myWritecs(pdev, temp_string, 0, indentlevel);
            sprintf(temp_string,
                    "<y>%d</y>\015",
                    pdev->xImage - psettings->CardFront.Hole[0].bottom -
                            psettings->CardFront.Hole[0].height);
            myWritecs(pdev, temp_string, 0, indentlevel);
            sprintf(temp_string,
                    "<width>%d</width>\015",
                    psettings->CardFront.Hole[0].width);
            myWritecs(pdev, temp_string, 0, indentlevel);
            sprintf(temp_string,
                    "<height>%d</height>\015",
                    psettings->CardFront.Hole[0].height);
            myWritecs(pdev, temp_string, 0, indentlevel--);
        } else {
            sprintf(temp_string,
                    "<x>%d</x>\015",
                    psettings->CardBack.Hole[0].left);
            myWritecs(pdev, temp_string, 0, indentlevel);
            sprintf(temp_string,
                    "<y>%d</y>\015",
                    pdev->xImage - psettings->CardBack.Hole[0].bottom -
                            psettings->CardBack.Hole[0].height);
            myWritecs(pdev, temp_string, 0, indentlevel);
            sprintf(temp_string,
                    "<width>%d</width>\015",
                    psettings->CardBack.Hole[0].width);
            myWritecs(pdev, temp_string, 0, indentlevel);
            sprintf(temp_string,
                    "<height>%d</height>\015",
                    psettings->CardBack.Hole[0].height);
            myWritecs(pdev, temp_string, 0, indentlevel--);
        }
    } else {
        if (bFront) {
            sprintf(temp_string,
                    "<x>%d</x>\015",
                    psettings->CardFront.Hole[1].left);
            myWritecs(pdev, temp_string, 0, indentlevel);
            sprintf(temp_string,
                    "<y>%d</y>\015",
                    pdev->xImage - psettings->CardFront.Hole[1].bottom -
                            psettings->CardFront.Hole[1].height);
            myWritecs(pdev, temp_string, 0, indentlevel);
            sprintf(temp_string,
                    "<width>%d</width>\015",
                    psettings->CardFront.Hole[1].width);
            myWritecs(pdev, temp_string, 0, indentlevel);
            sprintf(temp_string,
                    "<height>%d</height>\015",
                    psettings->CardFront.Hole[1].height);
            myWritecs(pdev, temp_string, 0, indentlevel--);
        } else {
            sprintf(temp_string,
                    "<x>%d</x>\015",
                    psettings->CardBack.Hole[1].left);
            myWritecs(pdev, temp_string, 0, indentlevel);
            sprintf(temp_string,
                    "<y>%d</y>\015",
                    pdev->xImage - psettings->CardBack.Hole[1].bottom -
                            psettings->CardBack.Hole[1].height);
            myWritecs(pdev, temp_string, 0, indentlevel);
            sprintf(temp_string,
                    "<width>%d</width>\015",
                    psettings->CardBack.Hole[1].width);
            myWritecs(pdev, temp_string, 0, indentlevel);
            sprintf(temp_string,
                    "<height>%d</height>\015",
                    psettings->CardBack.Hole[1].height);
            myWritecs(pdev, temp_string, 0, indentlevel--);
        }
    }

    myWritecs(pdev, "</hole>\015", 0, indentlevel);
    return indentlevel;
}

//-----------------------------------------------------------------------------
