
#include "command_helper.h"

#include <stdbool.h>

/*****************************************************************************
 *  AreaHoleActive()
 *      Determines if the given Area/Hole is active by checking if both the
 *      height and width are non-zero
 *
 *  Returns:
 *      true  if both Height and Width are non-zero for the given Area/Hole
 *      false otherwise
 *****************************************************************************/
bool AreaHoleActive(struct settings_ *settings,
                    AREA_HOLE_ID      AreaHoleIdentifier) {
    bool result = false;

    switch (AreaHoleIdentifier) {
        case FRONT_AREA1:
            if ((settings->CardFront.Area[0].width != 0) &&
                (settings->CardFront.Area[0].height != 0)) {
                result = true;
            }
            break;
        case FRONT_AREA2:
            if ((settings->CardFront.Area[1].width != 0) &&
                (settings->CardFront.Area[1].height != 0)) {
                result = true;
            }
            break;
        case FRONT_HOLE1:
            if ((settings->CardFront.Hole[0].width != 0) &&
                (settings->CardFront.Hole[0].height != 0)) {
                result = true;
            }
            break;
        case FRONT_HOLE2:
            if ((settings->CardFront.Hole[1].width != 0) &&
                (settings->CardFront.Hole[1].height != 0)) {
                result = true;
            }
            break;
        case BACK_AREA1:
            if ((settings->CardBack.Area[0].width != 0) &&
                (settings->CardBack.Area[0].height != 0)) {
                result = true;
            }
            break;
        case BACK_AREA2:
            if ((settings->CardBack.Area[1].width != 0) &&
                (settings->CardBack.Area[1].height != 0)) {
                result = true;
            }
            break;
        case BACK_HOLE1:
            if ((settings->CardBack.Hole[0].width != 0) &&
                (settings->CardBack.Hole[0].height != 0)) {
                result = true;
            }
            break;
        case BACK_HOLE2:
            if ((settings->CardBack.Hole[1].width != 0) &&
                (settings->CardBack.Hole[1].height != 0)) {
                result = true;
            }
            break;
    }
    return result;
}



void myWritecs(PDEVDATA pdev, char *chData, uint32_t cbbuf, int16_t indentlevel) {
    uint8_t  szOutputBuf[1024];
    uint16_t outputbuf_idx = 0;
    uint16_t cnt;
    uint32_t i    = 0;
    char *   pbuf = chData;

    // sort the length
    if (cbbuf == 0) {
        cbbuf = strlen(pbuf);

        // clear out local copy
        memset((uint8_t *)szOutputBuf, 0, sizeof(szOutputBuf));

        if (indentlevel > 0) {
            for (cnt = indentlevel; cnt; cnt--) {
                szOutputBuf[outputbuf_idx++] = 9; // tab
        }
        }
        // Buffer the data before sending it to the device
        memcpy((uint8_t *)&szOutputBuf[outputbuf_idx], pbuf, cbbuf);
        cbbuf += indentlevel;
        pbuf = (char *)&szOutputBuf;
    }

    TRACE("xml = [%s]", pbuf);

    // keep the crc checksum uptodate
    crc32update(&pdev->epCheckSum, pbuf, cbbuf);

    for (; i < cbbuf; i++) {
        putchar(*pbuf++);
    }
    return;
}
