#ifndef CMDDEFS_H
#define CMDDEFS_H

#include <cups/cups.h>
#include <cups/ppd.h>
#include <cups/raster.h>

#ifdef RPMBUILD

#include <dlfcn.h>

typedef cups_raster_t *(*cupsRasterOpen_fndef)(int fd, cups_mode_t mode);

typedef unsigned (*cupsRasterReadHeader_fndef)(cups_raster_t *      r,
                                               cups_page_header2_t *h);

typedef unsigned (*cupsRasterReadHeader2_fndef)(cups_raster_t *      r,
                                                cups_page_header2_t *h);

typedef unsigned (*cupsRasterReadPixels_fndef)(cups_raster_t *r,
                                               unsigned char *p,
                                               unsigned       len);

typedef void (*cupsRasterClose_fndef)(cups_raster_t *r);

static cupsRasterOpen_fndef        cupsRasterOpen_fn;
static cupsRasterReadHeader_fndef  cupsRasterReadHeader_fn;
static cupsRasterReadHeader2_fndef cupsRasterReadHeader2_fn;
static cupsRasterReadPixels_fndef  cupsRasterReadPixels_fn;
static cupsRasterClose_fndef       cupsRasterClose_fn;

#define CUPSRASTEROPEN (*cupsRasterOpen_fn)
#define CUPSRASTERREADHEADER (*cupsRasterReadHeader_fn)
#define CUPSRASTERREADHEADER2 (*cupsRasterReadHeader2_fn)
#define CUPSRASTERREADPIXELS (*cupsRasterReadPixels_fn)
#define CUPSRASTERCLOSE (*cupsRasterClose_fn)

typedef void (*ppdClose_fndef)(ppd_file_t *ppd);

typedef ppd_choice_t *(*ppdFindChoice_fndef)(ppd_option_t *o,
                                             const char *  option);

typedef ppd_choice_t *(*ppdFindMarkedChoice_fndef)(ppd_file_t *ppd,
                                                   const char *keyword);

typedef ppd_option_t *(*ppdFindOption_fndef)(ppd_file_t *ppd,
                                             const char *keyword);

typedef void (*ppdMarkDefaults_fndef)(ppd_file_t *ppd);

typedef ppd_file_t *(*ppdOpenFile_fndef)(const char *filename);

typedef void (*cupsFreeOptions_fndef)(int num_options, cups_option_t *options);

typedef int (*cupsParseOptions_fndef)(const char *    arg,
                                      int             num_options,
                                      cups_option_t **options);

typedef int (*cupsMarkOptions_fndef)(ppd_file_t *   ppd,
                                     int            num_options,
                                     cups_option_t *options);

static ppdClose_fndef            ppdClose_fn;
static ppdFindChoice_fndef       ppdFindChoice_fn;
static ppdFindMarkedChoice_fndef ppdFindMarkedChoice_fn;
static ppdFindOption_fndef       ppdFindOption_fn;
static ppdMarkDefaults_fndef     ppdMarkDefaults_fn;
static ppdOpenFile_fndef         ppdOpenFile_fn;

static cupsFreeOptions_fndef  cupsFreeOptions_fn;
static cupsParseOptions_fndef cupsParseOptions_fn;
static cupsMarkOptions_fndef  cupsMarkOptions_fn;

#define PPDCLOSE (*ppdClose_fn)
#define PPDFINDCHOICE (*ppdFindChoice_fn)
#define PPDFINDMARKEDCHOICE (*ppdFindMarkedChoice_fn)
#define PPDFINDOPTION (*ppdFindOption_fn)
#define PPDMARKDEFAULTS (*ppdMarkDefaults_fn)
#define PPDOPENFILE (*ppdOpenFile_fn)

#define CUPSFREEOPTIONS (*cupsFreeOptions_fn)
#define CUPSPARSEOPTIONS (*cupsParseOptions_fn)
#define CUPSMARKOPTIONS (*cupsMarkOptions_fn)

#else // not defined RPMBUILD

#define CUPSRASTEROPEN cupsRasterOpen
#define CUPSRASTERREADHEADER cupsRasterReadHeader
#define CUPSRASTERREADHEADER2 cupsRasterReadHeader2
#define CUPSRASTERREADPIXELS cupsRasterReadPixels
#define CUPSRASTERCLOSE cupsRasterClose

#define PPDCLOSE ppdClose
#define PPDFINDCHOICE ppdFindChoice
#define PPDFINDMARKEDCHOICE ppdFindMarkedChoice
#define PPDFINDOPTION ppdFindOption
#define PPDMARKDEFAULTS ppdMarkDefaults
#define PPDOPENFILE ppdOpenFile

#define CUPSFREEOPTIONS cupsFreeOptions
#define CUPSPARSEOPTIONS cupsParseOptions
#define CUPSMARKOPTIONS cupsMarkOptions

#endif // RPMBUILD

#endif // defined CMDDEFS_H
