/*
 * Decompiled with CFR 0.152.
 */
package UltimaDemo;

import SDK.SDKlib;
import UltimaDemo.Main;
import UltimaDemo.Utils;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.ByteByReference;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;

class Info {
    private final String SDKBITS = "SDKBITS";
    private final String LASTMSG = "LASTMSG";
    private final String STATUS = "STATUS";
    private final String INFO = "INFO";
    private final String VERSION = "VERSION";
    private final String CONNECTION = "CONNECTION";
    private final String TYPE = "TYPE";
    private final String MODEL = "MODEL";
    private final String TEMPERATURE = "TEMPERATURE";
    private final String CLEAR = "CLEAR";
    private final ActionHandler ah = new ActionHandler();
    public static final JPanel panelInfo = new JPanel();
    private final JButton btnLastMessage = new JButton("Last Message");
    private final JButton btnPrinterStatus = new JButton("Printer Status");
    private final JButton btnPrinterInfo = new JButton("Printer Info");
    private final JButton btnSDKVersion = new JButton("SDK Version");
    private final JButton btnConnectionType = new JButton("Connection Type");
    private final JButton btnPrinterType = new JButton("Printer Type");
    private final JButton btnPrinterModel = new JButton("Printer Model");
    private final JButton btnSDKBits = new JButton("SDK Bits");
    private final JButton btnTemperature = new JButton("Temperature");
    private final JButton btnClear = new JButton("Clear");
    private final JTextArea textInfoMsg = new JTextArea();
    private final JScrollPane scrollPane = new JScrollPane();
    private WinNT.HANDLE hSession;
    private SDKlib SDK;

    public Info() {
        panelInfo.setLayout(new MigLayout("", "[190.00][grow]", "[][][][][][][][][][][397.00][]"));
        panelInfo.add((Component)this.btnSDKVersion, "cell 0 1,growx");
        this.btnSDKVersion.setActionCommand("VERSION");
        this.btnSDKVersion.addActionListener(this.ah);
        panelInfo.add((Component)this.btnSDKBits, "cell 0 2,growx");
        this.btnSDKBits.setActionCommand("SDKBITS");
        this.btnSDKBits.addActionListener(this.ah);
        panelInfo.add((Component)this.btnConnectionType, "cell 0 3,growx");
        this.btnConnectionType.setActionCommand("CONNECTION");
        this.btnConnectionType.addActionListener(this.ah);
        panelInfo.add((Component)this.btnPrinterType, "cell 0 4,growx");
        this.btnPrinterType.setActionCommand("TYPE");
        this.btnPrinterType.addActionListener(this.ah);
        panelInfo.add((Component)this.btnPrinterModel, "cell 0 5,growx");
        this.btnPrinterModel.setActionCommand("MODEL");
        this.btnPrinterModel.addActionListener(this.ah);
        panelInfo.add((Component)this.btnPrinterStatus, "cell 0 6,growx");
        this.btnPrinterStatus.setActionCommand("STATUS");
        this.btnPrinterStatus.addActionListener(this.ah);
        panelInfo.add((Component)this.btnPrinterInfo, "cell 0 7,growx");
        this.btnPrinterInfo.setActionCommand("INFO");
        this.btnPrinterInfo.addActionListener(this.ah);
        panelInfo.add((Component)this.btnLastMessage, "cell 0 8,growx");
        this.btnLastMessage.setActionCommand("LASTMSG");
        this.btnLastMessage.addActionListener(this.ah);
        panelInfo.add((Component)this.btnTemperature, "cell 0 9,growx");
        this.btnTemperature.setActionCommand("TEMPERATURE");
        this.btnTemperature.addActionListener(this.ah);
        panelInfo.add((Component)this.btnClear, "cell 1 11,alignx center");
        this.btnClear.setActionCommand("CLEAR");
        this.btnClear.addActionListener(this.ah);
        panelInfo.add((Component)this.scrollPane, "cell 1 1 1 10,grow");
        this.textInfoMsg.setEditable(false);
        this.scrollPane.setViewportView(this.textInfoMsg);
    }

    void Init(WinNT.HANDLE handle, SDKlib sdk) {
        Main.tabbedPane.addTab("Information", null, panelInfo, null);
        this.hSession = handle;
        this.SDK = sdk;
    }

    void ClearMsg() {
        this.textInfoMsg.setText(null);
    }

    private void SDKBits() {
        this.textInfoMsg.append(String.valueOf(this.SDK.ID_SDKBits()) + " Bit SDK\n\n");
    }

    private void LastMsg() {
        StringBuilder Message = new StringBuilder();
        byte sdkReturn = this.SDK.ID_LastMessage(this.hSession, Message);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetLastMessage", sdkReturn);
        } else {
            this.textInfoMsg.append(String.valueOf(Message.toString()) + "\n\n");
        }
    }

    private void PrinterStatus() {
        String temp_string = "";
        switch (this.SDK.ID_PrinterStatus(this.hSession)) {
            case 0: {
                temp_string = "READY";
                break;
            }
            case 3: {
                temp_string = "OFFLINE";
                break;
            }
            case 2: {
                temp_string = "ERROR";
                break;
            }
            case 1: {
                temp_string = "BUSY";
            }
        }
        this.textInfoMsg.append("Printer is " + temp_string + "\n\n");
    }

    private void PrinterInfo() {
        Utils.CursorWait();
        SDKlib.UltimaInfo HI = new SDKlib.UltimaInfo();
        byte sdkReturn = this.SDK.ID_PrinterInfo(this.hSession, HI);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetPrinterInfo", sdkReturn);
        } else {
            this.textInfoMsg.append("FirmwareVersion: " + new String(HI.firmwareVersion));
            this.textInfoMsg.append("\nPrinterSerial: " + new String(HI.printerSerial));
            this.textInfoMsg.append("\nModelName: " + new String(HI.modelName));
            this.textInfoMsg.append("\nPrinterPartnerCode: " + HI.printerPartnerCode);
            this.textInfoMsg.append("\nCapabilityFlags: " + HI.capabilityFlags);
            this.textInfoMsg.append("\nManufacturer: " + new String(HI.manufacturer));
            this.textInfoMsg.append("\nTransferTargetTemp: " + HI.transferTargetTemperature);
            this.textInfoMsg.append("\nTransferActualTemp: " + HI.transferActualTemperature);
            this.textInfoMsg.append("\nTotalCards: " + HI.totalCards);
            this.textInfoMsg.append("\nTotalPanels: " + HI.totalPanels);
            this.textInfoMsg.append("\nCardsOnPrinthead: " + HI.cardsOnPrinthead);
            this.textInfoMsg.append("\nPanelsOnPrinthead: " + HI.panelsOnPrinthead);
            this.textInfoMsg.append("\nCardsLowLevel: " + HI.cardsLow);
            this.textInfoMsg.append("\nColourName: " + new String(HI.colourName));
            this.textInfoMsg.append("\nColourTotalPrints: " + HI.colourTotalPrints);
            this.textInfoMsg.append("\nColourPrintsRemaining: " + HI.colourPrintsRemaining);
            this.textInfoMsg.append("\nColourPartnerCode: " + HI.colourPartnerCode);
            this.textInfoMsg.append("\nTransferName: " + new String(HI.transferName));
            this.textInfoMsg.append("\nTransferTotalPrints: " + HI.transferTotalPrints);
            this.textInfoMsg.append("\nTransferPrintsRemaining: " + HI.transferPrintsRemaining);
            this.textInfoMsg.append("\nTransferPartnerCode: " + HI.transferPartnerCode);
            this.textInfoMsg.append("\nErrorCode: " + HI.errorCode);
            this.textInfoMsg.append("\nErrorContext: " + HI.errorContext);
            this.textInfoMsg.append("\nCardsBetweenPrompts: " + HI.cardsBetweenPrompts);
            this.textInfoMsg.append("\nCleaningOverdue: " + HI.cleaningOverdue);
            this.textInfoMsg.append("\nCardsSinceClean: " + HI.cardsSinceClean);
            this.textInfoMsg.append("\nPanelsSinceClean: " + HI.panelsSinceClean);
            this.textInfoMsg.append("\nCleaningCycles: " + HI.cleaningCycles);
            this.textInfoMsg.append("\nLaminateActualTemperature: " + HI.laminateActualTemperature);
            this.textInfoMsg.append("\nLaminateTargetTemperature: " + HI.laminateTargetTemperature);
            this.textInfoMsg.append("\nLaminateType: " + HI.laminateType);
            this.textInfoMsg.append("\nCardSpeed: " + HI.cardSpeed);
            this.textInfoMsg.append("\n\n");
        }
        Utils.CursorDefault();
    }

    private void SDKVersion() {
        SDKlib.SDKVersion version = new SDKlib.SDKVersion();
        byte sdkReturn = this.SDK.ID_SDKVersion(this.hSession, version);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetVersion", sdkReturn);
        } else {
            this.textInfoMsg.append("Version: " + version.major + "." + version.minor + "." + version.build + "." + version.beta + "\n\n");
        }
    }

    private void Connection() {
        String msg;
        switch (this.SDK.ID_ConnectionType(this.hSession)) {
            case 1: {
                msg = "USB";
                break;
            }
            case 3: {
                msg = "ETHERNET";
                break;
            }
            case 4: {
                msg = "FILE";
                break;
            }
            default: {
                msg = "UNKNOWN";
            }
        }
        this.textInfoMsg.append("Connection: " + msg + "\n\n");
    }

    private void Type() {
        this.textInfoMsg.append("Printer Type - ");
        switch (this.SDK.ID_PrinterType(this.hSession)) {
            case 0: {
                this.textInfoMsg.append("RioTango\n\n");
                break;
            }
            case 1: {
                this.textInfoMsg.append("AOTA\n\n");
                break;
            }
            case 2: {
                this.textInfoMsg.append("Enduro Family\n\n");
                break;
            }
            case 3: {
                this.textInfoMsg.append("Ultima\n\n");
                break;
            }
            case 4: {
                this.textInfoMsg.append("Generation 2 Family\n\n");
                break;
            }
            default: {
                this.textInfoMsg.append("UNKNOWN\n\n");
            }
        }
    }

    private void Model() {
        int model = this.SDK.ID_PrinterModel(this.hSession);
        String msg = (model & 0x1000) != 0 ? "Ultima" : "UNKNOWN";
        this.textInfoMsg.append("Printer - " + msg + "\n");
        this.textInfoMsg.append("Capability:\n");
        if ((model & 1) != 0) {
            this.textInfoMsg.append("  - Mag Stripe\n");
        }
        if ((model & 2) != 0) {
            this.textInfoMsg.append("  - Duplex\n");
        }
        if ((model & 0x10) != 0) {
            this.textInfoMsg.append("  - Chip Encoding\n");
        }
        if ((model & 8) != 0) {
            this.textInfoMsg.append("  - Contactless Encoding\n");
        }
        if ((model & 0x800) != 0) {
            this.textInfoMsg.append("  - Ethernet\n");
        }
        if ((model & 0x2000) != 0) {
            this.textInfoMsg.append("  - Laminator\n");
        }
        this.textInfoMsg.append("\n");
    }

    private void Temperature() {
        ByteByReference Status2 = new ByteByReference();
        byte sdkReturn = this.SDK.ID_Temperature(this.hSession, (byte)0, Status2);
        if (sdkReturn != 0) {
            Utils.DisplayError("Temperature", sdkReturn);
        } else {
            this.textInfoMsg.append("Transfer Temperature: " + (Status2.getValue() != 0 ? "Ready" : "Preheat") + "\n\n");
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (e.getActionCommand()) {
                case "CLEAR": {
                    Info.this.ClearMsg();
                    break;
                }
                case "LASTMSG": {
                    Info.this.LastMsg();
                    break;
                }
                case "SDKBITS": {
                    Info.this.SDKBits();
                    break;
                }
                case "STATUS": {
                    Info.this.PrinterStatus();
                    break;
                }
                case "INFO": {
                    Info.this.PrinterInfo();
                    break;
                }
                case "VERSION": {
                    Info.this.SDKVersion();
                    break;
                }
                case "CONNECTION": {
                    Info.this.Connection();
                    break;
                }
                case "TYPE": {
                    Info.this.Type();
                    break;
                }
                case "MODEL": {
                    Info.this.Model();
                    break;
                }
                case "TEMPERATURE": {
                    Info.this.Temperature();
                }
            }
        }
    }
}

