/*
 * Decompiled with CFR 0.152.
 */
package UltimaDemo;

import SDK.SDKlib;
import UltimaDemo.ComboItem;
import UltimaDemo.Driver1;
import UltimaDemo.Driver2;
import UltimaDemo.Encoding;
import UltimaDemo.Info;
import UltimaDemo.Main;
import UltimaDemo.PrintDemo;
import UltimaDemo.Utils;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.ByteByReference;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterJob;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

class Printer {
    static final int MAX_ERASECOUNT = 499;
    static final int MAX_OFFSET = 99;
    private final String OPEN = "OPEN";
    private final String CLOSE = "CLOSE";
    private final String RESPONSE = "RESPONSE";
    private final String MOVE = "MOVE";
    private final String CLEAN = "CLEAN";
    private final String RESTART = "RESTART";
    private final String TEST = "TEST";
    private final String EJECTMODE = "EJECTMODE";
    private final String IPSETTINGS = "IPSETTINGS";
    private final String RADIOGET = "RADIOGET";
    private final String RADIOSET = "RADIOSET";
    private final String CLEAR = "CLEAR";
    private final ActionHandler ah = new ActionHandler();
    private final JPanel panelPrinter = new JPanel();
    private final JPanel cardsOpenCloseSession = new JPanel(new CardLayout());
    private final JPanel panelOpen = new JPanel();
    private final JPanel panelClose = new JPanel();
    private final JButton btnOpenSession = new JButton("Open Session");
    private final JButton btnCloseSession = new JButton("Close Session");
    private final JComboBox<ComboItem> comboOpenSession = new JComboBox();
    private final JPanel panelErrorResponse = new JPanel();
    private final JComboBox<ComboItem> comboErrorResponse = new JComboBox();
    private final JButton btnErrorResponse = new JButton("Error Response");
    private final JPanel panelPrinterControl = new JPanel();
    private final JButton btnMoveCard = new JButton("Move Card");
    private final JComboBox<ComboItem> comboMoveCard = new JComboBox();
    private final JButton btnCleanPrinter = new JButton("Clean Printer");
    private final JButton btnTestCard = new JButton("Print Test Card");
    private final JButton btnRestartPrinter = new JButton("Restart Printer");
    private final JPanel panelAction = new JPanel();
    private final JPanel panelPrinterConfig = new JPanel();
    private final JLabel labelAction = new JLabel("Action:");
    private final JRadioButton rdbtnGet = new JRadioButton("Get");
    private final JRadioButton rdbtnSet = new JRadioButton("Set");
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final JPanel panelEjectMode = new JPanel();
    private final JComboBox<ComboItem> comboEjectMode = new JComboBox();
    private final JButton btnEjectMode = new JButton("Eject Mode");
    private final JPanel panelIPSettings = new JPanel();
    private final JLabel labelMode = new JLabel("Mode");
    private final JComboBox<ComboItem> comboIPMode = new JComboBox();
    private final JLabel labelAddress = new JLabel("Address");
    private final JTextField textIPAddress = new JTextField();
    private final JLabel labelSubnet = new JLabel("Subnet");
    private final JTextField textIPSubnet = new JTextField();
    private final JLabel labelGateway = new JLabel("Gateway");
    private final JTextField textIPGateway = new JTextField();
    private final JButton btnIPSettings = new JButton("IP Settings");
    private final JPanel panelPrinterMsg = new JPanel();
    private final JTextArea textPrinterMsg = new JTextArea();
    private final JScrollPane scrollPane = new JScrollPane(this.textPrinterMsg);
    private final JButton btnClear = new JButton("Clear");
    private JTabbedPane tabbedPane;
    private WinNT.HANDLE hSession;
    private SDKlib SDK = new SDKlib();
    static PrinterJob pj;

    protected Printer(JTabbedPane mainTab) {
        this.tabbedPane = mainTab;
        this.tabbedPane.addTab("Printer", null, this.panelPrinter, null);
        this.panelPrinter.setLayout(new MigLayout("", "[152.00px][100.00px][248px][167px]", "[53px][120.00][444.00px]"));
        this.cardsOpenCloseSession.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Session Control", 4, 2, null, new Color(0, 0, 0)));
        this.panelPrinter.add((Component)this.cardsOpenCloseSession, "cell 0 0 2 1,grow");
        this.cardsOpenCloseSession.add((Component)this.panelOpen, "OpenSessionPanel");
        this.cardsOpenCloseSession.add((Component)this.panelClose, "CloseSessionPanel");
        this.panelOpen.setLayout(new MigLayout("", "[][grow]", "[]"));
        this.btnOpenSession.setActionCommand("OPEN");
        this.btnOpenSession.addActionListener(this.ah);
        this.panelOpen.add((Component)this.btnOpenSession, "cell 0 0");
        this.comboOpenSession.addItem(new ComboItem("Config Normal", 0));
        this.comboOpenSession.addItem(new ComboItem("Config Quiet", 1));
        this.panelOpen.add(this.comboOpenSession, "cell 1 0,growx");
        this.btnCloseSession.setActionCommand("CLOSE");
        this.btnCloseSession.addActionListener(this.ah);
        this.panelClose.add(this.btnCloseSession);
        this.panelErrorResponse.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Error Handling", 4, 2, null, new Color(0, 0, 0)));
        this.panelPrinter.add((Component)this.panelErrorResponse, "cell 2 0 2 1,grow");
        this.panelErrorResponse.setLayout(new MigLayout("", "[167px,grow]", "[53px][]"));
        this.comboErrorResponse.setEnabled(false);
        this.comboErrorResponse.addItem(new ComboItem("OK", 0));
        this.comboErrorResponse.addItem(new ComboItem("Cancel", 1));
        this.panelErrorResponse.add(this.comboErrorResponse, "cell 0 0,growx");
        this.btnErrorResponse.setEnabled(false);
        this.panelErrorResponse.add((Component)this.btnErrorResponse, "cell 0 1,alignx center");
        this.btnErrorResponse.setActionCommand("RESPONSE");
        this.btnErrorResponse.addActionListener(this.ah);
        this.btnErrorResponse.setEnabled(false);
        this.panelPrinterControl.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Printer Control", 4, 2, null, new Color(0, 0, 0)));
        this.panelPrinter.add((Component)this.panelPrinterControl, "cell 0 1 2 1,grow");
        this.panelPrinterControl.setLayout(new MigLayout("", "[][94.00]", "[][][]"));
        this.panelPrinterControl.add((Component)this.btnMoveCard, "cell 0 0,growx");
        this.btnMoveCard.setActionCommand("MOVE");
        this.btnMoveCard.addActionListener(this.ah);
        this.btnMoveCard.setEnabled(false);
        this.panelPrinterControl.add(this.comboMoveCard, "cell 1 0,growx");
        this.comboMoveCard.addItem(new ComboItem("Transfer Standby", 0));
        this.comboMoveCard.addItem(new ComboItem("Heated Roller", 1));
        this.comboMoveCard.addItem(new ComboItem("Flip Standby", 2));
        this.comboMoveCard.addItem(new ComboItem("Rotate", 3));
        this.comboMoveCard.addItem(new ComboItem("Mag Encoder", 4));
        this.comboMoveCard.addItem(new ComboItem("Contact Encoder", 5));
        this.comboMoveCard.addItem(new ComboItem("Eject", 6));
        this.comboMoveCard.addItem(new ComboItem("Reject", 7));
        this.comboMoveCard.addItem(new ComboItem("Laminator", 8));
        this.comboMoveCard.addItem(new ComboItem("Contactless Encoder", 9));
        this.comboMoveCard.setEnabled(false);
        this.panelPrinterControl.add((Component)this.btnCleanPrinter, "cell 0 1,growx");
        this.btnCleanPrinter.setActionCommand("CLEAN");
        this.btnCleanPrinter.addActionListener(this.ah);
        this.btnCleanPrinter.setEnabled(false);
        this.panelPrinterControl.add((Component)this.btnRestartPrinter, "cell 1 1");
        this.btnRestartPrinter.setActionCommand("RESTART");
        this.btnRestartPrinter.addActionListener(this.ah);
        this.btnRestartPrinter.setEnabled(false);
        this.panelPrinterControl.add((Component)this.btnTestCard, "cell 0 2");
        this.btnTestCard.setActionCommand("TEST");
        this.btnTestCard.addActionListener(this.ah);
        this.btnTestCard.setEnabled(false);
        this.panelPrinter.add((Component)this.panelPrinterConfig, "cell 0 2 2 1,growx,aligny top");
        this.panelPrinterConfig.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Printer Config", 4, 2, null, new Color(0, 0, 0)));
        this.panelPrinterConfig.setLayout(new MigLayout("", "[grow][grow]", "[][][337.00,grow]"));
        this.panelPrinterConfig.add((Component)this.panelAction, "cell 0 0 2 1,grow");
        this.panelAction.add(this.labelAction);
        this.panelAction.add(this.rdbtnGet);
        this.rdbtnGet.setEnabled(false);
        this.rdbtnGet.setSelected(true);
        this.buttonGroup.add(this.rdbtnGet);
        this.rdbtnGet.setActionCommand("RADIOGET");
        this.rdbtnGet.addActionListener(this.ah);
        this.buttonGroup.add(this.rdbtnSet);
        this.panelAction.add(this.rdbtnSet);
        this.rdbtnSet.setEnabled(false);
        this.buttonGroup.add(this.rdbtnSet);
        this.rdbtnSet.setActionCommand("RADIOSET");
        this.rdbtnSet.addActionListener(this.ah);
        this.panelPrinterConfig.add((Component)this.panelEjectMode, "cell 0 1 2 1,grow");
        this.panelEjectMode.setLayout(new MigLayout("", "[grow]", "[]"));
        this.panelEjectMode.add((Component)this.btnEjectMode, "flowx,cell 0 0,growx");
        this.panelEjectMode.add(this.comboEjectMode, "cell 0 0,growx");
        this.comboEjectMode.addItem(new ComboItem("Off", 0));
        this.comboEjectMode.addItem(new ComboItem("On", 1));
        this.comboEjectMode.setEnabled(false);
        this.btnEjectMode.setEnabled(false);
        this.btnEjectMode.setActionCommand("EJECTMODE");
        this.btnEjectMode.addActionListener(this.ah);
        this.panelPrinterConfig.add((Component)this.panelIPSettings, "cell 0 2 2 1,growx,aligny top");
        this.panelIPSettings.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        this.panelIPSettings.setLayout(new MigLayout("", "[][grow]", "[][][][][]"));
        this.panelIPSettings.add((Component)this.labelMode, "cell 0 0,alignx left");
        this.panelIPSettings.add(this.comboIPMode, "cell 1 0,growx");
        this.comboIPMode.addItem(new ComboItem("Static", 0));
        this.comboIPMode.addItem(new ComboItem("Dynamic", 1));
        this.comboIPMode.setEnabled(false);
        this.panelIPSettings.add((Component)this.labelAddress, "cell 0 1,alignx left");
        this.panelIPSettings.add((Component)this.textIPAddress, "cell 1 1,growx");
        this.textIPAddress.setEnabled(false);
        this.panelIPSettings.add((Component)this.labelSubnet, "cell 0 2,alignx left");
        this.panelIPSettings.add((Component)this.textIPSubnet, "cell 1 2,growx");
        this.textIPSubnet.setEnabled(false);
        this.panelIPSettings.add((Component)this.labelGateway, "cell 0 3,alignx left");
        this.panelIPSettings.add((Component)this.textIPGateway, "cell 1 3,growx");
        this.textIPGateway.setEnabled(false);
        this.panelIPSettings.add((Component)this.btnIPSettings, "cell 0 4 2 1,alignx center");
        this.btnIPSettings.setActionCommand("IPSETTINGS");
        this.btnIPSettings.addActionListener(this.ah);
        this.btnIPSettings.setEnabled(false);
        this.panelPrinter.add((Component)this.panelPrinterMsg, "cell 2 1 2 2,grow");
        this.panelPrinterMsg.setLayout(new MigLayout("", "[grow]", "[grow][]"));
        this.panelPrinterMsg.add((Component)this.scrollPane, "cell 0 0,grow");
        this.textPrinterMsg.setEditable(false);
        this.textPrinterMsg.setBorder(BorderFactory.createLineBorder(Color.black));
        this.panelPrinterMsg.add((Component)this.btnClear, "cell 0 1,alignx center");
        this.btnClear.setActionCommand("CLEAR");
        this.btnClear.addActionListener(this.ah);
        this.textPrinterMsg.append("Demo Version: 1.0.4.1\n");
        this.textPrinterMsg.append("Java Shim Version: " + this.SDK.shimVersion + "\n");
        this.textPrinterMsg.append(String.valueOf(this.SDK.ID_SDKBits()) + " Bit SDK\n\n");
    }

    private void GetSetControls(Boolean state) {
        this.comboEjectMode.setEnabled(state);
        this.comboIPMode.setEnabled(state);
        this.textIPAddress.setEnabled(state);
        this.textIPSubnet.setEnabled(state);
        this.textIPGateway.setEnabled(state);
    }

    private void EnableControls(Boolean state) {
        this.btnMoveCard.setEnabled(state);
        this.comboMoveCard.setEnabled(state);
        this.btnTestCard.setEnabled(state);
        this.btnCleanPrinter.setEnabled(state);
        this.btnRestartPrinter.setEnabled(state);
        this.btnErrorResponse.setEnabled(state);
        this.comboErrorResponse.setEnabled(state);
        this.rdbtnGet.setEnabled(state);
        this.rdbtnSet.setEnabled(state);
        this.btnEjectMode.setEnabled(state);
        this.btnIPSettings.setEnabled(state);
        this.GetSetControls(this.rdbtnSet.isSelected());
    }

    private void ClearMsg() {
        this.textPrinterMsg.setText(null);
    }

    private void OpenSession() {
        pj = PrinterJob.getPrinterJob();
        if (pj.printDialog()) {
            Utils.CursorWait();
            WinNT.HANDLEByReference HandleRef = new WinNT.HANDLEByReference();
            byte sdkReturn = this.SDK.ID_OpenSession(pj.getPrintService().getName(), HandleRef, ((ComboItem)this.comboOpenSession.getSelectedItem()).getValue());
            if (sdkReturn != 0) {
                Utils.DisplayError("OpenSession", sdkReturn);
            } else {
                this.hSession = HandleRef.getValue();
                if (this.SDK.ID_PrinterType(this.hSession) != 3) {
                    JOptionPane.showMessageDialog(null, "Invalid Printer - Ultima Only", "SDK ERROR", 1);
                    this.SDK.ID_CloseSession(this.hSession);
                } else {
                    this.EnableControls(true);
                    CardLayout cl = (CardLayout)this.cardsOpenCloseSession.getLayout();
                    cl.last(this.cardsOpenCloseSession);
                    Main.InfoTab.Init(this.hSession, this.SDK);
                    Main.EncodingTab.Init(this.hSession, this.SDK);
                    Main.Driver1Tab.Init(this.hSession, this.SDK);
                    Main.Driver2Tab.Init(this.hSession, this.SDK, pj.getPrintService().getName());
                    Main.PrintDemoTab.Init(this.hSession, this.SDK);
                    SDKlib.PrinterInfo PI2 = new SDKlib.PrinterInfo();
                    sdkReturn = this.SDK.ID_PrinterInfo(this.hSession, PI2);
                    if (sdkReturn != 0) {
                        Utils.DisplayError("Open-GetPrinterInfo", sdkReturn);
                    } else {
                        this.EjectModeDisplay((PI2.bitFields & 8) != 0 ? (byte)1 : 0);
                        this.GetIPSettings(new SDKlib.IPData());
                    }
                    ((JFrame)this.tabbedPane.getTopLevelAncestor()).pack();
                }
            }
            Utils.CursorDefault();
        }
    }

    private void CloseSession() {
        CardLayout cl = (CardLayout)this.cardsOpenCloseSession.getLayout();
        cl.first(this.cardsOpenCloseSession);
        this.tabbedPane.remove(Info.panelInfo);
        this.tabbedPane.remove(Encoding.panelEncoding);
        this.tabbedPane.remove(Driver1.panelDriver1);
        this.tabbedPane.remove(Driver2.panelDriver2);
        this.tabbedPane.remove(PrintDemo.panelPrintDemo);
        this.EnableControls(false);
        byte sdkReturn = this.SDK.ID_CloseSession(this.hSession);
        if (sdkReturn != 0) {
            Utils.DisplayError("CloseSession", sdkReturn);
        }
    }

    private void MoveCard() {
        Utils.CursorWait();
        byte sdkReturn = this.SDK.ID_MoveCard(this.hSession, ((ComboItem)this.comboMoveCard.getSelectedItem()).getValue());
        if (sdkReturn != 0) {
            Utils.DisplayError("MoveCard", sdkReturn);
        } else {
            sdkReturn = Utils.WaitForPrinterToFinish(this.hSession, this.SDK);
            if (sdkReturn != 0) {
                Utils.DisplayError("MoveCardWait", sdkReturn);
            }
        }
        Utils.CursorDefault();
    }

    private void ErrorResponse() {
        byte sdkReturn = this.SDK.ID_ErrorResponse(this.hSession, ((ComboItem)this.comboErrorResponse.getSelectedItem()).getValue());
        if (sdkReturn != 0) {
            Utils.DisplayError("ErrorResponse", sdkReturn);
        }
    }

    private void CleanPrinter() {
        Utils.CursorWait();
        byte sdkReturn = this.SDK.ID_CleanPrinter(this.hSession);
        if (sdkReturn != 0) {
            Utils.DisplayError("CleanPrinter", sdkReturn);
        } else {
            sdkReturn = Utils.WaitForPrinterToFinish(this.hSession, this.SDK);
            if (sdkReturn != 0) {
                Utils.DisplayError("CleanPrinterWait", sdkReturn);
            }
        }
        Utils.CursorDefault();
    }

    private void RestartPrinter() {
        Utils.CursorWait();
        byte sdkReturn = this.SDK.ID_RestartPrinter(this.hSession);
        if (sdkReturn != 0) {
            Utils.DisplayError("RestartPrinter", sdkReturn);
        } else {
            sdkReturn = Utils.WaitForPrinterToFinish(this.hSession, this.SDK);
            if (sdkReturn != 0) {
                Utils.DisplayError("RestartPrinterWait", sdkReturn);
            }
        }
        Utils.CursorDefault();
    }

    private void PrintTestCard() {
        Utils.CursorWait();
        byte sdkReturn = this.SDK.ID_PrintTestCard(this.hSession);
        if (sdkReturn != 0) {
            Utils.DisplayError("PrintTestCard", sdkReturn);
        } else {
            sdkReturn = Utils.WaitForPrinterToFinish(this.hSession, this.SDK);
            if (sdkReturn != 0) {
                Utils.DisplayError("PrintTestCardWait", sdkReturn);
            }
        }
        Utils.CursorDefault();
    }

    private String EjectModeString(byte mode) {
        return this.comboEjectMode.getItemAt(mode).toString();
    }

    private void EjectModeDisplay(byte mode) {
        this.comboEjectMode.setSelectedIndex(mode);
    }

    private void EjectModeToMsgBox(byte action, byte mode) {
        this.textPrinterMsg.append("Eject Mode" + Utils.Separator(action) + this.EjectModeString(mode) + "\n\n");
    }

    private byte GetEjectMode(ByteByReference mode) {
        Utils.CursorWait();
        byte sdkReturn = this.SDK.ID_EjectMode(this.hSession, (byte)0, mode);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetEjectMode", sdkReturn);
        } else {
            this.EjectModeDisplay(mode.getValue());
        }
        Utils.CursorDefault();
        return sdkReturn;
    }

    private void EjectMode() {
        ByteByReference mode = new ByteByReference(((ComboItem)this.comboEjectMode.getSelectedItem()).getValue());
        if (this.rdbtnGet.isSelected()) {
            if (this.GetEjectMode(mode) == 0) {
                this.EjectModeToMsgBox((byte)0, mode.getValue());
            }
        } else {
            byte sdkReturn = this.SDK.ID_EjectMode(this.hSession, (byte)1, mode);
            if (sdkReturn != 0) {
                Utils.DisplayError("EjectMode", sdkReturn);
            } else {
                this.EjectModeToMsgBox((byte)1, mode.getValue());
            }
        }
    }

    private String IPModeString(byte mode) {
        return this.comboIPMode.getItemAt(mode).toString();
    }

    private void IPSettingsToMsgBox(byte action, SDKlib.IPData IP) {
        String sep = Utils.Separator(action);
        this.textPrinterMsg.append("IP Settings:\nAddress Mode" + sep + this.IPModeString(IP.mode) + "\n" + "IP Address" + sep + IP.getString(IP.address) + "\n" + "Subnet" + sep + IP.getString(IP.subnet) + "\n" + "Gateway" + sep + IP.getString(IP.gateway) + "\n\n");
    }

    private void IPSettingsToCtrl(SDKlib.IPData IP) {
        this.comboIPMode.setSelectedIndex(IP.mode);
        this.textIPAddress.setText(IP.getString(IP.address));
        this.textIPSubnet.setText(IP.getString(IP.subnet));
        this.textIPGateway.setText(IP.getString(IP.gateway));
    }

    private byte GetIPSettings(SDKlib.IPData IP) {
        byte sdkReturn = this.SDK.ID_IPSettings(this.hSession, (byte)0, IP);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetIPSettings", sdkReturn);
        }
        return sdkReturn;
    }

    private void IPSettings() {
        Utils.CursorWait();
        SDKlib.IPData IP = new SDKlib.IPData();
        if (this.rdbtnGet.isSelected()) {
            if (this.GetIPSettings(IP) == 0) {
                this.IPSettingsToMsgBox((byte)0, IP);
                this.IPSettingsToCtrl(IP);
            }
        } else {
            IP.mode = ((ComboItem)this.comboIPMode.getSelectedItem()).getValue();
            IP.address = IP.getInt(this.textIPAddress.getText());
            IP.subnet = IP.getInt(this.textIPSubnet.getText());
            IP.gateway = IP.getInt(this.textIPGateway.getText());
            byte sdkReturn = this.SDK.ID_IPSettings(this.hSession, (byte)1, IP);
            if (sdkReturn != 0) {
                Utils.DisplayError("IPSettings", sdkReturn);
            } else {
                this.IPSettingsToMsgBox((byte)1, IP);
            }
        }
        Utils.CursorDefault();
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (e.getActionCommand()) {
                case "RADIOGET": {
                    Printer.this.GetSetControls(false);
                    break;
                }
                case "RADIOSET": {
                    Printer.this.GetSetControls(true);
                    break;
                }
                case "OPEN": {
                    Printer.this.OpenSession();
                    break;
                }
                case "CLOSE": {
                    Printer.this.CloseSession();
                    break;
                }
                case "RESPONSE": {
                    Printer.this.ErrorResponse();
                    break;
                }
                case "CLEAR": {
                    Printer.this.ClearMsg();
                    break;
                }
                case "MOVE": {
                    Printer.this.MoveCard();
                    break;
                }
                case "CLEAN": {
                    Printer.this.CleanPrinter();
                    break;
                }
                case "RESTART": {
                    Printer.this.RestartPrinter();
                    break;
                }
                case "TEST": {
                    Printer.this.PrintTestCard();
                    break;
                }
                case "EJECTMODE": {
                    Printer.this.EjectMode();
                    break;
                }
                case "IPSETTINGS": {
                    Printer.this.IPSettings();
                }
            }
        }
    }
}

