/*
 * Decompiled with CFR 0.152.
 */
package UltimaDemo;

import SDK.SDKlib;
import UltimaDemo.ComboItem;
import UltimaDemo.Driver1;
import UltimaDemo.HKPreview;
import UltimaDemo.Main;
import UltimaDemo.Utils;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.ByteByReference;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PrinterName;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import sun.print.Win32PrintService;

public class Driver2 {
    static final int MAX_COPIES = 99;
    static final int MAX_HOLOKOTE_ID = 10;
    private final String PRINT = "PRINT";
    private final String CARD = "CARD";
    private final String CSCHANGED = "CSCHANGED";
    private final String HOLOKOTE = "HOLOKOTE";
    private final String HKCHANGED = "HKCHANGED";
    private final String HOLOKOTEID = "HOLOKOTEID";
    private final String COLOURAREA = "COLOURAREA";
    private final String CACHANGED = "CACHANGED";
    private final String COLOURADJUST = "COLOURADJUST";
    private final String HKPREVIEW = "HKPREVIEW";
    private final String RADIOGET = "RADIOGET";
    private final String RADIOSET = "RADIOSET";
    private final String CLEAR = "CLEAR";
    private final ActionHandler ah = new ActionHandler();
    public static final JPanel panelDriver2 = new JPanel();
    private final JPanel panelAction = new JPanel();
    private final JLabel labelAction = new JLabel("Action:");
    private final JRadioButton rdbtnGet = new JRadioButton("Get");
    private final JRadioButton rdbtnSet = new JRadioButton("Set");
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final JPanel panelPrintSettings = new JPanel();
    private final JLabel labelPrintSides = new JLabel("Sides to Print");
    private final JComboBox<ComboItem> comboDuplex = new JComboBox();
    private final JLabel labelCardSize = new JLabel("Card Size");
    private final JComboBox<MediaCombo> comboCardSize = new JComboBox();
    private final JLabel labelPrintCopies = new JLabel("Copies");
    private final JSpinner spinnerCopies = new JSpinner(new SpinnerNumberModel(1, 1, 99, 1));
    private final JButton btnPrintSettings = new JButton("Print Settings");
    private final JPanel panelCardSettings = new JPanel();
    private final JLabel labelCardSide = new JLabel("Side");
    private final JComboBox<ComboItem> comboCardSide = new JComboBox();
    private final JLabel labelColourFormat = new JLabel("Colour Format");
    private final JComboBox<ComboItem> comboColourFormat = new JComboBox();
    private final JLabel labelOrientation = new JLabel("Orientation");
    private final JComboBox<ComboItem> comboOrientation = new JComboBox();
    private final JCheckBox checkOvercoat = new JCheckBox("Overcoat");
    private final JCheckBox checkRotate = new JCheckBox("Rotate");
    private final JButton btnCardSettings = new JButton("Card Settings");
    private final JPanel panelHoloKote = new JPanel();
    private final JLabel labelHoloKoteSide = new JLabel("Side");
    private final JComboBox<ComboItem> comboHoloKoteSide = new JComboBox();
    private final JSpinner spinnerHoloKoteNo = new JSpinner(new SpinnerNumberModel(0, 0, 10, 1));
    private final JLabel labelHoloKoteRotation = new JLabel("Rotation");
    private final JComboBox<ComboItem> comboHoloKoteRotation = new JComboBox();
    private final JButton btnHoloKote = new JButton("HoloKote");
    private final JPanel panelHoloKoteID = new JPanel();
    private final JButton btnHoloKoteID = new JButton("HoloKote ID");
    private final JLabel lblSlotNo = new JLabel("Slot No.");
    private final JSpinner spinnerHoloKoteID = new JSpinner(new SpinnerNumberModel(1, 0, 10, 1));
    private final JPanel panelColourAdjust = new JPanel();
    private final JPanel panelColourArea = new JPanel();
    private final JLabel labelSide = new JLabel("Side");
    private final JComboBox<ComboItem> comboColourAreaSide = new JComboBox();
    private final JLabel labelCorrection = new JLabel("Correction");
    private final JButton btnColourArea = new JButton("Colour Area");
    private final JSpinner spinnerColourAreaL = new JSpinner(new SpinnerNumberModel(0, 0, 1034, 1));
    private final JSpinner spinnerColourAreaW = new JSpinner(new SpinnerNumberModel(0, 0, 1035, 1));
    private final JSpinner spinnerColourAreaB = new JSpinner(new SpinnerNumberModel(0, 0, 662, 1));
    private final JSpinner spinnerColourAreaH = new JSpinner(new SpinnerNumberModel(0, 0, 663, 1));
    private final JLabel labelID = new JLabel("ID");
    private final JButton btnColourAdjust = new JButton("Colour Adjust");
    private final JSpinner spinnerBlackRef = new JSpinner(new SpinnerNumberModel(0, 0, 4000, 1));
    private final JSpinner spinnerWhiteRef = new JSpinner(new SpinnerNumberModel(6000, 6000, 10000, 1));
    private final JLabel labelBlackRef = new JLabel("Black Ref");
    private final JLabel labelWhiteRef = new JLabel("White Ref");
    private final JLabel labelIlluminant = new JLabel("Illuminant");
    private final JComboBox<ComboItem> comboIlluminant = new JComboBox();
    private final JCheckBox checkDarkPicture = new JCheckBox("Dark Picture");
    private final JLabel labelContrast = new JLabel("Contrast");
    private final JSpinner spinnerColourAdjustRed = new JSpinner(new SpinnerNumberModel(2500, 2500, 65000, 1));
    private final JSpinner spinnerColourAdjustBlue = new JSpinner(new SpinnerNumberModel(2500, 2500, 65000, 1));
    private final JSpinner spinnerColourAdjustGreen = new JSpinner(new SpinnerNumberModel(2500, 2500, 65000, 1));
    private final JSpinner spinnerContrast = new JSpinner(new SpinnerNumberModel(0, -100, 100, 1));
    private final JSpinner spinnerTint = new JSpinner(new SpinnerNumberModel(0, -100, 100, 1));
    private final JSpinner spinnerColour = new JSpinner(new SpinnerNumberModel(0, -100, 100, 1));
    private final JSpinner spinnerBrightness = new JSpinner(new SpinnerNumberModel(0, -100, 100, 1));
    private final JCheckBox checkNegative = new JCheckBox("Negative");
    private final JLabel labelRed = new JLabel("R");
    private final JLabel labelGreen = new JLabel("G");
    private final JLabel labelBlue = new JLabel("B");
    private final JLabel labelTint = new JLabel("Tint");
    private final JLabel labelColour = new JLabel("Colour");
    private final JLabel labelBright = new JLabel("Bright");
    private final JSpinner spinnerColourAreaNo = new JSpinner(new SpinnerNumberModel(new Byte("1"), new Byte("1"), new Byte("5"), new Byte("1")));
    private final JComboBox<ComboItem> comboColourAreaCorrection = new JComboBox();
    private final JLabel labelNo = new JLabel("No.");
    private final JLabel labelLeft = new JLabel("L");
    private final JLabel labelWidth = new JLabel("W");
    private final JLabel labelBottom = new JLabel("B");
    private final JLabel labelHeight = new JLabel("H");
    private final JButton btnHolokotePreview = new JButton("HoloKote Preview");
    private final JTextArea textDriver2Msg = new JTextArea();
    private final JScrollPane scrollPane = new JScrollPane(this.textDriver2Msg);
    private final JButton btnClear = new JButton("Clear");
    private WinNT.HANDLE hSession;
    private SDKlib SDK;

    public Driver2() {
        panelDriver2.setLayout(new MigLayout("", "[213.00][grow]", "[][][][][][93.00][grow]"));
        panelDriver2.add((Component)this.panelAction, "cell 0 0,alignx center");
        this.panelAction.setLayout(new MigLayout("insets 0", "[][][]", "[]"));
        this.panelAction.add((Component)this.labelAction, "flowx,cell 0 0 3 0,alignx left");
        this.panelAction.add((Component)this.rdbtnGet, "cell 0 0");
        this.rdbtnGet.setSelected(true);
        this.buttonGroup.add(this.rdbtnGet);
        this.rdbtnGet.setActionCommand("RADIOGET");
        this.rdbtnGet.addActionListener(this.ah);
        this.buttonGroup.add(this.rdbtnSet);
        this.panelAction.add((Component)this.rdbtnSet, "cell 0 0");
        this.buttonGroup.add(this.rdbtnSet);
        this.rdbtnSet.setActionCommand("RADIOSET");
        this.rdbtnSet.addActionListener(this.ah);
        panelDriver2.add((Component)this.panelPrintSettings, "cell 0 1");
        this.panelPrintSettings.setLayout(new MigLayout("", "[][132.00]", "[][][][]"));
        this.panelPrintSettings.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        this.panelPrintSettings.add((Component)this.labelPrintSides, "cell 0 0");
        this.comboDuplex.setEnabled(false);
        this.panelPrintSettings.add(this.comboDuplex, "cell 1 0,growx");
        this.comboDuplex.addItem(new ComboItem("Front Only", 0));
        this.comboDuplex.addItem(new ComboItem("Both Sides", 1));
        this.comboDuplex.addItem(new ComboItem("Back Only", 2));
        this.panelPrintSettings.add((Component)this.labelCardSize, "cell 0 1,alignx left");
        this.comboCardSize.setEnabled(false);
        this.panelPrintSettings.add(this.comboCardSize, "cell 1 1,growx");
        this.panelPrintSettings.add((Component)this.labelPrintCopies, "cell 0 2");
        this.spinnerCopies.setEnabled(false);
        this.panelPrintSettings.add((Component)this.spinnerCopies, "flowx,cell 1 2,alignx left");
        this.panelPrintSettings.add((Component)this.btnPrintSettings, "cell 0 3 2 1,alignx center");
        this.btnPrintSettings.setActionCommand("PRINT");
        this.btnPrintSettings.addActionListener(this.ah);
        panelDriver2.add((Component)this.panelCardSettings, "cell 0 2,growy");
        this.panelCardSettings.setLayout(new MigLayout("", "[][132.00]", "[][][][][]"));
        this.panelCardSettings.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        this.panelCardSettings.add((Component)this.labelCardSide, "flowx,cell 0 0,alignx left");
        this.panelCardSettings.add(this.comboCardSide, "cell 1 0,growx");
        this.comboCardSide.addItem(new ComboItem("FRONT", 0));
        this.comboCardSide.addItem(new ComboItem("BACK", 1));
        this.panelCardSettings.add((Component)this.labelColourFormat, "flowx,cell 0 1,alignx left");
        this.comboColourFormat.setEnabled(false);
        this.panelCardSettings.add(this.comboColourFormat, "cell 1 1,growx");
        this.comboColourFormat.addItem(new ComboItem("YMC", 0));
        this.comboColourFormat.addItem(new ComboItem("YMCK", 1));
        this.comboColourFormat.addItem(new ComboItem("K-Resin", 2));
        this.panelCardSettings.add((Component)this.labelOrientation, "cell 0 2,alignx left");
        this.comboOrientation.setEnabled(false);
        this.panelCardSettings.add(this.comboOrientation, "cell 1 2,growx");
        this.comboOrientation.addItem(new ComboItem("Portrait", 0));
        this.comboOrientation.addItem(new ComboItem("Landscape", 1));
        this.checkOvercoat.setEnabled(false);
        this.panelCardSettings.add((Component)this.checkOvercoat, "cell 0 3");
        this.checkRotate.setEnabled(false);
        this.panelCardSettings.add((Component)this.checkRotate, "cell 1 3,alignx right");
        this.panelCardSettings.add((Component)this.btnCardSettings, "cell 0 4 2 1,alignx center");
        this.btnCardSettings.setActionCommand("CARD");
        this.btnCardSettings.addActionListener(this.ah);
        panelDriver2.add((Component)this.panelHoloKote, "cell 0 3,growy");
        this.panelHoloKote.setLayout(new MigLayout("", "[][159.00]", "[][][]"));
        this.panelHoloKote.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        this.panelHoloKote.add((Component)this.labelHoloKoteSide, "cell 0 0,growx");
        this.panelHoloKote.add(this.comboHoloKoteSide, "flowx,cell 1 0,growx");
        this.comboHoloKoteSide.addItem(new ComboItem("FRONT", 0));
        this.comboHoloKoteSide.addItem(new ComboItem("BACK", 1));
        this.panelHoloKote.add((Component)this.labelHoloKoteRotation, "cell 0 1,alignx left");
        this.comboHoloKoteRotation.setEnabled(false);
        this.panelHoloKote.add(this.comboHoloKoteRotation, "cell 1 1,growx");
        this.comboHoloKoteRotation.addItem(new ComboItem("None", 0));
        this.comboHoloKoteRotation.addItem(new ComboItem("90 Degrees", 1));
        this.comboHoloKoteRotation.addItem(new ComboItem("180 Degrees", 2));
        this.comboHoloKoteRotation.addItem(new ComboItem("270 Degrees", 3));
        this.panelHoloKote.add((Component)this.btnHoloKote, "flowx,cell 0 2 2 1,alignx left");
        this.panelHoloKote.add((Component)this.labelID, "cell 1 0,alignx right");
        this.panelHoloKote.add((Component)this.spinnerHoloKoteNo, "cell 1 0,growx");
        this.spinnerHoloKoteNo.setEnabled(false);
        this.btnHoloKote.setActionCommand("HOLOKOTE");
        this.btnHoloKote.addActionListener(this.ah);
        this.panelHoloKote.add((Component)this.btnHolokotePreview, "cell 0 2,growx");
        this.btnHolokotePreview.setActionCommand("HKPREVIEW");
        this.btnHolokotePreview.addActionListener(this.ah);
        panelDriver2.add((Component)this.panelHoloKoteID, "cell 0 4,growy");
        this.panelHoloKoteID.setLayout(new MigLayout("", "[203.00][203.00]", "[][]"));
        this.panelHoloKoteID.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        this.panelHoloKoteID.add((Component)this.lblSlotNo, "flowx,cell 0 0");
        this.panelHoloKoteID.add((Component)this.spinnerHoloKoteID, "cell 1 0,growx");
        this.panelHoloKoteID.add((Component)this.btnHoloKoteID, "cell 0 1 2 1,alignx center");
        this.btnHoloKoteID.setActionCommand("HOLOKOTEID");
        this.btnHoloKoteID.addActionListener(this.ah);
        panelDriver2.add((Component)this.panelColourArea, "cell 0 5 1 2,aligny top");
        this.panelColourArea.setLayout(new MigLayout("", "[101.00][132.00]", "[][][][][]"));
        this.panelColourArea.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        this.panelColourArea.add((Component)this.labelSide, "flowx,cell 0 0,alignx left");
        this.panelColourArea.add(this.comboColourAreaSide, "cell 0 0,growx");
        this.comboColourAreaSide.addItem(new ComboItem("FRONT", 0));
        this.comboColourAreaSide.addItem(new ComboItem("BACK", 1));
        this.comboColourAreaSide.setActionCommand("CACHANGED");
        this.comboColourAreaSide.addActionListener(this.ah);
        this.panelColourArea.add((Component)this.labelNo, "flowx,cell 1 0,alignx right");
        this.spinnerColourAreaNo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Driver2.this.ColourAreaChanged();
            }
        });
        this.panelColourArea.add((Component)this.spinnerColourAreaNo, "cell 1 0,alignx right");
        this.labelLeft.setHorizontalAlignment(0);
        this.panelColourArea.add((Component)this.labelLeft, "flowx,cell 0 2");
        this.spinnerColourAreaL.setEnabled(false);
        this.spinnerColourAreaL.setEditor(new JSpinner.NumberEditor(this.spinnerColourAreaL, "#"));
        this.panelColourArea.add((Component)this.spinnerColourAreaL, "cell 0 2,growx");
        this.labelWidth.setHorizontalAlignment(0);
        this.panelColourArea.add((Component)this.labelWidth, "flowx,cell 1 2");
        this.panelColourArea.add((Component)this.spinnerColourAreaW, "cell 1 2,growx");
        this.spinnerColourAreaW.setEnabled(false);
        this.spinnerColourAreaW.setEditor(new JSpinner.NumberEditor(this.spinnerColourAreaW, "#"));
        this.labelBottom.setHorizontalAlignment(0);
        this.panelColourArea.add((Component)this.labelBottom, "flowx,cell 0 3");
        this.panelColourArea.add((Component)this.spinnerColourAreaB, "cell 0 3,growx");
        this.spinnerColourAreaB.setEnabled(false);
        this.spinnerColourAreaB.setEditor(new JSpinner.NumberEditor(this.spinnerColourAreaB, "#"));
        this.labelHeight.setHorizontalAlignment(0);
        this.panelColourArea.add((Component)this.labelHeight, "flowx,cell 1 3");
        this.panelColourArea.add((Component)this.spinnerColourAreaH, "cell 1 3,growx");
        this.spinnerColourAreaH.setEnabled(false);
        this.spinnerColourAreaH.setEditor(new JSpinner.NumberEditor(this.spinnerColourAreaH, "#"));
        this.panelColourArea.add((Component)this.labelCorrection, "flowx,cell 0 1 2 1");
        this.panelColourArea.add(this.comboColourAreaCorrection, "cell 0 1 2 1,growx");
        Driver1.InitCorrectionCombo(this.comboColourAreaCorrection);
        this.comboColourAreaCorrection.setEnabled(false);
        this.panelColourArea.add((Component)this.btnColourArea, "cell 0 4 2 1,alignx center");
        this.btnColourArea.setActionCommand("COLOURAREA");
        this.btnColourArea.addActionListener(this.ah);
        panelDriver2.add((Component)this.panelColourAdjust, "cell 1 0 1 7,grow");
        this.panelColourAdjust.setLayout(new MigLayout("", "[::25%,grow][::25%,grow][::25%,grow][::25%,grow,fill]", "[1.00][][][7.00][][][][][][][grow][]"));
        this.panelColourAdjust.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        this.panelColourAdjust.add((Component)this.labelContrast, "flowx,cell 0 1 4 1,growx");
        this.labelContrast.setHorizontalAlignment(0);
        this.spinnerContrast.setEnabled(false);
        this.panelColourAdjust.add((Component)this.spinnerContrast, "flowx,cell 0 2 4 1,growx");
        this.panelColourAdjust.add((Component)this.labelBright, "cell 0 1 4 1,growx");
        this.labelBright.setHorizontalAlignment(0);
        this.spinnerBrightness.setEnabled(false);
        this.panelColourAdjust.add((Component)this.spinnerBrightness, "cell 0 2 4 1,growx");
        this.panelColourAdjust.add((Component)this.labelColour, "cell 0 1 4 1,growx");
        this.labelColour.setHorizontalAlignment(0);
        this.spinnerColour.setEnabled(false);
        this.panelColourAdjust.add((Component)this.spinnerColour, "cell 0 2 4 1,growx");
        this.panelColourAdjust.add((Component)this.labelTint, "cell 0 1 4 1,growx");
        this.labelTint.setHorizontalAlignment(0);
        this.spinnerTint.setEnabled(false);
        this.panelColourAdjust.add((Component)this.spinnerTint, "cell 0 2 4 1,growx");
        this.panelColourAdjust.add((Component)this.labelRed, "flowx,cell 0 3 4 1,growx");
        this.labelRed.setHorizontalAlignment(0);
        this.spinnerColourAdjustRed.setEnabled(false);
        this.panelColourAdjust.add((Component)this.spinnerColourAdjustRed, "flowx,cell 0 4 4 1,growx");
        this.panelColourAdjust.add((Component)this.labelGreen, "cell 0 3 4 1,growx");
        this.labelGreen.setHorizontalAlignment(0);
        this.spinnerColourAdjustGreen.setEnabled(false);
        this.panelColourAdjust.add((Component)this.spinnerColourAdjustGreen, "cell 0 4 4 1,growx");
        this.panelColourAdjust.add((Component)this.labelBlue, "cell 0 3 4 1,growx");
        this.labelBlue.setHorizontalAlignment(0);
        this.spinnerColourAdjustBlue.setEnabled(false);
        this.panelColourAdjust.add((Component)this.spinnerColourAdjustBlue, "cell 0 4 4 1,growx");
        this.panelColourAdjust.add((Component)this.labelIlluminant, "flowx,cell 0 6 4 1,alignx left");
        this.panelColourAdjust.add(this.comboIlluminant, "cell 0 6 4 1,growx");
        this.comboIlluminant.setEnabled(false);
        this.comboIlluminant.addItem(new ComboItem("Device Default", 0));
        this.comboIlluminant.addItem(new ComboItem("Tungsten Lamp", 1));
        this.comboIlluminant.addItem(new ComboItem("Noon Sunlight", 2));
        this.comboIlluminant.addItem(new ComboItem("NTSC Sunlight", 3));
        this.comboIlluminant.addItem(new ComboItem("Normal Print", 4));
        this.comboIlluminant.addItem(new ComboItem("Bond Paper Print", 5));
        this.comboIlluminant.addItem(new ComboItem("Standard Daylight", 6));
        this.comboIlluminant.addItem(new ComboItem("Northern Daylight", 7));
        this.comboIlluminant.addItem(new ComboItem("Cool White Lamp", 8));
        this.panelColourAdjust.add((Component)this.checkDarkPicture, "cell 0 5 2 1");
        this.checkDarkPicture.setEnabled(false);
        this.panelColourAdjust.add((Component)this.checkNegative, "cell 2 5 2 1,alignx right");
        this.checkNegative.setEnabled(false);
        this.panelColourAdjust.add((Component)this.labelBlackRef, "cell 0 7 2 1,alignx center");
        this.labelBlackRef.setHorizontalAlignment(0);
        this.panelColourAdjust.add((Component)this.labelWhiteRef, "cell 2 7 2 1,alignx center");
        this.labelWhiteRef.setHorizontalAlignment(0);
        this.spinnerBlackRef.setEnabled(false);
        this.panelColourAdjust.add((Component)this.spinnerBlackRef, "flowx,cell 0 8 2 1,alignx center");
        this.spinnerWhiteRef.setEnabled(false);
        this.panelColourAdjust.add((Component)this.spinnerWhiteRef, "cell 2 8 2 1,alignx center");
        this.panelColourAdjust.add((Component)this.btnColourAdjust, "cell 0 9 4 1,alignx center");
        this.btnColourAdjust.setActionCommand("COLOURADJUST");
        this.btnColourAdjust.addActionListener(this.ah);
        this.panelColourAdjust.add((Component)this.scrollPane, "cell 0 10 4 1,grow");
        this.textDriver2Msg.setEditable(false);
        this.textDriver2Msg.setBorder(BorderFactory.createLineBorder(Color.black));
        this.panelColourAdjust.add((Component)this.btnClear, "cell 0 11 4 1,alignx center");
        this.btnClear.setActionCommand("CLEAR");
        this.btnClear.addActionListener(this.ah);
    }

    private void InitCardSizeCombo(String printername) {
        HashAttributeSet aset = new HashAttributeSet();
        aset.add(new PrinterName(printername, null));
        PrintService[] services = PrintServiceLookup.lookupPrintServices(null, aset);
        int i = 0;
        while (i < services.length) {
            Win32PrintService service = (Win32PrintService)services[i];
            Object o = service.getSupportedAttributeValues(Media.class, null, null);
            if (o != null && o.getClass().isArray()) {
                Media[] mediaArray = (Media[])o;
                int n = mediaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Media res = mediaArray[n2];
                    if (res instanceof MediaSizeName) {
                        int z = service.findPaperID((MediaSizeName)res);
                        this.comboCardSize.addItem(new MediaCombo(res, z));
                    }
                    ++n2;
                }
            }
            ++i;
        }
    }

    void Init(WinNT.HANDLE handle, SDKlib sdk, String printername) {
        Main.tabbedPane.addTab("Driver 2", null, panelDriver2, null);
        this.hSession = handle;
        this.SDK = sdk;
        this.InitCardSizeCombo(printername);
        this.GetPrintSettings(new SDKlib.PrintSettings());
        this.GetCardSettings((byte)0, new SDKlib.CardSettings());
        this.GetHoloKote((byte)0, new SDKlib.HoloKote());
        this.GetColourArea((byte)0, (byte)1, new SDKlib.Area(), new ByteByReference());
        this.GetColourAdjust(new SDKlib.ColourAdj());
    }

    private void GetSetControls(Boolean state) {
        this.comboDuplex.setEnabled(state);
        this.comboCardSize.setEnabled(state);
        this.spinnerCopies.setEnabled(state);
        this.comboColourFormat.setEnabled(state);
        this.comboOrientation.setEnabled(state);
        this.checkOvercoat.setEnabled(state);
        this.checkRotate.setEnabled(state);
        this.spinnerHoloKoteNo.setEnabled(state);
        this.comboHoloKoteRotation.setEnabled(state);
        this.spinnerColourAreaL.setEnabled(state);
        this.spinnerColourAreaW.setEnabled(state);
        this.spinnerColourAreaB.setEnabled(state);
        this.spinnerColourAreaH.setEnabled(state);
        this.comboColourAreaCorrection.setEnabled(state);
        this.spinnerContrast.setEnabled(state);
        this.spinnerBrightness.setEnabled(state);
        this.spinnerColour.setEnabled(state);
        this.spinnerTint.setEnabled(state);
        this.spinnerColourAdjustRed.setEnabled(state);
        this.spinnerColourAdjustGreen.setEnabled(state);
        this.spinnerColourAdjustBlue.setEnabled(state);
        this.comboIlluminant.setEnabled(state);
        this.checkDarkPicture.setEnabled(state);
        this.checkNegative.setEnabled(state);
        this.spinnerBlackRef.setEnabled(state);
        this.spinnerWhiteRef.setEnabled(state);
        this.btnHoloKoteID.setEnabled(state == false);
        this.spinnerHoloKoteID.setEnabled(state == false);
    }

    private void ClearMsg() {
        this.textDriver2Msg.setText(null);
    }

    private String DuplexString(byte duplex) {
        return ((ComboItem)this.comboDuplex.getSelectedItem()).toString();
    }

    private String CardSizeString(int cardSize) {
        return ((MediaCombo)this.comboCardSize.getSelectedItem()).toString();
    }

    private void PrintSettingsToMsgBox(byte action, SDKlib.PrintSettings PS) {
        String sep = Utils.Separator(action);
        this.textDriver2Msg.append("Duplex" + sep + this.DuplexString(PS.duplex) + "\n" + "Card Size" + sep + this.CardSizeString(PS.cardSize) + "\n" + "Copy Count" + sep + PS.copyCount + "\n\n");
    }

    private byte GetPrintSettings(SDKlib.PrintSettings PS) {
        byte sdkReturn = this.SDK.ID_PrintSettings(this.hSession, (byte)0, PS);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetPrintSettings", sdkReturn);
        } else {
            this.comboDuplex.setSelectedIndex(PS.duplex);
            this.spinnerCopies.setValue(PS.copyCount);
            this.comboCardSize.setSelectedItem(PS.cardSize);
        }
        return sdkReturn;
    }

    private void PrintSettings() {
        SDKlib.PrintSettings PS = new SDKlib.PrintSettings();
        if (this.rdbtnGet.isSelected()) {
            if (this.GetPrintSettings(PS) == 0) {
                this.PrintSettingsToMsgBox((byte)0, PS);
            }
        } else {
            PS.duplex = ((ComboItem)this.comboDuplex.getSelectedItem()).getValue();
            PS.copyCount = (Byte)this.spinnerCopies.getValue();
            PS.cardSize = ((MediaCombo)this.comboCardSize.getSelectedItem()).getValue();
            byte sdkReturn = this.SDK.ID_PrintSettings(this.hSession, (byte)1, PS);
            if (sdkReturn != 0) {
                Utils.DisplayError("SetPrintSettings", sdkReturn);
            } else {
                this.PrintSettingsToMsgBox((byte)1, PS);
            }
        }
    }

    private String ColourFormatString(byte format) {
        return ((ComboItem)this.comboColourFormat.getSelectedItem()).toString();
    }

    private String OrientationString(byte orientation) {
        return ((ComboItem)this.comboOrientation.getSelectedItem()).toString();
    }

    private void CardSettingsChanged() {
        SDKlib.CardSettings CS = new SDKlib.CardSettings();
        if (this.GetCardSettings(((ComboItem)this.comboCardSide.getSelectedItem()).getValue(), CS) == 0) {
            this.SetCardSettings(CS);
        }
    }

    private void SetCardSettings(SDKlib.CardSettings CS) {
        this.comboColourFormat.setSelectedIndex(CS.colourFormat);
        this.checkOvercoat.setSelected(CS.overcoat);
        this.comboOrientation.setSelectedIndex(CS.orientation);
        this.checkRotate.setSelected(CS.rotation);
    }

    private void CardSettingsToMsgBox(byte action, SDKlib.CardSettings CS) {
        String sep = Utils.Separator(action);
        this.textDriver2Msg.append("CardSettings (" + ((ComboItem)this.comboCardSide.getSelectedItem()).toString() + ")" + "\n" + "Colour Format" + sep + this.ColourFormatString(CS.colourFormat) + "\n" + "Overcoat" + sep + Utils.OnOffString(CS.overcoat) + "\n" + "Orientation" + sep + this.OrientationString(CS.orientation) + "\n" + "Rotation" + sep + Utils.OnOffString(CS.rotation) + "\n\n");
    }

    private byte GetCardSettings(byte side, SDKlib.CardSettings CS) {
        byte sdkReturn = this.SDK.ID_CardSettings(this.hSession, (byte)0, side, CS);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetCardSettings", sdkReturn);
        } else {
            this.SetCardSettings(CS);
        }
        return sdkReturn;
    }

    private void CardSettings() {
        SDKlib.CardSettings CS = new SDKlib.CardSettings();
        byte side = ((ComboItem)this.comboCardSide.getSelectedItem()).getValue();
        if (this.rdbtnGet.isSelected()) {
            if (this.GetCardSettings(side, CS) == 0) {
                this.CardSettingsToMsgBox((byte)0, CS);
            }
        } else {
            CS.colourFormat = ((ComboItem)this.comboColourFormat.getSelectedItem()).getValue();
            CS.overcoat = this.checkOvercoat.isSelected();
            CS.orientation = ((ComboItem)this.comboOrientation.getSelectedItem()).getValue();
            CS.rotation = this.checkRotate.isSelected();
            byte sdkReturn = this.SDK.ID_CardSettings(this.hSession, (byte)1, side, CS);
            if (sdkReturn != 0) {
                Utils.DisplayError("SetCardSettings", sdkReturn);
            } else {
                this.CardSettingsToMsgBox((byte)1, CS);
            }
        }
    }

    private String RotationString(byte rotation) {
        return ((ComboItem)this.comboHoloKoteRotation.getSelectedItem()).toString();
    }

    private void HoloKoteChanged() {
        SDKlib.HoloKote HK = new SDKlib.HoloKote();
        if (this.GetHoloKote(((ComboItem)this.comboHoloKoteSide.getSelectedItem()).getValue(), HK) == 0) {
            this.SetHoloKote(HK);
        }
    }

    private void SetHoloKote(SDKlib.HoloKote HK) {
        this.spinnerHoloKoteNo.setValue(HK.imageID);
        this.comboHoloKoteRotation.setSelectedIndex(HK.rotation);
    }

    private void HoloKoteToMsgBox(byte action, SDKlib.HoloKote HK) {
        String sep = Utils.Separator(action);
        this.textDriver2Msg.append("HoloKote (" + ((ComboItem)this.comboHoloKoteSide.getSelectedItem()).toString() + ")");
        if (HK.imageID == 0) {
            this.textDriver2Msg.append(String.valueOf(sep) + "Disabled\n\n");
        } else {
            this.textDriver2Msg.append("\nImageID" + sep + HK.imageID + "\n" + "HoloKoteMap" + sep + Integer.toHexString(HK.map).toUpperCase() + "\n" + "Rotation" + sep + this.RotationString(HK.rotation) + "\n" + "UseLaminate" + sep + Utils.OnOffString(HK.useLaminate) + "\n" + "DisableCustomKey" + sep + Utils.OnOffString(HK.disableCustomKey) + "\n\n");
        }
    }

    private byte GetHoloKote(byte side, SDKlib.HoloKote HK) {
        byte sdkReturn = this.SDK.ID_HoloKote(this.hSession, (byte)0, side, HK);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetHoloKote", sdkReturn);
        } else {
            this.SetHoloKote(HK);
        }
        return sdkReturn;
    }

    private void HoloKote() {
        SDKlib.HoloKote HK = new SDKlib.HoloKote();
        byte side = ((ComboItem)this.comboHoloKoteSide.getSelectedItem()).getValue();
        if (this.rdbtnGet.isSelected()) {
            if (this.GetHoloKote(side, HK) == 0) {
                this.HoloKoteToMsgBox((byte)0, HK);
            }
        } else {
            HK.imageID = (Byte)this.spinnerHoloKoteNo.getValue();
            HK.rotation = ((ComboItem)this.comboHoloKoteRotation.getSelectedItem()).getValue();
            byte sdkReturn = this.SDK.ID_HoloKote(this.hSession, (byte)1, side, HK);
            if (sdkReturn != 0) {
                Utils.DisplayError("SetHoloKote", sdkReturn);
            } else {
                this.HoloKoteToMsgBox((byte)1, HK);
            }
        }
    }

    private void HoloKoteID() {
        StringBuilder Message = new StringBuilder();
        int slot = (Integer)this.spinnerHoloKoteID.getValue();
        byte sdkReturn = this.SDK.ID_HoloKoteIdentity(this.hSession, slot, Message);
        if (sdkReturn != 0) {
            Utils.DisplayError("HoloKoteIDs", sdkReturn);
        } else {
            if (slot == 0) {
                this.textDriver2Msg.append("HoloKote IDs:\n");
                StringTokenizer st = new StringTokenizer(Message.toString(), ",");
                int i = 1;
                while (st.hasMoreElements()) {
                    this.textDriver2Msg.append(String.valueOf(i++) + ": " + st.nextElement() + "\n");
                }
            } else {
                this.textDriver2Msg.append("HoloKote ID " + slot + ": " + Message.toString() + "\n");
            }
            this.textDriver2Msg.append("\n");
        }
    }

    private void ColourAreaChanged() {
        ByteByReference correction;
        byte areaNo;
        SDKlib.Area RA = new SDKlib.Area();
        byte side = ((ComboItem)this.comboColourAreaSide.getSelectedItem()).getValue();
        if (this.GetColourArea(side, areaNo = ((Byte)this.spinnerColourAreaNo.getValue()).byteValue(), RA, correction = new ByteByReference(((ComboItem)this.comboColourAreaCorrection.getSelectedItem()).getValue())) == 0) {
            this.SetColourArea(RA, correction.getValue());
        }
    }

    private String CorrectionString(byte correction) {
        return ((ComboItem)this.comboColourAreaCorrection.getSelectedItem()).toString();
    }

    private void ColourAreaToMsgBox(byte side, byte areaNo, SDKlib.Area RA, byte action, byte correction) {
        String sep = Utils.Separator(action);
        this.textDriver2Msg.append("Colour Area " + ((ComboItem)this.comboColourAreaSide.getSelectedItem()).toString() + " " + areaNo + "\n" + "Left" + sep + RA.left + "\n" + "Width" + sep + RA.width + "\n" + "Bottom" + sep + RA.bottom + "\n" + "Height" + sep + RA.height + "\n" + "Correction" + sep + this.CorrectionString(correction) + "\n\n");
    }

    private void SetColourArea(SDKlib.Area RA, byte correction) {
        this.spinnerColourAreaL.setValue(RA.left);
        this.spinnerColourAreaW.setValue(RA.width);
        this.spinnerColourAreaB.setValue(RA.bottom);
        this.spinnerColourAreaH.setValue(RA.height);
        this.comboColourAreaCorrection.setSelectedIndex(correction);
    }

    private byte GetColourArea(byte side, byte areaNo, SDKlib.Area area, ByteByReference correction) {
        byte sdkReturn = this.SDK.ID_ColourArea(this.hSession, (byte)0, side, areaNo, area, correction);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetColourArea", sdkReturn);
        } else {
            this.SetColourArea(area, correction.getValue());
        }
        return sdkReturn;
    }

    private void ColourArea() {
        SDKlib.Area RA = new SDKlib.Area();
        byte side = ((ComboItem)this.comboColourAreaSide.getSelectedItem()).getValue();
        byte areaNo = (Byte)this.spinnerColourAreaNo.getValue();
        ByteByReference correction = new ByteByReference(((ComboItem)this.comboColourAreaCorrection.getSelectedItem()).getValue());
        if (this.rdbtnGet.isSelected()) {
            if (this.GetColourArea(side, areaNo, RA, correction) == 0) {
                this.ColourAreaToMsgBox(side, areaNo, RA, (byte)0, correction.getValue());
            }
        } else {
            RA.left = (Integer)this.spinnerColourAreaL.getValue();
            RA.width = (Integer)this.spinnerColourAreaW.getValue();
            RA.bottom = (Integer)this.spinnerColourAreaB.getValue();
            RA.height = (Integer)this.spinnerColourAreaH.getValue();
            byte sdkReturn = this.SDK.ID_ColourArea(this.hSession, (byte)1, side, areaNo, RA, correction);
            if (sdkReturn != 0) {
                Utils.DisplayError("SetColourArea", sdkReturn);
            } else {
                this.ColourAreaToMsgBox(side, areaNo, RA, (byte)1, correction.getValue());
            }
        }
    }

    private String IlluminantString(byte index) {
        return ((ComboItem)this.comboIlluminant.getSelectedItem()).toString();
    }

    private void ColourAdjToMsgBox(SDKlib.ColourAdj ca, byte action) {
        String sep = Utils.Separator(action);
        this.textDriver2Msg.append("Contrast" + sep + ca.contrast + "\n" + "Brightness" + sep + ca.brightness + "\n" + "Colorfulness" + sep + ca.colour + "\n" + "RedGreenTint" + sep + ca.tint + "\n" + "RedGamma" + sep + ca.red + "\n" + "GreenGamma" + sep + ca.green + "\n" + "BlueGamma" + sep + ca.blue + "\n" + "IlluminantIndex" + sep + this.IlluminantString((byte)ca.illuminant) + "\n" + "Dark Picture" + sep + Utils.OnOffString((ca.flags & 2) != 0) + "\n" + "Negative" + sep + Utils.OnOffString((ca.flags & 1) != 0) + "\n" + "ReferenceBlack" + sep + ca.refBlack + "\n" + "ReferenceWhite" + sep + ca.refWhite + "\n\n");
    }

    private void SetColourAdjust(SDKlib.ColourAdj ca) {
        this.spinnerContrast.setValue(ca.contrast);
        this.spinnerBrightness.setValue(ca.brightness);
        this.spinnerColour.setValue(ca.colour);
        this.spinnerTint.setValue(ca.tint);
        this.spinnerColourAdjustRed.setValue(ca.red);
        this.spinnerColourAdjustGreen.setValue(ca.green);
        this.spinnerColourAdjustBlue.setValue(ca.blue);
        this.comboIlluminant.setSelectedItem(ca.illuminant);
        this.spinnerBlackRef.setValue(ca.refBlack);
        this.spinnerWhiteRef.setValue(ca.refWhite);
        this.checkNegative.setSelected((ca.flags & 2) != 0);
        this.checkDarkPicture.setSelected((ca.flags & 1) != 0);
    }

    private byte GetColourAdjust(SDKlib.ColourAdj pca) {
        byte sdkReturn = this.SDK.ID_ColourAdjust(this.hSession, (byte)0, pca);
        if (sdkReturn == 0) {
            this.SetColourAdjust(pca);
        } else {
            Utils.DisplayError("GetColourAdjust", sdkReturn);
        }
        return sdkReturn;
    }

    private void ColourAdjust() {
        SDKlib.ColourAdj ColAdjust = new SDKlib.ColourAdj();
        if (this.rdbtnGet.isSelected()) {
            if (this.GetColourAdjust(ColAdjust) == 0) {
                this.ColourAdjToMsgBox(ColAdjust, (byte)0);
            }
        } else {
            byte sdkReturn;
            ColAdjust.contrast = (Integer)this.spinnerContrast.getValue();
            ColAdjust.brightness = (Integer)this.spinnerBrightness.getValue();
            ColAdjust.colour = (Integer)this.spinnerColour.getValue();
            ColAdjust.tint = (Integer)this.spinnerTint.getValue();
            ColAdjust.red = (Integer)this.spinnerColourAdjustRed.getValue();
            ColAdjust.green = (Integer)this.spinnerColourAdjustGreen.getValue();
            ColAdjust.blue = (Integer)this.spinnerColourAdjustBlue.getValue();
            ColAdjust.refBlack = (Integer)this.spinnerBlackRef.getValue();
            ColAdjust.refWhite = (Integer)this.spinnerWhiteRef.getValue();
            ColAdjust.illuminant = ((ComboItem)this.comboIlluminant.getSelectedItem()).getValue();
            ColAdjust.flags = 0;
            if (this.checkNegative.isSelected()) {
                ColAdjust.flags |= 1;
            }
            if (this.checkDarkPicture.isSelected()) {
                ColAdjust.flags |= 2;
            }
            if ((sdkReturn = this.SDK.ID_ColourAdjust(this.hSession, (byte)1, ColAdjust)) != 0) {
                Utils.DisplayError("SetColourAdjust", sdkReturn);
            } else {
                this.ColourAdjToMsgBox(ColAdjust, (byte)1);
            }
        }
    }

    private void PreviewHoloKotes() {
        Utils.CursorWait();
        int maxHoloKotes = this.SDK.ID_HoloKoteCount(this.hSession);
        Image[] previews = new BufferedImage[maxHoloKotes];
        byte sdkReturn = this.SDK.ID_HoloKotePreview(this.hSession, (BufferedImage[])previews);
        if (sdkReturn != 0) {
            Utils.DisplayError("HolokotePreview", sdkReturn);
        } else {
            new HKPreview(new JFrame(), this.SDK, previews);
        }
        Utils.CursorDefault();
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (e.getActionCommand()) {
                case "RADIOGET": {
                    Driver2.this.GetSetControls(false);
                    break;
                }
                case "RADIOSET": {
                    Driver2.this.GetSetControls(true);
                    break;
                }
                case "CLEAR": {
                    Driver2.this.ClearMsg();
                    break;
                }
                case "PRINT": {
                    Driver2.this.PrintSettings();
                    break;
                }
                case "CARD": {
                    Driver2.this.CardSettings();
                    break;
                }
                case "CSCHANGED": {
                    Driver2.this.CardSettingsChanged();
                    break;
                }
                case "HOLOKOTE": {
                    Driver2.this.HoloKote();
                    break;
                }
                case "HKCHANGED": {
                    Driver2.this.HoloKoteChanged();
                    break;
                }
                case "HOLOKOTEID": {
                    Driver2.this.HoloKoteID();
                    break;
                }
                case "COLOURAREA": {
                    Driver2.this.ColourArea();
                    break;
                }
                case "CACHANGED": {
                    Driver2.this.ColourAreaChanged();
                    break;
                }
                case "COLOURADJUST": {
                    Driver2.this.ColourAdjust();
                    break;
                }
                case "HKPREVIEW": {
                    Driver2.this.PreviewHoloKotes();
                }
            }
        }
    }

    class MediaCombo {
        private Media key;
        private int value;

        public MediaCombo(Media res, int value) {
            this.key = res;
            this.value = value;
        }

        public String toString() {
            return this.key.toString();
        }

        public int getValue() {
            return this.value;
        }
    }
}

