/*
 * Decompiled with CFR 0.152.
 */
package UltimaDemo;

import SDK.SDKlib;
import UltimaDemo.ComboItem;
import UltimaDemo.Main;
import UltimaDemo.Utils;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.ByteByReference;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;

public class Driver1 {
    static final int MAX_POWER = 99;
    static final int MAX_SHARPNESS = 2;
    static final int MIN_SHARPNESS = -2;
    private final String RADIOGET = "RADIOGET";
    private final String RADIOSET = "RADIOSET";
    private final String CLEAR = "CLEAR";
    private final String GUICONTROL = "GUICONTROL";
    private final String SHARPNESS = "SHARPNESS";
    private final String COLOUR = "COLOUR";
    private final String POWERLEVEL = "POWERLEVEL";
    private final String RESINAREA = "RESINAREA";
    private final String RASIDE = "RASIDE";
    private final ActionHandler ah = new ActionHandler();
    public static final JPanel panelDriver1 = new JPanel();
    private final JPanel panelGeneral = new JPanel();
    private final JPanel panelAction = new JPanel();
    private final JLabel labelAction = new JLabel("Action:");
    private final JRadioButton rdbtnGet = new JRadioButton("Get");
    private final JRadioButton rdbtnSet = new JRadioButton("Set");
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final JCheckBox checkUser = new JCheckBox("User");
    private final JCheckBox checkPrinter = new JCheckBox("Printer");
    private final JButton btnGUIControl = new JButton("GUI Control");
    private final JSpinner spinnerSharpness = new JSpinner(new SpinnerNumberModel(0, -2, 2, 1));
    private final JButton btnSharpness = new JButton("Sharpness");
    private final JComboBox<ComboItem> comboCorrection = new JComboBox();
    private final JButton btnColour = new JButton("Colour Corr.");
    private final JPanel panelPowerLevel = new JPanel();
    private final JLabel labelYMC = new JLabel("YMC");
    private final JLabel labelResin = new JLabel("Resin");
    private final JLabel labelOvercoat = new JLabel("Overcoat");
    private final JSpinner spinnerYMCPower = new JSpinner(new SpinnerNumberModel(0, 0, 99, 1));
    private final JSpinner spinnerResinPower = new JSpinner(new SpinnerNumberModel(0, 0, 99, 1));
    private final JSpinner spinnerOvercoatPower = new JSpinner(new SpinnerNumberModel(0, 0, 99, 1));
    private final JButton btnPowerLevel = new JButton("Power Level");
    private final JPanel panelResinArea = new JPanel();
    private final JLabel labelResinSide = new JLabel("Side");
    private final JComboBox<ComboItem> comboResinAreaSide = new JComboBox();
    private final JLabel labelResinAreaNo = new JLabel("No.");
    private final JSpinner spinnerResinAreaNo = new JSpinner(new SpinnerNumberModel(new Byte("1"), new Byte("1"), new Byte("5"), new Byte("1")));
    private final JLabel labelResinL = new JLabel("L");
    private final JLabel labelResinW = new JLabel("W");
    private final JLabel labelResinB = new JLabel("B");
    private final JLabel labelResinH = new JLabel("H");
    private final JSpinner spinnerResinL = new JSpinner(new SpinnerNumberModel(0, 0, 1034, 1));
    private final JSpinner spinnerResinW = new JSpinner(new SpinnerNumberModel(0, 0, 1035, 1));
    private final JSpinner spinnerResinB = new JSpinner(new SpinnerNumberModel(0, 0, 662, 1));
    private final JSpinner spinnerResinH = new JSpinner(new SpinnerNumberModel(0, 0, 663, 1));
    private final JButton btnResinArea = new JButton("Resin Area");
    private final JTextArea textDriver1Msg = new JTextArea();
    private final JScrollPane scrollPane = new JScrollPane(this.textDriver1Msg);
    private final JButton btnClear = new JButton("Clear");
    private WinNT.HANDLE hSession;
    private SDKlib SDK;

    public Driver1() {
        panelDriver1.setLayout(new MigLayout("", "[pref!][grow]", "[][][][][110.00,grow][28.00]"));
        panelDriver1.add((Component)this.panelAction, "cell 0 0,alignx center");
        this.panelAction.setLayout(new MigLayout("insets 0", "[][][]", "[]"));
        this.panelAction.add((Component)this.labelAction, "flowx,cell 0 0 3 0,alignx left");
        this.panelAction.add((Component)this.rdbtnGet, "cell 0 0");
        this.rdbtnGet.setSelected(true);
        this.buttonGroup.add(this.rdbtnGet);
        this.rdbtnGet.setActionCommand("RADIOGET");
        this.buttonGroup.add(this.rdbtnSet);
        this.panelAction.add((Component)this.rdbtnSet, "cell 0 0");
        this.buttonGroup.add(this.rdbtnSet);
        this.rdbtnSet.setActionCommand("RADIOSET");
        this.rdbtnSet.addActionListener(this.ah);
        this.rdbtnGet.addActionListener(this.ah);
        panelDriver1.add((Component)this.panelGeneral, "cell 0 1,grow");
        this.panelGeneral.setLayout(new MigLayout("", "[100.00,grow][grow][grow]", "[][][]"));
        this.panelGeneral.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        this.panelGeneral.add((Component)this.btnGUIControl, "cell 0 0,growx");
        this.checkUser.setEnabled(false);
        this.panelGeneral.add((Component)this.checkUser, "cell 1 0,alignx right");
        this.checkPrinter.setEnabled(false);
        this.panelGeneral.add((Component)this.checkPrinter, "cell 2 0,alignx right");
        this.btnGUIControl.setActionCommand("GUICONTROL");
        this.btnGUIControl.addActionListener(this.ah);
        this.panelGeneral.add((Component)this.btnSharpness, "cell 0 1,growx");
        this.spinnerSharpness.setEnabled(false);
        this.panelGeneral.add((Component)this.spinnerSharpness, "cell 1 1 2 1,growx");
        this.btnSharpness.setActionCommand("SHARPNESS");
        this.btnSharpness.addActionListener(this.ah);
        this.panelGeneral.add((Component)this.btnColour, "cell 0 2,growx");
        this.comboCorrection.setEnabled(false);
        this.panelGeneral.add(this.comboCorrection, "cell 1 2 2 1,growx");
        Driver1.InitCorrectionCombo(this.comboCorrection);
        this.btnColour.setActionCommand("COLOUR");
        this.btnColour.addActionListener(this.ah);
        panelDriver1.add((Component)this.panelPowerLevel, "cell 0 2,grow");
        this.panelPowerLevel.setLayout(new MigLayout("", "[grow 33,center][grow 33,center][grow 33,center]", "[][][]"));
        this.panelPowerLevel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        this.panelPowerLevel.add((Component)this.labelYMC, "cell 0 0");
        this.panelPowerLevel.add((Component)this.labelResin, "cell 1 0");
        this.panelPowerLevel.add((Component)this.labelOvercoat, "cell 2 0");
        this.spinnerYMCPower.setEnabled(false);
        this.panelPowerLevel.add((Component)this.spinnerYMCPower, "cell 0 1,growx");
        this.spinnerResinPower.setEnabled(false);
        this.panelPowerLevel.add((Component)this.spinnerResinPower, "cell 1 1,growx");
        this.spinnerOvercoatPower.setEnabled(false);
        this.panelPowerLevel.add((Component)this.spinnerOvercoatPower, "cell 2 1,growx");
        this.panelPowerLevel.add((Component)this.btnPowerLevel, "cell 0 2 3 1,alignx center");
        this.btnPowerLevel.setActionCommand("POWERLEVEL");
        this.btnPowerLevel.addActionListener(this.ah);
        panelDriver1.add((Component)this.panelResinArea, "cell 0 3,grow");
        this.panelResinArea.setLayout(new MigLayout("", "[grow][grow][grow][grow]", "[][][][]"));
        this.panelResinArea.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        this.panelResinArea.add((Component)this.labelResinSide, "flowx,cell 0 0 2 1,alignx left");
        this.panelResinArea.add(this.comboResinAreaSide, "cell 0 0 2 1,growx");
        this.comboResinAreaSide.addItem(new ComboItem("Front", 0));
        this.comboResinAreaSide.addItem(new ComboItem("Back", 1));
        this.comboResinAreaSide.setActionCommand("RASIDE");
        this.comboResinAreaSide.addActionListener(this.ah);
        this.panelResinArea.add((Component)this.labelResinAreaNo, "cell 2 0,alignx right");
        this.panelResinArea.add((Component)this.spinnerResinAreaNo, "cell 3 0,growx");
        this.spinnerResinAreaNo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Driver1.this.ResinAreaChanged();
            }
        });
        this.panelResinArea.add((Component)this.labelResinL, "cell 0 1,alignx center");
        this.panelResinArea.add((Component)this.labelResinW, "cell 1 1,alignx center");
        this.panelResinArea.add((Component)this.labelResinB, "cell 2 1,alignx center");
        this.panelResinArea.add((Component)this.labelResinH, "cell 3 1,alignx center");
        this.spinnerResinL.setEnabled(false);
        this.spinnerResinL.setEditor(new JSpinner.NumberEditor(this.spinnerResinL, "#"));
        this.panelResinArea.add((Component)this.spinnerResinL, "cell 0 2,growx");
        this.spinnerResinW.setEnabled(false);
        this.spinnerResinW.setEditor(new JSpinner.NumberEditor(this.spinnerResinW, "#"));
        this.panelResinArea.add((Component)this.spinnerResinW, "cell 1 2,growx");
        this.spinnerResinB.setEnabled(false);
        this.spinnerResinB.setEditor(new JSpinner.NumberEditor(this.spinnerResinB, "#"));
        this.panelResinArea.add((Component)this.spinnerResinB, "cell 2 2,growx");
        this.spinnerResinH.setEnabled(false);
        this.spinnerResinH.setEditor(new JSpinner.NumberEditor(this.spinnerResinH, "#"));
        this.panelResinArea.add((Component)this.spinnerResinH, "cell 3 2,growx");
        this.panelResinArea.add((Component)this.btnResinArea, "cell 0 3 4 1,alignx center");
        this.btnResinArea.setActionCommand("RESINAREA");
        this.btnResinArea.addActionListener(this.ah);
        panelDriver1.add((Component)this.scrollPane, "flowy,cell 1 0 1 5,grow");
        this.textDriver1Msg.setEditable(false);
        this.textDriver1Msg.setBorder(BorderFactory.createLineBorder(Color.black));
        panelDriver1.add((Component)this.btnClear, "cell 1 5,alignx center");
        this.btnClear.setActionCommand("CLEAR");
        this.btnClear.addActionListener(this.ah);
    }

    void Init(WinNT.HANDLE handle, SDKlib sdk) {
        Main.tabbedPane.addTab("Driver 1", null, panelDriver1, null);
        this.hSession = handle;
        this.SDK = sdk;
        this.GetGUIControl(new SDKlib.GUIControl());
        this.GetSharpness(new ByteByReference());
        this.GetCorrection(new ByteByReference());
        this.GetResinArea((byte)0, (byte)1, new SDKlib.Area());
        this.GetPowerLevels(new SDKlib.PowerLevel());
    }

    static void InitCorrectionCombo(JComboBox<ComboItem> combo) {
        combo.addItem(new ComboItem("None", 0));
        combo.addItem(new ComboItem("Gamma 1", 1));
        combo.addItem(new ComboItem("Gamma 2", 2));
        combo.addItem(new ComboItem("ICC Internal", 3));
        combo.addItem(new ComboItem("ICC External", 4));
        combo.addItem(new ComboItem("Perceptual", 5));
        combo.addItem(new ComboItem("Saturation", 6));
        combo.addItem(new ComboItem("Rel. Colorimetric", 7));
        combo.addItem(new ComboItem("Abs. Colorimetric", 8));
    }

    private void GetSetControls(Boolean State) {
        this.checkUser.setEnabled(State);
        this.checkPrinter.setEnabled(State);
        this.spinnerSharpness.setEnabled(State);
        this.comboCorrection.setEnabled(State);
        this.spinnerYMCPower.setEnabled(State);
        this.spinnerResinPower.setEnabled(State);
        this.spinnerOvercoatPower.setEnabled(State);
        this.spinnerResinL.setEnabled(State);
        this.spinnerResinW.setEnabled(State);
        this.spinnerResinB.setEnabled(State);
        this.spinnerResinH.setEnabled(State);
    }

    private void ClearMsg() {
        this.textDriver1Msg.setText(null);
    }

    private void GUIControlToMsgBox(byte action, SDKlib.GUIControl GUI) {
        String sep = Utils.Separator(action);
        this.textDriver1Msg.append("GUI User" + sep + Utils.EnabledDisabledString(GUI.user) + "\n" + "GUI Printer" + sep + Utils.EnabledDisabledString(GUI.printer) + "\n\n");
    }

    private byte GetGUIControl(SDKlib.GUIControl GUI) {
        byte sdkReturn = this.SDK.ID_GUIControl(this.hSession, (byte)0, GUI);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetGUIControl", sdkReturn);
        } else {
            this.checkUser.setSelected(GUI.user);
            this.checkPrinter.setSelected(GUI.printer);
        }
        return sdkReturn;
    }

    private void GUIControl() {
        SDKlib.GUIControl GUI = new SDKlib.GUIControl();
        if (this.rdbtnGet.isSelected()) {
            if (this.GetGUIControl(GUI) == 0) {
                this.GUIControlToMsgBox((byte)0, GUI);
            }
        } else {
            GUI.user = this.checkUser.isSelected();
            GUI.printer = this.checkPrinter.isSelected();
            byte sdkReturn = this.SDK.ID_GUIControl(this.hSession, (byte)1, GUI);
            if (sdkReturn != 0) {
                Utils.DisplayError("SetGUIControl", sdkReturn);
            } else {
                this.GUIControlToMsgBox((byte)1, GUI);
            }
        }
    }

    private void SharpnessToMsgBox(byte action, byte sharpness) {
        this.textDriver1Msg.append("Sharpness" + Utils.Separator(action) + sharpness + "\n\n");
    }

    private byte GetSharpness(ByteByReference sharpness) {
        byte sdkReturn = this.SDK.ID_Sharpness(this.hSession, (byte)0, sharpness);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetSharpness", sdkReturn);
        } else {
            this.spinnerSharpness.setValue(sharpness.getValue());
        }
        return sdkReturn;
    }

    private void Sharpness() {
        ByteByReference sharpness = new ByteByReference();
        if (this.rdbtnGet.isSelected()) {
            if (this.GetSharpness(sharpness) == 0) {
                this.SharpnessToMsgBox((byte)0, sharpness.getValue());
            }
        } else {
            sharpness.setValue((Byte)this.spinnerSharpness.getValue());
            byte sdkReturn = this.SDK.ID_Sharpness(this.hSession, (byte)1, sharpness);
            if (sdkReturn != 0) {
                Utils.DisplayError("SetSharpness", sdkReturn);
            } else {
                this.SharpnessToMsgBox((byte)1, sharpness.getValue());
            }
        }
    }

    private String CorrectionString(byte correction) {
        return ((ComboItem)this.comboCorrection.getSelectedItem()).toString();
    }

    private void CorrectionToMsgBox(byte action, byte correction) {
        this.textDriver1Msg.append("Correction" + Utils.Separator(action) + this.CorrectionString(correction) + "\n\n");
    }

    private byte GetCorrection(ByteByReference correction) {
        byte sdkReturn = this.SDK.ID_ColourCorrection(this.hSession, (byte)0, correction);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetColourCorrection", sdkReturn);
        } else {
            this.comboCorrection.setSelectedIndex(correction.getValue());
        }
        return sdkReturn;
    }

    private void ColourCorrection() {
        ByteByReference correction = new ByteByReference(((ComboItem)this.comboCorrection.getSelectedItem()).getValue());
        if (this.rdbtnGet.isSelected()) {
            if (this.GetCorrection(correction) == 0) {
                this.CorrectionToMsgBox((byte)0, correction.getValue());
            }
        } else {
            byte sdkReturn = this.SDK.ID_ColourCorrection(this.hSession, (byte)1, correction);
            if (sdkReturn != 0) {
                Utils.DisplayError("SetColourCorrection", sdkReturn);
            } else {
                this.CorrectionToMsgBox((byte)1, correction.getValue());
            }
        }
    }

    private void PowerLevelToMsgBox(byte action, SDKlib.PowerLevel Power) {
        String sep = Utils.Separator(action);
        this.textDriver1Msg.append("Power Level YMC" + sep + Power.ymc + "\n" + "Power Level Resin" + sep + Power.resin + "\n" + "Power Level Overcoat" + sep + Power.overcoat + "\n\n");
    }

    private byte GetPowerLevels(SDKlib.PowerLevel Power) {
        byte sdkReturn = this.SDK.ID_PowerLevel(this.hSession, (byte)0, Power);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetPowerLevel", sdkReturn);
        } else {
            this.spinnerYMCPower.setValue(Power.ymc);
            this.spinnerResinPower.setValue(Power.resin);
            this.spinnerOvercoatPower.setValue(Power.overcoat);
        }
        return sdkReturn;
    }

    private void PowerLevel() {
        SDKlib.PowerLevel Power = new SDKlib.PowerLevel();
        if (this.rdbtnGet.isSelected()) {
            if (this.GetPowerLevels(Power) == 0) {
                this.PowerLevelToMsgBox((byte)0, Power);
            }
        } else {
            Power.ymc = (Byte)this.spinnerYMCPower.getValue();
            Power.resin = (Byte)this.spinnerResinPower.getValue();
            Power.overcoat = (Byte)this.spinnerOvercoatPower.getValue();
            byte sdkReturn = this.SDK.ID_PowerLevel(this.hSession, (byte)1, Power);
            if (sdkReturn != 0) {
                Utils.DisplayError("SetPowerLevel", sdkReturn);
            } else {
                this.PowerLevelToMsgBox((byte)1, Power);
            }
        }
    }

    private void ResinAreaChanged() {
        SDKlib.Area RA = new SDKlib.Area();
        if (this.GetResinArea(((ComboItem)this.comboResinAreaSide.getSelectedItem()).getValue(), (Byte)this.spinnerResinAreaNo.getValue(), RA) == 0) {
            this.ResinAreaDisplay(RA);
        }
    }

    private void ResinAreaDisplay(SDKlib.Area RA) {
        this.spinnerResinL.setValue(RA.left);
        this.spinnerResinW.setValue(RA.width);
        this.spinnerResinB.setValue(RA.bottom);
        this.spinnerResinH.setValue(RA.height);
    }

    private void ResinAreaToMsgBox(byte action, byte areaNo, byte side, SDKlib.Area RA) {
        String sep = Utils.Separator(action);
        this.textDriver1Msg.append("Resin Area " + ((ComboItem)this.comboResinAreaSide.getSelectedItem()).toString() + " " + areaNo + "\n" + "Left" + sep + RA.left + "\n" + "Width" + sep + RA.width + "\n" + "Bottom" + sep + RA.bottom + "\n" + "Height" + sep + RA.height + "\n\n");
    }

    private byte GetResinArea(byte side, byte areaNo, SDKlib.Area RA) {
        byte sdkReturn = this.SDK.ID_ResinArea(this.hSession, (byte)0, side, areaNo, RA);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetResinArea", sdkReturn);
        } else {
            this.ResinAreaDisplay(RA);
        }
        return sdkReturn;
    }

    private void ResinArea() {
        SDKlib.Area RA = new SDKlib.Area();
        byte side = ((ComboItem)this.comboResinAreaSide.getSelectedItem()).getValue();
        byte areaNo = (Byte)this.spinnerResinAreaNo.getValue();
        if (this.rdbtnGet.isSelected()) {
            if (this.GetResinArea(side, areaNo, RA) == 0) {
                this.ResinAreaToMsgBox((byte)0, areaNo, side, RA);
            }
        } else {
            RA.left = (Integer)this.spinnerResinL.getValue();
            RA.width = (Integer)this.spinnerResinW.getValue();
            RA.bottom = (Integer)this.spinnerResinB.getValue();
            RA.height = (Integer)this.spinnerResinH.getValue();
            byte sdkReturn = this.SDK.ID_ResinArea(this.hSession, (byte)1, side, areaNo, RA);
            if (sdkReturn != 0) {
                Utils.DisplayError("SetResinArea", sdkReturn);
            } else {
                this.ResinAreaToMsgBox((byte)1, areaNo, side, RA);
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (e.getActionCommand()) {
                case "RADIOGET": {
                    Driver1.this.GetSetControls(false);
                    break;
                }
                case "RADIOSET": {
                    Driver1.this.GetSetControls(true);
                    break;
                }
                case "CLEAR": {
                    Driver1.this.ClearMsg();
                    break;
                }
                case "GUICONTROL": {
                    Driver1.this.GUIControl();
                    break;
                }
                case "SHARPNESS": {
                    Driver1.this.Sharpness();
                    break;
                }
                case "COLOUR": {
                    Driver1.this.ColourCorrection();
                    break;
                }
                case "POWERLEVEL": {
                    Driver1.this.PowerLevel();
                    break;
                }
                case "RESINAREA": {
                    Driver1.this.ResinArea();
                    break;
                }
                case "RASIDE": {
                    Driver1.this.ResinAreaChanged();
                }
            }
        }
    }
}

