/*
 * Decompiled with CFR 0.152.
 */
package SDK;

import SDK.MagAPI;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.StdCallLibrary;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class SDKlib {
    protected MagAPI jsdk = MagAPI.INSTANCE;
    public String shimVersion = "1.2.2.0";
    static final int MAX_TRACKS = 3;
    public final int WIDTH300DPI = 1036;
    public final int HEIGHT300DPI = 664;
    public final int HKPREVIEW_WIDTH = 259;
    public final int HKPREVIEW_HEIGHT = 166;
    static final int LOCALPREVIEW_WIDTH = 259;
    static final int LOCALPREVIEW_HEIGHT = 166;
    public final int HKPREVIEWKEY_SIZE = 256;
    static final int LOCALPREVIEWKEY_SIZE = 256;
    public final int HKPREVIEW_SIZE = 5376;
    static final int LOCALPREVIEW_SIZE = 5376;
    static final byte SDK_TRANSPARENT = 5;

    public byte ID_OpenSession(String Printername, WinNT.HANDLEByReference hSession, byte config) {
        GDI32 lib = (GDI32)Native.loadLibrary("GDI32", GDI32.class);
        WinDef.HDC hdc = lib.CreateDCA("WINSPOOL", Printername, null, null);
        return this.jsdk.ID_OpenSession(hdc, hSession, config);
    }

    public byte ID_OpenSession(WinDef.HDC hdc, WinNT.HANDLEByReference hSession, byte config) {
        return this.jsdk.ID_OpenSession(hdc, hSession, config);
    }

    public byte ID_CloseSession(WinNT.HANDLE hSession) {
        return this.jsdk.ID_CloseSession(hSession);
    }

    public byte ID_SDKBits() {
        return this.jsdk.ID_SDKBits();
    }

    public byte ID_FeedCard(WinNT.HANDLE hSession, byte type, int iParam) {
        return this.jsdk.ID_FeedCard(hSession, type, iParam);
    }

    public byte ID_FeedCard(WinNT.HANDLE hSession) {
        return this.jsdk.ID_FeedCard(hSession, (byte)0, 0);
    }

    public byte ID_EjectCard(WinNT.HANDLE hSession) {
        return this.jsdk.ID_EjectCard(hSession);
    }

    public byte ID_MoveCard(WinNT.HANDLE hSession, byte position) {
        return this.jsdk.ID_MoveCard(hSession, position);
    }

    public byte ID_MoveFilm(WinNT.HANDLE hSession, byte panel) {
        return this.jsdk.ID_MoveFilm(hSession, panel);
    }

    public byte ID_GeneralCommand(WinNT.HANDLE hSession, String Command) {
        return this.jsdk.ID_GeneralCommandA(hSession, Command);
    }

    public byte ID_WaitForPrinter(WinNT.HANDLE hSession) {
        return this.jsdk.ID_WaitForPrinter(hSession);
    }

    public byte ID_PrepareForPrint(WinNT.HANDLE hSession) {
        return this.jsdk.ID_PrepareForPrint(hSession);
    }

    public byte ID_WaitPrintComplete(WinNT.HANDLE hSession) {
        return this.jsdk.ID_WaitPrintComplete(hSession);
    }

    public byte ID_FlipCard(WinNT.HANDLE hSession) {
        return this.jsdk.ID_FlipCard(hSession);
    }

    public byte ID_CleanPrinter(WinNT.HANDLE hSession) {
        return this.jsdk.ID_CleanPrinter(hSession);
    }

    public byte ID_RestartPrinter(WinNT.HANDLE hSession) {
        return this.jsdk.ID_RestartPrinter(hSession);
    }

    public byte ID_PrintTestCard(WinNT.HANDLE hSession) {
        return this.jsdk.ID_PrintTestCard(hSession);
    }

    public byte ID_ErrorResponse(WinNT.HANDLE hSession, byte response) {
        return this.jsdk.ID_ErrorResponse(hSession, response);
    }

    public byte ID_ConnectionType(WinNT.HANDLE hSession) {
        return this.jsdk.ID_ConnectionType(hSession);
    }

    public byte ID_EraseCard(WinNT.HANDLE hSession, int count, int bottomLeftX, int bottomLeftY, int topRightX, int topRightY) {
        return this.jsdk.ID_EraseCard(hSession, count, bottomLeftX, bottomLeftY, topRightX, topRightY);
    }

    public byte ID_PrinterType(WinNT.HANDLE hSession) {
        return this.jsdk.ID_PrinterType(hSession);
    }

    public int ID_PrinterModel(WinNT.HANDLE hSession) {
        return this.jsdk.ID_PrinterModel(hSession);
    }

    public byte ID_PrinterStatus(WinNT.HANDLE hSession) {
        return this.jsdk.ID_PrinterStatus(hSession);
    }

    public byte ID_LastMessage(WinNT.HANDLE hSession, StringBuilder message) {
        MagAPI.StringByReference msg;
        IntByReference size = new IntByReference();
        byte SDKResult = this.jsdk.ID_LastMessageA(hSession, null, size);
        if (SDKResult == -13 && (SDKResult = this.jsdk.ID_LastMessageA(hSession, msg = new MagAPI.StringByReference(size.getValue()), size)) == 0) {
            message.append(msg.getValue());
        }
        return SDKResult;
    }

    public byte ID_PrinterInfo(WinNT.HANDLE hSession, PrinterInfo prninfo) {
        return this.jsdk.ID_PrinterInfo(hSession, prninfo);
    }

    public byte ID_PrinterInfo(WinNT.HANDLE hSession, UltimaInfo prninfo) {
        return this.jsdk.ID_PrinterInfo(hSession, prninfo);
    }

    public byte ID_Temperature(WinNT.HANDLE hSession, byte temperatureID, ByteByReference status) {
        return this.jsdk.ID_Temperature(hSession, temperatureID, status);
    }

    public byte ID_SDKVersion(WinNT.HANDLE hSession, SDKVersion SDKVersion2) {
        return this.jsdk.ID_SDKVersion(hSession, SDKVersion2);
    }

    public byte ID_Sensors(WinNT.HANDLE hSession, IntByReference status) {
        return this.jsdk.ID_Sensors(hSession, status);
    }

    public byte ID_EncodeMag(WinNT.HANDLE hSession, MagDef Defn) {
        if (this.jsdk.ID_SDKBits() == 64) {
            MagAPI.SDKMagEnc64 Encode64 = new MagAPI.SDKMagEnc64();
            Encode64.encoding = Defn.encoding;
            Encode64.coercivity = Defn.coercivity;
            Encode64.verify = Defn.verify;
            if (Defn.track[0].data != null) {
                Encode64.t1Count = Defn.track[0].data.length();
                Encode64.t1Data = Defn.track[0].data;
                Encode64.t1BPC = Defn.track[0].bitsPerChar;
                Encode64.t1BPI = Defn.track[0].bitsPerInch;
                Encode64.t1Par = Defn.track[0].parity;
                Encode64.t1LRC = Defn.track[0].lrc;
            }
            if (Defn.track[1].data != null) {
                Encode64.t2Count = Defn.track[1].data.length();
                Encode64.t2Data = Defn.track[1].data;
                Encode64.t2BPC = Defn.track[1].bitsPerChar;
                Encode64.t2BPI = Defn.track[1].bitsPerInch;
                Encode64.t2Par = Defn.track[1].parity;
                Encode64.t2LRC = Defn.track[1].lrc;
            }
            if (Defn.track[2].data != null) {
                Encode64.t3Count = Defn.track[2].data.length();
                Encode64.t3Data = Defn.track[2].data;
                Encode64.t3BPC = Defn.track[2].bitsPerChar;
                Encode64.t3BPI = Defn.track[2].bitsPerInch;
                Encode64.t3Par = Defn.track[2].parity;
                Encode64.t3LRC = Defn.track[2].lrc;
            }
            return this.jsdk.ID_EncodeMagA(hSession, Encode64);
        }
        MagAPI.SDKMagEnc32 Encode32 = new MagAPI.SDKMagEnc32();
        Encode32.encoding = Defn.encoding;
        Encode32.coercivity = Defn.coercivity;
        Encode32.verify = Defn.verify;
        if (Defn.track[0].data != null) {
            Encode32.t1Count = Defn.track[0].data.length();
            Encode32.t1Data = Defn.track[0].data;
            Encode32.t1BPC = Defn.track[0].bitsPerChar;
            Encode32.t1BPI = Defn.track[0].bitsPerInch;
            Encode32.t1Par = Defn.track[0].parity;
            Encode32.t1LRC = Defn.track[0].lrc;
        }
        if (Defn.track[1].data != null) {
            Encode32.t2Count = Defn.track[1].data.length();
            Encode32.t2Data = Defn.track[1].data;
            Encode32.t2BPC = Defn.track[1].bitsPerChar;
            Encode32.t2BPI = Defn.track[1].bitsPerInch;
            Encode32.t2Par = Defn.track[1].parity;
            Encode32.t2LRC = Defn.track[1].lrc;
        }
        if (Defn.track[2].data != null) {
            Encode32.t3Count = Defn.track[2].data.length();
            Encode32.t3Data = Defn.track[2].data;
            Encode32.t3BPC = Defn.track[2].bitsPerChar;
            Encode32.t3BPI = Defn.track[2].bitsPerInch;
            Encode32.t3Par = Defn.track[2].parity;
            Encode32.t3LRC = Defn.track[2].lrc;
        }
        return this.jsdk.ID_EncodeMagA(hSession, Encode32);
    }

    public byte ID_ReadMag(WinNT.HANDLE hSession, MagData data, byte encodingSpec) {
        MagAPI.SDKMagDataRead SDKData = new MagAPI.SDKMagDataRead();
        byte result = this.jsdk.ID_ReadMag(hSession, SDKData, encodingSpec);
        data.msg_len = SDKData.msg_len;
        data.tk1_pass = SDKData.tk1_pass != 0;
        data.tk2_pass = SDKData.tk2_pass != 0;
        data.tk3_pass = SDKData.tk3_pass != 0;
        data.tk1_len = SDKData.tk1_len;
        data.tk2_len = SDKData.tk1_len;
        data.tk3_len = SDKData.tk3_len;
        data.tk1 = new String(SDKData.track1);
        data.tk2 = new String(SDKData.track2);
        data.tk3 = new String(SDKData.track3);
        return result;
    }

    public byte ID_ReadMagTracks(WinNT.HANDLE hSession, MagData data, byte encodingSpec, byte trackMask) {
        MagAPI.SDKMagDataRead SDKData = new MagAPI.SDKMagDataRead();
        byte result = this.jsdk.ID_ReadMagTracks(hSession, SDKData, encodingSpec, trackMask);
        data.msg_len = SDKData.msg_len;
        data.tk1_pass = SDKData.tk1_pass != 0;
        data.tk2_pass = SDKData.tk2_pass != 0;
        data.tk3_pass = SDKData.tk3_pass != 0;
        data.tk1_len = SDKData.tk1_len;
        data.tk2_len = SDKData.tk1_len;
        data.tk3_len = SDKData.tk3_len;
        if ((trackMask & 1) != 0) {
            data.tk1 = new String(SDKData.track1);
        }
        if ((trackMask & 2) != 0) {
            data.tk2 = new String(SDKData.track2);
        }
        if ((trackMask & 4) != 0) {
            data.tk3 = new String(SDKData.track3);
        }
        return result;
    }

    public byte ID_ReadMag(WinNT.HANDLE hSession, MagData2 data, byte encodingSpec) {
        MagAPI.SDKMagData2Read SDKData = new MagAPI.SDKMagData2Read();
        byte result = this.jsdk.ID_ReadMag(hSession, SDKData, encodingSpec);
        data.track1 = new String(SDKData.track1);
        data.track2 = new String(SDKData.track2);
        data.track3 = new String(SDKData.track3);
        return result;
    }

    public byte ID_ReadMagTracks(WinNT.HANDLE hSession, MagData2 data, byte encodingSpec, byte trackMask) {
        MagAPI.SDKMagData2Read SDKData = new MagAPI.SDKMagData2Read();
        byte result = this.jsdk.ID_ReadMag(hSession, SDKData, encodingSpec);
        if ((trackMask & 1) != 0) {
            data.track1 = new String(SDKData.track1);
        }
        if ((trackMask & 2) != 0) {
            data.track2 = new String(SDKData.track2);
        }
        if ((trackMask & 4) != 0) {
            data.track3 = new String(SDKData.track3);
        }
        return result;
    }

    public byte ID_MagStart(WinNT.HANDLE hSession, byte action, IntByReference position) {
        return this.jsdk.ID_MagStart(hSession, action, position);
    }

    public byte ID_PrintSettings(WinNT.HANDLE hSession, byte action, PrintSettings settings) {
        return this.jsdk.ID_PrintSettings(hSession, action, settings);
    }

    public int ID_CardWidth(WinNT.HANDLE hSession) {
        return this.jsdk.ID_CardWidth(hSession);
    }

    public byte ID_CardSettings(WinNT.HANDLE hSession, byte action, byte side, CardSettings settings) {
        return this.jsdk.ID_CardSettings(hSession, action, side, settings);
    }

    public byte ID_AreaHole(WinNT.HANDLE hSession, byte action, byte side, byte type, byte areaNo, Area dimensions) {
        return this.jsdk.ID_AreaHole(hSession, action, side, type, areaNo, dimensions);
    }

    public byte ID_ResinArea(WinNT.HANDLE hSession, byte action, byte side, byte areaNo, Area dimensions) {
        return this.jsdk.ID_ResinArea(hSession, action, side, areaNo, dimensions);
    }

    public byte ID_ResinOptions(WinNT.HANDLE hSession, byte action, byte side, ResinOptions settings) {
        return this.jsdk.ID_ResinOptions(hSession, action, side, settings);
    }

    public byte ID_ColourCorrection(WinNT.HANDLE hSession, byte action, ByteByReference correction) {
        return this.jsdk.ID_ColourCorrection(hSession, action, correction);
    }

    public byte ID_ColourArea(WinNT.HANDLE hSession, byte action, byte side, byte areaNo, Area colourArea, ByteByReference correction) {
        return this.jsdk.ID_ColourArea(hSession, action, side, areaNo, colourArea, correction);
    }

    public byte ID_Sharpness(WinNT.HANDLE hSession, byte action, ByteByReference sharpness) {
        return this.jsdk.ID_Sharpness(hSession, action, sharpness);
    }

    public byte ID_PrintSpeed(WinNT.HANDLE hSession, byte action, ByteByReference speed) {
        return this.jsdk.ID_PrintSpeed(hSession, action, speed);
    }

    public byte ID_HandFeed(WinNT.HANDLE hSession, byte action, ByteByReference mode) {
        return this.jsdk.ID_HandFeed(hSession, action, mode);
    }

    public byte ID_SmartOffset(WinNT.HANDLE hSession, byte action, ByteByReference offset) {
        return this.jsdk.ID_SmartOffset(hSession, action, offset);
    }

    public byte ID_SmartMode(WinNT.HANDLE hSession, byte action, ByteByReference mode) {
        return this.jsdk.ID_SmartMode(hSession, action, mode);
    }

    public byte ID_EraseSpeed(WinNT.HANDLE hSession, byte action, ByteByReference speed) {
        return this.jsdk.ID_EraseSpeed(hSession, action, speed);
    }

    public byte ID_EjectMode(WinNT.HANDLE hSession, byte action, ByteByReference mode) {
        return this.jsdk.ID_EjectMode(hSession, action, mode);
    }

    public byte ID_HorzEject(WinNT.HANDLE hSession, byte action, ByteByReference mode) {
        return this.jsdk.ID_HorzEject(hSession, action, mode);
    }

    public byte ID_HoloKote(WinNT.HANDLE hSession, byte action, byte sideID, HoloKote holoKote) {
        return this.jsdk.ID_HoloKote(hSession, action, sideID, holoKote);
    }

    public byte ID_HoloPatch(WinNT.HANDLE hSession, byte action, HoloPatch holoPatch) {
        return this.jsdk.ID_HoloPatch(hSession, action, holoPatch);
    }

    public byte ID_HoloKoteIdentity(WinNT.HANDLE hSession, int slot, StringBuilder holokoteID) {
        MagAPI.StringByReference msg;
        IntByReference size = new IntByReference();
        byte SDKResult = this.jsdk.ID_HoloKoteIdentityA(hSession, (byte)slot, null, size);
        if (SDKResult == -13 && (SDKResult = this.jsdk.ID_HoloKoteIdentityA(hSession, (byte)slot, msg = new MagAPI.StringByReference(size.getValue()), size)) == 0) {
            holokoteID.setLength(0);
            holokoteID.append(msg.getValue());
        }
        return SDKResult;
    }

    public byte ID_PowerLevel(WinNT.HANDLE hSession, byte action, PowerLevel powerLevel) {
        return this.jsdk.ID_PowerLevel(hSession, action, powerLevel);
    }

    public byte ID_Rewritable(WinNT.HANDLE hSession, byte action, Rewritable rewritable) {
        return this.jsdk.ID_Rewritable(hSession, action, rewritable);
    }

    public byte ID_RewritableArea(WinNT.HANDLE hSession, byte action, byte sideID, byte areaID, Area rwArea) {
        return this.jsdk.ID_RewritableArea(hSession, action, sideID, areaID, rwArea);
    }

    public byte ID_GUIControl(WinNT.HANDLE hSession, byte action, GUIControl control) {
        return this.jsdk.ID_GUIControl(hSession, action, control);
    }

    public byte ID_Control(WinNT.HANDLE hSession, byte action, ByteByReference controlMask) {
        return this.jsdk.ID_Control(hSession, action, controlMask);
    }

    public byte ID_Resolution(WinNT.HANDLE hSession, byte action, ByteByReference ID_Resolution) {
        return this.jsdk.ID_Resolution(hSession, action, ID_Resolution);
    }

    public byte ID_IPSettings(WinNT.HANDLE hSession, byte READ, IPData iPData) {
        return this.jsdk.ID_IPSettings(hSession, READ, iPData);
    }

    public byte ID_Password(WinNT.HANDLE hSession, byte command, String password1, String password2) {
        return this.jsdk.ID_PasswordA(hSession, command, password1, password2);
    }

    public byte ID_ColourAdjust(WinNT.HANDLE hSession, byte READ, ColourAdj caData) {
        MagAPI.SDKColourAdj SDKcaData = new MagAPI.SDKColourAdj();
        SDKcaData.size = (short)SDKcaData.size();
        SDKcaData.flags = (short)caData.flags;
        SDKcaData.illuminant = (short)caData.illuminant;
        SDKcaData.red = (short)caData.red;
        SDKcaData.green = (short)caData.green;
        SDKcaData.blue = (short)caData.blue;
        SDKcaData.refBlack = (short)caData.refBlack;
        SDKcaData.refWhite = (short)caData.refWhite;
        SDKcaData.contrast = (short)caData.contrast;
        SDKcaData.brightness = (short)caData.brightness;
        SDKcaData.colour = (short)caData.colour;
        SDKcaData.tint = (short)caData.tint;
        byte result = this.jsdk.ID_ColourAdjust(hSession, READ, SDKcaData);
        if (result == 0) {
            caData.flags = SDKcaData.flags;
            caData.illuminant = SDKcaData.illuminant;
            caData.red = SDKcaData.red;
            caData.green = SDKcaData.green;
            caData.blue = SDKcaData.blue;
            caData.refBlack = SDKcaData.refBlack;
            caData.refWhite = SDKcaData.refWhite;
            caData.contrast = SDKcaData.contrast;
            caData.brightness = SDKcaData.brightness;
            caData.colour = SDKcaData.colour;
            caData.tint = SDKcaData.tint;
        }
        return result;
    }

    public byte ID_CardLocation(WinNT.HANDLE hSession, ByteByReference Location2) {
        return this.jsdk.ID_CardLocation(hSession, Location2);
    }

    public byte ID_AccessInt(WinNT.HANDLE hSession, byte action, byte ID, IntByReference Param) {
        return this.jsdk.ID_AccessInt(hSession, action, ID, Param);
    }

    public byte ID_AccessBool(WinNT.HANDLE hSession, byte action, byte ID, WinDef.BOOLByReference Param) {
        return this.jsdk.ID_AccessBool(hSession, action, ID, Param);
    }

    public byte ID_AccessString(WinNT.HANDLE hSession, byte ReadWrite, byte ID, StringBuilder Message) {
        MagAPI.StringByReference msg;
        IntByReference size = new IntByReference();
        byte SDKResult = this.jsdk.ID_AccessBuffer(hSession, ReadWrite, ID, null, size);
        if (SDKResult == -13 && (SDKResult = this.jsdk.ID_AccessBuffer(hSession, ReadWrite, ID, msg = new MagAPI.StringByReference(size.getValue()), size)) == 0) {
            Message.setLength(0);
            Message.append(msg.getValue());
        }
        return SDKResult;
    }

    public byte ID_PrintableArea(WinNT.HANDLE hSession, byte ReadWrite, Area dimensions) {
        return this.jsdk.ID_PrintableArea(hSession, ReadWrite, dimensions);
    }

    public int ID_HoloKoteCount(WinNT.HANDLE hSession) {
        return this.jsdk.ID_HoloKoteCount(hSession);
    }

    public byte ID_HoloKotePreview(WinNT.HANDLE hSession, HoloKotePreview[] previews) {
        byte[] buff;
        IntByReference size = new IntByReference();
        byte SDKResult = this.jsdk.ID_HoloKotePreview(hSession, null, size);
        int i = 0;
        while (i < previews.length) {
            previews[i] = new HoloKotePreview();
            ++i;
        }
        if (SDKResult == -13 && (SDKResult = this.jsdk.ID_HoloKotePreview(hSession, buff = new byte[size.getValue()], size)) == 0) {
            int i2 = 0;
            while (i2 < previews.length) {
                System.arraycopy(buff, i2 * 5632, previews[i2].key, 0, 256);
                System.arraycopy(buff, i2 * 5632 + 256, previews[i2].image, 0, 5376);
                ++i2;
            }
        }
        return SDKResult;
    }

    private BufferedImage PreviewToImage(HoloKotePreview HKP) {
        BufferedImage result = new BufferedImage(259, 166, 12);
        Color myWhite = new Color(255, 255, 255);
        int rgbWhite = myWhite.getRGB();
        Color myBlack = new Color(0, 0, 0);
        int rgbBlack = myBlack.getRGB();
        int y = 0;
        while (y < result.getHeight()) {
            int x = 0;
            while (x < result.getWidth()) {
                int bitIndex = x + y * result.getWidth();
                boolean set = (HKP.image[bitIndex / 8] & 128 >> (bitIndex & 7)) != 0;
                result.setRGB(x, y, set ? rgbWhite : rgbBlack);
                ++x;
            }
            ++y;
        }
        return result;
    }

    public byte ID_HoloKotePreview(WinNT.HANDLE hSession, BufferedImage[] previews) {
        HoloKotePreview[] buff = new HoloKotePreview[previews.length];
        int i = 0;
        while (i < previews.length) {
            buff[i] = new HoloKotePreview();
            ++i;
        }
        byte SDKResult = this.ID_HoloKotePreview(hSession, buff);
        if (SDKResult == 0) {
            int i2 = 0;
            while (i2 < previews.length) {
                previews[i2] = this.PreviewToImage(buff[i2]);
                ++i2;
            }
        }
        return SDKResult;
    }

    public byte ID_CanvasInit(WinNT.HANDLE hSession, IntByReference hdc, byte canvasID) {
        return this.jsdk.ID_CanvasInit(hSession, hdc, canvasID);
    }

    public byte ID_CanvasDelete(WinNT.HANDLE hSession, byte canvasID) {
        return this.jsdk.ID_CanvasDelete(hSession, canvasID);
    }

    public byte ID_DrawText(WinNT.HANDLE hSession, byte CanvasID, TextDef inDefn) {
        MagAPI.SDKTextDef sdkDefn = new MagAPI.SDKTextDef();
        sdkDefn.text = new WString(inDefn.text);
        sdkDefn.x = inDefn.x;
        sdkDefn.y = inDefn.y;
        sdkDefn.angle = inDefn.angle;
        sdkDefn.fontName = new WString(inDefn.fontName);
        sdkDefn.fontSize = inDefn.fontSize;
        sdkDefn.fontColour = new MagAPI.ColorRef(inDefn.fontColour);
        sdkDefn.fontStyle = inDefn.fontStyle;
        return this.jsdk.ID_DrawTextW(hSession, CanvasID, sdkDefn);
    }

    public byte ID_DrawMagText(WinNT.HANDLE hSession, byte canvasID, MagTextDef inDefn) {
        MagAPI.SDKMagTextDef sdkDefn = new MagAPI.SDKMagTextDef();
        sdkDefn.track = inDefn.track;
        sdkDefn.data = new WString(inDefn.data);
        return this.jsdk.ID_DrawMagTextW(hSession, canvasID, sdkDefn);
    }

    public byte ID_DrawShape(WinNT.HANDLE hSession, byte CanvasID, ShapeDef inDefn) {
        MagAPI.SDKShapeDef sdkDefn = new MagAPI.SDKShapeDef();
        sdkDefn.shape = inDefn.shape;
        sdkDefn.penColour = new MagAPI.ColorRef(inDefn.penColour);
        sdkDefn.penWidth = inDefn.penWidth;
        sdkDefn.area.left = inDefn.area.left;
        sdkDefn.area.top = inDefn.area.top;
        sdkDefn.area.right = inDefn.area.right;
        sdkDefn.area.bottom = inDefn.area.bottom;
        sdkDefn.p1 = inDefn.p1;
        sdkDefn.p2 = inDefn.p2;
        sdkDefn.p3 = inDefn.p3;
        sdkDefn.p4 = inDefn.p4;
        sdkDefn.fillColour = inDefn.fillColour.getAlpha() == 0 ? 5 : new MagAPI.ColorRef(inDefn.fillColour).intValue();
        return this.jsdk.ID_DrawShape(hSession, CanvasID, sdkDefn);
    }

    public byte ID_DrawLine(WinNT.HANDLE hSession, byte canvasID, LineDef inDefn) {
        MagAPI.SDKLineDef sdkDefn = new MagAPI.SDKLineDef();
        sdkDefn.colour = new MagAPI.ColorRef(inDefn.colour);
        sdkDefn.width = inDefn.width;
        sdkDefn.startX = inDefn.startX;
        sdkDefn.startY = inDefn.startY;
        sdkDefn.endX = inDefn.endX;
        sdkDefn.endY = inDefn.endY;
        return this.jsdk.ID_DrawLine(hSession, canvasID, sdkDefn);
    }

    public byte ID_DrawImage(WinNT.HANDLE hSession, byte canvasID, ImageDef inDefn) {
        MagAPI.SDKImageDef sdkDefn = new MagAPI.SDKImageDef();
        sdkDefn.filename = new WString(inDefn.filename);
        sdkDefn.x = inDefn.x;
        sdkDefn.y = inDefn.y;
        sdkDefn.p1 = inDefn.p1;
        sdkDefn.p2 = inDefn.p2;
        return this.jsdk.ID_DrawImageW(hSession, canvasID, sdkDefn);
    }

    public byte ID_PrintCard(WinNT.HANDLE hSession) {
        return this.jsdk.ID_PrintCard(hSession);
    }

    public byte ID_PrinterPrefs(WinNT.HANDLE hSession) {
        return this.jsdk.ID_PrinterPrefs(hSession, User32.INSTANCE.GetForegroundWindow());
    }

    public static interface Action {
        public static final byte READ = 0;
        public static final byte WRITE = 1;
    }

    public static class Area
    extends Structure {
        public int left;
        public int width;
        public int bottom;
        public int height;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("left", "width", "bottom", "height");
        }

        public class ByReference
        extends Area
        implements Structure.ByReference {
        }

        public class ByValue
        extends Area
        implements Structure.ByValue {
        }
    }

    public static interface AreaHole {
        public static final byte AREA = 0;
        public static final byte HOLE = 1;
    }

    public static interface BitsPerChar {
        public static final byte DEFAULT = 0;
        public static final byte BPC1 = 1;
        public static final byte BPC4 = 2;
        public static final byte BPC5 = 3;
        public static final byte BPC7 = 4;
    }

    public static interface BitsPerInch {
        public static final byte DEFAULT = 0;
        public static final byte BPI75 = 1;
        public static final byte BPI210 = 2;
    }

    public static interface Canvas {
        public static final byte FRONT = 0;
        public static final byte BACK = 1;
        public static final byte FRONT_RESIN = 2;
        public static final byte BACK_RESIN = 3;
    }

    public static interface CardLocation {
        public static final byte UNKNOWN = 0;
        public static final byte NO_CARD = 1;
        public static final byte PRINT_READY = 2;
        public static final byte ENCODER = 3;
    }

    public static interface CardPosition {
        public static final byte STANDBY = 0;
        public static final byte TRANSFER_STANDBY = 0;
        public static final byte HEATED_ROLLER = 1;
        public static final byte FLIP_STANDBY = 2;
        public static final byte ROTATE = 3;
        public static final byte MAG_ENCODER = 4;
        public static final byte CONTACT_ENCODER = 5;
        public static final byte EJECT = 6;
        public static final byte REJECT = 7;
        public static final byte LAMINATOR = 8;
        public static final byte CONTACTLESS_ENCODER = 9;
        public static final byte INITIALISE = 10;
    }

    public static class CardSettings
    extends Structure
    implements Structure.ByReference {
        public byte colourFormat;
        public boolean overcoat;
        public byte orientation;
        public boolean rotation;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("colourFormat", "overcoat", "orientation", "rotation");
        }
    }

    public static interface Coercivity {
        public static final byte DEFAULT = 0;
        public static final byte HI_CO = 1;
        public static final byte LO_CO = 2;
        public static final byte MID_CO = 3;
    }

    public static class ColourAdj
    extends Structure
    implements Structure.ByReference {
        public int flags;
        public int illuminant;
        public int red;
        public int green;
        public int blue;
        public int refBlack;
        public int refWhite;
        public int contrast;
        public int brightness;
        public int colour;
        public int tint;
        public static final int RGB_GAMMA_MIN = 2500;
        public static final int RGB_GAMMA_MAX = 65000;
        public static final int REF_WHITE_MIN = 6000;
        public static final int REF_WHITE_MAX = 10000;
        public static final int REF_BLACK_MIN = 0;
        public static final int REF_BLACK_MAX = 4000;
        public static final int ADJUST_MIN = -100;
        public static final int ADJUST_MAX = 100;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("flags", "illuminant", "red", "green", "blue", "refBlack", "refWhite", "contrast", "brightness", "colour", "tint");
        }

        public static interface Flags {
            public static final byte NEGATIVE = 1;
            public static final byte LOG_FILTER = 2;
        }

        public static interface Illuminant {
            public static final byte DEFAULT = 0;
            public static final byte A = 1;
            public static final byte B = 2;
            public static final byte C = 3;
            public static final byte D50 = 4;
            public static final byte D55 = 5;
            public static final byte D65 = 6;
            public static final byte D75 = 7;
            public static final byte F2 = 8;
            public static final byte MAX_ILLUMINANT = 8;
            public static final byte TUNGSTEN = 1;
            public static final byte DAYLIGHT = 3;
            public static final byte FLUORESCENT = 8;
            public static final byte NTSC = 3;
        }
    }

    public static interface ColourFormat {
        public static final byte YMC = 0;
        public static final byte YMCK = 1;
        public static final byte K = 2;
    }

    public static interface Config {
        public static final byte NORMAL = 0;
        public static final byte QUIET = 1;
    }

    public static interface ConnectionType {
        public static final byte USB = 1;
        public static final byte ETHERNET = 3;
        public static final byte FILE = 4;
    }

    public static interface Control {
        public static final int ENCODE_ONLY = 1;
        public static final int ISO7810 = 2;
    }

    public static interface Correction {
        public static final byte NONE = 0;
        public static final byte GAMMA1 = 1;
        public static final byte GAMMA2 = 2;
        public static final byte ICC_INTERNAL = 3;
        public static final byte ICC_EXTERNAL = 4;
        public static final byte PERCEPTUAL = 5;
        public static final byte SATURATION = 6;
        public static final byte REL_COLORIMETRIC = 7;
        public static final byte ABS_COLORIMETRIC = 8;
    }

    public static interface Duplex {
        public static final byte FRONT_ONLY = 0;
        public static final byte BOTH_SIDES = 1;
        public static final byte BACK_ONLY = 2;
    }

    public static interface DyePanel {
        public static final byte INITIALISE = 0;
        public static final byte NEXT = 1;
        public static final byte YELLOW = 2;
        public static final byte MAGENTA = 3;
        public static final byte CYAN = 4;
        public static final byte KRESIN = 5;
        public static final byte OVERCOAT = 6;
    }

    public static interface EjectMode {
        public static final byte OFF = 0;
        public static final byte ON = 1;
    }

    public static interface EncodingType {
        public static final byte ISO = 0;
        public static final byte JIS2 = 1;
        public static final byte RAW = 2;
    }

    public static interface EraseSpeed {
        public static final byte THOROUGH = 0;
        public static final byte QUICK = 1;
    }

    public static interface FeedMode {
        public static final byte CHIPCARD = 0;
        public static final byte CONTACTLESS = 1;
    }

    public static interface FontStyle {
        public static final byte BOLD = 1;
        public static final byte ITALIC = 2;
        public static final byte UNDERLINE = 4;
        public static final byte STRIKEOUT = 8;
    }

    static interface GDI32
    extends StdCallLibrary {
        public WinDef.HDC CreateDCA(String var1, String var2, Structure.ByReference var3, Structure.ByReference var4);
    }

    public static class GUIControl
    extends Structure
    implements Structure.ByReference {
        public boolean user;
        public boolean printer;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("user", "printer");
        }
    }

    public static interface HandFeed {
        public static final byte OFF = 0;
        public static final byte ON = 1;
    }

    public static class HoloKote
    extends Structure
    implements Structure.ByReference {
        public byte imageID;
        public int map;
        public byte rotation;
        public boolean disableCustomKey;
        public boolean useLaminate;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("imageID", "map", "rotation", "disableCustomKey", "useLaminate");
        }
    }

    public static class HoloKotePreview
    extends Structure
    implements Structure.ByReference {
        public byte[] key = new byte[256];
        public byte[] image = new byte[5376];

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("key", "image");
        }
    }

    public static class HoloPatch
    extends Structure
    implements Structure.ByReference {
        public byte position;
        public boolean colourHole;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("position", "colourHole");
        }
    }

    public static interface HorzEject {
        public static final byte OFF = 0;
        public static final byte ON = 1;
    }

    public static class IPData
    extends Structure
    implements Structure.ByReference {
        public byte mode;
        public int address;
        public int subnet;
        public int gateway;
        public int macAddrHi;
        public int macAddrLo;

        public String getString(int ip) {
            return String.format("%d.%d.%d.%d", ip >> 24 & 0xFF, ip >> 16 & 0xFF, ip >> 8 & 0xFF, ip & 0xFF);
        }

        public int getInt(String addr) {
            String[] octets = addr.split(Pattern.quote("."));
            int ip = 0;
            int i = 3;
            while (i >= 0) {
                ip |= Integer.parseInt(octets[3 - i]) << i * 8;
                --i;
            }
            return ip;
        }

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("mode", "address", "subnet", "gateway", "macAddrHi", "macAddrLo");
        }
    }

    public static interface IPMode {
        public static final byte STATIC = 0;
        public static final byte DYNAMIC = 1;
    }

    public static class ImageDef
    extends Structure
    implements Structure.ByReference {
        public String filename;
        public int x;
        public int y;
        public int p1;
        public int p2;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("filename", "x", "y", "p1", "p2");
        }
    }

    public static interface InfoMask {
        public static final int NONE = 0;
        public static final int ENCODE_DEFAULT = 1;
        public static final int ENCODE_PLATEN = 2;
        public static final int ERASE_SPEED = 4;
        public static final int EJECT_MODE = 8;
        public static final int HORZ_EJECT = 16;
        public static final int ENCODE_XLI = 32;
        public static final int ENCODE_MODE = 35;
    }

    public static interface LRC {
        public static final byte DEFAULT = 0;
        public static final byte OFF = 1;
        public static final byte ODD = 2;
        public static final byte EVEN = 3;
    }

    public class LineDef {
        public Color colour;
        public int width;
        public int startX;
        public int startY;
        public int endX;
        public int endY;
    }

    public static class MagData
    extends Structure
    implements Structure.ByReference {
        public int notUsed;
        public int msg_len;
        public boolean tk1_pass;
        public boolean tk2_pass;
        public boolean tk3_pass;
        public int tk1_len;
        public int tk2_len;
        public int tk3_len;
        public String tk1;
        public String tk2;
        public String tk3;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("notUsed", "msg_len", "tk1_pass", "tk2_pass", "tk3_pass", "tk1_len", "tk2_len", "tk3_len", "tk1", "tk2", "tk3");
        }
    }

    public static class MagData2
    extends Structure
    implements Structure.ByReference {
        public String track1;
        public String track2;
        public String track3;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("track1", "track2", "track3");
        }
    }

    public static class MagDef {
        public byte encoding;
        public byte coercivity;
        public byte verify;
        public MagTrack[] track = new MagTrack[3];

        public MagDef() {
            this.track[0] = new MagTrack();
            this.track[1] = new MagTrack();
            this.track[2] = new MagTrack();
        }
    }

    public class MagTextDef {
        public int track;
        public String data;
    }

    public static class MagTrack {
        public String data;
        public byte bitsPerChar;
        public byte bitsPerInch;
        public byte parity;
        public byte lrc;
    }

    public static interface Model {
        public static final int MAGNETIC = 1;
        public static final int DUPLEX = 2;
        public static final int REWRITE = 4;
        public static final int CONTACTLESS = 8;
        public static final int CHIP = 16;
        public static final int PRONTO = 32;
        public static final int EXTENDED = 256;
        public static final int ENDURO = 512;
        public static final int PRONTO100 = 1024;
        public static final int ETHERNET = 2048;
        public static final int ULTIMA = 4096;
        public static final int LAMINATE = 8192;
        public static final int DPI600 = 16384;
        public static final int RIO_PRO = 32768;
        public static final int RIO_PRO360 = 65536;
        public static final int MODEL600 = 131072;
        public static final int MODEL300 = 262144;
        public static final int GENERATION2 = 524288;
    }

    public static interface Orientation {
        public static final byte PORTRAIT = 0;
        public static final byte LANDSCAPE = 1;
    }

    public static interface Parity {
        public static final byte DEFAULT = 0;
        public static final byte OFF = 1;
        public static final byte ODD = 2;
        public static final byte EVEN = 3;
    }

    public static interface Password {
        public static final byte SET = 0;
        public static final byte USE = 1;
    }

    public static class PowerLevel
    extends Structure
    implements Structure.ByReference {
        public byte ymc;
        public byte resin;
        public byte overcoat;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("ymc", "resin", "overcoat");
        }
    }

    public static class PrintSettings
    extends Structure
    implements Structure.ByReference {
        public byte duplex;
        public byte copyCount;
        public int cardSize;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("duplex", "copyCount", "cardSize");
        }
    }

    public static interface PrintSpeed {
        public static final byte HIGH = 0;
        public static final byte NORMAL = 1;
    }

    public static class PrinterInfo
    extends Structure
    implements Structure.ByReference {
        public boolean printerConnected;
        public int modelCode;
        public byte[] model = new byte[30];
        public int printheadType;
        public byte[] printerSerial = new byte[20];
        public byte[] printheadSerial = new byte[20];
        public byte[] pcbSerial = new byte[20];
        public char[] firmware = new char[20];
        public int dummy1;
        public int dummy2;
        public int smartOffset;
        public int bitFields;
        public int density;
        public int handFeed;
        public int cardsPrinted;
        public int cardsOnPrinthead;
        public int dyePanelsPrinted;
        public int cleansSinceShipped;
        public int dyePanelsSinceClean;
        public int cardsSinceClean;
        public int cardsBetweenCleans;
        public int printHeadPosn;
        public int imageStartPosn;
        public int imageEndPosn;
        public int majorError;
        public int minorError;
        public byte[] tagUID = new byte[20];
        public int shotsOnFilm;
        public int shotsUsed;
        public byte[] dyeFilmType = new byte[20];
        public int colourLength;
        public int resinLength;
        public int overcoatLength;
        public int dyeFlags;
        public int commandCode;
        public int dob;
        public int dyeFilmManuf;
        public int dyeFilmProg;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("printerConnected", "modelCode", "model", "printheadType", "printerSerial", "printheadSerial", "pcbSerial", "firmware", "dummy1", "dummy2", "smartOffset", "bitFields", "density", "handFeed", "cardsPrinted", "cardsOnPrinthead", "dyePanelsPrinted", "cleansSinceShipped", "dyePanelsSinceClean", "cardsSinceClean", "cardsBetweenCleans", "printHeadPosn", "imageStartPosn", "imageEndPosn", "majorError", "minorError", "tagUID", "shotsOnFilm", "shotsUsed", "dyeFilmType", "colourLength", "resinLength", "overcoatLength", "dyeFlags", "commandCode", "dob", "dyeFilmManuf", "dyeFilmProg");
        }
    }

    public static interface PrinterType {
        public static final byte RIO = 0;
        public static final byte AOTA = 1;
        public static final byte ENDURO = 2;
        public static final byte ULTIMA = 3;
        public static final byte RIOPRO360 = 4;
        public static final byte GENERATION2 = 4;
        public static final byte NONE = -1;
    }

    public static interface Pro360Param {
        public static final byte CapabilityDuplex = 0;
        public static final byte CapabilityMag = 1;
        public static final byte CapabilitySmart = 2;
        public static final byte SystemVersion = 3;
        public static final byte PrinterAppVersion = 4;
        public static final byte FirmwareVersion = 5;
        public static final byte MagFirmwareVersion = 6;
        public static final byte PrinterSerial = 7;
        public static final byte PrintheadSerial = 8;
        public static final byte BoardSerial = 9;
        public static final byte ModelName = 10;
        public static final byte DealerCode = 11;
        public static final byte ProjectCode = 12;
        public static final byte TotalCards = 13;
        public static final byte TotalPanels = 14;
        public static final byte CardsOnPrinthead = 15;
        public static final byte PanelsOnPrinthead = 16;
        public static final byte CardsSinceClean = 17;
        public static final byte PanelsSinceClean = 18;
        public static final byte Cleans = 19;
        public static final byte DyeFilmName = 20;
        public static final byte DyeFilmSerial = 21;
        public static final byte DyeFilmTotalPrints = 22;
        public static final byte DyeFilmPrintsRemaining = 23;
        public static final byte DyeFilmManufacturer = 24;
        public static final byte CleansInterval = 25;
        public static final byte CleanOverdue = 26;
        public static final byte MACAddress = 27;
        public static final byte UseDHCP = 28;
        public static final byte DynamicIPAddress = 29;
        public static final byte DynamicGateway = 30;
        public static final byte DynamicSubnet = 31;
        public static final byte StaticIPAddress = 32;
        public static final byte StaticGateway = 33;
        public static final byte StaticSubnet = 34;
        public static final byte ErrorCode = 35;
        public static final byte HandFeed = 36;
        public static final byte CardLocation = 37;
        public static final byte MagStart = 38;
        public static final byte ColourLength = 39;
        public static final byte BlackLength = 40;
        public static final byte OverlayLength = 41;
        public static final byte SmartOffset = 42;
        public static final byte HoloKoteCount = 43;
        public static final byte Capability600dpi = 44;
        public static final byte HopperSensor = 45;
        public static final byte ExitSensor = 46;
        public static final byte LidSensor = 47;
        public static final byte Manufacturer = 48;
        public static final byte HopperSensorFitted = 49;
        public static final byte ExitSensorFitted = 50;
        public static final byte Region = 51;
    }

    public class Rect {
        public int left;
        public int top;
        public int right;
        public int bottom;
    }

    public static class ResinOptions
    extends Structure
    implements Structure.ByReference {
        public boolean picturesUseYMC;
        public boolean blackText;
        public boolean monoBitmaps;
        public boolean blackPolygons;
        public boolean allBlack;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("picturesUseYMC", "blackText", "monoBitmaps", "blackPolygons", "allBlack");
        }
    }

    public static interface Response {
        public static final byte OK = 0;
        public static final byte CANCEL = 1;
    }

    public static interface Return {
        public static final byte SUCCESS = 0;
        public static final byte TIMEOUT = -1;
        public static final byte ERROR = -2;
        public static final byte PRINTER_ERROR = -3;
        public static final byte DRIVER_NOT_COMPLIANT = -4;
        public static final byte OPEN_PRINTER_ERROR = -5;
        public static final byte REMOTE_COMM_ERROR = -6;
        public static final byte LOCAL_COMM_ERROR = -7;
        public static final byte SPOOLER_NOT_EMPTY = -8;
        public static final byte SESSION_ACTIVE = -9;
        public static final byte LOCAL_COMM_IN_USE = -10;
        public static final byte PARAM_ERROR = -11;
        public static final byte INVALID_SESSION = -12;
        public static final byte MORE_DATA = -13;
        public static final byte INVALID_PRINTER = -14;
        public static final byte INVALID_ACTION = -15;
        public static final byte READ_ERROR = -16;
        public static final byte WRITE_ERROR = -17;
        public static final byte NO_MAG_DATA = -18;
    }

    public static class Rewritable
    extends Structure
    implements Structure.ByReference {
        public boolean eraseBeforePrint;
        public Area eraseArea;
        public byte erasePowerStart;
        public byte erasePowerEnd;
        public byte writePower;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("eraseBeforePrint", "eraseArea", "erasePowerStart", "erasePowerEnd", "writePower");
        }
    }

    public static interface Rotation {
        public static final byte NONE = 0;
        public static final byte DEGREES_90 = 1;
        public static final byte DEGREES_180 = 2;
        public static final byte DEGREES_270 = 3;
    }

    public static class SDKVersion
    extends Structure
    implements Structure.ByReference {
        public int major;
        public int minor;
        public int build;
        public int beta;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("major", "minor", "build", "beta");
        }
    }

    public static interface Sensors {
        public static final byte LID_SENSOR = 1;
        public static final byte HOPPER_SENSOR = 2;
        public static final byte HOPPER_VALID = 2;
        public static final byte EXIT_SENSOR = 4;
        public static final byte EXIT_VALID = 4;
    }

    public class ShapeDef {
        public byte shape;
        public Color penColour;
        public int penWidth;
        public Color fillColour;
        public Rect area;
        public int p1;
        public int p2;
        public int p3;
        public int p4;

        public ShapeDef() {
            this.area = new Rect();
        }
    }

    public static interface ShapeType {
        public static final byte RECTANGLE = 0;
        public static final byte ELLIPSE = 1;
        public static final byte ROUND_RECT = 2;
        public static final byte PIE = 3;
        public static final byte CHORD = 4;
    }

    public static interface Side {
        public static final byte FRONT = 0;
        public static final byte BACK = 1;
    }

    public static interface SmartMode {
        public static final byte DEFAULT = 0;
        public static final byte PLATEN = 1;
        public static final byte XLI = 2;
    }

    public static interface Status {
        public static final byte READY = 0;
        public static final byte BUSY = 1;
        public static final byte ERROR = 2;
        public static final byte OFFLINE = 3;
    }

    public static interface Temperature {
        public static final byte TRANSFER = 0;
        public static final byte LAMINATE = 1;
    }

    public class TextDef {
        public String text;
        public int x;
        public int y;
        public int angle;
        public String fontName;
        public int fontSize;
        public Color fontColour;
        public byte fontStyle;
    }

    public static class UltimaInfo
    extends Structure
    implements Structure.ByReference {
        public byte[] firmwareVersion = new byte[32];
        public byte[] printerSerial = new byte[32];
        public byte[] modelName = new byte[32];
        public int printerPartnerCode;
        public int capabilityFlags;
        public byte[] manufacturer = new byte[32];
        public int transferTargetTemperature;
        public int transferActualTemperature;
        public int totalCards;
        public int totalPanels;
        public int cardsOnPrinthead;
        public int panelsOnPrinthead;
        public int cardsLow;
        public byte[] colourName = new byte[32];
        public int colourTotalPrints;
        public int colourPrintsRemaining;
        public int colourPartnerCode;
        public byte[] transferName = new byte[32];
        public int transferTotalPrints;
        public int transferPrintsRemaining;
        public int transferPartnerCode;
        public int errorCode;
        public int errorContext;
        public int cardsBetweenPrompts;
        public int cleaningOverdue;
        public int cardsSinceClean;
        public int panelsSinceClean;
        public int cleaningCycles;
        public int laminateActualTemperature;
        public int laminateTargetTemperature;
        public int laminateType;
        public int cardSpeed;
        public byte[] reserved = new byte[32];

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("firmwareVersion", "printerSerial", "modelName", "printerPartnerCode", "capabilityFlags", "manufacturer", "transferTargetTemperature", "transferActualTemperature", "totalCards", "totalPanels", "cardsOnPrinthead", "panelsOnPrinthead", "cardsLow", "colourName", "colourTotalPrints", "colourPrintsRemaining", "colourPartnerCode", "transferName", "transferTotalPrints", "transferPrintsRemaining", "transferPartnerCode", "errorCode", "errorContext", "cardsBetweenPrompts", "cleaningOverdue", "cardsSinceClean", "panelsSinceClean", "cleaningCycles", "laminateActualTemperature", "laminateTargetTemperature", "laminateType", "cardSpeed", "reserved");
        }
    }

    public static interface Verify {
        public static final byte OFF = 0;
        public static final byte ON = 1;
    }
}

