/*
 * Decompiled with CFR 0.152.
 */
package SDK;

import SDK.SDKlib;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;

public interface MagAPI
extends Library {
    public static final MagAPI INSTANCE = (MagAPI)Native.loadLibrary("MagAPI.dll", MagAPI.class);
    public static final int MAGDATA_BUFSIZE = 172;
    public static final int MAGDATA2_BUFSIZE = 112;

    public byte ID_OpenSession(WinDef.HDC var1, WinNT.HANDLEByReference var2, byte var3);

    public byte ID_CloseSession(WinNT.HANDLE var1);

    public byte ID_FeedCard(WinNT.HANDLE var1, byte var2, int var3);

    public byte ID_EjectCard(WinNT.HANDLE var1);

    public byte ID_GeneralCommandA(WinNT.HANDLE var1, String var2);

    public byte ID_WaitForPrinter(WinNT.HANDLE var1);

    public byte ID_PrepareForPrint(WinNT.HANDLE var1);

    public byte ID_WaitPrintComplete(WinNT.HANDLE var1);

    public byte ID_FlipCard(WinNT.HANDLE var1);

    public byte ID_CleanPrinter(WinNT.HANDLE var1);

    public byte ID_RestartPrinter(WinNT.HANDLE var1);

    public byte ID_PrintTestCard(WinNT.HANDLE var1);

    public byte ID_ErrorResponse(WinNT.HANDLE var1, byte var2);

    public byte ID_PrinterType(WinNT.HANDLE var1);

    public byte ID_EraseCard(WinNT.HANDLE var1, int var2, int var3, int var4, int var5, int var6);

    public int ID_PrinterModel(WinNT.HANDLE var1);

    public byte ID_PrinterStatus(WinNT.HANDLE var1);

    public byte ID_ConnectionType(WinNT.HANDLE var1);

    public byte ID_SDKVersion(WinNT.HANDLE var1, SDKlib.SDKVersion var2);

    public byte ID_PrinterInfo(WinNT.HANDLE var1, SDKlib.PrinterInfo var2);

    public byte ID_PrinterInfo(WinNT.HANDLE var1, SDKlib.UltimaInfo var2);

    public byte ID_LastMessageA(WinNT.HANDLE var1, StringByReference var2, IntByReference var3);

    public byte ID_Sensors(WinNT.HANDLE var1, IntByReference var2);

    public byte ID_SDKBits();

    public byte ID_EncodeMagA(WinNT.HANDLE var1, SDKMagEnc32 var2);

    public byte ID_EncodeMagA(WinNT.HANDLE var1, SDKMagEnc64 var2);

    public byte ID_ReadMag(WinNT.HANDLE var1, SDKMagDataRead var2, byte var3);

    public byte ID_ReadMag(WinNT.HANDLE var1, SDKMagData2Read var2, byte var3);

    public byte ID_ReadMagTracks(WinNT.HANDLE var1, SDKMagDataRead var2, byte var3, byte var4);

    public byte ID_ReadMagTracks(WinNT.HANDLE var1, SDKMagData2Read var2, byte var3, byte var4);

    public byte ID_MagStart(WinNT.HANDLE var1, byte var2, IntByReference var3);

    public byte ID_PrintSettings(WinNT.HANDLE var1, byte var2, SDKlib.PrintSettings var3);

    public int ID_CardWidth(WinNT.HANDLE var1);

    public byte ID_CardSettings(WinNT.HANDLE var1, byte var2, byte var3, SDKlib.CardSettings var4);

    public byte ID_AreaHole(WinNT.HANDLE var1, byte var2, byte var3, byte var4, byte var5, SDKlib.Area var6);

    public byte ID_ResinOptions(WinNT.HANDLE var1, byte var2, byte var3, SDKlib.ResinOptions var4);

    public byte ID_ResinArea(WinNT.HANDLE var1, byte var2, byte var3, byte var4, SDKlib.Area var5);

    public byte ID_ColourCorrection(WinNT.HANDLE var1, byte var2, ByteByReference var3);

    public byte ID_ColourArea(WinNT.HANDLE var1, byte var2, byte var3, byte var4, SDKlib.Area var5, ByteByReference var6);

    public byte ID_Sharpness(WinNT.HANDLE var1, byte var2, ByteByReference var3);

    public byte ID_PrintSpeed(WinNT.HANDLE var1, byte var2, ByteByReference var3);

    public byte ID_HandFeed(WinNT.HANDLE var1, byte var2, ByteByReference var3);

    public byte ID_SmartOffset(WinNT.HANDLE var1, byte var2, ByteByReference var3);

    public byte ID_SmartMode(WinNT.HANDLE var1, byte var2, ByteByReference var3);

    public byte ID_EraseSpeed(WinNT.HANDLE var1, byte var2, ByteByReference var3);

    public byte ID_EjectMode(WinNT.HANDLE var1, byte var2, ByteByReference var3);

    public byte ID_HorzEject(WinNT.HANDLE var1, byte var2, ByteByReference var3);

    public byte ID_HoloKote(WinNT.HANDLE var1, byte var2, byte var3, SDKlib.HoloKote var4);

    public byte ID_HoloPatch(WinNT.HANDLE var1, byte var2, SDKlib.HoloPatch var3);

    public byte ID_PowerLevel(WinNT.HANDLE var1, byte var2, SDKlib.PowerLevel var3);

    public byte ID_Rewritable(WinNT.HANDLE var1, byte var2, SDKlib.Rewritable var3);

    public byte ID_RewritableArea(WinNT.HANDLE var1, byte var2, byte var3, byte var4, SDKlib.Area var5);

    public byte ID_GUIControl(WinNT.HANDLE var1, byte var2, SDKlib.GUIControl var3);

    public byte ID_Control(WinNT.HANDLE var1, byte var2, ByteByReference var3);

    public byte ID_Resolution(WinNT.HANDLE var1, byte var2, ByteByReference var3);

    public byte ID_IPSettings(WinNT.HANDLE var1, byte var2, SDKlib.IPData var3);

    public byte ID_PasswordA(WinNT.HANDLE var1, byte var2, String var3, String var4);

    public byte ID_ColourAdjust(WinNT.HANDLE var1, byte var2, SDKColourAdj var3);

    public byte ID_MoveCard(WinNT.HANDLE var1, byte var2);

    public byte ID_HoloKoteIdentityA(WinNT.HANDLE var1, byte var2, StringByReference var3, IntByReference var4);

    public byte ID_Temperature(WinNT.HANDLE var1, byte var2, ByteByReference var3);

    public byte ID_MoveFilm(WinNT.HANDLE var1, byte var2);

    public byte ID_HoloKotePreview(WinNT.HANDLE var1, byte[] var2, IntByReference var3);

    public int ID_HoloKoteCount(WinNT.HANDLE var1);

    public byte ID_CardLocation(WinNT.HANDLE var1, ByteByReference var2);

    public byte ID_AccessInt(WinNT.HANDLE var1, byte var2, byte var3, IntByReference var4);

    public byte ID_AccessBool(WinNT.HANDLE var1, byte var2, byte var3, WinDef.BOOLByReference var4);

    public byte ID_AccessBuffer(WinNT.HANDLE var1, byte var2, byte var3, StringByReference var4, IntByReference var5);

    public byte ID_PrintableArea(WinNT.HANDLE var1, byte var2, SDKlib.Area var3);

    public byte ID_SendAPDU(WinNT.HANDLE var1, StringByReference var2, StringByReference var3, IntByReference var4);

    public byte ID_CanvasInit(WinNT.HANDLE var1, IntByReference var2, byte var3);

    public byte ID_CanvasDelete(WinNT.HANDLE var1, byte var2);

    public byte ID_DrawTextW(WinNT.HANDLE var1, byte var2, SDKTextDef var3);

    public byte ID_DrawText600W(WinNT.HANDLE var1, byte var2, SDKTextDef var3);

    public byte ID_DrawMagTextW(WinNT.HANDLE var1, byte var2, SDKMagTextDef var3);

    public byte ID_DrawShape(WinNT.HANDLE var1, byte var2, SDKShapeDef var3);

    public byte ID_DrawShape600(WinNT.HANDLE var1, byte var2, SDKShapeDef var3);

    public byte ID_DrawLine(WinNT.HANDLE var1, byte var2, SDKLineDef var3);

    public byte ID_DrawLine600(WinNT.HANDLE var1, byte var2, SDKLineDef var3);

    public byte ID_DrawImageW(WinNT.HANDLE var1, byte var2, SDKImageDef var3);

    public byte ID_DrawImage600W(WinNT.HANDLE var1, byte var2, SDKImageDef var3);

    public byte ID_PrintCard(WinNT.HANDLE var1);

    public byte ID_PrinterPrefs(WinNT.HANDLE var1, WinNT.HANDLE var2);

    public static class ColorRef
    extends WinDef.UINT {
        static final int CLR_INVALID = -1;

        public ColorRef() {
        }

        public ColorRef(long value) {
            super(value);
        }

        public ColorRef(Color color) {
            this.setColor(color);
        }

        public void setColor(Color color) {
            int rgb = color.getRGB();
            this.setValue(ColorRef.toBGR(rgb));
        }

        public Color toColor() {
            return ColorRef.fromNativeColor(this.intValue());
        }

        public static int toBGR(int rgb) {
            int r = (rgb & 0xFF0000) >> 16;
            int g = rgb & 0xFF00;
            int b = rgb & 0xFF;
            int result = r | g | b << 16;
            return result;
        }

        public static int toRGB(int bgr) {
            int b = (bgr & 0xFF0000) >> 16;
            int g = bgr & 0xFF00;
            int r = bgr & 0xFF;
            int result = b | g | r << 16;
            return result;
        }

        public static int toNativeColor(Color color) {
            return ColorRef.toBGR(color.getRGB());
        }

        public static Color fromNativeColor(int color) {
            return new Color(ColorRef.toRGB(color));
        }

        public boolean isInvalid() {
            long value = this.intValue();
            return value == -1L;
        }
    }

    public static class SDKColourAdj
    extends Structure
    implements Structure.ByReference {
        public short size;
        public short flags;
        public short illuminant;
        public short red;
        public short green;
        public short blue;
        public short refBlack;
        public short refWhite;
        public short contrast;
        public short brightness;
        public short colour;
        public short tint;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("size", "flags", "illuminant", "red", "green", "blue", "refBlack", "refWhite", "contrast", "brightness", "colour", "tint");
        }
    }

    public static class SDKImageDef
    extends Structure
    implements Structure.ByReference {
        public WString filename;
        public int x;
        public int y;
        public int p1;
        public int p2;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("filename", "x", "y", "p1", "p2");
        }
    }

    public static class SDKLineDef
    extends Structure
    implements Structure.ByReference {
        public ColorRef colour;
        public int width;
        public int startX;
        public int startY;
        public int endX;
        public int endY;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("colour", "width", "startX", "startY", "endX", "endY");
        }
    }

    public static class SDKMagData2Read
    extends Structure
    implements Structure.ByReference {
        public byte[] track1 = new byte[112];
        public byte[] track2 = new byte[112];
        public byte[] track3 = new byte[112];

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("track1", "track2", "track3");
        }
    }

    public static class SDKMagDataRead
    extends Structure
    implements Structure.ByReference {
        public int notUsed;
        public int msg_len;
        public int tk1_pass;
        public int tk2_pass;
        public int tk3_pass;
        public int tk1_len;
        public int tk2_len;
        public int tk3_len;
        public byte[] track1 = new byte[172];
        public byte[] track2 = new byte[172];
        public byte[] track3 = new byte[172];

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("notUsed", "msg_len", "tk1_pass", "tk2_pass", "tk3_pass", "tk1_len", "tk2_len", "tk3_len", "track1", "track2", "track3");
        }
    }

    public static class SDKMagEnc32
    extends Structure
    implements Structure.ByReference {
        public byte encoding;
        public byte coercivity;
        public byte verify;
        public int t1Count = 0;
        public String t1Data;
        public byte t1BPC = (byte)17;
        public byte t1BPI = (byte)18;
        public byte t1Par = (byte)19;
        public byte t1LRC = (byte)20;
        public int t2Count = 0;
        public String t2Data;
        public byte t2BPC = (byte)33;
        public byte t2BPI = (byte)34;
        public byte t2Par = (byte)35;
        public byte t2LRC = (byte)36;
        public int t3Count = 0;
        public String t3Data;
        public byte t3BPC = (byte)49;
        public byte t3BPI = (byte)50;
        public byte t3Par = (byte)51;
        public byte t3LRC = (byte)52;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("encoding", "coercivity", "verify", "t1Count", "t1Data", "t1BPC", "t1BPI", "t1Par", "t1LRC", "t2Count", "t2Data", "t2BPC", "t2BPI", "t2Par", "t2LRC", "t3Count", "t3Data", "t3BPC", "t3BPI", "t3Par", "t3LRC");
        }
    }

    public static class SDKMagEnc64
    extends Structure
    implements Structure.ByReference {
        public byte encoding;
        public byte coercivity;
        public byte verify;
        public byte packing1 = (byte)85;
        public int packing2 = -1;
        public int t1Count = 0;
        public int t1packing1 = -1;
        public String t1Data;
        public byte t1BPC = (byte)17;
        public byte t1BPI = (byte)18;
        public byte t1Par = (byte)19;
        public byte t1LRC = (byte)20;
        public int t1packing2 = -1;
        public int t2Count = 0;
        public int t2packing1 = -1;
        public String t2Data;
        public byte t2BPC = (byte)33;
        public byte t2BPI = (byte)34;
        public byte t2Par = (byte)35;
        public byte t2LRC = (byte)36;
        public int t2packing2 = -1;
        public int t3Count = 0;
        public int t3packing1 = -1;
        public String t3Data;
        public byte t3BPC = (byte)49;
        public byte t3BPI = (byte)50;
        public byte t3Par = (byte)51;
        public byte t3LRC = (byte)52;
        public int t3packing2 = -1;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("encoding", "coercivity", "verify", "packing1", "packing2", "t1Count", "t1packing1", "t1Data", "t1BPC", "t1BPI", "t1Par", "t1LRC", "t1packing2", "t2Count", "t2packing1", "t2Data", "t2BPC", "t2BPI", "t2Par", "t2LRC", "t2packing2", "t3Count", "t3packing1", "t3Data", "t3BPC", "t3BPI", "t3Par", "t3LRC", "t3packing2");
        }
    }

    public static class SDKMagTextDef
    extends Structure
    implements Structure.ByReference {
        public int track;
        public WString data;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("track", "data");
        }
    }

    public static class SDKRect
    extends Structure {
        public int left;
        public int top;
        public int right;
        public int bottom;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("left", "top", "right", "bottom");
        }
    }

    public static class SDKShapeDef
    extends Structure
    implements Structure.ByReference {
        public byte shape;
        public ColorRef penColour;
        public int penWidth;
        public int fillColour;
        public SDKRect area = new SDKRect();
        public int p1;
        public int p2;
        public int p3;
        public int p4;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("shape", "penColour", "penWidth", "fillColour", "area", "p1", "p2", "p3", "p4");
        }
    }

    public static class SDKTextDef
    extends Structure
    implements Structure.ByReference {
        public WString text;
        public int x;
        public int y;
        public int angle;
        public WString fontName;
        public int fontSize;
        public ColorRef fontColour;
        public int fontStyle;

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("text", "x", "y", "angle", "fontName", "fontSize", "fontColour", "fontStyle");
        }
    }

    public static class StringByReference
    extends ByReference {
        public StringByReference() {
            this(0);
        }

        public StringByReference(int size) {
            super(size < 4 ? 4 : size);
            this.getPointer().clear(size < 4 ? 4 : size);
        }

        public StringByReference(String str) {
            super(str.length() < 4 ? 4 : str.length() + 1);
            this.setValue(str);
        }

        private void setValue(String str) {
            this.getPointer().setString(0L, str);
        }

        public String getValue() {
            return this.getPointer().getString(0L);
        }
    }
}

