/*
 * Decompiled with CFR 0.152.
 */
package DTCDemo;

import DTCDemo.Main;
import DTCDemo.Utils;
import SDK.SDKlib;
import com.sun.jna.platform.win32.WinNT;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

class Utility {
    private final ActionHandler ah = new ActionHandler();
    public static final JPanel panelUtility = new JPanel();
    private final JButton btnClear = new JButton("Clear");
    private final JPanel panelSLE = new JPanel();
    private final JButton btnSendAPDU = new JButton("Send APDU");
    private final JTextArea editAPDU = new JTextArea();
    private final JTextArea textUtilityMsg = new JTextArea();
    private final JScrollPane scrollPane = new JScrollPane();
    private WinNT.HANDLE hSession;
    private SDKlib SDK;
    private final String CLEAR = "CLEAR";
    private final String APDU = "APDU";

    public Utility() {
        panelUtility.setLayout(new MigLayout("", "[129.00][grow]", "[][][][][][][][][][][][397.00][397.00,grow][]"));
        panelUtility.add((Component)this.panelSLE, "cell 0 0 2 1,grow");
        this.panelSLE.setLayout(new MigLayout("", "[grow]", "[]"));
        this.panelSLE.setBorder(new TitledBorder(null, "Single Line Encoding", 4, 2, null, null));
        this.panelSLE.add((Component)this.editAPDU, "cell 0 0,growx");
        panelUtility.add((Component)this.scrollPane, "cell 1 1 1 12,grow");
        this.textUtilityMsg.setEditable(false);
        this.scrollPane.setViewportView(this.textUtilityMsg);
        this.btnSendAPDU.setActionCommand("APDU");
        this.btnSendAPDU.addActionListener(this.ah);
        this.panelSLE.add((Component)this.btnSendAPDU, "cell 0 0");
        panelUtility.add((Component)this.btnClear, "cell 1 13,alignx center");
        this.btnClear.setActionCommand("CLEAR");
        this.btnClear.addActionListener(this.ah);
    }

    void Init(WinNT.HANDLE handle, SDKlib sdk) {
        Main.tabbedPane.addTab("Utility", null, panelUtility, null);
        this.hSession = handle;
        this.SDK = sdk;
        boolean bControl = Utils.connectedPrinter == 4;
        this.btnSendAPDU.setEnabled(bControl);
        this.editAPDU.setEnabled(bControl);
    }

    void ClearMsg() {
        this.textUtilityMsg.setText(null);
    }

    private void SendAPDU() {
        if (this.editAPDU.getText().length() > 1) {
            String[] apduList;
            String[] stringArray = apduList = this.editAPDU.getText().split("\n");
            int n = apduList.length;
            int n2 = 0;
            while (n2 < n) {
                String apdu = stringArray[n2];
                this.textUtilityMsg.append("APDU Sent -> " + apdu + "\n");
                StringBuilder inputAPDU = new StringBuilder(apdu);
                StringBuilder outputAPDU = new StringBuilder();
                byte sdkReturn = this.SDK.ID_SendAPDU(this.hSession, inputAPDU, outputAPDU);
                if (sdkReturn != 0) {
                    Utils.DisplayError("APDU", sdkReturn);
                } else {
                    this.textUtilityMsg.append("APDU Reply: " + outputAPDU + "\n");
                }
                ++n2;
            }
        } else {
            JOptionPane.showMessageDialog(null, "APDU Box is empty", "SDK Error", 1);
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (e.getActionCommand()) {
                case "CLEAR": {
                    Utility.this.ClearMsg();
                    break;
                }
                case "APDU": {
                    Utility.this.SendAPDU();
                }
            }
        }
    }
}

