/*
 * Decompiled with CFR 0.152.
 */
package DTCDemo;

import DTCDemo.ComboItem;
import DTCDemo.Main;
import DTCDemo.Printer;
import DTCDemo.Utils;
import SDK.SDKlib;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

class Info {
    private final String SDKBITS = "SDKBITS";
    private final String LASTMSG = "LASTMSG";
    private final String STATUS = "STATUS";
    private final String INFO = "INFO";
    private final String VERSION = "VERSION";
    private final String CONNECTION = "CONNECTION";
    private final String TYPE = "TYPE";
    private final String MODEL = "MODEL";
    private final String PASSWORD = "PASSWORD";
    private final String PWDCMD = "PWDCMD";
    private final String CLEAR = "CLEAR";
    private final String READ360 = "READ360";
    private final String ALL360 = "ALL360";
    private final String SENSORS = "SENSORS";
    private final ActionHandler ah = new ActionHandler();
    public static final JPanel panelInfo = new JPanel();
    private final JButton btnLastMessage = new JButton("Last Message");
    private final JButton btnPrinterStatus = new JButton("Printer Status");
    private final JButton btnPrinterInfo = new JButton("Printer Info");
    private final JButton btnSDKVersion = new JButton("SDK Version");
    private final JButton btnConnectionType = new JButton("Connection Type");
    private final JButton btnPrinterType = new JButton("Printer Type");
    private final JButton btnPrinterModel = new JButton("Printer Model");
    private final JButton btnSDKBits = new JButton("SDK Bits");
    private final JButton btnClear = new JButton("Clear");
    private final JPanel panelPassword = new JPanel();
    private final JComboBox<ComboItem> comboPassword = new JComboBox();
    private final JLabel labelPassword1 = new JLabel("P1");
    private final JLabel labelPassword2 = new JLabel("P2");
    private final JButton btnPassword = new JButton("Send");
    private final JTextField editPassword1 = new JTextField();
    private final JTextField editPassword2 = new JTextField();
    private final JTextArea textInfoMsg = new JTextArea();
    private final JScrollPane scrollPane = new JScrollPane();
    private final JPanel panelPro360 = new JPanel();
    private final JLabel labelParameter = new JLabel("Parameter");
    private final JComboBox<ComboItem> comboParam360 = new JComboBox();
    private final JButton btnRead360 = new JButton("Read");
    private final JButton btnAllParams = new JButton("All Params");
    private WinNT.HANDLE hSession;
    private SDKlib SDK;
    Param360[] ParamSet = new Param360[]{new Param360("Duplex", 0, ParamType.AsBool), new Param360("Mag Encoding", 1, ParamType.AsBool), new Param360("Smart Encoding", 2, ParamType.AsBool), new Param360("System Version", 3, ParamType.AsString), new Param360("Printer App Vers.", 4, ParamType.AsString), new Param360("Firmware Version", 5, ParamType.AsString), new Param360("Mag Firmware Vers.", 6, ParamType.AsString), new Param360("Printer Serial", 7, ParamType.AsString), new Param360("Printhead Serial", 8, ParamType.AsString), new Param360("Main Board Serial", 9, ParamType.AsString), new Param360("Model Name", 10, ParamType.AsString), new Param360("Dealer Code", 11, ParamType.AsInt), new Param360("Project Code", 12, ParamType.AsInt), new Param360("Total Cards", 13, ParamType.AsInt), new Param360("Total Panels", 14, ParamType.AsInt), new Param360("Cards on Printhead", 15, ParamType.AsInt), new Param360("Panels on Printhead", 16, ParamType.AsInt), new Param360("Cards since Clean", 17, ParamType.AsInt), new Param360("Panels since Clean", 18, ParamType.AsInt), new Param360("Cleaning Cycles", 19, ParamType.AsInt), new Param360("Dyefilm Name", 20, ParamType.AsString), new Param360("Dyefilm Serial", 21, ParamType.AsString), new Param360("Dyefilm Prints", 22, ParamType.AsInt), new Param360("Dyefilm Prints Left", 23, ParamType.AsInt), new Param360("Dyefilm Manu.", 24, ParamType.AsInt), new Param360("Cards between Cleans", 25, ParamType.AsInt), new Param360("Clean Overdue", 26, ParamType.AsBool), new Param360("MAC Address", 27, ParamType.AsString), new Param360("Use DHCP", 28, ParamType.AsBool), new Param360("IP Address", 29, ParamType.AsString), new Param360("IP Gateway", 30, ParamType.AsString), new Param360("IP Subnet", 31, ParamType.AsString), new Param360("Static IP Address", 32, ParamType.AsString), new Param360("Static IP Gateway", 33, ParamType.AsString), new Param360("Static IP Subnet", 34, ParamType.AsString), new Param360("Error Status", 35, ParamType.AsString), new Param360("Hand Feed", 36, ParamType.AsBool), new Param360("Card Position", 37, ParamType.AsString), new Param360("Mag Enc. Start", 38, ParamType.AsInt), new Param360("Dyefilm YMC Length", 39, ParamType.AsInt), new Param360("Dyefilm K Length", 40, ParamType.AsInt), new Param360("Dyefilm O Length", 41, ParamType.AsInt), new Param360("Contactless Offset", 42, ParamType.AsInt), new Param360("HoloKote Slots", 43, ParamType.AsInt), new Param360("600 dpi", 44, ParamType.AsBool), new Param360("Hopper Sensor", 45, ParamType.AsBool), new Param360("Exit Sensor", 46, ParamType.AsBool), new Param360("Lid Sensor", 47, ParamType.AsBool), new Param360("Manufacturer", 48, ParamType.AsString), new Param360("Hopper Sensor Fitted", 49, ParamType.AsBool), new Param360("Exit Sensor Fitted", 50, ParamType.AsBool), new Param360("Region", 51, ParamType.AsInt)};
    private final JButton btnSensors = new JButton("Sensors");

    public Info() {
        panelInfo.setLayout(new MigLayout("", "[129.00][grow]", "[][][][][][][][][][][][397.00][397.00,grow][]"));
        panelInfo.add((Component)this.panelPassword, "cell 0 0 2 1,grow");
        this.panelPassword.setLayout(new MigLayout("", "[grow]", "[]"));
        this.panelPassword.setBorder(new TitledBorder(null, "Password", 4, 2, null, null));
        this.panelPassword.add(this.comboPassword, "flowx,cell 0 0,growx");
        this.comboPassword.addItem(new ComboItem("Set", 0));
        this.comboPassword.addItem(new ComboItem("Use", 1));
        this.comboPassword.setActionCommand("PWDCMD");
        this.comboPassword.addActionListener(this.ah);
        this.panelPassword.add((Component)this.labelPassword1, "cell 0 0");
        this.panelPassword.add((Component)this.editPassword1, "cell 0 0");
        this.panelPassword.add((Component)this.labelPassword2, "cell 0 0");
        this.panelPassword.add((Component)this.editPassword2, "cell 0 0");
        this.editPassword1.setColumns(10);
        this.editPassword2.setColumns(10);
        panelInfo.add((Component)this.scrollPane, "cell 1 1 1 12,grow");
        this.textInfoMsg.setEditable(false);
        this.scrollPane.setViewportView(this.textInfoMsg);
        this.btnPassword.setActionCommand("PASSWORD");
        this.btnPassword.addActionListener(this.ah);
        this.panelPassword.add((Component)this.btnPassword, "cell 0 0");
        panelInfo.add((Component)this.btnSDKVersion, "cell 0 1,growx");
        this.btnSDKVersion.setActionCommand("VERSION");
        this.btnSDKVersion.addActionListener(this.ah);
        panelInfo.add((Component)this.btnSDKBits, "cell 0 2,growx");
        this.btnSDKBits.setActionCommand("SDKBITS");
        this.btnSDKBits.addActionListener(this.ah);
        panelInfo.add((Component)this.btnConnectionType, "cell 0 3,growx");
        this.btnConnectionType.setActionCommand("CONNECTION");
        this.btnConnectionType.addActionListener(this.ah);
        panelInfo.add((Component)this.btnPrinterType, "cell 0 4,growx");
        this.btnPrinterType.setActionCommand("TYPE");
        this.btnPrinterType.addActionListener(this.ah);
        panelInfo.add((Component)this.btnPrinterModel, "cell 0 5,growx");
        this.btnPrinterModel.setActionCommand("MODEL");
        this.btnPrinterModel.addActionListener(this.ah);
        panelInfo.add((Component)this.btnPrinterStatus, "cell 0 6,growx");
        this.btnPrinterStatus.setActionCommand("STATUS");
        this.btnPrinterStatus.addActionListener(this.ah);
        panelInfo.add((Component)this.btnPrinterInfo, "cell 0 7,growx");
        this.btnPrinterInfo.setActionCommand("INFO");
        this.btnPrinterInfo.addActionListener(this.ah);
        panelInfo.add((Component)this.btnLastMessage, "cell 0 8,growx");
        this.btnLastMessage.setActionCommand("LASTMSG");
        this.btnLastMessage.addActionListener(this.ah);
        panelInfo.add((Component)this.btnSensors, "cell 0 9,growx");
        this.btnSensors.setActionCommand("SENSORS");
        this.btnSensors.addActionListener(this.ah);
        this.panelPro360.setBorder(new TitledBorder(null, "Rio Pro 360 Settings", 4, 2, null, null));
        panelInfo.add((Component)this.panelPro360, "cell 0 12,grow");
        this.panelPro360.setLayout(new MigLayout("", "[grow]", "[][][][grow][grow][]"));
        this.labelParameter.setHorizontalAlignment(0);
        this.panelPro360.add((Component)this.labelParameter, "cell 0 0,growx");
        this.panelPro360.add(this.comboParam360, "cell 0 1,growx");
        this.panelPro360.add((Component)this.btnRead360, "cell 0 2,alignx center");
        this.btnRead360.setActionCommand("READ360");
        this.btnRead360.addActionListener(this.ah);
        Param360[] param360Array = this.ParamSet;
        int n = this.ParamSet.length;
        int n2 = 0;
        while (n2 < n) {
            Param360 item = param360Array[n2];
            this.comboParam360.addItem(new ComboItem(item.Text, item.ID));
            ++n2;
        }
        this.panelPro360.add((Component)this.btnAllParams, "cell 0 5,alignx center");
        this.btnAllParams.setActionCommand("ALL360");
        this.btnAllParams.addActionListener(this.ah);
        panelInfo.add((Component)this.btnClear, "cell 1 13,alignx center");
        this.btnClear.setActionCommand("CLEAR");
        this.btnClear.addActionListener(this.ah);
    }

    void Init(WinNT.HANDLE handle, SDKlib sdk) {
        Main.tabbedPane.addTab("Information", null, panelInfo, null);
        this.hSession = handle;
        this.SDK = sdk;
        boolean bControl = Utils.connectedPrinter != 4;
        this.btnPassword.setEnabled(bControl);
        this.editPassword1.setEnabled(bControl);
        this.editPassword2.setEnabled(bControl);
        this.comboPassword.setEnabled(bControl);
        this.labelPassword1.setEnabled(bControl);
        this.labelPassword2.setEnabled(bControl);
        this.panelPro360.setVisible(!bControl);
        this.labelParameter.setVisible(!bControl);
        this.btnRead360.setVisible(!bControl);
        this.btnAllParams.setVisible(!bControl);
        this.comboParam360.setVisible(!bControl);
    }

    void ClearMsg() {
        this.textInfoMsg.setText(null);
    }

    private void SDKBits() {
        this.textInfoMsg.append(String.valueOf(this.SDK.ID_SDKBits()) + " Bit SDK\n\n");
    }

    private void LastMsg() {
        StringBuilder Message = new StringBuilder();
        byte sdkReturn = this.SDK.ID_LastMessage(this.hSession, Message);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetLastMessage", sdkReturn);
        } else {
            this.textInfoMsg.append(String.valueOf(Message.toString()) + "\n\n");
        }
    }

    private void PrinterStatus() {
        String temp_string = "";
        switch (this.SDK.ID_PrinterStatus(this.hSession)) {
            case 0: {
                temp_string = "READY";
                break;
            }
            case 3: {
                temp_string = "OFFLINE";
                break;
            }
            case 2: {
                temp_string = "ERROR";
                break;
            }
            case 1: {
                temp_string = "BUSY";
            }
        }
        this.textInfoMsg.append("Printer is " + temp_string + "\n\n");
    }

    private void PrinterInfo() {
        Utils.CursorWait();
        SDKlib.PrinterInfo PI2 = new SDKlib.PrinterInfo();
        byte sdkReturn = this.SDK.ID_PrinterInfo(this.hSession, PI2);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetPrinterInfo", sdkReturn);
        } else {
            this.textInfoMsg.append("PrinterConnected: " + (PI2.printerConnected ? "Yes" : "No") + "\n");
            this.textInfoMsg.append("Model Code: " + PI2.modelCode + "\n");
            this.textInfoMsg.append("Model: " + new String(PI2.model) + "\n");
            this.textInfoMsg.append("PrintheadType: " + PI2.printheadType + "\n");
            this.textInfoMsg.append("PrinterSerial: " + new String(PI2.printerSerial) + "\n");
            this.textInfoMsg.append("PrintheadSerial: " + new String(PI2.printheadSerial) + "\n");
            this.textInfoMsg.append("PCBSerial: " + new String(PI2.pcbSerial) + "\n");
            this.textInfoMsg.append("FirmwareVersion: " + new String(PI2.firmware) + "\n");
            this.textInfoMsg.append("Density: " + PI2.density + "\n");
            this.textInfoMsg.append("HandFeed: " + Utils.OnOffString(PI2.handFeed != 0) + "\n");
            this.textInfoMsg.append("CardsPrinted: " + PI2.cardsPrinted + "\n");
            this.textInfoMsg.append("CardsOnPrinthead: " + PI2.cardsOnPrinthead + "\n");
            this.textInfoMsg.append("DyePanelsPrinted: " + PI2.dyePanelsPrinted + "\n");
            this.textInfoMsg.append("CleansSinceShipped: " + PI2.cleansSinceShipped + "\n");
            this.textInfoMsg.append("DyePanelsSinceClean: " + PI2.dyePanelsSinceClean + "\n");
            this.textInfoMsg.append("CardsSinceClean: " + PI2.cardsSinceClean + "\n");
            this.textInfoMsg.append("CardsBetweenCleans: " + PI2.cardsBetweenCleans + "\n");
            this.textInfoMsg.append("PrintHeadPosn: " + PI2.printHeadPosn + "\n");
            this.textInfoMsg.append("ImageStartPosn: " + PI2.imageStartPosn + "\n");
            this.textInfoMsg.append("ImageEndPosn: " + PI2.imageEndPosn + "\n");
            this.textInfoMsg.append("MajorError: " + PI2.majorError + "\n");
            this.textInfoMsg.append("MinorError: " + PI2.minorError + "\n");
            this.textInfoMsg.append("TagUID: " + new String(PI2.tagUID) + "\n");
            this.textInfoMsg.append("ShotsOnFilm: " + PI2.shotsOnFilm + "\n");
            this.textInfoMsg.append("ShotsUsed: " + PI2.shotsUsed + "\n");
            this.textInfoMsg.append("DyeFilmType: " + new String(PI2.dyeFilmType) + "\n");
            this.textInfoMsg.append("DyeFilmManuf: " + PI2.dyeFilmManuf + "\n");
            this.textInfoMsg.append("ColourLength: " + PI2.colourLength + "\n");
            this.textInfoMsg.append("ResinLength: " + PI2.resinLength + "\n");
            this.textInfoMsg.append("OvercoatLength: " + PI2.overcoatLength + "\n");
            this.textInfoMsg.append("DyeFlags: " + PI2.dyeFlags + "\n");
            this.textInfoMsg.append("CommandCode: " + PI2.commandCode + "\n");
            this.textInfoMsg.append("DOB: " + PI2.dob + "\n");
            this.textInfoMsg.append("DyeFilmProg: " + PI2.dyeFilmProg + "\n");
            this.textInfoMsg.append("Smart Mode: ");
            switch (PI2.bitFields & 0x23) {
                case 2: {
                    this.textInfoMsg.append(String.valueOf(Printer.SmartModeString((byte)1)) + "\n");
                    break;
                }
                case 32: {
                    this.textInfoMsg.append(String.valueOf(Printer.SmartModeString((byte)2)) + "\n");
                    break;
                }
                default: {
                    this.textInfoMsg.append(String.valueOf(Printer.SmartModeString((byte)0)) + "\n");
                }
            }
            this.textInfoMsg.append("Smart Offset: " + PI2.smartOffset + "\n");
            this.textInfoMsg.append("Eject Mode: " + Utils.OnOffString((PI2.bitFields & 8) != 0) + "\n");
            this.textInfoMsg.append("Horz Eject Mode: " + Utils.OnOffString((PI2.bitFields & 0x10) != 0) + "\n");
            this.textInfoMsg.append("Erase Speed: " + ((PI2.bitFields & 4) != 0 ? "Quick" : "Thorough") + "\n");
            this.textInfoMsg.append("\n");
        }
        Utils.CursorDefault();
    }

    private void SDKVersion() {
        SDKlib.SDKVersion version = new SDKlib.SDKVersion();
        byte sdkReturn = this.SDK.ID_SDKVersion(this.hSession, version);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetVersion", sdkReturn);
        } else {
            this.textInfoMsg.append("Version: " + version.major + "." + version.minor + "." + version.build + "." + version.beta + "\n\n");
        }
    }

    private void Connection() {
        String msg;
        switch (this.SDK.ID_ConnectionType(this.hSession)) {
            case 1: {
                msg = "USB";
                break;
            }
            case 3: {
                msg = "ETHERNET";
                break;
            }
            case 4: {
                msg = "FILE";
                break;
            }
            default: {
                msg = "UNKNOWN";
            }
        }
        this.textInfoMsg.append("Connection: " + msg + "\n\n");
    }

    private void Type() {
        this.textInfoMsg.append("Printer Type - ");
        switch (this.SDK.ID_PrinterType(this.hSession)) {
            case 0: {
                this.textInfoMsg.append("RioTango\n\n");
                break;
            }
            case 1: {
                this.textInfoMsg.append("AOTA\n\n");
                break;
            }
            case 2: {
                this.textInfoMsg.append("Enduro Family\n\n");
                break;
            }
            case 3: {
                this.textInfoMsg.append("Ultima\n\n");
                break;
            }
            case 4: {
                this.textInfoMsg.append("Generation 2 Family\n\n");
                break;
            }
            default: {
                this.textInfoMsg.append("UNKNOWN\n\n");
            }
        }
    }

    private void Model() {
        int model = this.SDK.ID_PrinterModel(this.hSession);
        String msg = (model & 0x20) != 0 ? "Pronto" : ((model & 0x8000) != 0 ? "Rio Pro" : ((model & 0x1000) != 0 ? "Ultima" : ((model & 0x200) != 0 ? "Enduro" : ((model & 0x10000) != 0 ? "Rio Pro 360" : ((model & 0x20000) != 0 ? "600" : ((model & 0x40000) != 0 ? "300" : ((model & 0x400) != 0 ? "Pronto 100" : ((model & 0x80000) != 0 ? "Generation 2" : "UNKNOWN"))))))));
        this.textInfoMsg.append("Printer - " + msg + "\n");
        this.textInfoMsg.append("Capability:\n");
        if ((model & 1) != 0) {
            this.textInfoMsg.append("  - Mag Encoding\n");
        }
        if ((model & 2) != 0) {
            this.textInfoMsg.append("  - Duplex\n");
        }
        if ((model & 4) != 0) {
            this.textInfoMsg.append("  - Rewrite\n");
        }
        if ((model & 0x10) != 0) {
            this.textInfoMsg.append("  - Chip Encoding\n");
        }
        if ((model & 8) != 0) {
            this.textInfoMsg.append("  - Contactless Encoding\n");
        }
        if ((model & 0x100) != 0) {
            this.textInfoMsg.append("  - Extended\n");
        }
        if ((model & 0x800) != 0) {
            this.textInfoMsg.append("  - Ethernet\n");
        }
        if ((model & 0x4000) != 0) {
            this.textInfoMsg.append("  - 600 dpi\n");
        }
        this.textInfoMsg.append("\n");
    }

    private void Password() {
        byte sdkReturn = this.SDK.ID_Password(this.hSession, ((ComboItem)this.comboPassword.getSelectedItem()).getValue(), this.editPassword1.getText(), this.editPassword2.getText());
        if (sdkReturn != 0) {
            Utils.DisplayError("Password", sdkReturn);
        }
    }

    private void PasswordCmd() {
        if (((ComboItem)this.comboPassword.getSelectedItem()).getValue() == 1) {
            this.labelPassword2.setEnabled(false);
            this.editPassword2.setEnabled(false);
        } else {
            this.labelPassword2.setEnabled(true);
            this.editPassword2.setEnabled(true);
        }
    }

    void Read360() {
        Comparable<StringBuilder> temp;
        int SDKReturn = -2;
        Param360 item = this.ParamSet[((ComboItem)this.comboParam360.getSelectedItem()).getValue()];
        switch (item.Type) {
            case AsInt: {
                IntByReference tempint = new IntByReference();
                SDKReturn = this.SDK.ID_AccessInt(this.hSession, (byte)0, item.ID, tempint);
                temp = tempint.getValue();
                break;
            }
            case AsBool: {
                WinDef.BOOLByReference tempbool = new WinDef.BOOLByReference();
                SDKReturn = this.SDK.ID_AccessBool(this.hSession, (byte)0, item.ID, tempbool);
                temp = tempbool.getValue().booleanValue();
                break;
            }
            default: {
                StringBuilder tempString = new StringBuilder();
                SDKReturn = this.SDK.ID_AccessString(this.hSession, (byte)0, item.ID, tempString);
                temp = tempString;
            }
        }
        if (SDKReturn != 0) {
            Utils.DisplayError("GetPro360Param", SDKReturn);
        } else {
            this.textInfoMsg.append(String.valueOf(item.Text) + Utils.Separator((byte)0) + temp.toString() + "\n\n");
        }
    }

    void AllParams() {
        Utils.CursorWait();
        Param360[] param360Array = this.ParamSet;
        int n = this.ParamSet.length;
        int n2 = 0;
        while (n2 < n) {
            Comparable<StringBuilder> temp;
            byte SDKReturn;
            Param360 item = param360Array[n2];
            switch (item.Type) {
                case AsInt: {
                    IntByReference tempint = new IntByReference();
                    SDKReturn = this.SDK.ID_AccessInt(this.hSession, (byte)0, item.ID, tempint);
                    temp = tempint.getValue();
                    break;
                }
                case AsBool: {
                    WinDef.BOOLByReference tempbool = new WinDef.BOOLByReference();
                    SDKReturn = this.SDK.ID_AccessBool(this.hSession, (byte)0, item.ID, tempbool);
                    temp = tempbool.getValue().booleanValue();
                    break;
                }
                default: {
                    StringBuilder tempString = new StringBuilder();
                    SDKReturn = this.SDK.ID_AccessString(this.hSession, (byte)0, item.ID, tempString);
                    temp = tempString;
                }
            }
            if (SDKReturn != 0) {
                Utils.DisplayError("GetAllParams", SDKReturn);
            } else {
                this.textInfoMsg.append(String.valueOf(item.Text) + Utils.Separator((byte)0) + temp.toString().toUpperCase() + "\n");
            }
            ++n2;
        }
        this.textInfoMsg.append("\n");
        Utils.CursorDefault();
    }

    private void Sensors() {
        Utils.CursorWait();
        IntByReference sensors = new IntByReference();
        byte SDKReturn = this.SDK.ID_Sensors(this.hSession, sensors);
        if (SDKReturn != 0) {
            Utils.DisplayError("Sensors", SDKReturn);
        } else {
            this.textInfoMsg.append("Sensors:\n");
            if ((sensors.getValue() & 1) != 0) {
                this.textInfoMsg.append("- Lid Closed\n");
            } else {
                this.textInfoMsg.append("- Lid Open\n");
            }
            if ((sensors.getValue() & 2) == 0) {
                this.textInfoMsg.append("- Hopper Sensor Not Fitted\n");
            } else if ((sensors.getValue() & 2) != 0) {
                this.textInfoMsg.append("- Cards in Hopper\n");
            } else {
                this.textInfoMsg.append("- Cards Low\n");
            }
            if ((sensors.getValue() & 4) == 0) {
                this.textInfoMsg.append("- Exit Sensor Not Fitted\n");
            } else if ((sensors.getValue() & 4) != 0) {
                this.textInfoMsg.append("- Exit Blocked\n");
            } else {
                this.textInfoMsg.append("- Exit Clear\n");
            }
        }
        this.textInfoMsg.append("\n");
        Utils.CursorDefault();
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (e.getActionCommand()) {
                case "CLEAR": {
                    Info.this.ClearMsg();
                    break;
                }
                case "LASTMSG": {
                    Info.this.LastMsg();
                    break;
                }
                case "SDKBITS": {
                    Info.this.SDKBits();
                    break;
                }
                case "STATUS": {
                    Info.this.PrinterStatus();
                    break;
                }
                case "INFO": {
                    Info.this.PrinterInfo();
                    break;
                }
                case "VERSION": {
                    Info.this.SDKVersion();
                    break;
                }
                case "CONNECTION": {
                    Info.this.Connection();
                    break;
                }
                case "TYPE": {
                    Info.this.Type();
                    break;
                }
                case "MODEL": {
                    Info.this.Model();
                    break;
                }
                case "PASSWORD": {
                    Info.this.Password();
                    break;
                }
                case "PWDCMD": {
                    Info.this.PasswordCmd();
                    break;
                }
                case "READ360": {
                    Info.this.Read360();
                    break;
                }
                case "ALL360": {
                    Info.this.AllParams();
                    break;
                }
                case "SENSORS": {
                    Info.this.Sensors();
                }
            }
        }
    }

    class Param360 {
        public String Text;
        public byte ID;
        public ParamType Type;

        public Param360(String param, byte ID, ParamType paramType) {
            this.Text = param;
            this.ID = ID;
            this.Type = paramType;
        }
    }

    static enum ParamType {
        AsBool,
        AsInt,
        AsString;

    }
}

