/*
 * Decompiled with CFR 0.152.
 */
package DTCDemo;

import DTCDemo.ComboItem;
import DTCDemo.Main;
import DTCDemo.Utils;
import SDK.SDKlib;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.ByteByReference;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;

public class Driver1 {
    static final int MAX_POWER = 99;
    static final int MAX_SHARPNESS = 2;
    static final int MIN_SHARPNESS = -2;
    private final String RADIOGET = "RADIOGET";
    private final String RADIOSET = "RADIOSET";
    private final String CLEAR = "CLEAR";
    private final String GUICONTROL = "GUICONTROL";
    private final String SHARPNESS = "SHARPNESS";
    private final String COLOUR = "COLOUR";
    private final String POWERLEVEL = "POWERLEVEL";
    private final String PRINTSPEED = "PRINTSPEED";
    private final String RESINAREA = "RESINAREA";
    private final String RASIDE = "RASIDE";
    private final String AREAHOLE = "AREAHOLE";
    private final String AHSIDE = "AHSIDE";
    private final String AHTYPE = "AHTYPE";
    private final String REWRITABLE = "REWRITABLE";
    private final String PRINTABLEAREA = "PRINTABLEAREA";
    private final String RESOLUTION = "RESOLUTION";
    private final ActionHandler ah = new ActionHandler();
    public static final JPanel panelDriver1 = new JPanel();
    public static final String DRIVER1_TAB_TITLE = "Driver 1";
    private final JPanel panelGeneral = new JPanel();
    private final JPanel panelAction = new JPanel();
    private final JLabel labelAction = new JLabel("Action:");
    private final JRadioButton rdbtnGet = new JRadioButton("Get");
    private final JRadioButton rdbtnSet = new JRadioButton("Set");
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final JCheckBox checkUser = new JCheckBox("User");
    private final JCheckBox checkPrinter = new JCheckBox("Printer");
    private final JButton btnGUIControl = new JButton("GUI Control");
    private final JSpinner spinnerSharpness = new JSpinner(new SpinnerNumberModel(0, -2, 2, 1));
    private final JButton btnSharpness = new JButton("Sharpness");
    private final JComboBox<ComboItem> comboCorrection = new JComboBox();
    private final JButton btnColour = new JButton("Colour Corr.");
    private final JComboBox<ComboItem> comboPrintSpeed = new JComboBox();
    private final JButton btnPrintSpeed = new JButton("Print Speed");
    private final JPanel panelPowerLevel = new JPanel();
    private final JLabel labelYMC = new JLabel("YMC");
    private final JLabel labelResin = new JLabel("Resin");
    private final JLabel labelOvercoat = new JLabel("Overcoat");
    private final JSpinner spinnerYMCPower = new JSpinner(new SpinnerNumberModel(0, 0, 99, 1));
    private final JSpinner spinnerResinPower = new JSpinner(new SpinnerNumberModel(0, 0, 99, 1));
    private final JSpinner spinnerOvercoatPower = new JSpinner(new SpinnerNumberModel(0, 0, 99, 1));
    private final JButton btnPowerLevel = new JButton("Power Level");
    private final JPanel panelResinArea = new JPanel();
    private final JLabel labelResinSide = new JLabel("Side");
    private final JComboBox<ComboItem> comboResinAreaSide = new JComboBox();
    private final JLabel labelResinAreaNo = new JLabel("No.");
    private final JSpinner spinnerResinAreaNo = new JSpinner(new SpinnerNumberModel(new Byte("1"), new Byte("1"), new Byte("5"), new Byte("1")));
    private final JLabel labelResinL = new JLabel("L");
    private final JLabel labelResinW = new JLabel("W");
    private final JLabel labelResinB = new JLabel("B");
    private final JLabel labelResinH = new JLabel("H");
    private final JSpinner spinnerResinL = new JSpinner(new SpinnerNumberModel(0, 0, Utils.maxXCoord, 1));
    private final JSpinner spinnerResinW = new JSpinner(new SpinnerNumberModel(0, 0, Utils.maxCardLength, 1));
    private final JSpinner spinnerResinB = new JSpinner(new SpinnerNumberModel(0, 0, 641, 1));
    private final JSpinner spinnerResinH = new JSpinner(new SpinnerNumberModel(0, 0, 642, 1));
    private final JButton btnResinArea = new JButton("Resin Area");
    private final JPanel panelAreaHole = new JPanel();
    private final JLabel labelAreaHoleSide = new JLabel("Side");
    private final JComboBox<ComboItem> comboAreaHoleSide = new JComboBox();
    private final JLabel labelAreaHoleNo = new JLabel("No.");
    private final JSpinner spinnerAreaHoleNo = new JSpinner(new SpinnerNumberModel(new Byte("1"), new Byte("1"), new Byte("2"), new Byte("1")));
    private final JLabel labelAreaHoleType = new JLabel("Type");
    private final JComboBox<ComboItem> comboAreaHoleType = new JComboBox();
    private final JLabel labelAreaHoleL = new JLabel("L");
    private final JLabel labelAreaHoleW = new JLabel("W");
    private final JLabel labelAreaHoleB = new JLabel("B");
    private final JLabel labelAreaHoleH = new JLabel("H");
    private final JSpinner spinnerAreaHoleL = new JSpinner(new SpinnerNumberModel(0, 0, Utils.maxXCoord, 1));
    private final JSpinner spinnerAreaHoleW = new JSpinner(new SpinnerNumberModel(0, 0, Utils.maxCardLength, 1));
    private final JSpinner spinnerAreaHoleB = new JSpinner(new SpinnerNumberModel(0, 0, 641, 1));
    private final JSpinner spinnerAreaHoleH = new JSpinner(new SpinnerNumberModel(0, 0, 642, 1));
    private final JButton btnAreaHole = new JButton("Area/Hole");
    private final JPanel panelRewritable = new JPanel();
    private final JLabel labelL = new JLabel("L");
    private final JLabel labelW = new JLabel("W");
    private final JLabel labelB = new JLabel("B");
    private final JLabel labelH = new JLabel("H");
    private final JSpinner spinnerEraseAreaL = new JSpinner(new SpinnerNumberModel(0, 0, Utils.maxXCoord, 1));
    private final JSpinner spinnerEraseAreaW = new JSpinner(new SpinnerNumberModel(0, 0, Utils.maxCardLength, 1));
    private final JSpinner spinnerEraseAreaB = new JSpinner(new SpinnerNumberModel(0, 0, 641, 1));
    private final JSpinner spinnerEraseAreaH = new JSpinner(new SpinnerNumberModel(0, 0, 642, 1));
    private final JLabel labelPower = new JLabel("Power");
    private final JLabel labelWritePower = new JLabel("Write");
    private final JSpinner spinnerEraseWrite = new JSpinner(new SpinnerNumberModel(0, 0, 99, 1));
    private final JCheckBox checkEraseBeforePrint = new JCheckBox("Erase before Print");
    private final JLabel labelStartPower = new JLabel("Start");
    private final JSpinner spinnerEraseStart = new JSpinner(new SpinnerNumberModel(0, 0, 99, 1));
    private final JLabel labelEndPower = new JLabel("End");
    private final JSpinner spinnerEraseEnd = new JSpinner(new SpinnerNumberModel(0, 0, 99, 1));
    private final JButton btnRewritable = new JButton("Rewritable");
    private final JPanel panelPrintableArea = new JPanel();
    private final JLabel labelPrintableAreaL = new JLabel("L");
    private final JLabel labelPrintableAreaW = new JLabel("W");
    private final JLabel labelPrintableAreaB = new JLabel("B");
    private final JLabel labelPrintableAreaH = new JLabel("H");
    private final JSpinner spinnerPrintableAreaL = new JSpinner(new SpinnerNumberModel(0, 0, Utils.maxXCoord, 1));
    private final JSpinner spinnerPrintableAreaW = new JSpinner(new SpinnerNumberModel(0, 0, Utils.maxCardLength, 1));
    private final JSpinner spinnerPrintableAreaB = new JSpinner(new SpinnerNumberModel(0, 0, 641, 1));
    private final JSpinner spinnerPrintableAreaH = new JSpinner(new SpinnerNumberModel(0, 0, 642, 1));
    private final JButton btnPrintableArea = new JButton("Printable Area");
    private final JPanel panelResolution = new JPanel();
    private final JRadioButton rdbtn300DPI = new JRadioButton("300 x 300 DPI");
    private final ButtonGroup buttonGroupResolution = new ButtonGroup();
    private final JTextArea textDriver1Msg = new JTextArea();
    private final JScrollPane scrollPane = new JScrollPane(this.textDriver1Msg);
    private final JButton btnClear = new JButton("Clear");
    private WinNT.HANDLE hSession;
    private SDKlib SDK;
    public final JRadioButton rdbtn600DPI = new JRadioButton("600 x 300 DPI");
    public final JButton btnResolution = new JButton("Resolution");

    public Driver1() {
        panelDriver1.setLayout(new MigLayout("", "[pref!][203.00,grow]", "[][][grow][][][110.00][28.00]"));
        panelDriver1.add((Component)this.panelAction, "cell 0 0 2 1,alignx center");
        this.panelAction.setLayout(new MigLayout("insets 0", "[][][]", "[]"));
        this.panelAction.add((Component)this.labelAction, "flowx,cell 0 0 3 0,alignx left");
        this.panelAction.add((Component)this.rdbtnGet, "cell 0 0");
        this.buttonGroup.add(this.rdbtnGet);
        this.rdbtnGet.setActionCommand("RADIOGET");
        this.rdbtnGet.addActionListener(this.ah);
        this.rdbtnGet.setSelected(true);
        this.panelAction.add((Component)this.rdbtnSet, "cell 0 0");
        this.buttonGroup.add(this.rdbtnSet);
        this.rdbtnSet.setActionCommand("RADIOSET");
        this.rdbtnSet.addActionListener(this.ah);
        panelDriver1.add((Component)this.panelGeneral, "cell 0 1,grow");
        this.panelGeneral.setLayout(new MigLayout("", "[100.00,grow][grow][grow]", "[][][][]"));
        this.panelGeneral.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        this.panelGeneral.add((Component)this.btnGUIControl, "cell 0 0,growx");
        this.checkUser.setEnabled(false);
        this.panelGeneral.add((Component)this.checkUser, "cell 1 0,alignx right");
        this.checkPrinter.setEnabled(false);
        this.panelGeneral.add((Component)this.checkPrinter, "cell 2 0,alignx right");
        this.btnGUIControl.setActionCommand("GUICONTROL");
        this.btnGUIControl.addActionListener(this.ah);
        this.panelGeneral.add((Component)this.btnSharpness, "cell 0 1,growx");
        this.spinnerSharpness.setEnabled(false);
        this.panelGeneral.add((Component)this.spinnerSharpness, "cell 1 1 2 1,growx");
        this.btnSharpness.setActionCommand("SHARPNESS");
        this.btnSharpness.addActionListener(this.ah);
        this.panelGeneral.add((Component)this.btnColour, "cell 0 2,growx");
        this.comboCorrection.setEnabled(false);
        this.panelGeneral.add(this.comboCorrection, "cell 1 2 2 1,growx");
        Driver1.InitCorrectionCombo(this.comboCorrection);
        this.btnColour.setActionCommand("COLOUR");
        this.btnColour.addActionListener(this.ah);
        this.panelGeneral.add((Component)this.btnPrintSpeed, "cell 0 3,growx");
        this.comboPrintSpeed.setEnabled(false);
        this.panelGeneral.add(this.comboPrintSpeed, "cell 1 3 2 1,growx");
        this.comboPrintSpeed.addItem(new ComboItem("High", 0));
        this.comboPrintSpeed.addItem(new ComboItem("Normal", 1));
        this.btnPrintSpeed.setActionCommand("PRINTSPEED");
        this.btnPrintSpeed.addActionListener(this.ah);
        panelDriver1.add((Component)this.panelPowerLevel, "cell 0 2,grow");
        this.panelPowerLevel.setLayout(new MigLayout("", "[grow 33,center][grow 33,center][grow 33,center]", "[][][]"));
        this.panelPowerLevel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        this.panelPowerLevel.add((Component)this.labelYMC, "cell 0 0");
        this.panelPowerLevel.add((Component)this.labelResin, "cell 1 0");
        this.panelPowerLevel.add((Component)this.labelOvercoat, "cell 2 0");
        this.spinnerYMCPower.setEnabled(false);
        this.panelPowerLevel.add((Component)this.spinnerYMCPower, "cell 0 1,growx");
        this.spinnerResinPower.setEnabled(false);
        this.panelPowerLevel.add((Component)this.spinnerResinPower, "cell 1 1,growx");
        this.spinnerOvercoatPower.setEnabled(false);
        this.panelPowerLevel.add((Component)this.spinnerOvercoatPower, "cell 2 1,growx");
        this.panelPowerLevel.add((Component)this.btnPowerLevel, "cell 0 2 3 1,alignx center");
        this.btnPowerLevel.setActionCommand("POWERLEVEL");
        this.btnPowerLevel.addActionListener(this.ah);
        panelDriver1.add((Component)this.panelResinArea, "cell 0 3,grow");
        this.panelResinArea.setLayout(new MigLayout("", "[grow][grow][grow][grow]", "[][][][]"));
        this.panelResinArea.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        this.panelResinArea.add((Component)this.labelResinSide, "flowx,cell 0 0 2 1,alignx left");
        this.panelResinArea.add(this.comboResinAreaSide, "cell 0 0 2 1,growx");
        this.comboResinAreaSide.addItem(new ComboItem("Front", 0));
        this.comboResinAreaSide.addItem(new ComboItem("Back", 1));
        this.comboResinAreaSide.setActionCommand("RASIDE");
        this.comboResinAreaSide.addActionListener(this.ah);
        this.panelResinArea.add((Component)this.labelResinAreaNo, "cell 2 0,alignx right");
        this.panelResinArea.add((Component)this.spinnerResinAreaNo, "cell 3 0,growx");
        this.spinnerResinAreaNo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Driver1.this.ResinAreaChanged();
            }
        });
        this.panelResinArea.add((Component)this.labelResinL, "cell 0 1,alignx center");
        this.panelResinArea.add((Component)this.labelResinW, "cell 1 1,alignx center");
        this.panelResinArea.add((Component)this.labelResinB, "cell 2 1,alignx center");
        this.panelResinArea.add((Component)this.labelResinH, "cell 3 1,alignx center");
        this.spinnerResinL.setEnabled(false);
        this.spinnerResinL.setEditor(new JSpinner.NumberEditor(this.spinnerResinL, "#"));
        this.panelResinArea.add((Component)this.spinnerResinL, "cell 0 2,growx");
        this.spinnerResinW.setEnabled(false);
        this.spinnerResinW.setEditor(new JSpinner.NumberEditor(this.spinnerResinW, "#"));
        this.panelResinArea.add((Component)this.spinnerResinW, "cell 1 2,growx");
        this.spinnerResinB.setEnabled(false);
        this.spinnerResinB.setEditor(new JSpinner.NumberEditor(this.spinnerResinB, "#"));
        this.panelResinArea.add((Component)this.spinnerResinB, "cell 2 2,growx");
        this.spinnerResinH.setEnabled(false);
        this.spinnerResinH.setEditor(new JSpinner.NumberEditor(this.spinnerResinH, "#"));
        this.panelResinArea.add((Component)this.spinnerResinH, "cell 3 2,growx");
        this.panelResinArea.add((Component)this.btnResinArea, "cell 0 3 4 1,alignx center");
        this.btnResinArea.setActionCommand("RESINAREA");
        this.btnResinArea.addActionListener(this.ah);
        panelDriver1.add((Component)this.panelAreaHole, "cell 0 4,grow");
        this.panelAreaHole.setLayout(new MigLayout("", "[grow][grow][grow][grow][grow]", "[][][][][]"));
        this.panelAreaHole.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        this.panelAreaHole.add((Component)this.labelAreaHoleSide, "flowx,cell 0 0");
        this.panelAreaHole.add(this.comboAreaHoleSide, "cell 1 0 2 1,growx");
        this.comboAreaHoleSide.addItem(new ComboItem("Front", 0));
        this.comboAreaHoleSide.addItem(new ComboItem("Back", 1));
        this.comboAreaHoleSide.setActionCommand("AHSIDE");
        this.comboAreaHoleSide.addActionListener(this.ah);
        this.panelAreaHole.add((Component)this.labelAreaHoleType, "flowx,cell 0 1");
        this.panelAreaHole.add(this.comboAreaHoleType, "cell 1 1 2 1,growx");
        this.comboAreaHoleType.addItem(new ComboItem("Area", 0));
        this.comboAreaHoleType.addItem(new ComboItem("Hole", 1));
        this.comboAreaHoleType.setActionCommand("AHTYPE");
        this.comboAreaHoleType.addActionListener(this.ah);
        this.panelAreaHole.add((Component)this.labelAreaHoleNo, "cell 3 1,alignx right");
        this.panelAreaHole.add((Component)this.spinnerAreaHoleNo, "cell 4 1,growx");
        this.spinnerAreaHoleNo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Driver1.this.AreaHoleChanged();
            }
        });
        this.panelAreaHole.add((Component)this.labelAreaHoleL, "cell 0 2 2 1,alignx center");
        this.spinnerAreaHoleL.setEnabled(false);
        this.spinnerAreaHoleL.setEditor(new JSpinner.NumberEditor(this.spinnerAreaHoleL, "#"));
        this.panelAreaHole.add((Component)this.spinnerAreaHoleL, "cell 0 3 2 1,growx");
        this.panelAreaHole.add((Component)this.labelAreaHoleW, "cell 2 2,alignx center");
        this.spinnerAreaHoleW.setEnabled(false);
        this.spinnerAreaHoleW.setEditor(new JSpinner.NumberEditor(this.spinnerAreaHoleW, "#"));
        this.panelAreaHole.add((Component)this.spinnerAreaHoleW, "cell 2 3,growx");
        this.panelAreaHole.add((Component)this.labelAreaHoleB, "cell 3 2,alignx center");
        this.spinnerAreaHoleB.setEnabled(false);
        this.spinnerAreaHoleB.setEditor(new JSpinner.NumberEditor(this.spinnerAreaHoleB, "#"));
        this.panelAreaHole.add((Component)this.spinnerAreaHoleB, "cell 3 3,growx");
        this.panelAreaHole.add((Component)this.labelAreaHoleH, "cell 4 2,alignx center");
        this.spinnerAreaHoleH.setEnabled(false);
        this.spinnerAreaHoleH.setEditor(new JSpinner.NumberEditor(this.spinnerAreaHoleH, "#"));
        this.panelAreaHole.add((Component)this.spinnerAreaHoleH, "cell 4 3,growx");
        this.panelAreaHole.add((Component)this.btnAreaHole, "cell 0 4 5 1,alignx center");
        this.btnAreaHole.setActionCommand("AREAHOLE");
        this.btnAreaHole.addActionListener(this.ah);
        panelDriver1.add((Component)this.panelRewritable, "cell 0 5 1 2,grow");
        this.panelRewritable.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        this.panelRewritable.setLayout(new MigLayout("", "[grow][grow][grow][grow]", "[][][][][][]"));
        this.panelRewritable.add((Component)this.labelL, "cell 0 0,alignx center");
        this.panelRewritable.add((Component)this.labelW, "cell 1 0,alignx center");
        this.panelRewritable.add((Component)this.labelB, "cell 2 0,alignx center");
        this.panelRewritable.add((Component)this.labelH, "cell 3 0,alignx center");
        this.spinnerEraseAreaL.setEnabled(false);
        this.spinnerEraseAreaL.setEditor(new JSpinner.NumberEditor(this.spinnerEraseAreaL, "#"));
        this.panelRewritable.add((Component)this.spinnerEraseAreaL, "cell 0 1,growx");
        this.spinnerEraseAreaW.setEnabled(false);
        this.spinnerEraseAreaW.setEditor(new JSpinner.NumberEditor(this.spinnerEraseAreaW, "#"));
        this.panelRewritable.add((Component)this.spinnerEraseAreaW, "cell 1 1,growx");
        this.spinnerEraseAreaB.setEnabled(false);
        this.spinnerEraseAreaB.setEditor(new JSpinner.NumberEditor(this.spinnerEraseAreaB, "#"));
        this.panelRewritable.add((Component)this.spinnerEraseAreaB, "cell 2 1,growx");
        this.spinnerEraseAreaH.setEnabled(false);
        this.spinnerEraseAreaH.setEditor(new JSpinner.NumberEditor(this.spinnerEraseAreaH, "#"));
        this.panelRewritable.add((Component)this.spinnerEraseAreaH, "cell 3 1,growx");
        this.panelRewritable.add((Component)this.labelPower, "cell 0 2");
        this.panelRewritable.add((Component)this.labelWritePower, "cell 0 3");
        this.spinnerEraseWrite.setEnabled(false);
        this.panelRewritable.add((Component)this.spinnerEraseWrite, "cell 1 3,growx");
        this.checkEraseBeforePrint.setEnabled(false);
        this.panelRewritable.add((Component)this.checkEraseBeforePrint, "cell 2 3 2 1,alignx right");
        this.panelRewritable.add((Component)this.labelStartPower, "cell 0 4");
        this.spinnerEraseStart.setEnabled(false);
        this.panelRewritable.add((Component)this.spinnerEraseStart, "cell 1 4,growx");
        this.panelRewritable.add((Component)this.labelEndPower, "cell 2 4");
        this.spinnerEraseEnd.setEnabled(false);
        this.panelRewritable.add((Component)this.spinnerEraseEnd, "cell 3 4,growx");
        this.panelRewritable.add((Component)this.btnRewritable, "cell 0 5 4 1,alignx center");
        this.btnRewritable.setActionCommand("REWRITABLE");
        this.btnRewritable.addActionListener(this.ah);
        panelDriver1.add((Component)this.panelPrintableArea, "cell 1 1,grow");
        this.panelPrintableArea.setLayout(new MigLayout("", "[grow][grow][grow][grow]", "[grow][grow][grow]"));
        this.panelPrintableArea.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        this.panelPrintableArea.add((Component)this.labelPrintableAreaL, "cell 0 0,alignx center");
        this.spinnerPrintableAreaL.setEnabled(false);
        this.spinnerPrintableAreaL.setEditor(new JSpinner.NumberEditor(this.spinnerPrintableAreaL, "#"));
        this.panelPrintableArea.add((Component)this.spinnerPrintableAreaL, "cell 1 0,growx");
        this.panelPrintableArea.add((Component)this.labelPrintableAreaB, "cell 2 0,alignx center");
        this.spinnerPrintableAreaB.setEnabled(false);
        this.spinnerPrintableAreaB.setEditor(new JSpinner.NumberEditor(this.spinnerPrintableAreaB, "#"));
        this.panelPrintableArea.add((Component)this.spinnerPrintableAreaB, "cell 3 0,growx");
        this.panelPrintableArea.add((Component)this.labelPrintableAreaW, "cell 0 1,alignx center");
        this.spinnerPrintableAreaW.setEnabled(false);
        this.spinnerPrintableAreaW.setEditor(new JSpinner.NumberEditor(this.spinnerPrintableAreaW, "#"));
        this.panelPrintableArea.add((Component)this.spinnerPrintableAreaW, "cell 1 1,growx");
        this.panelPrintableArea.add((Component)this.labelPrintableAreaH, "cell 2 1,alignx center");
        this.spinnerPrintableAreaH.setEnabled(false);
        this.spinnerPrintableAreaH.setEditor(new JSpinner.NumberEditor(this.spinnerPrintableAreaH, "#"));
        this.panelPrintableArea.add((Component)this.spinnerPrintableAreaH, "cell 3 1,growx");
        this.panelPrintableArea.add((Component)this.btnPrintableArea, "cell 0 2 4 1,alignx center");
        this.btnPrintableArea.setActionCommand("PRINTABLEAREA");
        this.btnPrintableArea.addActionListener(this.ah);
        panelDriver1.add((Component)this.panelResolution, "cell 1 2,grow");
        this.panelResolution.setLayout(new MigLayout("", "[grow][grow][grow]", "[][][]"));
        this.panelResolution.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        this.rdbtn300DPI.setEnabled(false);
        this.panelResolution.add((Component)this.rdbtn300DPI, "cell 0 0 3 1,alignx center");
        this.rdbtn600DPI.setEnabled(false);
        this.panelResolution.add((Component)this.rdbtn600DPI, "cell 0 1 3 1,alignx center");
        this.btnResolution.setEnabled(false);
        this.panelResolution.add((Component)this.btnResolution, "cell 1 2,alignx center");
        this.buttonGroupResolution.add(this.rdbtn300DPI);
        this.buttonGroupResolution.add(this.rdbtn600DPI);
        this.btnResolution.setActionCommand("RESOLUTION");
        this.btnResolution.addActionListener(this.ah);
        panelDriver1.add((Component)this.scrollPane, "flowy,cell 1 3 1 3,grow");
        this.textDriver1Msg.setBorder(BorderFactory.createLineBorder(Color.black));
        panelDriver1.add((Component)this.btnClear, "cell 1 6,alignx center");
        this.btnClear.setActionCommand("CLEAR");
        this.btnClear.addActionListener(this.ah);
    }

    void Init(WinNT.HANDLE handle, SDKlib sdk) {
        Main.tabbedPane.addTab(DRIVER1_TAB_TITLE, null, panelDriver1, null);
        this.hSession = handle;
        this.SDK = sdk;
        this.spinnerResinL.setModel(new SpinnerNumberModel(0, 0, Utils.maxXCoord, 1));
        this.spinnerResinW.setModel(new SpinnerNumberModel(0, 0, Utils.maxCardLength, 1));
        this.spinnerAreaHoleL.setModel(new SpinnerNumberModel(0, 0, Utils.maxXCoord, 1));
        this.spinnerAreaHoleW.setModel(new SpinnerNumberModel(0, 0, Utils.maxCardLength, 1));
        this.spinnerEraseAreaL.setModel(new SpinnerNumberModel(0, 0, Utils.maxXCoord, 1));
        this.spinnerEraseAreaW.setModel(new SpinnerNumberModel(0, 0, Utils.maxCardLength, 1));
        this.GetGUIControl(new SDKlib.GUIControl());
        this.GetSharpness(new ByteByReference());
        this.GetCorrection(new ByteByReference());
        this.GetResinArea((byte)0, (byte)1, new SDKlib.Area());
        this.GetAreaHole((byte)0, (byte)0, (byte)1, new SDKlib.Area());
        this.GetRewritable(new SDKlib.Rewritable());
        if (Utils.connectedPrinter == 4) {
            this.btnPrintSpeed.setVisible(false);
            this.comboPrintSpeed.setVisible(false);
            this.spinnerYMCPower.setModel(new SpinnerNumberModel(new Byte("0"), new Byte("-100"), new Byte("100"), new Byte("1")));
            this.spinnerResinPower.setModel(new SpinnerNumberModel(new Byte("0"), new Byte("-100"), new Byte("100"), new Byte("1")));
            this.spinnerOvercoatPower.setModel(new SpinnerNumberModel(new Byte("0"), new Byte("-100"), new Byte("100"), new Byte("1")));
        } else {
            this.btnPrintSpeed.setVisible(true);
            this.comboPrintSpeed.setVisible(true);
            this.GetPrintSpeed(new ByteByReference());
        }
        this.GetPowerLevels(new SDKlib.PowerLevel());
    }

    void Selected() {
        if (this.PrinterIs600DPICapable()) {
            ByteByReference resolution = new ByteByReference();
            this.GetResolution(resolution);
            this.btnResolution.setEnabled(true);
        }
    }

    static void InitCorrectionCombo(JComboBox<ComboItem> combo) {
        combo.addItem(new ComboItem("None", 0));
        combo.addItem(new ComboItem("Gamma 1", 1));
        combo.addItem(new ComboItem("Gamma 2", 2));
        combo.addItem(new ComboItem("ICC Internal", 3));
        combo.addItem(new ComboItem("ICC External", 4));
        combo.addItem(new ComboItem("Perceptual", 5));
        combo.addItem(new ComboItem("Saturation", 6));
        combo.addItem(new ComboItem("Rel. Colorimetric", 7));
        combo.addItem(new ComboItem("Abs. Colorimetric", 8));
    }

    private void GetSetControls(Boolean State) {
        this.checkUser.setEnabled(State);
        this.checkPrinter.setEnabled(State);
        this.spinnerSharpness.setEnabled(State);
        this.comboCorrection.setEnabled(State);
        this.comboPrintSpeed.setEnabled(State);
        this.spinnerYMCPower.setEnabled(State);
        this.spinnerResinPower.setEnabled(State);
        this.spinnerOvercoatPower.setEnabled(State);
        this.spinnerResinL.setEnabled(State);
        this.spinnerResinW.setEnabled(State);
        this.spinnerResinB.setEnabled(State);
        this.spinnerResinH.setEnabled(State);
        this.spinnerAreaHoleL.setEnabled(State);
        this.spinnerAreaHoleW.setEnabled(State);
        this.spinnerAreaHoleB.setEnabled(State);
        this.spinnerAreaHoleH.setEnabled(State);
        this.spinnerEraseAreaL.setEnabled(State);
        this.spinnerEraseAreaW.setEnabled(State);
        this.spinnerEraseAreaB.setEnabled(State);
        this.spinnerEraseAreaH.setEnabled(State);
        this.spinnerEraseStart.setEnabled(State);
        this.spinnerEraseEnd.setEnabled(State);
        this.spinnerEraseWrite.setEnabled(State);
        this.checkEraseBeforePrint.setEnabled(State);
        switch (Utils.connectedPrinter) {
            case 2: {
                this.comboPrintSpeed.setEnabled(State);
                break;
            }
            case 4: {
                this.spinnerPrintableAreaL.setEnabled(State);
                this.spinnerPrintableAreaW.setEnabled(State);
                this.spinnerPrintableAreaB.setEnabled(State);
                this.spinnerPrintableAreaH.setEnabled(State);
                if (!this.PrinterIs600DPICapable()) break;
                this.rdbtn300DPI.setEnabled(State);
                this.rdbtn600DPI.setEnabled(State);
            }
        }
    }

    public boolean PrinterIs600DPICapable() {
        if (Utils.connectedPrinter != 4) {
            return false;
        }
        return (this.SDK.ID_PrinterModel(this.hSession) & 0x4000) != 0;
    }

    private void ClearMsg() {
        this.textDriver1Msg.setText(null);
    }

    private void GUIControlToMsgBox(byte action, SDKlib.GUIControl GUI) {
        String sep = Utils.Separator(action);
        this.textDriver1Msg.append("GUI User" + sep + Utils.EnabledDisabledString(GUI.user) + "\n" + "GUI Printer" + sep + Utils.EnabledDisabledString(GUI.printer) + "\n\n");
    }

    private byte GetGUIControl(SDKlib.GUIControl GUI) {
        byte sdkReturn = this.SDK.ID_GUIControl(this.hSession, (byte)0, GUI);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetGUIControl", sdkReturn);
        } else {
            this.checkUser.setSelected(GUI.user);
            this.checkPrinter.setSelected(GUI.printer);
        }
        return sdkReturn;
    }

    private void GUIControl() {
        SDKlib.GUIControl GUI = new SDKlib.GUIControl();
        if (this.rdbtnGet.isSelected()) {
            if (this.GetGUIControl(GUI) == 0) {
                this.GUIControlToMsgBox((byte)0, GUI);
            }
        } else {
            GUI.user = this.checkUser.isSelected();
            GUI.printer = this.checkPrinter.isSelected();
            byte sdkReturn = this.SDK.ID_GUIControl(this.hSession, (byte)1, GUI);
            if (sdkReturn != 0) {
                Utils.DisplayError("SetGUIControl", sdkReturn);
            } else {
                this.GUIControlToMsgBox((byte)1, GUI);
            }
        }
    }

    private void SharpnessToMsgBox(byte action, byte sharpness) {
        this.textDriver1Msg.append("Sharpness" + Utils.Separator(action) + sharpness + "\n\n");
    }

    private byte GetSharpness(ByteByReference sharpness) {
        byte sdkReturn = this.SDK.ID_Sharpness(this.hSession, (byte)0, sharpness);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetSharpness", sdkReturn);
        } else {
            this.spinnerSharpness.setValue(sharpness.getValue());
        }
        return sdkReturn;
    }

    private void Sharpness() {
        ByteByReference sharpness = new ByteByReference();
        if (this.rdbtnGet.isSelected()) {
            if (this.GetSharpness(sharpness) == 0) {
                this.SharpnessToMsgBox((byte)0, sharpness.getValue());
            }
        } else {
            sharpness.setValue((Byte)this.spinnerSharpness.getValue());
            byte sdkReturn = this.SDK.ID_Sharpness(this.hSession, (byte)1, sharpness);
            if (sdkReturn != 0) {
                Utils.DisplayError("SetSharpness", sdkReturn);
            } else {
                this.SharpnessToMsgBox((byte)1, sharpness.getValue());
            }
        }
    }

    private String CorrectionString(byte correction) {
        return ((ComboItem)this.comboCorrection.getSelectedItem()).toString();
    }

    private void CorrectionToMsgBox(byte action, byte correction) {
        this.textDriver1Msg.append("Correction" + Utils.Separator(action) + this.CorrectionString(correction) + "\n\n");
    }

    private byte GetCorrection(ByteByReference correction) {
        byte sdkReturn = this.SDK.ID_ColourCorrection(this.hSession, (byte)0, correction);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetColourCorrection", sdkReturn);
        } else {
            this.comboCorrection.setSelectedIndex(correction.getValue());
        }
        return sdkReturn;
    }

    private void ColourCorrection() {
        ByteByReference correction = new ByteByReference(((ComboItem)this.comboCorrection.getSelectedItem()).getValue());
        if (this.rdbtnGet.isSelected()) {
            if (this.GetCorrection(correction) == 0) {
                this.CorrectionToMsgBox((byte)0, correction.getValue());
            }
        } else {
            byte sdkReturn = this.SDK.ID_ColourCorrection(this.hSession, (byte)1, correction);
            if (sdkReturn != 0) {
                Utils.DisplayError("SetColourCorrection", sdkReturn);
            } else {
                this.CorrectionToMsgBox((byte)1, correction.getValue());
            }
        }
    }

    private void PowerLevelToMsgBox(byte action, SDKlib.PowerLevel Power) {
        String sep = Utils.Separator(action);
        this.textDriver1Msg.append("Power Level YMC" + sep + Power.ymc + "\n" + "Power Level Resin" + sep + Power.resin + "\n" + "Power Level Overcoat" + sep + Power.overcoat + "\n\n");
    }

    private byte GetPowerLevels(SDKlib.PowerLevel Power) {
        byte sdkReturn = this.SDK.ID_PowerLevel(this.hSession, (byte)0, Power);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetPowerLevel", sdkReturn);
        } else {
            this.spinnerYMCPower.setValue(Power.ymc);
            this.spinnerResinPower.setValue(Power.resin);
            this.spinnerOvercoatPower.setValue(Power.overcoat);
        }
        return sdkReturn;
    }

    private void PowerLevel() {
        SDKlib.PowerLevel Power = new SDKlib.PowerLevel();
        if (this.rdbtnGet.isSelected()) {
            if (this.GetPowerLevels(Power) == 0) {
                this.PowerLevelToMsgBox((byte)0, Power);
            }
        } else {
            Power.ymc = (Byte)this.spinnerYMCPower.getValue();
            Power.resin = (Byte)this.spinnerResinPower.getValue();
            Power.overcoat = (Byte)this.spinnerOvercoatPower.getValue();
            byte sdkReturn = this.SDK.ID_PowerLevel(this.hSession, (byte)1, Power);
            if (sdkReturn != 0) {
                Utils.DisplayError("SetPowerLevel", sdkReturn);
            } else {
                this.PowerLevelToMsgBox((byte)1, Power);
            }
        }
    }

    private void PrintSpeedToMsgBox(byte action, byte speed) {
        this.textDriver1Msg.append("Print Speed" + Utils.Separator(action) + (speed == 0 ? "High" : "Normal") + "\n\n");
    }

    private byte GetPrintSpeed(ByteByReference speed) {
        byte sdkReturn = this.SDK.ID_PrintSpeed(this.hSession, (byte)0, speed);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetPrintSpeed", sdkReturn);
        } else {
            this.comboPrintSpeed.setSelectedIndex(speed.getValue());
        }
        return sdkReturn;
    }

    private void PrintSpeed() {
        ByteByReference speed = new ByteByReference(((ComboItem)this.comboPrintSpeed.getSelectedItem()).getValue());
        if (this.rdbtnGet.isSelected()) {
            if (this.GetPrintSpeed(speed) == 0) {
                this.PrintSpeedToMsgBox((byte)0, speed.getValue());
            }
        } else {
            byte sdkReturn = this.SDK.ID_PrintSpeed(this.hSession, (byte)1, speed);
            if (sdkReturn != 0) {
                Utils.DisplayError("SetPrintSpeed", sdkReturn);
            } else {
                this.PrintSpeedToMsgBox((byte)1, speed.getValue());
            }
        }
    }

    private void ResinAreaChanged() {
        SDKlib.Area RA = new SDKlib.Area();
        if (this.GetResinArea(((ComboItem)this.comboResinAreaSide.getSelectedItem()).getValue(), (Byte)this.spinnerResinAreaNo.getValue(), RA) == 0) {
            this.ResinAreaDisplay(RA);
        }
    }

    private void ResinAreaDisplay(SDKlib.Area RA) {
        this.spinnerResinL.setValue(RA.left);
        this.spinnerResinW.setValue(RA.width);
        this.spinnerResinB.setValue(RA.bottom);
        this.spinnerResinH.setValue(RA.height);
    }

    private void ResinAreaToMsgBox(byte action, byte areaNo, byte side, SDKlib.Area RA) {
        String sep = Utils.Separator(action);
        this.textDriver1Msg.append("Resin Area " + ((ComboItem)this.comboResinAreaSide.getSelectedItem()).toString() + " " + areaNo + "\n" + "Left" + sep + RA.left + "\n" + "Width" + sep + RA.width + "\n" + "Bottom" + sep + RA.bottom + "\n" + "Height" + sep + RA.height + "\n\n");
    }

    private byte GetResinArea(byte side, byte areaNo, SDKlib.Area RA) {
        byte sdkReturn = this.SDK.ID_ResinArea(this.hSession, (byte)0, side, areaNo, RA);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetResinArea", sdkReturn);
        } else {
            this.ResinAreaDisplay(RA);
        }
        return sdkReturn;
    }

    private void ResinArea() {
        SDKlib.Area RA = new SDKlib.Area();
        byte side = ((ComboItem)this.comboResinAreaSide.getSelectedItem()).getValue();
        byte areaNo = (Byte)this.spinnerResinAreaNo.getValue();
        if (this.rdbtnGet.isSelected()) {
            if (this.GetResinArea(side, areaNo, RA) == 0) {
                this.ResinAreaToMsgBox((byte)0, areaNo, side, RA);
            }
        } else {
            RA.left = (Integer)this.spinnerResinL.getValue();
            RA.width = (Integer)this.spinnerResinW.getValue();
            RA.bottom = (Integer)this.spinnerResinB.getValue();
            RA.height = (Integer)this.spinnerResinH.getValue();
            byte sdkReturn = this.SDK.ID_ResinArea(this.hSession, (byte)1, side, areaNo, RA);
            if (sdkReturn != 0) {
                Utils.DisplayError("SetResinArea", sdkReturn);
            } else {
                this.ResinAreaToMsgBox((byte)1, areaNo, side, RA);
            }
        }
    }

    private void AreaHoleChanged() {
        SDKlib.Area RA = new SDKlib.Area();
        if (this.GetAreaHole(((ComboItem)this.comboAreaHoleSide.getSelectedItem()).getValue(), ((ComboItem)this.comboAreaHoleType.getSelectedItem()).getValue(), (Byte)this.spinnerAreaHoleNo.getValue(), RA) == 0) {
            this.AreaHoleDisplay(RA);
        }
    }

    private void AreaHoleDisplay(SDKlib.Area RA) {
        this.spinnerAreaHoleL.setValue(RA.left);
        this.spinnerAreaHoleW.setValue(RA.width);
        this.spinnerAreaHoleB.setValue(RA.bottom);
        this.spinnerAreaHoleH.setValue(RA.height);
    }

    private void AreaHoleToMsgBox(byte action, byte side, byte type, byte areaNo, SDKlib.Area RA) {
        String sep = Utils.Separator(action);
        this.textDriver1Msg.append("Area/Hole " + ((ComboItem)this.comboAreaHoleSide.getSelectedItem()).toString() + (type == 1 ? " Hole " : " Area ") + areaNo + "\n" + "Left" + sep + RA.left + "\n" + "Width" + sep + RA.width + "\n" + "Bottom" + sep + RA.bottom + "\n" + "Height" + sep + RA.height + "\n\n");
    }

    private byte GetAreaHole(byte side, byte type, byte areaNo, SDKlib.Area RA) {
        byte sdkReturn = this.SDK.ID_AreaHole(this.hSession, (byte)0, side, type, areaNo, RA);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetAreaHole", sdkReturn);
        } else {
            this.AreaHoleDisplay(RA);
        }
        return sdkReturn;
    }

    private void AreaHole() {
        SDKlib.Area RA = new SDKlib.Area();
        byte side = ((ComboItem)this.comboAreaHoleSide.getSelectedItem()).getValue();
        byte type = ((ComboItem)this.comboAreaHoleType.getSelectedItem()).getValue();
        byte areaNo = (Byte)this.spinnerResinAreaNo.getValue();
        if (this.rdbtnGet.isSelected()) {
            if (this.GetAreaHole(side, type, areaNo, RA) == 0) {
                this.AreaHoleToMsgBox((byte)0, side, type, areaNo, RA);
            }
        } else {
            RA.left = (Integer)this.spinnerAreaHoleL.getValue();
            RA.width = (Integer)this.spinnerAreaHoleW.getValue();
            RA.bottom = (Integer)this.spinnerAreaHoleB.getValue();
            RA.height = (Integer)this.spinnerAreaHoleH.getValue();
            byte sdkReturn = this.SDK.ID_AreaHole(this.hSession, (byte)1, side, type, areaNo, RA);
            if (sdkReturn != 0) {
                Utils.DisplayError("SetAreaHole", sdkReturn);
            } else {
                this.AreaHoleToMsgBox((byte)1, side, type, areaNo, RA);
            }
        }
    }

    private void RewritableToMsgBox(byte action, SDKlib.Rewritable Rewrite) {
        String sep = Utils.Separator(action);
        this.textDriver1Msg.append("Erase Area" + sep + Rewrite.eraseArea.left + "," + Rewrite.eraseArea.width + "," + Rewrite.eraseArea.bottom + "," + Rewrite.eraseArea.height + "\n" + "Erase Before Print" + sep + Utils.OnOffString(Rewrite.eraseBeforePrint) + "\n" + "Erase Power Start" + sep + Rewrite.erasePowerStart + "\n" + "Erase Power End" + sep + Rewrite.erasePowerEnd + "\n" + "Write Power" + sep + Rewrite.writePower + "\n\n");
    }

    private byte GetRewritable(SDKlib.Rewritable Rewrite) {
        byte sdkReturn = this.SDK.ID_Rewritable(this.hSession, (byte)0, Rewrite);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetRewritable", sdkReturn);
        } else {
            this.spinnerEraseAreaL.setValue(Rewrite.eraseArea.left);
            this.spinnerEraseAreaW.setValue(Rewrite.eraseArea.width);
            this.spinnerEraseAreaB.setValue(Rewrite.eraseArea.bottom);
            this.spinnerEraseAreaH.setValue(Rewrite.eraseArea.height);
            this.checkEraseBeforePrint.setSelected(Rewrite.eraseBeforePrint);
            this.spinnerEraseStart.setValue(Rewrite.erasePowerStart);
            this.spinnerEraseEnd.setValue(Rewrite.erasePowerEnd);
            this.spinnerEraseWrite.setValue(Rewrite.writePower);
        }
        return sdkReturn;
    }

    private void Rewritable() {
        SDKlib.Rewritable Rewrite = new SDKlib.Rewritable();
        if (this.rdbtnGet.isSelected()) {
            if (this.GetRewritable(Rewrite) == 0) {
                this.RewritableToMsgBox((byte)0, Rewrite);
            }
        } else {
            Rewrite.eraseArea.left = (Integer)this.spinnerEraseAreaL.getValue();
            Rewrite.eraseArea.width = (Integer)this.spinnerEraseAreaW.getValue();
            Rewrite.eraseArea.bottom = (Integer)this.spinnerEraseAreaB.getValue();
            Rewrite.eraseArea.height = (Integer)this.spinnerEraseAreaH.getValue();
            Rewrite.eraseBeforePrint = this.checkEraseBeforePrint.isSelected();
            Rewrite.erasePowerStart = (Byte)this.spinnerEraseStart.getValue();
            Rewrite.erasePowerEnd = (Byte)this.spinnerEraseEnd.getValue();
            Rewrite.writePower = (Byte)this.spinnerEraseWrite.getValue();
            byte sdkReturn = this.SDK.ID_Rewritable(this.hSession, (byte)1, Rewrite);
            if (sdkReturn != 0) {
                Utils.DisplayError("SetRewritable", sdkReturn);
            } else {
                this.RewritableToMsgBox((byte)1, Rewrite);
            }
        }
    }

    private void PrintableAreaDisplay(SDKlib.Area RA) {
        this.spinnerPrintableAreaL.setValue(RA.left);
        this.spinnerPrintableAreaW.setValue(RA.width);
        this.spinnerPrintableAreaB.setValue(RA.bottom);
        this.spinnerPrintableAreaH.setValue(RA.height);
    }

    private void PrintableAreaToMsgBox(byte action, SDKlib.Area RA) {
        String sep = Utils.Separator(action);
        this.textDriver1Msg.append("Printable Area Left" + sep + RA.left + "\n" + "Width" + sep + RA.width + "\n" + "Bottom" + sep + RA.bottom + "\n" + "Height" + sep + RA.height + "\n\n");
    }

    private byte GetPrintableArea(SDKlib.Area RA) {
        byte sdkReturn = this.SDK.ID_PrintableArea(this.hSession, (byte)0, RA);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetPrintableArea", sdkReturn);
        } else {
            this.PrintableAreaDisplay(RA);
        }
        return sdkReturn;
    }

    private void PrintableArea() {
        SDKlib.Area RA = new SDKlib.Area();
        if (this.rdbtnGet.isSelected()) {
            if (this.GetPrintableArea(RA) == 0) {
                this.PrintableAreaToMsgBox((byte)0, RA);
            }
        } else {
            RA.left = (Integer)this.spinnerPrintableAreaL.getValue();
            RA.width = (Integer)this.spinnerPrintableAreaW.getValue();
            RA.bottom = (Integer)this.spinnerPrintableAreaB.getValue();
            RA.height = (Integer)this.spinnerPrintableAreaH.getValue();
            byte sdkReturn = this.SDK.ID_PrintableArea(this.hSession, (byte)1, RA);
            if (sdkReturn != 0) {
                Utils.DisplayError("SetPrintableArea", sdkReturn);
            } else {
                this.PrintableAreaToMsgBox((byte)1, RA);
            }
        }
    }

    public byte GetResolution(ByteByReference resolution) {
        byte sdkReturn = this.SDK.ID_Resolution(this.hSession, (byte)0, resolution);
        if (sdkReturn == 0) {
            this.SetResolution(resolution.getValue());
        } else {
            Utils.DisplayError("GetResolution", sdkReturn);
        }
        return sdkReturn;
    }

    private void ResolutionToMsgBox(byte action, byte resolution) {
        this.textDriver1Msg.append("Resolution" + Utils.Separator(action) + (resolution != 0 ? "600" : "300") + " x 300 DPI\n\n");
    }

    private void SetResolution(byte resolution) {
        if (resolution == 0) {
            this.rdbtn300DPI.setSelected(true);
        } else {
            this.rdbtn600DPI.setSelected(true);
        }
    }

    private void Resolution() {
        ByteByReference resolution = new ByteByReference();
        if (this.rdbtnGet.isSelected()) {
            if (this.GetResolution(resolution) == 0) {
                this.ResolutionToMsgBox((byte)0, resolution.getValue());
            }
        } else {
            resolution.setValue((byte)(this.rdbtn600DPI.isSelected() ? 1 : 0));
            byte sdkReturn = this.SDK.ID_Resolution(this.hSession, (byte)1, resolution);
            if (sdkReturn != 0) {
                Utils.DisplayError("SetResolution", sdkReturn);
            } else {
                this.ResolutionToMsgBox((byte)1, resolution.getValue());
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (e.getActionCommand()) {
                case "RADIOGET": {
                    Driver1.this.GetSetControls(false);
                    break;
                }
                case "RADIOSET": {
                    Driver1.this.GetSetControls(true);
                    break;
                }
                case "CLEAR": {
                    Driver1.this.ClearMsg();
                    break;
                }
                case "GUICONTROL": {
                    Driver1.this.GUIControl();
                    break;
                }
                case "SHARPNESS": {
                    Driver1.this.Sharpness();
                    break;
                }
                case "COLOUR": {
                    Driver1.this.ColourCorrection();
                    break;
                }
                case "POWERLEVEL": {
                    Driver1.this.PowerLevel();
                    break;
                }
                case "PRINTSPEED": {
                    Driver1.this.PrintSpeed();
                    break;
                }
                case "RESINAREA": {
                    Driver1.this.ResinArea();
                    break;
                }
                case "RASIDE": {
                    Driver1.this.ResinAreaChanged();
                    break;
                }
                case "AREAHOLE": {
                    Driver1.this.AreaHole();
                    break;
                }
                case "AHSIDE": {
                    Driver1.this.AreaHoleChanged();
                    break;
                }
                case "AHTYPE": {
                    Driver1.this.AreaHoleChanged();
                    break;
                }
                case "REWRITABLE": {
                    Driver1.this.Rewritable();
                    break;
                }
                case "PRINTABLEAREA": {
                    Driver1.this.PrintableArea();
                    break;
                }
                case "RESOLUTION": {
                    Driver1.this.Resolution();
                }
            }
        }
    }
}

