/*
 * Decompiled with CFR 0.152.
 */
package DTCDemo;

import DTCDemo.ComboItem;
import DTCDemo.Main;
import DTCDemo.Utils;
import SDK.SDKlib;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

class Encoding {
    private static final byte TRACK1 = 1;
    private static final byte TRACK2 = 2;
    private static final byte TRACK3 = 4;
    private static final byte ALL_TRACKS = 7;
    private final String RADIOGET = "RADIOGET";
    private final String RADIOSET = "RADIOSET";
    private final String CLEAR = "CLEAR";
    private final String MAGSTART = "MAGSTART";
    private final String ENCODEMAG = "ENCODEMAG";
    private final String ENCODETYPE = "ENCODETYPE";
    private final String READMAG = "READMAG";
    private final String READTRACKS = "READTRACKS";
    private final String TRACKCLICK1 = "TRACKCLICK1";
    private final String TRACKCLICK2 = "TRACKCLICK2";
    private final String TRACKCLICK3 = "TRACKCLICK3";
    private final ActionHandler ah = new ActionHandler();
    public static final JPanel panelEncoding = new JPanel();
    private final JPanel panelMagStart = new JPanel();
    private final JButton btnMagStart = new JButton("Mag Start");
    private final JRadioButton rdbtnGet = new JRadioButton("Get");
    private final JRadioButton rdbtnSet = new JRadioButton("Set");
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final JLabel lblStartPosition = new JLabel("Start Position");
    private final JSpinner spinnerStartPosition = new JSpinner(new SpinnerNumberModel(0, 0, 85000, 1));
    private final JLabel labelType = new JLabel("Type");
    private final JComboBox<ComboItem> comboEncoding = new JComboBox();
    private final JLabel labelCoercivity = new JLabel("Coercivity");
    private final JComboBox<ComboItem> comboCoercivity = new JComboBox();
    private final JCheckBox checkVerify = new JCheckBox("Verify");
    private final JLabel labelTrack1 = new JLabel("Track 1");
    private final JCheckBox checkTrack1Write = new JCheckBox("");
    private final JTextField textTrack1 = new JTextField("THE QUICK BROWN FOX JUMPS OVER THE LAZY DOG");
    private final JLabel labelTrack2 = new JLabel("Track 2");
    private final JCheckBox checkTrack2Write = new JCheckBox("");
    private final JTextField textTrack2 = new JTextField();
    private final JLabel labelTrack3 = new JLabel("Track 3");
    private final JCheckBox checkTrack3Write = new JCheckBox("");
    private final JTextField textTrack3 = new JTextField();
    private final JLabel labelBitsPerChar = new JLabel("Bits Per Char");
    private final JLabel labelBitsPerInch = new JLabel("Bits Per Inch");
    private final JLabel labelParity = new JLabel("Parity");
    private final JLabel labelLRC = new JLabel("LRC");
    private final JLabel labelConfigTrack1 = new JLabel("Track 1");
    private final JComboBox<ComboItem> comboT1BPC = new JComboBox();
    private final JComboBox<ComboItem> comboT1BPI = new JComboBox();
    private final JComboBox<ComboItem> comboT1Par = new JComboBox();
    private final JComboBox<ComboItem> comboT1LRC = new JComboBox();
    private final JLabel labelConfigTrack2 = new JLabel("Track 2");
    private final JComboBox<ComboItem> comboT2BPC = new JComboBox();
    private final JComboBox<ComboItem> comboT2BPI = new JComboBox();
    private final JComboBox<ComboItem> comboT2Par = new JComboBox();
    private final JComboBox<ComboItem> comboT2LRC = new JComboBox();
    private final JLabel labelConfigTrack3 = new JLabel("Track 3");
    private final JComboBox<ComboItem> comboT3BPC = new JComboBox();
    private final JComboBox<ComboItem> comboT3BPI = new JComboBox();
    private final JComboBox<ComboItem> comboT3Par = new JComboBox();
    private final JComboBox<ComboItem> comboT3LRC = new JComboBox();
    private final JButton btnEncodeMag = new JButton("Encode Mag");
    private final JCheckBox checkTrack1Read = new JCheckBox("Track 1");
    private final JCheckBox checkTrack2Read = new JCheckBox("Track 2");
    private final JCheckBox checkTrack3Read = new JCheckBox("Track 3");
    private final JButton btnReadMagTracks = new JButton("Read Mag Tracks");
    private final JButton btnReadMag = new JButton("Read Mag");
    private final JTextArea textEncodingMsg = new JTextArea();
    private final JScrollPane scrollPane = new JScrollPane(this.textEncodingMsg);
    private final JButton btnClear = new JButton("Clear");
    private WinNT.HANDLE hSession;
    private SDKlib SDK;
    private final char ISO_7_BIT_START_SENTINEL = (char)37;
    private final char ISO_5_BIT_START_SENTINEL = (char)59;
    private final char ISO_END_SENTINEL = (char)63;
    private final char JIS2_SENTINEL = (char)127;

    public Encoding() {
        panelEncoding.setLayout(new MigLayout("", "[grow]", "[][][grow]"));
        panelEncoding.add((Component)this.panelMagStart, "cell 0 0,grow");
        this.panelMagStart.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        this.panelMagStart.setLayout(new MigLayout("", "[132.00,center][][98.00][][grow]", "[]"));
        this.panelMagStart.add((Component)this.rdbtnGet, "flowx,cell 0 0");
        this.buttonGroup.add(this.rdbtnGet);
        this.rdbtnGet.setActionCommand("RADIOGET");
        this.rdbtnGet.addActionListener(this.ah);
        this.rdbtnGet.setSelected(true);
        this.panelMagStart.add((Component)this.rdbtnSet, "cell 0 0");
        this.buttonGroup.add(this.rdbtnSet);
        this.rdbtnSet.setActionCommand("RADIOSET");
        this.rdbtnSet.addActionListener(this.ah);
        this.panelMagStart.add((Component)this.lblStartPosition, "flowx,cell 1 0");
        this.panelMagStart.add((Component)this.spinnerStartPosition, "cell 2 0,growx");
        this.spinnerStartPosition.setEnabled(false);
        this.panelMagStart.add((Component)this.btnMagStart, "cell 4 0,alignx center");
        this.btnMagStart.setActionCommand("MAGSTART");
        this.btnMagStart.addActionListener(this.ah);
        JPanel panelSelections = new JPanel();
        panelSelections.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        panelEncoding.add((Component)panelSelections, "cell 0 1,grow");
        panelSelections.setLayout(new MigLayout("", "[42.00][90.00,grow][90.00,grow][90.00,grow][90.00,grow]", "[][][][][][][][][]"));
        this.labelType.setHorizontalAlignment(2);
        panelSelections.add((Component)this.labelType, "cell 0 0,alignx left");
        panelSelections.add(this.comboEncoding, "cell 1 0,growx");
        this.comboEncoding.addItem(new ComboItem("ISO", 0));
        this.comboEncoding.addItem(new ComboItem("JIS2", 1));
        this.comboEncoding.setActionCommand("ENCODETYPE");
        this.comboEncoding.addActionListener(this.ah);
        panelSelections.add((Component)this.labelCoercivity, "flowx,cell 2 0,alignx trailing");
        panelSelections.add(this.comboCoercivity, "cell 3 0,growx");
        this.comboCoercivity.addItem(new ComboItem("Default", 0));
        this.comboCoercivity.addItem(new ComboItem("HiCo", 1));
        this.comboCoercivity.addItem(new ComboItem("LoCo", 2));
        panelSelections.add((Component)this.checkVerify, "cell 4 0,alignx right");
        this.checkVerify.setSelected(true);
        panelSelections.add((Component)this.labelTrack1, "flowx,cell 0 1");
        panelSelections.add((Component)this.checkTrack1Write, "cell 0 1");
        this.checkTrack1Write.setSelected(true);
        this.checkTrack1Write.setActionCommand("TRACKCLICK1");
        this.checkTrack1Write.addActionListener(this.ah);
        panelSelections.add((Component)this.textTrack1, "cell 1 1 4 1,growx");
        this.labelTrack2.setEnabled(false);
        panelSelections.add((Component)this.labelTrack2, "flowx,cell 0 2");
        panelSelections.add((Component)this.checkTrack2Write, "cell 0 2");
        this.checkTrack2Write.setActionCommand("TRACKCLICK2");
        this.checkTrack2Write.addActionListener(this.ah);
        this.textTrack2.setEnabled(false);
        panelSelections.add((Component)this.textTrack2, "cell 1 2 4 1,growx");
        this.labelTrack3.setEnabled(false);
        panelSelections.add((Component)this.labelTrack3, "flowx,cell 0 3");
        panelSelections.add((Component)this.checkTrack3Write, "cell 0 3");
        this.checkTrack3Write.setActionCommand("TRACKCLICK3");
        this.checkTrack3Write.addActionListener(this.ah);
        this.textTrack3.setEnabled(false);
        panelSelections.add((Component)this.textTrack3, "cell 1 3 4 1,growx");
        panelSelections.add((Component)this.labelBitsPerChar, "cell 1 4,alignx center");
        panelSelections.add((Component)this.labelBitsPerInch, "cell 2 4,alignx center");
        panelSelections.add((Component)this.labelParity, "cell 3 4,alignx center");
        panelSelections.add((Component)this.labelLRC, "cell 4 4,alignx center");
        panelSelections.add((Component)this.labelConfigTrack1, "cell 0 5,alignx left");
        panelSelections.add(this.comboT1BPC, "cell 1 5,growx");
        this.comboT1BPC.addItem(new ComboItem("Default", 0));
        this.comboT1BPC.addItem(new ComboItem("1", 1));
        this.comboT1BPC.addItem(new ComboItem("5", 3));
        this.comboT1BPC.addItem(new ComboItem("7", 4));
        panelSelections.add(this.comboT1BPI, "cell 2 5,growx");
        this.comboT1BPI.addItem(new ComboItem("Default", 0));
        this.comboT1BPI.addItem(new ComboItem("210", 2));
        this.comboT1BPI.addItem(new ComboItem("75", 1));
        panelSelections.add(this.comboT1Par, "cell 3 5,growx");
        this.comboT1Par.addItem(new ComboItem("Default", 0));
        this.comboT1Par.addItem(new ComboItem("Odd", 2));
        this.comboT1Par.addItem(new ComboItem("Even", 3));
        this.comboT1Par.addItem(new ComboItem("Off", 1));
        panelSelections.add(this.comboT1LRC, "cell 4 5,growx");
        this.comboT1LRC.addItem(new ComboItem("Default", 0));
        this.comboT1LRC.addItem(new ComboItem("Odd", 2));
        this.comboT1LRC.addItem(new ComboItem("Even", 3));
        this.comboT1LRC.addItem(new ComboItem("Off", 1));
        this.labelConfigTrack2.setEnabled(false);
        panelSelections.add((Component)this.labelConfigTrack2, "cell 0 6,alignx left");
        this.comboT2BPC.setEnabled(false);
        panelSelections.add(this.comboT2BPC, "cell 1 6,growx");
        this.comboT2BPC.addItem(new ComboItem("Default", 0));
        this.comboT2BPC.addItem(new ComboItem("1", 1));
        this.comboT2BPC.addItem(new ComboItem("5", 3));
        this.comboT2BPC.addItem(new ComboItem("7", 4));
        this.comboT2BPI.setEnabled(false);
        panelSelections.add(this.comboT2BPI, "cell 2 6,growx");
        this.comboT2BPI.addItem(new ComboItem("Default", 0));
        this.comboT2BPI.addItem(new ComboItem("210", 2));
        this.comboT2BPI.addItem(new ComboItem("75", 1));
        this.comboT2Par.setEnabled(false);
        panelSelections.add(this.comboT2Par, "cell 3 6,growx");
        this.comboT2Par.addItem(new ComboItem("Default", 0));
        this.comboT2Par.addItem(new ComboItem("Odd", 2));
        this.comboT2Par.addItem(new ComboItem("Even", 3));
        this.comboT2Par.addItem(new ComboItem("Off", 1));
        this.comboT2LRC.setEnabled(false);
        panelSelections.add(this.comboT2LRC, "cell 4 6,growx");
        this.comboT2LRC.addItem(new ComboItem("Default", 0));
        this.comboT2LRC.addItem(new ComboItem("Odd", 2));
        this.comboT2LRC.addItem(new ComboItem("Even", 3));
        this.comboT2LRC.addItem(new ComboItem("Off", 1));
        this.labelConfigTrack3.setEnabled(false);
        panelSelections.add((Component)this.labelConfigTrack3, "cell 0 7,alignx left");
        this.comboT3BPC.setEnabled(false);
        panelSelections.add(this.comboT3BPC, "cell 1 7,growx");
        this.comboT3BPC.addItem(new ComboItem("Default", 0));
        this.comboT3BPC.addItem(new ComboItem("1", 1));
        this.comboT3BPC.addItem(new ComboItem("5", 3));
        this.comboT3BPC.addItem(new ComboItem("7", 4));
        this.comboT3BPI.setEnabled(false);
        panelSelections.add(this.comboT3BPI, "cell 2 7,growx");
        this.comboT3BPI.addItem(new ComboItem("Default", 0));
        this.comboT3BPI.addItem(new ComboItem("210", 2));
        this.comboT3BPI.addItem(new ComboItem("75", 1));
        this.comboT3Par.setEnabled(false);
        panelSelections.add(this.comboT3Par, "cell 3 7,growx");
        this.comboT3Par.addItem(new ComboItem("Default", 0));
        this.comboT3Par.addItem(new ComboItem("Odd", 2));
        this.comboT3Par.addItem(new ComboItem("Even", 3));
        this.comboT3Par.addItem(new ComboItem("Off", 1));
        this.comboT3LRC.setEnabled(false);
        panelSelections.add(this.comboT3LRC, "cell 4 7,growx");
        this.comboT3LRC.addItem(new ComboItem("Default", 0));
        this.comboT3LRC.addItem(new ComboItem("Odd", 2));
        this.comboT3LRC.addItem(new ComboItem("Even", 3));
        this.comboT3LRC.addItem(new ComboItem("Off", 1));
        panelSelections.add((Component)this.btnEncodeMag, "cell 0 8 5 1,alignx center");
        this.btnEncodeMag.setActionCommand("ENCODEMAG");
        this.btnEncodeMag.addActionListener(this.ah);
        JPanel panelResults = new JPanel();
        panelResults.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        panelEncoding.add((Component)panelResults, "cell 0 2,grow");
        panelResults.setLayout(new MigLayout("", "[70.00][88.00][grow]", "[][grow][]"));
        panelResults.add((Component)this.checkTrack1Read, "flowx,cell 0 0,alignx left,aligny baseline");
        this.checkTrack1Read.setSelected(true);
        panelResults.add((Component)this.checkTrack2Read, "cell 0 0");
        this.checkTrack2Read.setSelected(true);
        panelResults.add((Component)this.checkTrack3Read, "cell 0 0");
        this.checkTrack3Read.setSelected(true);
        panelResults.add((Component)this.btnReadMagTracks, "cell 1 0,growx");
        this.btnReadMagTracks.setActionCommand("READTRACKS");
        this.btnReadMagTracks.addActionListener(this.ah);
        panelResults.add((Component)this.btnReadMag, "cell 2 0,alignx right");
        this.btnReadMag.setActionCommand("READMAG");
        this.btnReadMag.addActionListener(this.ah);
        panelResults.add((Component)this.scrollPane, "cell 0 1 3 1,grow");
        this.textEncodingMsg.setEditable(false);
        this.textEncodingMsg.setBorder(BorderFactory.createLineBorder(Color.black));
        panelResults.add((Component)this.btnClear, "cell 0 2 3 1,alignx center");
        this.btnClear.setActionCommand("CLEAR");
        this.btnClear.addActionListener(this.ah);
    }

    void Init(WinNT.HANDLE handle, SDKlib sdk) {
        Main.tabbedPane.addTab("Mag Encoding", null, panelEncoding, null);
        this.hSession = handle;
        this.SDK = sdk;
        if (Utils.connectedPrinter == 4) {
            this.labelParity.setVisible(false);
            this.labelLRC.setVisible(false);
            this.comboT1Par.setVisible(false);
            this.comboT2Par.setVisible(false);
            this.comboT3Par.setVisible(false);
            this.comboT1LRC.setVisible(false);
            this.comboT2LRC.setVisible(false);
            this.comboT3LRC.setVisible(false);
            IntByReference MagStart = new IntByReference();
            this.GetMagStart(MagStart);
        } else {
            this.btnMagStart.setEnabled(false);
            this.rdbtnGet.setEnabled(false);
            this.rdbtnSet.setEnabled(false);
        }
    }

    private void GetSetControls(Boolean state) {
        this.spinnerStartPosition.setEnabled(state);
    }

    private void EncodingChanged() {
        Boolean visible = ((ComboItem)this.comboEncoding.getSelectedItem()).getValue() == 0;
        this.checkTrack1Write.setVisible(visible);
        this.labelConfigTrack1.setVisible(visible);
        this.labelTrack2.setVisible(visible);
        this.textTrack2.setVisible(visible);
        this.checkTrack2Write.setVisible(visible);
        this.labelConfigTrack2.setVisible(visible);
        this.labelTrack3.setVisible(visible);
        this.textTrack3.setVisible(visible);
        this.checkTrack3Write.setVisible(visible);
        this.labelConfigTrack3.setVisible(visible);
        this.comboT1BPC.setVisible(visible);
        this.comboT1BPI.setVisible(visible);
        this.comboT2BPC.setVisible(visible);
        this.comboT2BPI.setVisible(visible);
        this.comboT3BPC.setVisible(visible);
        this.comboT3BPI.setVisible(visible);
        this.labelBitsPerChar.setVisible(visible);
        this.labelBitsPerInch.setVisible(visible);
        if (Utils.connectedPrinter == 2) {
            this.comboT1LRC.setVisible(visible);
            this.comboT1Par.setVisible(visible);
            this.comboT2LRC.setVisible(visible);
            this.comboT2Par.setVisible(visible);
            this.comboT3LRC.setVisible(visible);
            this.comboT3Par.setVisible(visible);
            this.labelParity.setVisible(visible);
            this.labelLRC.setVisible(visible);
        }
        this.labelTrack1.setText(visible != false ? "Track 1" : "Data");
        this.checkTrack1Read.setVisible(visible);
        this.checkTrack2Read.setVisible(visible);
        this.checkTrack3Read.setVisible(visible);
        this.btnReadMagTracks.setVisible(visible);
    }

    private void CheckDataAvailable() {
        this.btnEncodeMag.setEnabled(this.checkTrack1Write.isSelected() || this.checkTrack2Write.isSelected() || this.checkTrack3Write.isSelected());
    }

    private void Track1Clicked() {
        Boolean control = this.checkTrack1Write.isSelected();
        this.labelTrack1.setEnabled(control);
        this.labelConfigTrack1.setEnabled(control);
        this.textTrack1.setEnabled(control);
        this.comboT1BPC.setEnabled(control);
        this.comboT1BPI.setEnabled(control);
        if (Utils.connectedPrinter == 2) {
            this.comboT1Par.setEnabled(control);
            this.comboT1LRC.setEnabled(control);
        }
        this.CheckDataAvailable();
    }

    private void Track2Clicked() {
        Boolean control = this.checkTrack2Write.isSelected();
        this.labelTrack2.setEnabled(control);
        this.labelConfigTrack2.setEnabled(control);
        this.textTrack2.setEnabled(control);
        this.comboT2BPC.setEnabled(control);
        this.comboT2BPI.setEnabled(control);
        if (Utils.connectedPrinter == 2) {
            this.comboT2Par.setEnabled(control);
            this.comboT2LRC.setEnabled(control);
        }
        this.CheckDataAvailable();
    }

    private void Track3Clicked() {
        Boolean control = this.checkTrack3Write.isSelected();
        this.labelTrack3.setEnabled(control);
        this.labelConfigTrack3.setEnabled(control);
        this.textTrack3.setEnabled(control);
        this.comboT3BPC.setEnabled(control);
        this.comboT3BPI.setEnabled(control);
        if (Utils.connectedPrinter == 2) {
            this.comboT3Par.setEnabled(control);
            this.comboT3LRC.setEnabled(control);
        }
        this.CheckDataAvailable();
    }

    private void ClearMsg() {
        this.textEncodingMsg.setText(null);
    }

    private void EncodeMagData() {
        Utils.CursorWait();
        SDKlib.MagDef Def = new SDKlib.MagDef();
        Def.encoding = ((ComboItem)this.comboEncoding.getSelectedItem()).getValue();
        Def.verify = this.checkVerify.isSelected() ? (byte)1 : 0;
        Def.coercivity = ((ComboItem)this.comboCoercivity.getSelectedItem()).getValue();
        if (((ComboItem)this.comboEncoding.getSelectedItem()).getValue() == 1) {
            Def.track[0].data = String.valueOf('\u007f') + this.textTrack1.getText() + '\u007f';
        } else {
            if (this.checkTrack1Write.isSelected()) {
                Def.track[0].data = ((ComboItem)this.comboEncoding.getSelectedItem()).getValue() == 0 ? String.valueOf('%') + this.textTrack1.getText() + '?' : this.textTrack1.getText();
                Def.track[0].bitsPerChar = ((ComboItem)this.comboT1BPC.getSelectedItem()).getValue();
                Def.track[0].bitsPerInch = ((ComboItem)this.comboT1BPI.getSelectedItem()).getValue();
                if (Utils.connectedPrinter == 2) {
                    Def.track[0].parity = ((ComboItem)this.comboT1Par.getSelectedItem()).getValue();
                    Def.track[0].lrc = ((ComboItem)this.comboT1LRC.getSelectedItem()).getValue();
                }
            }
            if (this.checkTrack2Write.isSelected()) {
                Def.track[1].data = ((ComboItem)this.comboEncoding.getSelectedItem()).getValue() == 0 ? String.valueOf(';') + this.textTrack2.getText() + '?' : this.textTrack2.getText();
                Def.track[1].bitsPerChar = ((ComboItem)this.comboT2BPC.getSelectedItem()).getValue();
                Def.track[1].bitsPerInch = ((ComboItem)this.comboT2BPI.getSelectedItem()).getValue();
                if (Utils.connectedPrinter == 2) {
                    Def.track[1].parity = ((ComboItem)this.comboT2Par.getSelectedItem()).getValue();
                    Def.track[1].lrc = ((ComboItem)this.comboT2LRC.getSelectedItem()).getValue();
                }
            }
            if (this.checkTrack3Write.isSelected()) {
                Def.track[2].data = ((ComboItem)this.comboEncoding.getSelectedItem()).getValue() == 0 ? String.valueOf(';') + this.textTrack3.getText() + '?' : this.textTrack3.getText();
                Def.track[2].bitsPerChar = ((ComboItem)this.comboT3BPC.getSelectedItem()).getValue();
                Def.track[2].bitsPerInch = ((ComboItem)this.comboT3BPI.getSelectedItem()).getValue();
                if (Utils.connectedPrinter == 2) {
                    Def.track[2].parity = ((ComboItem)this.comboT3Par.getSelectedItem()).getValue();
                    Def.track[2].lrc = ((ComboItem)this.comboT3LRC.getSelectedItem()).getValue();
                }
            }
        }
        byte sdkReturn = this.SDK.ID_EncodeMag(this.hSession, Def);
        if (sdkReturn != 0) {
            Utils.DisplayError("EncodeMagStripe", sdkReturn);
        } else {
            sdkReturn = Utils.WaitForPrinterToFinish(this.hSession, this.SDK);
            if (sdkReturn != 0) {
                Utils.DisplayError("EncodeMagStripeWait", sdkReturn);
            }
        }
        Utils.CursorDefault();
    }

    private void DisplayEnduroMagData(SDKlib.MagData MagData3, int Tracks) {
        String temp;
        if ((Tracks & 1) != 0) {
            temp = "(1): ";
            temp = String.valueOf(temp) + (MagData3.tk1_pass ? "PASS," : "FAIL");
            temp = String.valueOf(temp) + MagData3.tk1;
            this.textEncodingMsg.append(String.valueOf(temp) + "\n");
        }
        if (((ComboItem)this.comboEncoding.getSelectedItem()).getValue() == 0) {
            if ((Tracks & 2) != 0) {
                temp = "(2): ";
                temp = String.valueOf(temp) + (!MagData3.tk2_pass ? "PASS," : "FAIL");
                temp = String.valueOf(temp) + MagData3.tk2;
                this.textEncodingMsg.append(String.valueOf(temp) + "\n");
            }
            if ((Tracks & 4) != 0) {
                temp = "(3): ";
                temp = String.valueOf(temp) + (MagData3.tk3_pass ? "PASS," : "FAIL");
                temp = String.valueOf(temp) + MagData3.tk3;
                this.textEncodingMsg.append(String.valueOf(temp) + "\n");
            }
        }
        this.textEncodingMsg.append("\n");
    }

    private void DisplayGeneration2MagData(SDKlib.MagData2 MagData3, int Tracks) {
        if ((Tracks & 1) != 0) {
            this.textEncodingMsg.append("(1): " + MagData3.track1 + "\n");
        }
        if (((ComboItem)this.comboEncoding.getSelectedItem()).getValue() == 0) {
            if ((Tracks & 2) != 0) {
                this.textEncodingMsg.append("(2): " + MagData3.track2 + "\n");
            }
            if ((Tracks & 4) != 0) {
                this.textEncodingMsg.append("(3): " + MagData3.track3 + "\n");
            }
        }
        this.textEncodingMsg.append("\n");
    }

    private void ReadMagData(byte Tracks) {
        Utils.CursorWait();
        if (Utils.connectedPrinter == 4) {
            SDKlib.MagData2 MD = new SDKlib.MagData2();
            byte sdkReturn = this.SDK.ID_ReadMagTracks(this.hSession, MD, ((ComboItem)this.comboEncoding.getSelectedItem()).getValue(), Tracks);
            if (sdkReturn != 0) {
                Utils.DisplayError("ReadMagStripe", sdkReturn);
            } else {
                this.DisplayGeneration2MagData(MD, Tracks);
            }
        } else {
            SDKlib.MagData MD = new SDKlib.MagData();
            byte sdkReturn = this.SDK.ID_ReadMagTracks(this.hSession, MD, ((ComboItem)this.comboEncoding.getSelectedItem()).getValue(), Tracks);
            if (sdkReturn != 0) {
                Utils.DisplayError("ReadMagStripe", sdkReturn);
            } else {
                this.DisplayEnduroMagData(MD, Tracks);
            }
        }
        Utils.CursorDefault();
    }

    private void ReadMagTracks() {
        byte Tracks = 0;
        if (this.checkTrack1Read.isSelected()) {
            Tracks = (byte)(Tracks | 1);
        }
        if (this.checkTrack2Read.isSelected()) {
            Tracks = (byte)(Tracks | 2);
        }
        if (this.checkTrack3Read.isSelected()) {
            Tracks = (byte)(Tracks | 4);
        }
        if (Tracks != 0) {
            this.ReadMagData(Tracks);
        }
    }

    private byte GetMagStart(IntByReference MagStart) {
        byte SDKReturn = this.SDK.ID_MagStart(this.hSession, (byte)0, MagStart);
        if (SDKReturn != 0) {
            Utils.DisplayError("MagStart", SDKReturn);
        } else {
            this.spinnerStartPosition.setValue(MagStart.getValue());
        }
        return SDKReturn;
    }

    private void MagStartToMsgBox(int MagStart, byte action) {
        this.textEncodingMsg.append("MagStart" + Utils.Separator(action) + MagStart + "\n\n");
    }

    private void MagStart() {
        IntByReference MagStart = new IntByReference();
        if (this.rdbtnGet.isSelected()) {
            if (this.GetMagStart(MagStart) == 0) {
                this.MagStartToMsgBox(MagStart.getValue(), (byte)0);
            }
        } else {
            MagStart.setValue((Integer)this.spinnerStartPosition.getValue());
            byte SDKReturn = this.SDK.ID_MagStart(this.hSession, (byte)1, MagStart);
            if (SDKReturn != 0) {
                Utils.DisplayError("SetMagStart", SDKReturn);
            } else {
                this.MagStartToMsgBox(MagStart.getValue(), (byte)1);
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (e.getActionCommand()) {
                case "RADIOGET": {
                    Encoding.this.GetSetControls(false);
                    break;
                }
                case "RADIOSET": {
                    Encoding.this.GetSetControls(true);
                    break;
                }
                case "CLEAR": {
                    Encoding.this.ClearMsg();
                    break;
                }
                case "MAGSTART": {
                    Encoding.this.MagStart();
                    break;
                }
                case "ENCODETYPE": {
                    Encoding.this.EncodingChanged();
                    break;
                }
                case "ENCODEMAG": {
                    Encoding.this.EncodeMagData();
                    break;
                }
                case "TRACKCLICK1": {
                    Encoding.this.Track1Clicked();
                    break;
                }
                case "TRACKCLICK2": {
                    Encoding.this.Track2Clicked();
                    break;
                }
                case "TRACKCLICK3": {
                    Encoding.this.Track3Clicked();
                    break;
                }
                case "READTRACKS": {
                    Encoding.this.ReadMagTracks();
                    break;
                }
                case "READMAG": {
                    Encoding.this.ReadMagData((byte)7);
                }
            }
        }
    }
}

