/*
 * Decompiled with CFR 0.152.
 */
package DTCDemo;

import DTCDemo.ComboItem;
import DTCDemo.Driver1;
import DTCDemo.Driver2;
import DTCDemo.Encoding;
import DTCDemo.Info;
import DTCDemo.Main;
import DTCDemo.PrintDemo;
import DTCDemo.Utils;
import SDK.SDKlib;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.ByteByReference;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterJob;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

class Printer {
    static final int MAX_ERASECOUNT = 499;
    static final int MAX_OFFSET = 99;
    private final String OPEN = "OPEN";
    private final String CLOSE = "CLOSE";
    private final String RESPONSE = "RESPONSE";
    private final String GENERAL = "GENERAL";
    private final String FEEDMOVE = "FEEDMOVE";
    private final String MOVEFILM = "MOVEFILM";
    private final String EJECT = "EJECT";
    private final String FLIP = "FLIP";
    private final String CLEAN = "CLEAN";
    private final String RESTART = "RESTART";
    private final String TEST = "TEST";
    private final String LOCATION = "LOCATION";
    private final String ERASE = "ERASE";
    private final String HANDFEED = "HANDFEED";
    private final String EJECTMODE = "EJECTMODE";
    private final String HORZEJECT = "HORZEJECT";
    private final String SMARTMODE = "SMARTMODE";
    private final String SMARTOFFSET = "SMARTOFFSET";
    private final String ERASESPEED = "ERASESPEED";
    private final String IPSETTINGS = "IPSETTINGS";
    private final String RADIOGET = "RADIOGET";
    private final String RADIOSET = "RADIOSET";
    private final String CLEAR = "CLEAR";
    private final ActionHandler ah = new ActionHandler();
    private final JPanel panelPrinter = new JPanel();
    private final JPanel cardsOpenCloseSession = new JPanel(new CardLayout());
    private final JPanel panelOpen = new JPanel();
    private final JPanel panelClose = new JPanel();
    private final JButton btnOpenSession = new JButton("Open Session");
    private final JButton btnCloseSession = new JButton("Close Session");
    private final JComboBox<ComboItem> comboOpenSession = new JComboBox();
    private final JPanel panelGeneralCommand = new JPanel();
    private final JTextField editGenCommand;
    private final JButton btnGenCommand = new JButton("Send");
    private final JPanel panelErrorResponse = new JPanel();
    private final JComboBox<ComboItem> comboErrorResponse = new JComboBox();
    private final JButton btnErrorResponse = new JButton("Error Response");
    private final JPanel panelPrinterControl = new JPanel();
    private final JButton btnFeedMove = new JButton("Feed Card");
    private final JButton btnMoveFilm = new JButton("Move Film");
    private final JButton btnEjectCard = new JButton("Eject Card");
    private final JButton btnCleanPrinter = new JButton("Clean Ptr");
    private final JButton btnTestCard = new JButton("Test Card");
    private final JButton btnFlipCard = new JButton("Flip Card");
    private final JButton btnRestartPrinter = new JButton("Restart");
    private final JButton btnCardLocation = new JButton("Card Locn");
    private final JComboBox<ComboItem> comboFeedMove = new JComboBox();
    private final JComboBox<ComboItem> comboMoveFilm = new JComboBox();
    private final JPanel panelRewritable = new JPanel();
    private final JLabel labelEraseAreaBotL = new JLabel("Bot L");
    private final JSpinner spinnerEraseAreaBotLX = new JSpinner(new SpinnerNumberModel(0, 0, Utils.maxXCoord, 1));
    private final JSpinner spinnerEraseAreaBotLY = new JSpinner(new SpinnerNumberModel(0, 0, 641, 1));
    private final JLabel labelEraseAreaTopR = new JLabel("Top R");
    private final JSpinner spinnerEraseAreaTopRX = new JSpinner(new SpinnerNumberModel(Utils.maxXCoord, 0, Utils.maxCardLength, 1));
    private final JSpinner spinnerEraseAreaTopRY = new JSpinner(new SpinnerNumberModel(641, 0, 642, 1));
    private final JLabel labelEraseAreaCount = new JLabel("Count");
    private final JSpinner spinnerEraseCount = new JSpinner(new SpinnerNumberModel(1, 1, 499, 1));
    private final JLabel labelEraseAreaX = new JLabel("X");
    private final JLabel labelEraseAreaY = new JLabel("Y");
    private final JButton btnErase = new JButton("Erase Area");
    private final JPanel panelPrinterConfig = new JPanel();
    private final JLabel labelAction = new JLabel("Action:");
    private final JRadioButton rdbtnGet = new JRadioButton("Get");
    private final JRadioButton rdbtnSet = new JRadioButton("Set");
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final JComboBox<ComboItem> comboHandFeed = new JComboBox();
    private final JButton btnHandFeed = new JButton("Hand Feed");
    private final JComboBox<ComboItem> comboEjectMode = new JComboBox();
    private final JButton btnEjectMode = new JButton("Eject Mode");
    private final JComboBox<ComboItem> comboHorzEject = new JComboBox();
    private final JButton btnHorzEject = new JButton("Horz Eject");
    private final JComboBox<ComboItem> comboSmartMode = new JComboBox();
    private final JButton btnSmartMode = new JButton("Smart Mode");
    private final JSpinner spinnerSmartOffset = new JSpinner(new SpinnerNumberModel(new Byte("0"), new Byte("0"), new Byte(99), new Byte("1")));
    private final JButton btnSmartOffset = new JButton("Smart Offset");
    private final JComboBox<ComboItem> comboEraseSpeed = new JComboBox();
    private final JButton btnEraseSpeed = new JButton("Erase Speed");
    private final JPanel panelIPSettings = new JPanel();
    private final JLabel labelIPMode = new JLabel("Mode");
    private final JComboBox<ComboItem> comboIPMode = new JComboBox();
    private final JLabel labelIPAddress = new JLabel("Address");
    private final JTextField textIPAddress = new JTextField();
    private final JLabel labelIPSubnet = new JLabel("Subnet");
    private final JTextField textIPSubnet = new JTextField();
    private final JLabel labelIPGateway = new JLabel("Gateway");
    private final JTextField textIPGateway = new JTextField();
    private final JButton btnIPSettings = new JButton("IP Settings");
    private final JPanel panelPrinterMsg = new JPanel();
    private final JTextArea textPrinterMsg = new JTextArea();
    private final JScrollPane scrollPane = new JScrollPane(this.textPrinterMsg);
    private final JButton btnClear = new JButton("Clear");
    private JTabbedPane tabbedPane;
    private WinNT.HANDLE hSession;
    private SDKlib SDK = new SDKlib();
    static PrinterJob pj;

    protected Printer(JTabbedPane mainTab) {
        this.tabbedPane = mainTab;
        this.tabbedPane.addTab("Printer", null, this.panelPrinter, null);
        this.panelPrinter.setLayout(new MigLayout("", "[250.00px][248px][248px][167px]", "[53px][53px][120.00][][]"));
        this.cardsOpenCloseSession.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Session Control", 4, 2, null, new Color(0, 0, 0)));
        this.panelPrinter.add((Component)this.cardsOpenCloseSession, "cell 0 0 3 1,grow");
        this.cardsOpenCloseSession.add((Component)this.panelOpen, "OpenSessionPanel");
        this.cardsOpenCloseSession.add((Component)this.panelClose, "CloseSessionPanel");
        this.panelOpen.setLayout(new MigLayout("", "[][grow]", "[]"));
        this.btnOpenSession.setActionCommand("OPEN");
        this.btnOpenSession.addActionListener(this.ah);
        this.panelOpen.add((Component)this.btnOpenSession, "cell 0 0");
        this.comboOpenSession.addItem(new ComboItem("Config Normal", 0));
        this.comboOpenSession.addItem(new ComboItem("Config Quiet", 1));
        this.panelOpen.add(this.comboOpenSession, "cell 1 0,growx");
        this.btnCloseSession.setActionCommand("CLOSE");
        this.btnCloseSession.addActionListener(this.ah);
        this.panelClose.add(this.btnCloseSession);
        this.panelErrorResponse.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Error Handling", 4, 2, null, new Color(0, 0, 0)));
        this.panelPrinter.add((Component)this.panelErrorResponse, "cell 3 0 1 2,grow");
        this.panelErrorResponse.setLayout(new MigLayout("", "[167px,grow]", "[53px][]"));
        this.comboErrorResponse.setEnabled(false);
        this.comboErrorResponse.addItem(new ComboItem("OK", 0));
        this.comboErrorResponse.addItem(new ComboItem("Cancel", 1));
        this.panelErrorResponse.add(this.comboErrorResponse, "cell 0 0,growx");
        this.btnErrorResponse.setEnabled(false);
        this.panelErrorResponse.add((Component)this.btnErrorResponse, "cell 0 1,alignx center");
        this.btnErrorResponse.setActionCommand("RESPONSE");
        this.btnErrorResponse.addActionListener(this.ah);
        this.btnErrorResponse.setEnabled(false);
        this.panelGeneralCommand.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "General Command", 4, 2, null, new Color(0, 0, 0)));
        this.panelPrinter.add((Component)this.panelGeneralCommand, "cell 0 1 3 1,grow");
        this.panelGeneralCommand.setLayout(new MigLayout("", "[grow]", "[]"));
        this.editGenCommand = new JTextField();
        this.editGenCommand.setEnabled(false);
        this.panelGeneralCommand.add((Component)this.editGenCommand, "flowx,cell 0 0,growx");
        this.btnGenCommand.setEnabled(false);
        this.panelGeneralCommand.add((Component)this.btnGenCommand, "cell 0 0");
        this.btnGenCommand.setActionCommand("GENERAL");
        this.btnGenCommand.addActionListener(this.ah);
        this.panelPrinterControl.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Printer Control", 4, 2, null, new Color(0, 0, 0)));
        this.panelPrinter.add((Component)this.panelPrinterControl, "cell 0 2 2 1,grow");
        this.panelPrinterControl.setLayout(new MigLayout("", "[][][]", "[grow][grow][grow][grow]"));
        this.panelPrinterControl.add((Component)this.btnFeedMove, "cell 0 0,growx");
        this.btnFeedMove.setActionCommand("FEEDMOVE");
        this.btnFeedMove.addActionListener(this.ah);
        this.btnFeedMove.setEnabled(false);
        this.panelPrinterControl.add(this.comboFeedMove, "cell 1 0 2 1,growx");
        this.comboFeedMove.setEnabled(false);
        this.btnMoveFilm.setEnabled(false);
        this.panelPrinterControl.add((Component)this.btnMoveFilm, "cell 0 1,growx");
        this.btnMoveFilm.setActionCommand("MOVEFILM");
        this.btnMoveFilm.addActionListener(this.ah);
        this.btnMoveFilm.setEnabled(false);
        this.panelPrinterControl.add(this.comboMoveFilm, "cell 1 1 2 1,growx");
        this.comboMoveFilm.addItem(new ComboItem("Initialise", 0));
        this.comboMoveFilm.addItem(new ComboItem("Next", 1));
        this.comboMoveFilm.addItem(new ComboItem("Yellow", 2));
        this.comboMoveFilm.addItem(new ComboItem("Magenta", 3));
        this.comboMoveFilm.addItem(new ComboItem("Cyan", 4));
        this.comboMoveFilm.addItem(new ComboItem("KResin", 5));
        this.comboMoveFilm.addItem(new ComboItem("Overcoat", 6));
        this.comboMoveFilm.setEnabled(false);
        this.panelPrinterControl.add((Component)this.btnEjectCard, "cell 0 2,growx");
        this.btnEjectCard.setActionCommand("EJECT");
        this.btnEjectCard.addActionListener(this.ah);
        this.btnEjectCard.setEnabled(false);
        this.panelPrinterControl.add((Component)this.btnFlipCard, "cell 1 2,growx");
        this.btnFlipCard.setActionCommand("FLIP");
        this.btnFlipCard.addActionListener(this.ah);
        this.btnFlipCard.setEnabled(false);
        this.panelPrinterControl.add((Component)this.btnCleanPrinter, "cell 2 3,growx");
        this.btnCleanPrinter.setActionCommand("CLEAN");
        this.btnCleanPrinter.addActionListener(this.ah);
        this.btnCleanPrinter.setEnabled(false);
        this.panelPrinterControl.add((Component)this.btnRestartPrinter, "cell 1 3,growx");
        this.btnRestartPrinter.setActionCommand("RESTART");
        this.btnRestartPrinter.addActionListener(this.ah);
        this.btnRestartPrinter.setEnabled(false);
        this.panelPrinterControl.add((Component)this.btnTestCard, "cell 2 2,growx");
        this.btnTestCard.setActionCommand("TEST");
        this.btnTestCard.addActionListener(this.ah);
        this.btnTestCard.setEnabled(false);
        this.panelPrinterControl.add((Component)this.btnCardLocation, "cell 0 3,growx");
        this.btnCardLocation.setActionCommand("LOCATION");
        this.btnCardLocation.addActionListener(this.ah);
        this.btnCardLocation.setEnabled(false);
        this.panelPrinter.add((Component)this.panelRewritable, "cell 2 2 2 1,grow");
        this.panelRewritable.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Rewritable Cards", 4, 2, null, new Color(0, 0, 0)));
        this.panelRewritable.setLayout(new MigLayout("", "[grow][grow,center][grow,center]", "[grow][grow][grow][][grow]"));
        this.panelRewritable.add((Component)this.labelEraseAreaX, "cell 1 0");
        this.panelRewritable.add((Component)this.labelEraseAreaY, "cell 2 0");
        this.panelRewritable.add((Component)this.labelEraseAreaBotL, "cell 0 1,alignx left");
        this.panelRewritable.add((Component)this.spinnerEraseAreaBotLX, "cell 1 1,growx");
        this.spinnerEraseAreaBotLX.setEditor(new JSpinner.NumberEditor(this.spinnerEraseAreaBotLX, "#"));
        this.spinnerEraseAreaBotLX.setEnabled(false);
        this.panelRewritable.add((Component)this.spinnerEraseAreaBotLY, "cell 2 1,growx");
        this.spinnerEraseAreaBotLY.setEditor(new JSpinner.NumberEditor(this.spinnerEraseAreaBotLY, "#"));
        this.spinnerEraseAreaBotLY.setEnabled(false);
        this.panelRewritable.add((Component)this.labelEraseAreaTopR, "cell 0 2,alignx left");
        this.spinnerEraseAreaTopRX.setEditor(new JSpinner.NumberEditor(this.spinnerEraseAreaTopRX, "#"));
        this.spinnerEraseAreaTopRX.setEnabled(false);
        this.panelRewritable.add((Component)this.spinnerEraseAreaTopRX, "cell 1 2,growx");
        this.spinnerEraseAreaTopRY.setEditor(new JSpinner.NumberEditor(this.spinnerEraseAreaTopRY, "#"));
        this.spinnerEraseAreaTopRY.setEnabled(false);
        this.panelRewritable.add((Component)this.spinnerEraseAreaTopRY, "cell 2 2,growx");
        this.panelRewritable.add((Component)this.labelEraseAreaCount, "cell 0 3,alignx left");
        this.spinnerEraseCount.setEnabled(false);
        this.panelRewritable.add((Component)this.spinnerEraseCount, "cell 1 3,growx");
        this.btnErase.setEnabled(false);
        this.panelRewritable.add((Component)this.btnErase, "cell 0 4 3 1,alignx center");
        this.btnErase.setActionCommand("ERASE");
        this.btnErase.addActionListener(this.ah);
        this.panelPrinter.add((Component)this.panelPrinterConfig, "cell 0 3 2 1,grow");
        this.panelPrinterConfig.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Printer Config", 4, 2, null, new Color(0, 0, 0)));
        this.panelPrinterConfig.setLayout(new MigLayout("", "[][grow]", "[][][][][][][]"));
        this.panelPrinterConfig.add((Component)this.labelAction, "flowx,cell 0 0 2 1,alignx center");
        this.panelPrinterConfig.add((Component)this.rdbtnGet, "cell 0 0");
        this.rdbtnGet.setEnabled(false);
        this.rdbtnGet.setSelected(true);
        this.buttonGroup.add(this.rdbtnGet);
        this.rdbtnGet.setActionCommand("RADIOGET");
        this.buttonGroup.add(this.rdbtnSet);
        this.panelPrinterConfig.add((Component)this.rdbtnSet, "cell 0 0");
        this.rdbtnSet.setEnabled(false);
        this.buttonGroup.add(this.rdbtnSet);
        this.rdbtnSet.setActionCommand("RADIOSET");
        this.rdbtnSet.addActionListener(this.ah);
        this.rdbtnGet.addActionListener(this.ah);
        this.panelPrinterConfig.add((Component)this.btnHandFeed, "cell 0 1,growx");
        this.btnHandFeed.setEnabled(false);
        this.btnHandFeed.setActionCommand("HANDFEED");
        this.btnHandFeed.addActionListener(this.ah);
        this.panelPrinterConfig.add(this.comboHandFeed, "cell 1 1,growx");
        this.comboHandFeed.addItem(new ComboItem("Off", 0));
        this.comboHandFeed.addItem(new ComboItem("On", 1));
        this.comboHandFeed.setEnabled(false);
        this.panelPrinterConfig.add((Component)this.btnEjectMode, "cell 0 2,growx");
        this.btnEjectMode.setEnabled(false);
        this.btnEjectMode.setActionCommand("EJECTMODE");
        this.btnEjectMode.addActionListener(this.ah);
        this.panelPrinterConfig.add(this.comboEjectMode, "cell 1 2,growx");
        this.comboEjectMode.addItem(new ComboItem("Off", 0));
        this.comboEjectMode.addItem(new ComboItem("On", 1));
        this.comboEjectMode.setEnabled(false);
        this.panelPrinterConfig.add((Component)this.btnSmartOffset, "cell 0 3,growx");
        this.btnSmartOffset.setEnabled(false);
        this.btnSmartOffset.setActionCommand("SMARTOFFSET");
        this.btnSmartOffset.addActionListener(this.ah);
        this.panelPrinterConfig.add((Component)this.spinnerSmartOffset, "cell 1 3,growx");
        this.spinnerSmartOffset.setEnabled(false);
        this.panelPrinterConfig.add((Component)this.btnSmartMode, "cell 0 4,growx");
        this.btnSmartMode.setEnabled(false);
        this.btnSmartMode.setActionCommand("SMARTMODE");
        this.btnSmartMode.addActionListener(this.ah);
        this.panelPrinterConfig.add(this.comboSmartMode, "cell 1 4,growx");
        this.comboSmartMode.addItem(new ComboItem("Default", 0));
        this.comboSmartMode.addItem(new ComboItem("Platen", 1));
        this.comboSmartMode.addItem(new ComboItem("XLI", 2));
        this.comboSmartMode.setEnabled(false);
        this.panelPrinterConfig.add((Component)this.btnHorzEject, "cell 0 5,growx");
        this.btnHorzEject.setEnabled(false);
        this.btnHorzEject.setActionCommand("HORZEJECT");
        this.btnHorzEject.addActionListener(this.ah);
        this.panelPrinterConfig.add(this.comboHorzEject, "cell 1 5,growx");
        this.comboHorzEject.addItem(new ComboItem("Off", 0));
        this.comboHorzEject.addItem(new ComboItem("On", 1));
        this.comboHorzEject.setEnabled(false);
        this.panelPrinterConfig.add((Component)this.btnEraseSpeed, "cell 0 6,growx");
        this.btnEraseSpeed.setEnabled(false);
        this.btnEraseSpeed.setActionCommand("ERASESPEED");
        this.btnEraseSpeed.addActionListener(this.ah);
        this.panelPrinterConfig.add(this.comboEraseSpeed, "cell 1 6,growx");
        this.comboEraseSpeed.addItem(new ComboItem("Thorough", 0));
        this.comboEraseSpeed.addItem(new ComboItem("Quick", 1));
        this.comboEraseSpeed.setEnabled(false);
        this.panelPrinter.add((Component)this.panelIPSettings, "cell 0 4 2 1,grow");
        this.panelIPSettings.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        this.panelIPSettings.setLayout(new MigLayout("", "[][grow]", "[][][][][]"));
        this.panelIPSettings.add((Component)this.labelIPMode, "cell 0 0,alignx left");
        this.panelIPSettings.add(this.comboIPMode, "cell 1 0,growx");
        this.comboIPMode.addItem(new ComboItem("Static", 0));
        this.comboIPMode.addItem(new ComboItem("Dynamic", 1));
        this.comboIPMode.setEnabled(false);
        this.panelIPSettings.add((Component)this.labelIPAddress, "cell 0 1,alignx left");
        this.panelIPSettings.add((Component)this.textIPAddress, "cell 1 1,growx");
        this.textIPAddress.setEnabled(false);
        this.panelIPSettings.add((Component)this.labelIPSubnet, "cell 0 2,alignx left");
        this.panelIPSettings.add((Component)this.textIPSubnet, "cell 1 2,growx");
        this.textIPSubnet.setEnabled(false);
        this.panelIPSettings.add((Component)this.labelIPGateway, "cell 0 3,alignx left");
        this.panelIPSettings.add((Component)this.textIPGateway, "cell 1 3,growx");
        this.textIPGateway.setEnabled(false);
        this.panelIPSettings.add((Component)this.btnIPSettings, "cell 0 4 2 1,alignx center");
        this.btnIPSettings.setActionCommand("IPSETTINGS");
        this.btnIPSettings.addActionListener(this.ah);
        this.btnIPSettings.setEnabled(false);
        this.panelPrinter.add((Component)this.panelPrinterMsg, "cell 2 3 2 2,grow");
        this.panelPrinterMsg.setLayout(new MigLayout("", "[grow]", "[grow][]"));
        this.panelPrinterMsg.add((Component)this.scrollPane, "cell 0 0,grow");
        this.textPrinterMsg.setEditable(false);
        this.textPrinterMsg.setBorder(BorderFactory.createLineBorder(Color.black));
        this.panelPrinterMsg.add((Component)this.btnClear, "cell 0 1,alignx center");
        this.btnClear.setActionCommand("CLEAR");
        this.btnClear.addActionListener(this.ah);
        this.textPrinterMsg.append("Demo Version: 1.1.4.1\n");
        this.textPrinterMsg.append("Java Shim Version: " + this.SDK.shimVersion + "\n");
        this.textPrinterMsg.append(String.valueOf(this.SDK.ID_SDKBits()) + " Bit SDK\n\n");
    }

    private void ShowHideControls() {
        boolean bControl = Utils.connectedPrinter == 4;
        this.btnMoveFilm.setVisible(bControl);
        this.comboMoveFilm.setVisible(bControl);
        this.btnCardLocation.setVisible(bControl);
        this.panelGeneralCommand.setVisible(!bControl);
        this.editGenCommand.setVisible(!bControl);
        this.btnGenCommand.setVisible(!bControl);
        this.btnCleanPrinter.setVisible(!bControl);
        this.btnSmartMode.setVisible(!bControl);
        this.comboSmartMode.setVisible(!bControl);
        this.btnHorzEject.setVisible(!bControl);
        this.comboHorzEject.setVisible(!bControl);
        this.btnEraseSpeed.setVisible(!bControl);
        this.comboEraseSpeed.setVisible(!bControl);
    }

    private void EnableGetSetControls(Boolean state) {
        this.comboHandFeed.setEnabled(state);
        this.comboEjectMode.setEnabled(state);
        this.comboSmartMode.setEnabled(state);
        this.spinnerSmartOffset.setEnabled(state);
        this.comboEraseSpeed.setEnabled(state);
        this.comboHorzEject.setEnabled(state);
        if (this.ProntoPrinter().booleanValue()) {
            this.btnIPSettings.setEnabled(false);
        } else {
            this.comboIPMode.setEnabled(state);
            this.textIPAddress.setEnabled(state);
            this.textIPSubnet.setEnabled(state);
            this.textIPGateway.setEnabled(state);
        }
    }

    private void EnableControls(Boolean state) {
        this.btnFeedMove.setEnabled(state);
        this.comboFeedMove.setEnabled(state);
        this.btnMoveFilm.setEnabled(state);
        this.comboMoveFilm.setEnabled(state);
        this.btnCardLocation.setEnabled(state);
        this.btnEjectCard.setEnabled(state);
        this.btnFlipCard.setEnabled(state);
        this.btnTestCard.setEnabled(state);
        this.btnCleanPrinter.setEnabled(state);
        this.btnRestartPrinter.setEnabled(state);
        this.btnGenCommand.setEnabled(state);
        this.editGenCommand.setEnabled(state);
        this.btnErase.setEnabled(state);
        this.spinnerEraseAreaBotLX.setEnabled(state);
        this.spinnerEraseAreaBotLY.setEnabled(state);
        this.spinnerEraseAreaTopRX.setEnabled(state);
        this.spinnerEraseAreaTopRY.setEnabled(state);
        this.spinnerEraseCount.setEnabled(state);
        this.btnErrorResponse.setEnabled(state);
        this.comboErrorResponse.setEnabled(state);
        this.rdbtnGet.setEnabled(state);
        this.rdbtnSet.setEnabled(state);
        this.btnHandFeed.setEnabled(state);
        this.btnEjectMode.setEnabled(state);
        this.btnHorzEject.setEnabled(state);
        this.btnSmartMode.setEnabled(state);
        this.btnSmartOffset.setEnabled(state);
        this.btnEraseSpeed.setEnabled(state);
        this.btnIPSettings.setEnabled(state);
        this.EnableGetSetControls(this.rdbtnSet.isSelected());
    }

    private void ClearMsg() {
        this.textPrinterMsg.setText(null);
    }

    private Boolean ProntoPrinter() {
        if (Utils.connectedPrinter != 2) {
            return false;
        }
        int sdkReturn = this.SDK.ID_PrinterModel(this.hSession);
        if (sdkReturn == -2) {
            return false;
        }
        if ((sdkReturn & 0x20) != 0) {
            return true;
        }
        return false;
    }

    private void OpenSession() {
        pj = PrinterJob.getPrinterJob();
        if (pj.printDialog()) {
            Utils.CursorWait();
            WinNT.HANDLEByReference HandleRef = new WinNT.HANDLEByReference();
            String printername = pj.getPrintService().getName();
            byte sdkReturn = this.SDK.ID_OpenSession(printername, HandleRef, ((ComboItem)this.comboOpenSession.getSelectedItem()).getValue());
            if (sdkReturn != 0) {
                Utils.DisplayError("OpenSession", sdkReturn);
            } else {
                this.hSession = HandleRef.getValue();
                Utils.connectedPrinter = this.SDK.ID_PrinterType(this.hSession);
                if (Utils.connectedPrinter != 2 && Utils.connectedPrinter != 4) {
                    JOptionPane.showMessageDialog(null, "Invalid Printer - DTC Only", "SDK ERROR", 1);
                    this.CloseSession();
                } else {
                    this.ShowHideControls();
                    CardLayout cl = (CardLayout)this.cardsOpenCloseSession.getLayout();
                    cl.last(this.cardsOpenCloseSession);
                    Utils.maxCardLength = this.SDK.ID_CardWidth(this.hSession);
                    Utils.maxXCoord = Utils.maxCardLength - 1;
                    this.spinnerEraseAreaBotLX.setModel(new SpinnerNumberModel(0, 0, Utils.maxXCoord, 1));
                    this.spinnerEraseAreaTopRX.setModel(new SpinnerNumberModel(Utils.maxXCoord, 0, Utils.maxXCoord, 1));
                    this.spinnerEraseAreaTopRX.setValue(Utils.maxXCoord);
                    Main.InfoTab.Init(this.hSession, this.SDK);
                    Main.EncodingTab.Init(this.hSession, this.SDK);
                    Main.Driver1Tab.Init(this.hSession, this.SDK);
                    Main.Driver2Tab.Init(this.hSession, this.SDK, pj.getPrintService().getName());
                    Main.PrintDemoTab.Init(this.hSession, this.SDK);
                    Main.UtilityTab.Init(this.hSession, this.SDK);
                    if (Utils.connectedPrinter == 4) {
                        this.btnFeedMove.setText("MoveCard");
                        this.comboFeedMove.addItem(new ComboItem("Standby", 0));
                        this.comboFeedMove.addItem(new ComboItem("Contact", 5));
                        this.comboFeedMove.addItem(new ComboItem("Contactless", 9));
                        this.comboFeedMove.addItem(new ComboItem("Flip", 2));
                        this.comboFeedMove.addItem(new ComboItem("Eject", 6));
                        this.comboFeedMove.addItem(new ComboItem("Initialise", 10));
                        this.comboFeedMove.addItem(new ComboItem("Reject", 7));
                        this.comboFeedMove.setSelectedIndex(0);
                        this.comboFeedMove.setEnabled(true);
                        ByteByReference HandFeed2 = new ByteByReference();
                        this.GetHandFeed(HandFeed2);
                        this.HandFeedDisplay(HandFeed2.getValue());
                    } else {
                        this.btnFeedMove.setText("FeedCard");
                        this.comboFeedMove.addItem(new ComboItem("Contact", 0));
                        this.comboFeedMove.addItem(new ComboItem("Contactless", 1));
                        this.comboFeedMove.setSelectedIndex(0);
                        this.comboFeedMove.setEnabled(true);
                        SDKlib.PrinterInfo PI2 = new SDKlib.PrinterInfo();
                        sdkReturn = this.SDK.ID_PrinterInfo(this.hSession, PI2);
                        if (sdkReturn != 0) {
                            Utils.DisplayError("Open-GetPrinterInfo", sdkReturn);
                        } else {
                            this.HandFeedDisplay((byte)PI2.handFeed);
                            switch (PI2.bitFields & 0x23) {
                                case 2: {
                                    this.SmartModeDisplay((byte)1);
                                    break;
                                }
                                case 32: {
                                    this.SmartModeDisplay((byte)2);
                                    break;
                                }
                                default: {
                                    this.SmartModeDisplay((byte)0);
                                }
                            }
                            this.EraseSpeedDisplay((PI2.bitFields & 4) != 0 ? (byte)1 : 0);
                            this.EjectModeDisplay((PI2.bitFields & 8) != 0 ? (byte)1 : 0);
                            this.HorzEjectDisplay((PI2.bitFields & 0x10) != 0 ? (byte)1 : 0);
                            this.SmartOffsetDisplay((byte)PI2.smartOffset);
                        }
                    }
                    if (this.ProntoPrinter().booleanValue()) {
                        this.btnIPSettings.setVisible(false);
                        this.comboIPMode.setVisible(false);
                        this.textIPAddress.setVisible(false);
                        this.textIPSubnet.setVisible(false);
                        this.textIPGateway.setVisible(false);
                        this.panelIPSettings.setVisible(false);
                        this.labelIPMode.setVisible(false);
                        this.labelIPAddress.setVisible(false);
                        this.labelIPSubnet.setVisible(false);
                        this.labelIPGateway.setVisible(false);
                    } else {
                        SDKlib.IPData IP = new SDKlib.IPData();
                        this.GetIPSettings(IP);
                        this.IPSettingsToCtrl(IP);
                    }
                    this.btnOpenSession.setVisible(false);
                    this.comboOpenSession.setVisible(false);
                    this.btnCloseSession.setVisible(true);
                    this.EnableControls(true);
                }
                ((JFrame)this.tabbedPane.getTopLevelAncestor()).pack();
            }
            Utils.CursorDefault();
        }
    }

    private void CloseSession() {
        CardLayout cl = (CardLayout)this.cardsOpenCloseSession.getLayout();
        cl.first(this.cardsOpenCloseSession);
        this.tabbedPane.remove(Info.panelInfo);
        this.tabbedPane.remove(Encoding.panelEncoding);
        this.tabbedPane.remove(Driver1.panelDriver1);
        this.tabbedPane.remove(Driver2.panelDriver2);
        this.tabbedPane.remove(PrintDemo.panelPrintDemo);
        this.btnOpenSession.setVisible(true);
        this.comboOpenSession.setVisible(true);
        this.btnCloseSession.setVisible(false);
        this.EnableControls(false);
        this.EnableGetSetControls(false);
        byte sdkReturn = this.SDK.ID_CloseSession(this.hSession);
        if (sdkReturn != 0) {
            Utils.DisplayError("CloseSession", sdkReturn);
        }
    }

    private void FeedMove() {
        if (Utils.connectedPrinter == 4) {
            this.MoveCard();
        } else {
            this.FeedCard();
        }
    }

    private void FeedCard() {
        Utils.CursorWait();
        byte sdkReturn = this.SDK.ID_FeedCard(this.hSession, ((ComboItem)this.comboFeedMove.getSelectedItem()).getValue(), 0);
        if (sdkReturn != 0) {
            Utils.DisplayError("FeedCard", sdkReturn);
        } else {
            sdkReturn = Utils.WaitForPrinterToFinish(this.hSession, this.SDK);
            if (sdkReturn != 0) {
                Utils.DisplayError("FeedCardWait", sdkReturn);
            }
        }
        Utils.CursorDefault();
    }

    private void MoveCard() {
        Utils.CursorWait();
        byte sdkReturn = this.SDK.ID_MoveCard(this.hSession, ((ComboItem)this.comboFeedMove.getSelectedItem()).getValue());
        if (sdkReturn != 0) {
            Utils.DisplayError("MoveCardWait", sdkReturn);
        }
        Utils.CursorDefault();
    }

    private void MoveFilm() {
        Utils.CursorWait();
        byte sdkReturn = this.SDK.ID_MoveFilm(this.hSession, ((ComboItem)this.comboMoveFilm.getSelectedItem()).getValue());
        if (sdkReturn != 0) {
            Utils.DisplayError("MoveFilmWait", sdkReturn);
        }
        Utils.CursorDefault();
    }

    private void CardLocation() {
        Utils.CursorWait();
        ByteByReference location = new ByteByReference();
        byte sdkReturn = this.SDK.ID_CardLocation(this.hSession, location);
        if (sdkReturn != 0) {
            Utils.DisplayError("CardLocation", sdkReturn);
        } else {
            String temp_string;
            switch (location.getValue()) {
                case 0: {
                    temp_string = "Unknown";
                    break;
                }
                case 1: {
                    temp_string = "No Card";
                    break;
                }
                case 2: {
                    temp_string = "Standby";
                    break;
                }
                case 3: {
                    temp_string = "Encoder";
                    break;
                }
                default: {
                    temp_string = "???????";
                }
            }
            this.textPrinterMsg.append("Card Location: " + temp_string + "\n\n");
        }
        Utils.CursorDefault();
    }

    private void ErrorResponse() {
        byte sdkReturn = this.SDK.ID_ErrorResponse(this.hSession, ((ComboItem)this.comboErrorResponse.getSelectedItem()).getValue());
        if (sdkReturn != 0) {
            Utils.DisplayError("ErrorResponse", sdkReturn);
        }
    }

    private void EjectCard() {
        Utils.CursorWait();
        byte sdkReturn = this.SDK.ID_EjectCard(this.hSession);
        if (sdkReturn != 0) {
            Utils.DisplayError("EjectCard", sdkReturn);
        } else {
            sdkReturn = Utils.WaitForPrinterToFinish(this.hSession, this.SDK);
            if (sdkReturn != 0) {
                Utils.DisplayError("EjectCardWait", sdkReturn);
            }
        }
        Utils.CursorDefault();
    }

    private void GeneralCommand() {
        if (this.editGenCommand.getText().length() != 0) {
            Utils.CursorWait();
            byte sdkReturn = this.SDK.ID_GeneralCommand(this.hSession, this.editGenCommand.getText());
            if (sdkReturn != 0) {
                Utils.DisplayError("GeneralCommand", sdkReturn);
            }
            Utils.CursorDefault();
        }
    }

    private void FlipCard() {
        Utils.CursorWait();
        byte sdkReturn = this.SDK.ID_FlipCard(this.hSession);
        if (sdkReturn != 0) {
            Utils.DisplayError("FlipCard", sdkReturn);
        } else {
            sdkReturn = Utils.WaitForPrinterToFinish(this.hSession, this.SDK);
            if (sdkReturn != 0) {
                Utils.DisplayError("FlipCardWait", sdkReturn);
            }
        }
        Utils.CursorDefault();
    }

    private void CleanPrinter() {
        Utils.CursorWait();
        byte sdkReturn = this.SDK.ID_CleanPrinter(this.hSession);
        if (sdkReturn != 0) {
            Utils.DisplayError("CleanPrinter", sdkReturn);
        } else {
            sdkReturn = Utils.WaitForPrinterToFinish(this.hSession, this.SDK);
            if (sdkReturn != 0) {
                Utils.DisplayError("CleanPrinterWait", sdkReturn);
            }
        }
        Utils.CursorDefault();
    }

    private void RestartPrinter() {
        Utils.CursorWait();
        byte sdkReturn = this.SDK.ID_RestartPrinter(this.hSession);
        if (sdkReturn != 0) {
            Utils.DisplayError("RestartPrinter", sdkReturn);
        } else {
            sdkReturn = Utils.WaitForPrinterToFinish(this.hSession, this.SDK);
            if (sdkReturn != 0) {
                Utils.DisplayError("RestartPrinterWait", sdkReturn);
            }
        }
        Utils.CursorDefault();
    }

    private void PrintTestCard() {
        byte sdkReturn;
        Utils.CursorWait();
        if (Utils.connectedPrinter == 4 && (sdkReturn = this.SDK.ID_PrepareForPrint(this.hSession)) != 0) {
            Utils.DisplayError("PrintTestCardPrepare", sdkReturn);
            return;
        }
        sdkReturn = this.SDK.ID_PrintTestCard(this.hSession);
        if (sdkReturn != 0) {
            Utils.DisplayError("PrintTestCard", sdkReturn);
        } else if (Utils.connectedPrinter == 4) {
            sdkReturn = this.SDK.ID_WaitPrintComplete(this.hSession);
            if (sdkReturn != 0) {
                Utils.DisplayError("PrintTestCardComplete", sdkReturn);
            }
        } else {
            sdkReturn = Utils.WaitForPrinterToFinish(this.hSession, this.SDK);
            if (sdkReturn != 0) {
                Utils.DisplayError("PrintTestCardWait", sdkReturn);
            }
        }
        Utils.CursorDefault();
    }

    private void EraseCard() {
        Utils.CursorWait();
        byte sdkReturn = this.SDK.ID_EraseCard(this.hSession, (Integer)this.spinnerEraseCount.getValue(), (Integer)this.spinnerEraseAreaBotLX.getValue(), (Integer)this.spinnerEraseAreaBotLY.getValue(), (Integer)this.spinnerEraseAreaTopRX.getValue(), (Integer)this.spinnerEraseAreaTopRY.getValue());
        if (sdkReturn != 0) {
            Utils.DisplayError("EraseCard", sdkReturn);
        } else {
            sdkReturn = Utils.WaitForPrinterToFinish(this.hSession, this.SDK);
            if (sdkReturn != 0) {
                Utils.DisplayError("EjectCardWait", sdkReturn);
            }
        }
        Utils.CursorDefault();
    }

    private String HandFeedString(byte mode) {
        return this.comboHandFeed.getItemAt(mode).toString();
    }

    private void HandFeedDisplay(byte HandFeed2) {
        this.comboHandFeed.setSelectedIndex(HandFeed2);
    }

    private void HandFeedToMsgBox(byte action, byte mode) {
        this.textPrinterMsg.append("Hand Feed" + Utils.Separator(action) + this.HandFeedString(mode) + "\n\n");
    }

    private byte GetHandFeed(ByteByReference mode) {
        Utils.CursorWait();
        byte sdkReturn = this.SDK.ID_HandFeed(this.hSession, (byte)0, mode);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetHandFeed", sdkReturn);
        } else {
            this.HandFeedDisplay(mode.getValue());
        }
        Utils.CursorDefault();
        return sdkReturn;
    }

    private void HandFeed() {
        ByteByReference mode = new ByteByReference(((ComboItem)this.comboHandFeed.getSelectedItem()).getValue());
        if (this.rdbtnGet.isSelected()) {
            if (this.GetHandFeed(mode) == 0) {
                this.HandFeedToMsgBox((byte)0, mode.getValue());
            }
        } else {
            byte sdkReturn = this.SDK.ID_HandFeed(this.hSession, (byte)1, mode);
            if (sdkReturn != 0) {
                Utils.DisplayError("SetHandFeed", sdkReturn);
            } else {
                this.HandFeedToMsgBox((byte)1, mode.getValue());
            }
        }
    }

    private String EjectModeString(byte mode) {
        return this.comboEjectMode.getItemAt(mode).toString();
    }

    private void EjectModeDisplay(byte mode) {
        this.comboEjectMode.setSelectedIndex(mode);
    }

    private void EjectModeToMsgBox(byte action, byte mode) {
        this.textPrinterMsg.append("Eject Mode" + Utils.Separator(action) + this.EjectModeString(mode) + "\n\n");
    }

    private byte GetEjectMode(ByteByReference mode) {
        Utils.CursorWait();
        byte sdkReturn = this.SDK.ID_EjectMode(this.hSession, (byte)0, mode);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetEjectMode", sdkReturn);
        } else {
            this.EjectModeDisplay(mode.getValue());
        }
        Utils.CursorDefault();
        return sdkReturn;
    }

    private void EjectMode() {
        ByteByReference mode = new ByteByReference(((ComboItem)this.comboEjectMode.getSelectedItem()).getValue());
        if (this.rdbtnGet.isSelected()) {
            if (this.GetEjectMode(mode) == 0) {
                this.EjectModeToMsgBox((byte)0, mode.getValue());
            }
        } else {
            byte sdkReturn = this.SDK.ID_EjectMode(this.hSession, (byte)1, mode);
            if (sdkReturn != 0) {
                Utils.DisplayError("EjectMode", sdkReturn);
            } else {
                this.EjectModeToMsgBox((byte)1, mode.getValue());
            }
        }
    }

    private String HorzEjectString(byte mode) {
        return this.comboHorzEject.getItemAt(mode).toString();
    }

    private void HorzEjectDisplay(byte mode) {
        this.comboHorzEject.setSelectedIndex(mode);
    }

    private void HorzEjectToMsgBox(byte action, byte mode) {
        this.textPrinterMsg.append("Horz Eject" + Utils.Separator(action) + this.HorzEjectString(mode) + "\n\n");
    }

    private byte GetHorzEject(ByteByReference mode) {
        Utils.CursorWait();
        byte sdkReturn = this.SDK.ID_HorzEject(this.hSession, (byte)0, mode);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetHorzEject", sdkReturn);
        } else {
            this.HorzEjectDisplay(mode.getValue());
        }
        Utils.CursorDefault();
        return sdkReturn;
    }

    private void HorzEject() {
        ByteByReference mode = new ByteByReference(((ComboItem)this.comboHorzEject.getSelectedItem()).getValue());
        if (this.rdbtnGet.isSelected()) {
            if (this.GetHorzEject(mode) == 0) {
                this.HorzEjectToMsgBox((byte)0, mode.getValue());
            }
        } else {
            byte sdkReturn = this.SDK.ID_HorzEject(this.hSession, (byte)1, mode);
            if (sdkReturn != 0) {
                Utils.DisplayError("HorzEject", sdkReturn);
            } else {
                this.HorzEjectToMsgBox((byte)1, mode.getValue());
            }
        }
    }

    static String SmartModeString(byte mode) {
        switch (mode) {
            case 1: {
                return "Platen";
            }
            case 2: {
                return "XLI";
            }
        }
        return "Default";
    }

    private void SmartModeDisplay(byte mode) {
        this.comboSmartMode.setSelectedIndex(mode);
    }

    private void SmartModeToMsgBox(byte action, byte mode) {
        this.textPrinterMsg.append("Smart Mode" + Utils.Separator(action) + Printer.SmartModeString(mode) + "\n\n");
    }

    private byte GetSmartMode(ByteByReference mode) {
        Utils.CursorWait();
        byte sdkReturn = this.SDK.ID_SmartMode(this.hSession, (byte)0, mode);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetSmarMode", sdkReturn);
        } else {
            this.SmartModeDisplay(mode.getValue());
        }
        Utils.CursorDefault();
        return sdkReturn;
    }

    private void SmartMode() {
        ByteByReference mode = new ByteByReference(((ComboItem)this.comboSmartMode.getSelectedItem()).getValue());
        if (this.rdbtnGet.isSelected()) {
            if (this.GetSmartMode(mode) == 0) {
                this.SmartModeToMsgBox((byte)0, mode.getValue());
            }
        } else {
            byte sdkReturn = this.SDK.ID_SmartMode(this.hSession, (byte)1, mode);
            if (sdkReturn != 0) {
                Utils.DisplayError("SmartMode", sdkReturn);
            } else {
                this.SmartModeToMsgBox((byte)1, mode.getValue());
            }
        }
    }

    private void SmartOffsetDisplay(byte offset) {
        this.spinnerSmartOffset.setValue(offset);
    }

    private void SmartOffsetToMsgBox(byte action, byte offset) {
        String sep = Utils.Separator(action);
        this.textPrinterMsg.append("Smart Offset" + sep + offset + "\n\n");
    }

    private byte GetSmartOffset(ByteByReference offset) {
        Utils.CursorWait();
        byte sdkReturn = this.SDK.ID_SmartOffset(this.hSession, (byte)0, offset);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetSmartOffset", sdkReturn);
        } else {
            this.SmartOffsetDisplay(offset.getValue());
        }
        Utils.CursorDefault();
        return sdkReturn;
    }

    private void SmartOffset() {
        ByteByReference offset = new ByteByReference();
        if (this.rdbtnGet.isSelected()) {
            if (this.GetSmartOffset(offset) == 0) {
                this.SmartOffsetToMsgBox((byte)0, offset.getValue());
            }
        } else {
            offset.setValue((Byte)this.spinnerSmartOffset.getValue());
            byte sdkReturn = this.SDK.ID_SmartOffset(this.hSession, (byte)1, offset);
            if (sdkReturn != 0) {
                Utils.DisplayError("SetSmartOffset", sdkReturn);
            } else {
                this.SmartOffsetToMsgBox((byte)1, offset.getValue());
            }
        }
    }

    private String EraseSpeedString(byte mode) {
        return this.comboEraseSpeed.getItemAt(mode).toString();
    }

    private void EraseSpeedDisplay(byte speed) {
        this.comboEraseSpeed.setSelectedIndex(speed);
    }

    private void EraseSpeedToMsgBox(byte action, byte speed) {
        this.textPrinterMsg.append("Erase Speed" + Utils.Separator(action) + this.EraseSpeedString(speed) + "\n\n");
    }

    private byte GetEraseSpeed(ByteByReference speed) {
        Utils.CursorWait();
        byte sdkReturn = this.SDK.ID_EraseSpeed(this.hSession, (byte)0, speed);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetEraseSpeed", sdkReturn);
        } else {
            this.EraseSpeedDisplay(speed.getValue());
        }
        Utils.CursorDefault();
        return sdkReturn;
    }

    private void EraseSpeed() {
        ByteByReference speed = new ByteByReference(((ComboItem)this.comboEraseSpeed.getSelectedItem()).getValue());
        if (this.rdbtnGet.isSelected()) {
            if (this.GetEraseSpeed(speed) == 0) {
                this.EraseSpeedToMsgBox((byte)0, speed.getValue());
            }
        } else {
            byte sdkReturn = this.SDK.ID_EraseSpeed(this.hSession, (byte)1, speed);
            if (sdkReturn != 0) {
                Utils.DisplayError("EraseSpeed", sdkReturn);
            } else {
                this.EraseSpeedToMsgBox((byte)1, speed.getValue());
            }
        }
    }

    private String IPModeString(byte mode) {
        return this.comboIPMode.getItemAt(mode).toString();
    }

    private void IPSettingsToMsgBox(byte action, SDKlib.IPData IP) {
        String sep = Utils.Separator(action);
        this.textPrinterMsg.append("IP Settings:\nAddress Mode" + sep + this.IPModeString(IP.mode) + "\n" + "IP Address" + sep + IP.getString(IP.address) + "\n" + "Subnet" + sep + IP.getString(IP.subnet) + "\n" + "Gateway" + sep + IP.getString(IP.gateway) + "\n\n");
    }

    private void IPSettingsToCtrl(SDKlib.IPData IP) {
        this.comboIPMode.setSelectedIndex(IP.mode);
        this.textIPAddress.setText(IP.getString(IP.address));
        this.textIPSubnet.setText(IP.getString(IP.subnet));
        this.textIPGateway.setText(IP.getString(IP.gateway));
    }

    private byte GetIPSettings(SDKlib.IPData IP) {
        byte sdkReturn = this.SDK.ID_IPSettings(this.hSession, (byte)0, IP);
        if (sdkReturn != 0) {
            Utils.DisplayError("GetIPSettings", sdkReturn);
        }
        return sdkReturn;
    }

    private void IPSettings() {
        Utils.CursorWait();
        SDKlib.IPData IP = new SDKlib.IPData();
        if (this.rdbtnGet.isSelected()) {
            if (this.GetIPSettings(IP) == 0) {
                this.IPSettingsToMsgBox((byte)0, IP);
                this.IPSettingsToCtrl(IP);
            }
        } else {
            IP.mode = ((ComboItem)this.comboIPMode.getSelectedItem()).getValue();
            IP.address = IP.getInt(this.textIPAddress.getText());
            IP.subnet = IP.getInt(this.textIPSubnet.getText());
            IP.gateway = IP.getInt(this.textIPGateway.getText());
            byte sdkReturn = this.SDK.ID_IPSettings(this.hSession, (byte)1, IP);
            if (sdkReturn != 0) {
                Utils.DisplayError("IPSettings", sdkReturn);
            } else {
                this.IPSettingsToMsgBox((byte)1, IP);
            }
        }
        Utils.CursorDefault();
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (e.getActionCommand()) {
                case "RADIOGET": {
                    Printer.this.EnableGetSetControls(false);
                    break;
                }
                case "RADIOSET": {
                    Printer.this.EnableGetSetControls(true);
                    break;
                }
                case "OPEN": {
                    Printer.this.OpenSession();
                    break;
                }
                case "CLOSE": {
                    Printer.this.CloseSession();
                    break;
                }
                case "RESPONSE": {
                    Printer.this.ErrorResponse();
                    break;
                }
                case "CLEAR": {
                    Printer.this.ClearMsg();
                    break;
                }
                case "GENERAL": {
                    Printer.this.GeneralCommand();
                    break;
                }
                case "FEEDMOVE": {
                    Printer.this.FeedMove();
                    break;
                }
                case "MOVEFILM": {
                    Printer.this.MoveFilm();
                    break;
                }
                case "LOCATION": {
                    Printer.this.CardLocation();
                    break;
                }
                case "EJECT": {
                    Printer.this.EjectCard();
                    break;
                }
                case "FLIP": {
                    Printer.this.FlipCard();
                    break;
                }
                case "CLEAN": {
                    Printer.this.CleanPrinter();
                    break;
                }
                case "RESTART": {
                    Printer.this.RestartPrinter();
                    break;
                }
                case "TEST": {
                    Printer.this.PrintTestCard();
                    break;
                }
                case "ERASE": {
                    Printer.this.EraseCard();
                    break;
                }
                case "HANDFEED": {
                    Printer.this.HandFeed();
                    break;
                }
                case "EJECTMODE": {
                    Printer.this.EjectMode();
                    break;
                }
                case "HORZEJECT": {
                    Printer.this.HorzEject();
                    break;
                }
                case "SMARTMODE": {
                    Printer.this.SmartMode();
                    break;
                }
                case "SMARTOFFSET": {
                    Printer.this.SmartOffset();
                    break;
                }
                case "ERASESPEED": {
                    Printer.this.EraseSpeed();
                    break;
                }
                case "IPSETTINGS": {
                    Printer.this.IPSettings();
                }
            }
        }
    }
}

